// Code generated by sauron/cmd/codegen; EDITED.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-08-24 16:28:16.136897 -0700 PDT m=+0.058219680
// Template path: handler_definitions/templates/internal/event/{name}/handler_test.go.tmpl

package celebrationpurchase_test

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"testing"
	"time"

	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/internal/event/celebrationpurchase"
	"code.justin.tv/cb/sauron/internal/mocks"
	"code.justin.tv/cb/sauron/types"
	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

type mockHandlerParams struct {
	DynamoDB *mocks.Database
	Pubsub   *mocks.Publisher
	Users    *mocks.Users
	Statsd   *mocks.StatSender
}

func handlerMocks() mockHandlerParams {
	return mockHandlerParams{
		DynamoDB: &mocks.Database{},
		Pubsub:   &mocks.Publisher{},
		Users:    &mocks.Users{},
		Statsd:   &mocks.StatSender{},
	}
}

func mockHandler(params mockHandlerParams) *celebrationpurchase.Handler {
	return &celebrationpurchase.Handler{
		DynamoDB: params.DynamoDB,
		Pubsub:   params.Pubsub,
		Users:    params.Users,
		Statsd:   params.Statsd,
	}
}

func getInvokeInput(timestamp time.Time, channelID string, userID string, intensity string, effect string) []byte {
	msg := celebrationpurchase.Message{
		Timestamp: timestamp,
		ChannelID: channelID,
		UserID:    userID,
		Intensity: intensity,
		Effect:    effect,
	}

	msgBytes, _ := json.Marshal(msg)

	snsEntity := events.SNSEntity{
		Message: string(msgBytes),
	}

	snsEntityBytes, _ := json.Marshal(snsEntity)

	sqsMessage := events.SQSMessage{
		Body: string(snsEntityBytes),
	}
	records := make([]events.SQSMessage, 1, 1)
	records[0] = sqsMessage
	input := events.SQSEvent{
		Records: records,
	}

	inputBytes := new(bytes.Buffer)
	_ = json.NewEncoder(inputBytes).Encode(input)
	return inputBytes.Bytes()
}

func TestInvokeWithInvalidInput(t *testing.T) {
	log.SetLevel(log.PanicLevel)
	m := handlerMocks()
	handler := mockHandler(m)
	ctx := context.Background()
	m.Statsd.On("GoIncrement", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("GoExecutionTime", mock.Anything, mock.Anything).Maybe()

	Convey("When the handler is invoked with invalid input", t, func() {
		Convey("When the sqs payload contains invalid json", func() {
			Convey("It should return an error", func() {
				invalidSqs := []byte("{\"Records\":}")
				m.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
				result, err := handler.Invoke(ctx, invalidSqs)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})

		})

		Convey("When the sqs payload has no messages", func() {
			Convey("It should return nil", func() {
				sqs := []byte("{\"Records\":[]}")
				m.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
				result, err := handler.Invoke(ctx, sqs)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})

		Convey("When the sqs message has invalid json", func() {
			Convey("It should return an error", func() {
				sqs := []byte("{\"Records\":[{\"messageId\":]}")
				m.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
				result, err := handler.Invoke(ctx, sqs)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})
	})
}

func TestInvokeWithValidInput(t *testing.T) {
	log.SetLevel(log.PanicLevel)
	mocks := handlerMocks()
	handler := mockHandler(mocks)
	ctx := context.Background()
	channelID := "321321321"
	userID := "123123123"
	intensity := "LARGE"
	effect := "FIREWORKS"
	timestamp := time.Now()
	mocks.Statsd.On("GoIncrement", mock.Anything, mock.Anything).Maybe()
	mocks.Statsd.On("GoExecutionTime", mock.Anything, mock.Anything).Maybe()

	Convey("Given CelebrationPurchase handler", t, func() {
		Convey("when getting user fails", func() {
			input := getInvokeInput(timestamp, channelID, userID, intensity, effect)

			mocks.Users.On("GetUser", ctx, userID).Once().Return(types.User{}, errors.New("user service failed"))
			mocks.DynamoDB.AssertNotCalled(t, "InsertCelebrationPurchase", ctx, channelID, mock.Anything)
			mocks.Pubsub.AssertNotCalled(t, "PublishCelebrationPurchase", ctx, channelID, mock.Anything)

			mocks.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
			result, err := handler.Invoke(ctx, input)
			So(result, ShouldBeNil)
			So(err, ShouldNotBeNil)
			mocks.Pubsub.AssertExpectations(t)
		})

		Convey("when we don't find user", func() {
			input := getInvokeInput(timestamp, channelID, userID, intensity, effect)

			mocks.Users.On("GetUser", ctx, userID).Once().Return(types.User{}, users.ErrUserNotFound)
			mocks.DynamoDB.AssertNotCalled(t, "InsertCelebrationPurchase", ctx, channelID, mock.Anything)
			mocks.Pubsub.AssertNotCalled(t, "PublishCelebrationPurchase", ctx, channelID, mock.Anything)

			mocks.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
			result, err := handler.Invoke(ctx, input)
			So(result, ShouldBeNil)
			So(err, ShouldBeNil)
			mocks.Pubsub.AssertExpectations(t)
		})

		Convey("when we find user", func() {
			Convey("When inserting fails", func() {
				Convey("It should return a nil result and an error, and not publish", func() {
					input := getInvokeInput(timestamp, channelID, userID, intensity, effect)

					mocks.Users.On("GetUser", ctx, userID).Once().Return(types.User{
						ID:          userID,
						DisplayName: "SomeUser",
						Login:       "someUser",
					}, nil)
					mocks.DynamoDB.On("InsertCelebrationPurchase", ctx, channelID, mock.Anything).Once().Return(errors.New("dynamo failed"))
					mocks.Pubsub.AssertNotCalled(t, "PublishCelebrationPurchase", ctx, channelID, mock.Anything)

					mocks.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldNotBeNil)
					mocks.Pubsub.AssertExpectations(t)
				})
			})

			Convey("When inserting succeeds", func() {
				Convey("When publishing to pubsub fails", func() {
					input := getInvokeInput(timestamp, channelID, userID, intensity, effect)

					mocks.Users.On("GetUser", ctx, userID).Once().Return(types.User{
						ID:          userID,
						DisplayName: "SomeUser",
						Login:       "someUser",
					}, nil)
					mocks.DynamoDB.On("InsertCelebrationPurchase", ctx, channelID, mock.Anything).Once().Return(nil)
					mocks.Pubsub.On("PublishCelebrationPurchase", ctx, channelID, mock.Anything).Once().Return(errors.New("pubsub failed"))

					Convey("It should return a nil result and an error", func() {
						mocks.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
						result, err := handler.Invoke(ctx, input)
						So(result, ShouldBeNil)
						So(err, ShouldNotBeNil)
					})

					mocks.Pubsub.AssertExpectations(t)
					mocks.DynamoDB.AssertExpectations(t)
				})

				Convey("When publishing to pubsub succeeds", func() {
					input := getInvokeInput(timestamp, channelID, userID, intensity, effect)

					mocks.Users.On("GetUser", ctx, userID).Once().Return(types.User{
						ID:          userID,
						DisplayName: "SomeUser",
						Login:       "someUser",
					}, nil)
					mocks.DynamoDB.On("InsertCelebrationPurchase", ctx, channelID, mock.Anything).Once().Return(nil)
					mocks.Pubsub.On("PublishCelebrationPurchase", ctx, channelID, mock.Anything).Once().Return(nil)

					Convey("It should return a nil result and nil error", func() {
						mocks.Statsd.On("Shutdown", mock.Anything).Once().Return(nil)
						result, err := handler.Invoke(ctx, input)
						So(result, ShouldBeNil)
						So(err, ShouldBeNil)
					})

					mocks.Pubsub.AssertExpectations(t)
					mocks.DynamoDB.AssertExpectations(t)
				})
			})
		})
	})
}
