// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2020-11-16 17:32:06.101232 -0800 PST m=+0.048932825
// Template path: handler_definitions/templates/internal/event/{name}/generated.go.tmpl

package copogoalupdate

import (
	"context"
	"encoding/json"
	"time"

	"code.justin.tv/cb/sauron/internal/clients/copo"
	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	"github.com/aws/aws-lambda-go/events"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "event.copo.copogoalupdate."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB dynamodb.Database
	Pubsub   pubsub.Publisher
	Copo     communitypoints.CopoService
	Users    users.Users
	Statsd   stats.StatSender
}

// Invoke allows Handler to implement github.com/aws/aws-lambda-go/lambda.Handler.
func (h Handler) Invoke(ctx context.Context, payload []byte) ([]byte, error) {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	logger := log.WithField("payload", string(payload))

	var event events.SQSEvent

	if err := json.Unmarshal(payload, &event); err != nil {
		logger.WithError(err).Warn("invalid json payload")

		return nil, err
	}

	if len(event.Records) == 0 {
		logger.Warn("no records in sqs event")

		return nil, nil
	}

	for _, record := range event.Records {
		if err := h.processMessage(ctx, record); err != nil {
			return nil, err
		}
	}

	return nil, nil
}

// convert takes in an sqs message and unmarshals it to the proper follow message we need
// for processing. We need to unmarshal twice: first to get the message body, which contains
// the follow message as a json string, and then secondly to unmarshal that json string.
func convert(sqsMessage events.SQSMessage) (Message, error) {
	var sqsBody events.SNSEntity
	if err := json.Unmarshal([]byte(sqsMessage.Body), &sqsBody); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("copogoalupdate: invalid json body in sqs message")
		return Message{}, err
	}

	var msg Message
	if err := json.Unmarshal([]byte(sqsBody.Message), &msg); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("copogoalupdate: invalid json message in sns message")
		return Message{}, err
	}
	msg.Timestamp = sqsBody.Timestamp

	return msg, nil
}

func (h *Handler) insertAndPublishCopoGoalEnded(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	channelPointsGoalID string, channelPointsGoalTitle string, channelPointsPointsContributed int, channelPointsGoalAmount int, channelPointsGoalStatus string, channelPointsGoalType string, channelPointsName string) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("copogoalupdate: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	err = h.DynamoDB.InsertCopoGoalEnded(ctx, channelID, dynamodb.CopoGoalEnded{
		ID:                             id.String(),
		Timestamp:                      timestamp,
		ChannelPointsGoalID:            channelPointsGoalID,
		ChannelPointsGoalTitle:         channelPointsGoalTitle,
		ChannelPointsPointsContributed: channelPointsPointsContributed,
		ChannelPointsGoalAmount:        channelPointsGoalAmount,
		ChannelPointsGoalStatus:        channelPointsGoalStatus,
		ChannelPointsGoalType:          channelPointsGoalType,
		ChannelPointsName:              channelPointsName,
	})
	if err != nil {
		logger.WithError(err).Error("copogoalupdate: failed to insert 'copo_goal_ended' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.CopoGoalEnded{
		ID:                             id.String(),
		Timestamp:                      timestamp,
		ChannelPointsGoalID:            channelPointsGoalID,
		ChannelPointsGoalTitle:         channelPointsGoalTitle,
		ChannelPointsPointsContributed: channelPointsPointsContributed,
		ChannelPointsGoalAmount:        channelPointsGoalAmount,
		ChannelPointsGoalStatus:        channelPointsGoalStatus,
		ChannelPointsGoalType:          channelPointsGoalType,
		ChannelPointsName:              channelPointsName,
	}
	err = h.Pubsub.PublishCopoGoalEnded(ctx, channelID, pubsubMsg)
	if err != nil {
		logger.WithError(err).Error("copogoalupdate: failed to publish 'copo_goal_ended' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
