// Code generated by sauron/cmd/codegen; EDITED.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-10-22 15:11:02.92564 -0700 PDT m=+0.055990597
// Template path: handler_definitions/templates/internal/event/{name}/handler.go.tmpl

package copogoalupdate

import (
	"context"

	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
)

func (h Handler) processMessage(ctx context.Context, sqsMessage events.SQSMessage) error {
	logger := log.WithField("message_body", sqsMessage.Body)

	msg, err := convert(sqsMessage)
	if err != nil {
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if err := validate(msg); err != nil {
		h.Statsd.GoIncrement(validateErrorStat, 1)
		logger.WithError(err).Warn("copogoalupdate: failed to validate message")
		return nil
	}

	channelPointsName, err := h.Copo.GetChannelPointsName(ctx, msg.ChannelID)
	if err != nil {
		logger.WithError(err).Errorf("copogoalupdate: failed to fetch copo points name for channel id '%s'", msg.ChannelID)
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	logger = log.WithFields(log.Fields{
		"copogoalupdate_msg":  msg,
		"channel_points_name": channelPointsName,
	})
	return h.insertAndPublishCopoGoalEnded(ctx, logger, msg.Timestamp, msg.ChannelID, msg.GoalID, msg.Title, msg.PointsContributed, msg.GoalAmount, msg.Status, msg.Type, channelPointsName)
}
