// Code generated by sauron/cmd/codegen; EDITED.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-10-22 15:11:02.93166 -0700 PDT m=+0.062010295
// Template path: handler_definitions/templates/internal/event/{name}/handler_test.go.tmpl

package copogoalupdate_test

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"testing"
	"time"

	"code.justin.tv/cb/sauron/internal/event/copo/copogoalupdate"
	"code.justin.tv/cb/sauron/internal/mocks"
	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

type mockHandlerParams struct {
	DynamoDB *mocks.Database
	Pubsub   *mocks.Publisher
	Copo     *mocks.CopoService
	Users    *mocks.Users
	Statsd   *mocks.StatSender
}

func handlerMocks() mockHandlerParams {
	return mockHandlerParams{
		DynamoDB: &mocks.Database{},
		Pubsub:   &mocks.Publisher{},
		Copo:     &mocks.CopoService{},
		Users:    &mocks.Users{},
		Statsd:   &mocks.StatSender{},
	}
}

func mockHandler(params mockHandlerParams) *copogoalupdate.Handler {
	return &copogoalupdate.Handler{
		DynamoDB: params.DynamoDB,
		Pubsub:   params.Pubsub,
		Copo:     params.Copo,
		Users:    params.Users,
		Statsd:   params.Statsd,
	}
}

func getInvokeInput(channelID string, goalID string, title string, pointsContributed int, goalAmount int, goalStatus string, goalType string) []byte {
	msg := copogoalupdate.Message{
		Timestamp:         time.Now(),
		ChannelID:         channelID,
		GoalID:            goalID,
		Title:             title,
		PointsContributed: pointsContributed,
		GoalAmount:        goalAmount,
		Status:            goalStatus,
		Type:              goalType,
	}

	msgBytes, _ := json.Marshal(msg)

	snsEntity := events.SNSEntity{
		Message: string(msgBytes),
	}

	snsEntityBytes, _ := json.Marshal(snsEntity)

	sqsMessage := events.SQSMessage{
		Body: string(snsEntityBytes),
	}
	records := make([]events.SQSMessage, 1, 1)
	records[0] = sqsMessage
	input := events.SQSEvent{
		Records: records,
	}

	inputBytes := new(bytes.Buffer)
	_ = json.NewEncoder(inputBytes).Encode(input)
	return inputBytes.Bytes()
}

func TestInvokeWithInvalidInput(t *testing.T) {
	log.SetLevel(log.PanicLevel)
	m := handlerMocks()
	handler := mockHandler(m)
	ctx := context.Background()
	m.Statsd.On("GoIncrement", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("GoExecutionTime", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("Shutdown", mock.Anything).Return(nil)

	channelId := "channel-id"
	pointsContributed := 10
	goalAmount := 100
	goalId := "goal-id"
	title := "goal-title"
	goalStatus := "goal-status"
	goalType := "goal-type"

	Convey("When the handler is invoked with invalid input", t, func() {
		Convey("When the sqs payload contains invalid json", func() {
			Convey("It should return an error", func() {
				invalidSqs := []byte("{\"Records\":}")
				result, err := handler.Invoke(ctx, invalidSqs)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})

		})

		Convey("When the sqs payload has no messages", func() {
			Convey("It should return nil", func() {
				sqs := []byte("{\"Records\":[]}")
				result, err := handler.Invoke(ctx, sqs)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})

		Convey("When the sqs message has invalid json", func() {
			Convey("It should return an error", func() {
				sqs := []byte("{\"Records\":[{\"messageId\":]}")
				result, err := handler.Invoke(ctx, sqs)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})

		Convey("When target channel is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput("", goalId, title, pointsContributed, goalAmount, goalStatus, goalType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When goal id is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, "", title, pointsContributed, goalAmount, goalStatus, goalType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When title is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalId, "", pointsContributed, goalAmount, goalStatus, goalType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When status is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalId, title, pointsContributed, goalAmount, "", goalType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When goalAmount is not positive", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalId, title, pointsContributed, 0, goalStatus, goalType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
	})
}

func TestInvokeWithValidInput(t *testing.T) {
	log.SetLevel(log.PanicLevel)
	m := handlerMocks()
	handler := mockHandler(m)
	ctx := context.Background()
	m.Statsd.On("GoIncrement", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("GoExecutionTime", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("Shutdown", mock.Anything).Return(nil)

	channelId := "channel-id"
	pointsContributed := 10
	goalAmount := 100
	goalId := "goal-id"
	title := "goal-title"
	pointsName := "points-name"
	goalStatus := "goal-status"
	goalType := "goal-type"

	Convey("When the handler is invoked with a valid input", t, func() {
		Convey("When copo service fails", func() {
			Convey("It should return a nil result and an error", func() {
				input := getInvokeInput(channelId, goalId, title, pointsContributed, goalAmount, goalStatus, goalType)
				m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return("", errors.New("copo service failed"))

				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})

		Convey("When inserting fails", func() {
			Convey("It should return a nil result and an error, and not publish", func() {
				input := getInvokeInput(channelId, goalId, title, pointsContributed, goalAmount, goalStatus, goalType)
				m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return(pointsName, nil)
				m.DynamoDB.On("InsertCopoGoalEnded", ctx, mock.Anything, mock.Anything).Once().Return(errors.New("dynamo failed"))

				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)

				m.Pubsub.AssertNotCalled(t, "PublishCopoGoalEnded", ctx, mock.Anything, mock.Anything, mock.Anything)
			})
		})

		Convey("When publishing to pubsub fails", func() {
			Convey("It should return a nil result and an error", func() {
				input := getInvokeInput(channelId, goalId, title, pointsContributed, goalAmount, goalStatus, goalType)
				m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return(pointsName, nil)
				m.DynamoDB.On("InsertCopoGoalEnded", ctx, mock.Anything, mock.Anything).Once().Return(nil)
				m.Pubsub.On("PublishCopoGoalEnded", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(errors.New("pubsub failed"))

				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})

		Convey("When no call failures", func() {
			Convey("When progress is 0", func() {
				Convey("It should return a nil result and no error", func() {
					input := getInvokeInput(channelId, goalId, title, 0, goalAmount, goalStatus, goalType)
					m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return(pointsName, nil)
					m.DynamoDB.On("InsertCopoGoalEnded", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishCopoGoalEnded", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)
				})
			})
			Convey("When goal type is empty", func() {
				Convey("It should return a nil result and no error", func() {
					input := getInvokeInput(channelId, goalId, title, pointsContributed, goalAmount, goalStatus, "")
					m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return(pointsName, nil)
					m.DynamoDB.On("InsertCopoGoalEnded", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishCopoGoalEnded", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)
				})
			})
			Convey("When progress is made", func() {
				Convey("It should return a nil result and no error", func() {
					input := getInvokeInput(channelId, goalId, title, pointsContributed, goalAmount, goalStatus, goalType)
					m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return(pointsName, nil)
					m.DynamoDB.On("InsertCopoGoalEnded", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishCopoGoalEnded", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)
				})
			})
			Convey("When progress reaches goal", func() {
				Convey("It should return a nil result and no error", func() {
					input := getInvokeInput(channelId, goalId, title, goalAmount, goalAmount, goalStatus, goalType)
					m.Copo.On("GetChannelPointsName", ctx, channelId).Once().Return(pointsName, nil)
					m.DynamoDB.On("InsertCopoGoalEnded", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishCopoGoalEnded", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)
				})
			})
		})
	})
}
