// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2020-05-12 17:11:51.45185 -0700 PDT m=+0.100885399
// Template path: handler_definitions/templates/internal/event/{name}/generated.go.tmpl

package customrewardredemption

import (
	"context"
	"encoding/json"
	"time"

	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/types"
	"github.com/aws/aws-lambda-go/events"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "event.copo.customrewardredemption."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
	userNotFoundStat  = statPrefix + "user_not_found"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB dynamodb.Database
	Pubsub   pubsub.Publisher
	Users    users.Users
	Statsd   stats.StatSender
}

// Invoke allows Handler to implement github.com/aws/aws-lambda-go/lambda.Handler.
func (h Handler) Invoke(ctx context.Context, payload []byte) ([]byte, error) {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	logger := log.WithField("payload", string(payload))

	var event events.SQSEvent

	if err := json.Unmarshal(payload, &event); err != nil {
		logger.WithError(err).Warn("invalid json payload")

		return nil, err
	}

	if len(event.Records) == 0 {
		logger.Warn("no records in sqs event")

		return nil, nil
	}

	for _, record := range event.Records {
		if err := h.processMessage(ctx, record); err != nil {
			return nil, err
		}
	}

	return nil, nil
}

// convert takes in an sqs message and unmarshals it to the proper follow message we need
// for processing. We need to unmarshal twice: first to get the message body, which contains
// the follow message as a json string, and then secondly to unmarshal that json string.
func convert(sqsMessage events.SQSMessage) (Message, error) {
	var sqsBody events.SNSEntity
	if err := json.Unmarshal([]byte(sqsMessage.Body), &sqsBody); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("customrewardredemption: invalid json body in sqs message")
		return Message{}, err
	}

	var msg Message
	if err := json.Unmarshal([]byte(sqsBody.Message), &msg); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("customrewardredemption: invalid json message in sns message")
		return Message{}, err
	}
	msg.Timestamp = sqsBody.Timestamp

	return msg, nil
}

func (h *Handler) insertAndPublishChannelPointsCustomRewardRedemption(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	redemptionID string, redeemingUser types.User, rewardID string, rewardTitle string, userInput *string) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("customrewardredemption: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	err = h.DynamoDB.InsertChannelPointsCustomRewardRedemption(ctx, channelID, dynamodb.ChannelPointsCustomRewardRedemption{
		ID:              id.String(),
		Timestamp:       timestamp,
		RedemptionID:    redemptionID,
		RedeemingUserID: redeemingUser.ID,
		RewardID:        rewardID,
		RewardTitle:     rewardTitle,
		UserInput:       userInput,
	})
	if err != nil {
		logger.WithError(err).Error("customrewardredemption: failed to insert 'channel_points_custom_reward_redemption' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.ChannelPointsCustomRewardRedemption{
		ID:            id.String(),
		Timestamp:     timestamp,
		RedemptionID:  redemptionID,
		RedeemingUser: redeemingUser,
		RewardID:      rewardID,
		RewardTitle:   rewardTitle,
		UserInput:     userInput,
	}
	err = h.Pubsub.PublishChannelPointsCustomRewardRedemption(ctx, channelID, pubsubMsg)
	if err != nil {
		logger.WithError(err).Error("customrewardredemption: failed to publish 'channel_points_custom_reward_redemption' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
