// Code generated by sauron/cmd/codegen; DO NOT EDIT.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-05-08 16:30:29.055796 -0700 PDT m=+0.099744315
// Template path: handler_definitions/templates/internal/event/{name}/handler.go.tmpl

package customrewardredemption

import (
	"context"

	"code.justin.tv/cb/sauron/internal/clients/users"
	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
)

func (h Handler) processMessage(ctx context.Context, sqsMessage events.SQSMessage) error {
	logger := log.WithField("message_body", sqsMessage.Body)

	msg, err := convert(sqsMessage)
	if err != nil {
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if err := validate(msg); err != nil {
		h.Statsd.GoIncrement(validateErrorStat, 1)
		logger.WithError(err).Warn("customrewardredemption: failed to validate message")
		return nil
	}
	user, err := h.Users.GetUser(ctx, msg.RedeemingUserID)
	if err != nil {
		switch err {
		case users.ErrUserNotFound:
			h.Statsd.GoIncrement(userNotFoundStat, 1)
			logger.Warnf("customrewardredemption: RedeemingUser not found for user id '%s'", msg.RedeemingUserID)
			return nil
		default:
			h.Statsd.GoIncrement(errorStat, 1)
			logger.WithError(err).Errorf("customrewardredemption: failed to fetch RedeemingUser with user id '%s'", msg.RedeemingUserID)
			return err
		}
	}

	logger = log.WithFields(log.Fields{
		"customrewardredemption_msg": msg,
		"redeeming_user":             user,
	})
	return h.insertAndPublishChannelPointsCustomRewardRedemption(ctx, logger, msg.Timestamp, msg.ChannelID, msg.RedemptionID, user, msg.RewardID, msg.RewardTitle, msg.UserInput)
}
