// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2020-05-12 17:11:51.442955 -0700 PDT m=+0.091989995
// Template path: handler_definitions/templates/internal/event/{name}/generated.go.tmpl

package hosting

import (
	"context"
	"encoding/json"
	"time"

	"code.justin.tv/cb/sauron/activity"
	"code.justin.tv/cb/sauron/internal/alerts"
	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/types"
	"github.com/aws/aws-lambda-go/events"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "event.hosting."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
	userNotFoundStat  = statPrefix + "user_not_found"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB     dynamodb.Database
	Pubsub       pubsub.Publisher
	Users        users.Users
	Statsd       stats.StatSender
	AlertManager alerts.Manager
}

// Invoke allows Handler to implement github.com/aws/aws-lambda-go/lambda.Handler.
func (h Handler) Invoke(ctx context.Context, payload []byte) ([]byte, error) {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	logger := log.WithField("payload", string(payload))

	var event events.SQSEvent

	if err := json.Unmarshal(payload, &event); err != nil {
		logger.WithError(err).Warn("invalid json payload")

		return nil, err
	}

	if len(event.Records) == 0 {
		logger.Warn("no records in sqs event")

		return nil, nil
	}

	for _, record := range event.Records {
		if err := h.processMessage(ctx, record); err != nil {
			return nil, err
		}
	}

	return nil, nil
}

// convert takes in an sqs message and unmarshals it to the proper follow message we need
// for processing. We need to unmarshal twice: first to get the message body, which contains
// the follow message as a json string, and then secondly to unmarshal that json string.
func convert(sqsMessage events.SQSMessage) (Message, error) {
	var sqsBody events.SNSEntity
	if err := json.Unmarshal([]byte(sqsMessage.Body), &sqsBody); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("hosting: invalid json body in sqs message")
		return Message{}, err
	}

	var msg Message
	if err := json.Unmarshal([]byte(sqsBody.Message), &msg); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("hosting: invalid json message in sns message")
		return Message{}, err
	}

	return msg, nil
}

func (h *Handler) insertAndPublishAutoHostStart(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	host types.User, viewerCount *int) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("hosting: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypeAutoHostStart)
	err = h.DynamoDB.InsertAutoHostStart(ctx, channelID, dynamodb.AutoHostStart{
		ID:          id.String(),
		Timestamp:   timestamp,
		HostID:      host.ID,
		ViewerCount: viewerCount,
		AlertStatus: alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("hosting: failed to insert 'auto_host_start' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.AutoHostStart{
		ID:          id.String(),
		Timestamp:   timestamp,
		Host:        host,
		ViewerCount: viewerCount,
	}
	err = h.Pubsub.PublishAutoHostStart(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("hosting: failed to publish 'auto_host_start' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypeAutoHostStart,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("hosting: failed to publish 'auto_host_start' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}

func (h *Handler) insertAndPublishHostStart(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	host types.User, viewerCount *int) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("hosting: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypeHostStart)
	err = h.DynamoDB.InsertHostStart(ctx, channelID, dynamodb.HostStart{
		ID:          id.String(),
		Timestamp:   timestamp,
		HostID:      host.ID,
		ViewerCount: viewerCount,
		AlertStatus: alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("hosting: failed to insert 'host_start' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.HostStart{
		ID:          id.String(),
		Timestamp:   timestamp,
		Host:        host,
		ViewerCount: viewerCount,
	}
	err = h.Pubsub.PublishHostStart(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("hosting: failed to publish 'host_start' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypeHostStart,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("hosting: failed to publish 'host_start' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
