// This file was generated by robots at
// 2020-04-13 13:58:49.60096 -0700 PDT m=+0.084670997
// Template path: handler_definitions/templates/internal/event/{name}/validate.go.tmpl

package fulfillment

import (
	"errors"

	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
)

func validateSQSBody(sqsBody *events.SNSEntity) error {
	fulfillmentTypeAttr := sqsBody.MessageAttributes["FulfillmentType"]
	if fulfillmentTypeAttr == nil {
		return errors.New("fulfillment: 'FulfillmentType' missing in message attributes of sns message")
	}

	var errMsg string
	if fulfillmentType, ok := fulfillmentTypeAttr.(map[string]interface{}); !ok {
		errMsg = "fulfillment: invalid 'FulfillmentType' message attribute in sns message"
	} else if value, ok := fulfillmentType["Value"].(string); !ok {
		errMsg = "fulfillment: invalid 'Value' key-value pair in 'FulfillmentType' attribute in sns message"
	} else if value != StandardGift {
		return errInvalidFulfillmentType
	}
	if errMsg != "" {
		log.Warn(errMsg)
		return errors.New(errMsg)
	}
	return nil
}

func validate(msg Message) error {
	if msg.Status != "success" {
		return errNonSuccess
	}

	if msg.ChannelID == "" {
		return errors.New("fulfillment: missing channel_id in sns message")
	}

	if msg.SenderID == "" {
		return errors.New("fulfillment: missing sender_id in sns message")
	}

	if msg.RecipientID == "" {
		return errors.New("fulfillment: missing recipient_id in sns message")
	}

	if msg.ProductID == "" {
		return errors.New("fulfillment: missing product_id in sns message")
	}

	return nil
}
