// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2020-09-23 14:29:30.840496 -0700 PDT m=+0.037135976
// Template path: handler_definitions/templates/internal/event/{name}/generated.go.tmpl

package notice

import (
	"context"
	"encoding/json"
	"time"

	"code.justin.tv/cb/sauron/activity"
	"code.justin.tv/cb/sauron/internal/alerts"
	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/internal/clients/zuma"
	"code.justin.tv/cb/sauron/types"
	"github.com/aws/aws-lambda-go/events"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "event.subscription.notice."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
	userNotFoundStat  = statPrefix + "user_not_found"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB     dynamodb.Database
	Pubsub       pubsub.Publisher
	Zuma         zuma.Zuma
	Users        users.Users
	Statsd       stats.StatSender
	AlertManager alerts.Manager
}

// Invoke allows Handler to implement github.com/aws/aws-lambda-go/lambda.Handler.
func (h Handler) Invoke(ctx context.Context, payload []byte) ([]byte, error) {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	logger := log.WithField("payload", string(payload))

	var event events.SQSEvent

	if err := json.Unmarshal(payload, &event); err != nil {
		logger.WithError(err).Warn("invalid json payload")

		return nil, err
	}

	if len(event.Records) == 0 {
		logger.Warn("no records in sqs event")

		return nil, nil
	}

	for _, record := range event.Records {
		if err := h.processMessage(ctx, record); err != nil {
			return nil, err
		}
	}

	return nil, nil
}

// convert takes in an sqs message and unmarshals it to the proper follow message we need
// for processing. We need to unmarshal twice: first to get the message body, which contains
// the follow message as a json string, and then secondly to unmarshal that json string.
func convert(sqsMessage events.SQSMessage) (Message, error) {
	var sqsBody events.SNSEntity
	if err := json.Unmarshal([]byte(sqsMessage.Body), &sqsBody); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("notice: invalid json body in sqs message")
		return Message{}, err
	}

	var msg Message
	if err := json.Unmarshal([]byte(sqsBody.Message), &msg); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("notice: invalid json message in sns message")
		return Message{}, err
	}

	return msg, nil
}

func (h *Handler) insertAndPublishPrimeResubscriptionSharing(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	subscriber types.User, cumulativeTenureMonths int, customMessageFragments []types.Fragment, customMessageText string, multiMonthDuration int, multiMonthTenure int) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("notice: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypePrimeResubscriptionSharing)
	err = h.DynamoDB.InsertPrimeResubscriptionSharing(ctx, channelID, dynamodb.PrimeResubscriptionSharing{
		ID:                     id.String(),
		Timestamp:              timestamp,
		SubscriberID:           subscriber.ID,
		CumulativeTenureMonths: cumulativeTenureMonths,
		CustomMessageFragments: customMessageFragments,
		CustomMessageText:      customMessageText,
		MultiMonthDuration:     multiMonthDuration,
		MultiMonthTenure:       multiMonthTenure,
		AlertStatus:            alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("notice: failed to insert 'prime_resubscription_sharing' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.PrimeResubscriptionSharing{
		ID:                     id.String(),
		Timestamp:              timestamp,
		Subscriber:             subscriber,
		CumulativeTenureMonths: cumulativeTenureMonths,
		CustomMessageFragments: customMessageFragments,
		CustomMessageText:      customMessageText,
		MultiMonthDuration:     multiMonthDuration,
		MultiMonthTenure:       multiMonthTenure,
	}
	err = h.Pubsub.PublishPrimeResubscriptionSharing(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("notice: failed to publish 'prime_resubscription_sharing' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypePrimeResubscriptionSharing,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("notice: failed to publish 'prime_resubscription_sharing' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}

func (h *Handler) insertAndPublishPrimeSubscription(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	subscriber types.User) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("notice: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypePrimeSubscription)
	err = h.DynamoDB.InsertPrimeSubscription(ctx, channelID, dynamodb.PrimeSubscription{
		ID:           id.String(),
		Timestamp:    timestamp,
		SubscriberID: subscriber.ID,
		AlertStatus:  alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("notice: failed to insert 'prime_subscription' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.PrimeSubscription{
		ID:         id.String(),
		Timestamp:  timestamp,
		Subscriber: subscriber,
	}
	err = h.Pubsub.PublishPrimeSubscription(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("notice: failed to publish 'prime_subscription' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypePrimeSubscription,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("notice: failed to publish 'prime_subscription' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}

func (h *Handler) insertAndPublishResubscriptionSharing(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	subscriber types.User, tier string, cumulativeTenureMonths int, customMessageFragments []types.Fragment, customMessageText string, multiMonthDuration int, multiMonthTenure int) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("notice: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypeResubscriptionSharing)
	err = h.DynamoDB.InsertResubscriptionSharing(ctx, channelID, dynamodb.ResubscriptionSharing{
		ID:                     id.String(),
		Timestamp:              timestamp,
		SubscriberID:           subscriber.ID,
		Tier:                   tier,
		CumulativeTenureMonths: cumulativeTenureMonths,
		CustomMessageFragments: customMessageFragments,
		CustomMessageText:      customMessageText,
		MultiMonthDuration:     multiMonthDuration,
		MultiMonthTenure:       multiMonthTenure,
		AlertStatus:            alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("notice: failed to insert 'resubscription_sharing' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.ResubscriptionSharing{
		ID:                     id.String(),
		Timestamp:              timestamp,
		Subscriber:             subscriber,
		Tier:                   tier,
		CumulativeTenureMonths: cumulativeTenureMonths,
		CustomMessageFragments: customMessageFragments,
		CustomMessageText:      customMessageText,
		MultiMonthDuration:     multiMonthDuration,
		MultiMonthTenure:       multiMonthTenure,
	}
	err = h.Pubsub.PublishResubscriptionSharing(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("notice: failed to publish 'resubscription_sharing' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypeResubscriptionSharing,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("notice: failed to publish 'resubscription_sharing' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}

func (h *Handler) insertAndPublishSubscription(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	subscriber types.User, tier string, multiMonthDuration int, multiMonthTenure int) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("notice: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypeSubscription)
	err = h.DynamoDB.InsertSubscription(ctx, channelID, dynamodb.Subscription{
		ID:                 id.String(),
		Timestamp:          timestamp,
		SubscriberID:       subscriber.ID,
		Tier:               tier,
		MultiMonthDuration: multiMonthDuration,
		MultiMonthTenure:   multiMonthTenure,
		AlertStatus:        alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("notice: failed to insert 'subscription' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.Subscription{
		ID:                 id.String(),
		Timestamp:          timestamp,
		Subscriber:         subscriber,
		Tier:               tier,
		MultiMonthDuration: multiMonthDuration,
		MultiMonthTenure:   multiMonthTenure,
	}
	err = h.Pubsub.PublishSubscription(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("notice: failed to publish 'subscription' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypeSubscription,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("notice: failed to publish 'subscription' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
