// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-03-12 16:20:43.307766 -0800 PST m=+0.066634382
// Template path: handler_definitions/templates/internal/eventbus/{name}/generated.go.tmpl

package follow

import (
	"context"
	"time"

	"code.justin.tv/cb/sauron/activity"
	"code.justin.tv/cb/sauron/internal/alerts"
	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/cb/sauron/types"
	"code.justin.tv/eventbus/schema/pkg/user_follow_user"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "eventbus.follow."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
	userNotFoundStat  = statPrefix + "user_not_found"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB     dynamodb.Database
	Pubsub       pubsub.Publisher
	Users        users.Users
	Statsd       stats.StatSender
	AlertManager alerts.Manager
}

// Handle allows Handler to implement eventbus.Handler from code.justin.tv/eventbus/client.
func (h Handler) Handle(ctx context.Context, header *eventbus.Header, event *user_follow_user.UserFollowUserCreate) error {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	if err := h.processMessage(ctx, header, event); err != nil {
		return err
	}

	return nil
}

func (h *Handler) insertAndPublishFollow(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	follower types.User) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("follow: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypeFollow)
	err = h.DynamoDB.InsertFollow(ctx, channelID, dynamodb.Follow{
		ID:          id.String(),
		Timestamp:   timestamp,
		FollowerID:  follower.ID,
		AlertStatus: alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("follow: failed to insert 'follow' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.Follow{
		ID:        id.String(),
		Timestamp: timestamp,
		Follower:  follower,
	}
	err = h.Pubsub.PublishFollow(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("follow: failed to publish 'follow' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypeFollow,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("follow: failed to publish 'follow' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
