// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-07-01 20:28:48.660092 -0400 EDT m=+0.035791153
// Template path: handler_definitions/templates/internal/eventbus/{name}/generated.go.tmpl

package raiding

import (
	"context"
	"time"

	"code.justin.tv/cb/sauron/activity"
	"code.justin.tv/cb/sauron/internal/alerts"
	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/cb/sauron/types"
	"code.justin.tv/eventbus/schema/pkg/raid"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "eventbus.raiding."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
	userNotFoundStat  = statPrefix + "user_not_found"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB     dynamodb.Database
	Pubsub       pubsub.Publisher
	Users        users.Users
	Statsd       stats.StatSender
	AlertManager alerts.Manager
}

// Handle allows Handler to implement eventbus.Handler from code.justin.tv/eventbus/client.
func (h Handler) Handle(ctx context.Context, header *eventbus.Header, event *raid.RaidUpdate) error {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	if err := h.processMessage(ctx, header, event); err != nil {
		return err
	}

	return nil
}

func (h *Handler) insertAndPublishRaiding(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	raider types.User, viewerCount int32, status int32) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("raiding: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	alertStatus := h.AlertManager.GetAlertStatus(ctx, channelID, activity.TypeRaiding)
	err = h.DynamoDB.InsertRaiding(ctx, channelID, dynamodb.Raiding{
		ID:          id.String(),
		Timestamp:   timestamp,
		RaiderID:    raider.ID,
		ViewerCount: viewerCount,
		Status:      status,
		AlertStatus: alertStatus.StatusName,
	})
	if err != nil {
		logger.WithError(err).Error("raiding: failed to insert 'raiding' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.Raiding{
		ID:          id.String(),
		Timestamp:   timestamp,
		Raider:      raider,
		ViewerCount: viewerCount,
		Status:      status,
	}
	err = h.Pubsub.PublishRaiding(ctx, channelID, pubsubMsg, string(alertStatus.StatusName))
	if err != nil {
		logger.WithError(err).Error("raiding: failed to publish 'raiding' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if alertStatus.CanPublish {
		// Alerts are still published for offline channels
		err = h.Pubsub.PublishAlert(ctx, channelID, pubsub.Alert{
			ActivityID:   id.String(),
			ActivityType: activity.TypeRaiding,
			AlertStatus:  string(alertStatus.StatusName),
			AlertData:    pubsubMsg,
		})

		if err != nil {
			logger.WithError(err).Error("raiding: failed to publish 'raiding' alert to pubsub, setting alert status to failed")
			h.Statsd.GoOther(func() { h.AlertManager.FailAlertStatus(context.Background(), channelID, id.String()) })
			h.Statsd.GoIncrement(errorStat, 1)
			return err
		}
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
