package rollbar

import (
	"strings"

	"github.com/heroku/rollrus"
	log "github.com/sirupsen/logrus"
)

// SetupLogging configures Logrus to log certain levels to Rollbar.
func SetupLogging(token, env string) {
	if strings.Contains(env, "dev") {
		log.Info("sauron: development logs are not sent to rollbar")
		return
	}

	rollrus.SetupLoggingForLevels(token, env, []log.Level{
		log.WarnLevel,
		log.ErrorLevel,
		log.FatalLevel,
		log.PanicLevel,
	})
	log.Info("sauron: logs set to send to rollbar")
}
