// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-03-02 10:21:49.099698 -0800 PST m=+0.062747068
// Template path: handler_definitions/templates/jenkins.groovy.tmpl

// Each job definition must be added as a phaseJob in each multiJob below for builds and deployments.
def jobDefinition = [
  'api-get-activities': [
    packagePath: 'cmd/activity/getactivity/*.go',
    functionSuffix: 'api-get-activities'
  ],
  'handle-bits-usage': [
    packagePath: 'cmd/event/bitsusage/*.go',
    functionSuffix: 'payday-bits-usage'
  ],
  'handle-hosting': [
    packagePath: 'cmd/event/hosting/*.go',
    functionSuffix: 'clue-hosting-events'
  ],
  'handle-subscription-notice': [
    packagePath: 'cmd/event/subscription/notice/*.go',
    functionSuffix: 'subscriptions-subscription-notice'
  ],
  'handle-subscription-fulfillment': [
    packagePath: 'cmd/event/subscription/fulfillment/*.go',
    functionSuffix: 'lambdwich-fulfillment-status'
  ],
  'handle-subscription-mmg': [
    packagePath: 'cmd/event/subscription/mmg/*.go',
    functionSuffix: 'lambdwich-mmg-status'
  ],
  'handle-boost': [
    packagePath: 'cmd/event/boosts/*.go',
    functionSuffix: 'boost-activity-feed'
  ],
  'handle-celebration-purchase': [
    packagePath: 'cmd/event/celebrationpurchase/*.go',
    functionSuffix: 'celebration-purchase-activity-feed'
  ],
  'handle-copo-channel-points-custom-reward-redemption': [
    packagePath: 'cmd/event/copo/customrewardredemption/*.go',
    functionSuffix: 'copo-custom-reward-redemption'
  ],
  'handle-copo-channel-points-goal-update': [
    packagePath: 'cmd/event/copo/copogoalupdate/*.go',
    functionSuffix: 'copo-goal-update'
  ],
  'handle-drop-claim-window-open': [
    packagePath: 'cmd/event/drops/*.go',
    functionSuffix: 'drops-activity-feed'
  ],
  'handle-hype-train': [
    packagePath: 'cmd/event/hypetrain/*.go',
    functionSuffix: 'hype-train-activity-feed'
  ],
  'handle-event-bus': [
     packagePath: 'cmd/eventbus/*.go',
     functionSuffix: 'event-bus'
  ]
]

// BUILD
multiJob('cb-sauron-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/sauron', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Lint & test') {
      phaseJob('cb-sauron-test') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }

    phase('Build') {
      phaseJob('cb-sauron-build-api') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-api-get-activities') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-bits-usage') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-hosting') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-subscription-notice') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-subscription-fulfillment') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-subscription-mmg') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-boost') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-celebration-purchase') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-copo-channel-points-custom-reward-redemption') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-copo-channel-points-goal-update') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-drop-claim-window-open') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-hype-train') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-build-handle-event-bus') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

freeStyleJob('cb-sauron-test') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/sauron', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell 'manta -v -f .manta.test.json'
  }
}

jobDefinition.each { jobNameSuffix, definition ->
  freeStyleJob("cb-sauron-build-${jobNameSuffix}") {
    parameters {
      stringParam 'GIT_COMMIT'
    }

    concurrentBuild()

    scm {
      git {
        remote {
          github 'cb/sauron', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }
        branches '${GIT_COMMIT}'
        clean true
      }
    }

    wrappers {
      logRotator {
        daysToKeep(14)
      }
      preBuildCleanup()
      timestamps()
      colorizeOutput()
      sshAgent 'git-aws-read-key'
      credentialsBinding {
        file('AWS_CONFIG_FILE', 'aws_config')
        file('COURIERD_PRIVATE_KEY', 'courierd')
      }
      buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
    }

    steps {
      shell "manta -v -E PACKAGE_PATH=${definition['packagePath']} -f .manta.build.json"
      saveDeployArtifact "cb/sauron-${jobNameSuffix}", '.manta'
    }
  }
}

freeStyleJob('cb-sauron-build-api') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'cb/sauron', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
      credentialsBinding {
        file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
        file('COURIERD_PRIVATE_KEY', 'courierd')
        string 'SONAR_TOKEN', 'hallpass-sonar-token'
      }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell "./scripts/build_api.sh"
  }
}

// DEPLOY
multiJob('cb-sauron-deploy') {
  parameters {
    stringParam 'BRANCH'
    stringParam 'ENVIRONMENT'
    stringParam 'GIT_COMMIT'
    stringParam 'HOSTS'
    stringParam 'SKADI_ID'
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    timestamps()
    buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('cb-sauron-deploy-api') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-api-get-activities') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-bits-usage') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-hosting') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-subscription-notice') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-subscription-fulfillment') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-subscription-mmg') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-boost') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-celebration-purchase') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-copo-channel-points-custom-reward-redemption') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-copo-channel-points-goal-update') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-drop-claim-window-open') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-hype-train') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('cb-sauron-deploy-handle-event-bus') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('ENVIRONMENT', '$ENVIRONMENT')
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

jobDefinition.each { jobNameSuffix, definition ->
  freeStyleJob("cb-sauron-deploy-${jobNameSuffix}") {
    using 'TEMPLATE-minimal-skadi-deploy'

    wrappers {
      logRotator {
        daysToKeep(14)
      }
      timestamps()

      credentialsBinding {
        file('COURIERD_PRIVATE_KEY', 'courierd')
        file('AWS_CONFIG_FILE', 'aws_config')
        file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
      }

      buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
    }

    scm {
      git {
        remote {
          github 'cb/sauron', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }
        branches '${GIT_COMMIT}'
        clean true
      }
    }

    steps {
      shell 'mkdir .deploy'
      downloadDeployArtifact "cb/sauron-${jobNameSuffix}", '.deploy'
      shell "FUNCTION_NAME=cb-sauron-\$ENVIRONMENT-${definition['functionSuffix']} ./scripts/deploy.sh"
    }
  }
}

freeStyleJob('cb-sauron-deploy-api') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('COURIERD_PRIVATE_KEY', 'courierd')
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/sauron', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_api.sh'
  }
}
