// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: rpc/sauron/service.proto

/*
Package sauron is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	rpc/sauron/service.proto
*/
package sauron

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ================
// Sauron Interface
// ================

type Sauron interface {
	GetActivities(context.Context, *GetActivitiesReq) (*GetActivitiesResp, error)

	GetAlertPrefs(context.Context, *GetAlertPrefsReq) (*GetAlertPrefsResp, error)

	SetAlertPrefs(context.Context, *SetAlertPrefsReq) (*SetAlertPrefsResp, error)

	GetAlertQueue(context.Context, *GetAlertQueueReq) (*GetAlertQueueResp, error)

	SetAlertStatus(context.Context, *SetAlertStatusReq) (*SetAlertStatusResp, error)
}

// ======================
// Sauron Protobuf Client
// ======================

type sauronProtobufClient struct {
	client HTTPClient
	urls   [5]string
}

// NewSauronProtobufClient creates a Protobuf client that implements the Sauron interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewSauronProtobufClient(addr string, client HTTPClient) Sauron {
	prefix := urlBase(addr) + SauronPathPrefix
	urls := [5]string{
		prefix + "GetActivities",
		prefix + "GetAlertPrefs",
		prefix + "SetAlertPrefs",
		prefix + "GetAlertQueue",
		prefix + "SetAlertStatus",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &sauronProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &sauronProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *sauronProtobufClient) GetActivities(ctx context.Context, in *GetActivitiesReq) (*GetActivitiesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "GetActivities")
	out := new(GetActivitiesResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *sauronProtobufClient) GetAlertPrefs(ctx context.Context, in *GetAlertPrefsReq) (*GetAlertPrefsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertPrefs")
	out := new(GetAlertPrefsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *sauronProtobufClient) SetAlertPrefs(ctx context.Context, in *SetAlertPrefsReq) (*SetAlertPrefsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertPrefs")
	out := new(SetAlertPrefsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *sauronProtobufClient) GetAlertQueue(ctx context.Context, in *GetAlertQueueReq) (*GetAlertQueueResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertQueue")
	out := new(GetAlertQueueResp)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *sauronProtobufClient) SetAlertStatus(ctx context.Context, in *SetAlertStatusReq) (*SetAlertStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertStatus")
	out := new(SetAlertStatusResp)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

// ==================
// Sauron JSON Client
// ==================

type sauronJSONClient struct {
	client HTTPClient
	urls   [5]string
}

// NewSauronJSONClient creates a JSON client that implements the Sauron interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewSauronJSONClient(addr string, client HTTPClient) Sauron {
	prefix := urlBase(addr) + SauronPathPrefix
	urls := [5]string{
		prefix + "GetActivities",
		prefix + "GetAlertPrefs",
		prefix + "SetAlertPrefs",
		prefix + "GetAlertQueue",
		prefix + "SetAlertStatus",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &sauronJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &sauronJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *sauronJSONClient) GetActivities(ctx context.Context, in *GetActivitiesReq) (*GetActivitiesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "GetActivities")
	out := new(GetActivitiesResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *sauronJSONClient) GetAlertPrefs(ctx context.Context, in *GetAlertPrefsReq) (*GetAlertPrefsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertPrefs")
	out := new(GetAlertPrefsResp)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *sauronJSONClient) SetAlertPrefs(ctx context.Context, in *SetAlertPrefsReq) (*SetAlertPrefsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertPrefs")
	out := new(SetAlertPrefsResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *sauronJSONClient) GetAlertQueue(ctx context.Context, in *GetAlertQueueReq) (*GetAlertQueueResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertQueue")
	out := new(GetAlertQueueResp)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *sauronJSONClient) SetAlertStatus(ctx context.Context, in *SetAlertStatusReq) (*SetAlertStatusResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertStatus")
	out := new(SetAlertStatusResp)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

// =====================
// Sauron Server Handler
// =====================

type sauronServer struct {
	Sauron
	hooks *twirp.ServerHooks
}

func NewSauronServer(svc Sauron, hooks *twirp.ServerHooks) TwirpServer {
	return &sauronServer{
		Sauron: svc,
		hooks:  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *sauronServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// SauronPathPrefix is used for all URL paths on a twirp Sauron server.
// Requests are always: POST SauronPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SauronPathPrefix = "/twirp/code.justin.tv.cb.sauron.Sauron/"

func (s *sauronServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.cb.sauron")
	ctx = ctxsetters.WithServiceName(ctx, "Sauron")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.cb.sauron.Sauron/GetActivities":
		s.serveGetActivities(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.cb.sauron.Sauron/GetAlertPrefs":
		s.serveGetAlertPrefs(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.cb.sauron.Sauron/SetAlertPrefs":
		s.serveSetAlertPrefs(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.cb.sauron.Sauron/GetAlertQueue":
		s.serveGetAlertQueue(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.cb.sauron.Sauron/SetAlertStatus":
		s.serveSetAlertStatus(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *sauronServer) serveGetActivities(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActivitiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActivitiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sauronServer) serveGetActivitiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActivities")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActivitiesReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetActivitiesResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetActivities(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActivitiesResp and nil error while calling GetActivities. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveGetActivitiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActivities")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetActivitiesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetActivitiesResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetActivities(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActivitiesResp and nil error while calling GetActivities. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveGetAlertPrefs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAlertPrefsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAlertPrefsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sauronServer) serveGetAlertPrefsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertPrefs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAlertPrefsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAlertPrefsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAlertPrefs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAlertPrefsResp and nil error while calling GetAlertPrefs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveGetAlertPrefsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertPrefs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAlertPrefsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAlertPrefsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAlertPrefs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAlertPrefsResp and nil error while calling GetAlertPrefs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveSetAlertPrefs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetAlertPrefsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetAlertPrefsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sauronServer) serveSetAlertPrefsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertPrefs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetAlertPrefsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetAlertPrefsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetAlertPrefs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAlertPrefsResp and nil error while calling SetAlertPrefs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveSetAlertPrefsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertPrefs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetAlertPrefsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetAlertPrefsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetAlertPrefs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAlertPrefsResp and nil error while calling SetAlertPrefs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveGetAlertQueue(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAlertQueueJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAlertQueueProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sauronServer) serveGetAlertQueueJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertQueue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAlertQueueReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAlertQueueResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAlertQueue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAlertQueueResp and nil error while calling GetAlertQueue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveGetAlertQueueProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAlertQueue")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAlertQueueReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAlertQueueResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAlertQueue(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAlertQueueResp and nil error while calling GetAlertQueue. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveSetAlertStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetAlertStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetAlertStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sauronServer) serveSetAlertStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetAlertStatusReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetAlertStatusResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetAlertStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAlertStatusResp and nil error while calling SetAlertStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) serveSetAlertStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetAlertStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetAlertStatusReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetAlertStatusResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetAlertStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetAlertStatusResp and nil error while calling SetAlertStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sauronServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *sauronServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1133 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0x56, 0xf6, 0xaf, 0xce, 0xd9, 0x24, 0x4a, 0x47, 0x01, 0x99, 0x50, 0x4a, 0x64, 0x55, 0x28,
	0x2a, 0x91, 0x53, 0x2d, 0x08, 0xa1, 0x0a, 0x45, 0x34, 0x75, 0x53, 0x72, 0x91, 0x40, 0xbd, 0x0b,
	0x88, 0x5e, 0x54, 0xf2, 0x7a, 0x27, 0xd9, 0x69, 0xbd, 0x1e, 0xe3, 0x19, 0xa7, 0xe4, 0x86, 0x2b,
	0x5e, 0x83, 0xd7, 0xe0, 0xb9, 0x78, 0x00, 0x2e, 0xd0, 0x1c, 0xff, 0x8d, 0x1d, 0x67, 0xd7, 0x91,
	0xe0, 0x6e, 0xe6, 0x9c, 0xef, 0xfc, 0xcc, 0x39, 0xdf, 0x1c, 0x8f, 0xc1, 0x8c, 0x23, 0xff, 0x50,
	0x78, 0x49, 0xcc, 0xc3, 0x43, 0x41, 0xe3, 0x2b, 0xe6, 0x53, 0x3b, 0x8a, 0xb9, 0xe4, 0xc4, 0xf4,
	0xf9, 0x8c, 0xda, 0x6f, 0x13, 0x21, 0x59, 0x68, 0xcb, 0x2b, 0xdb, 0x9f, 0xda, 0x29, 0x6e, 0xf7,
	0xd3, 0x4b, 0xce, 0x2f, 0x03, 0x7a, 0x88, 0xb8, 0x69, 0x72, 0x71, 0x28, 0xd9, 0x82, 0x0a, 0xe9,
	0x2d, 0xa2, 0xd4, 0xd4, 0x7a, 0x03, 0xdb, 0x2f, 0xa9, 0x7c, 0xe6, 0x4b, 0x76, 0xc5, 0x24, 0xa3,
	0xc2, 0xa5, 0xbf, 0x92, 0x07, 0xb0, 0xee, 0xcf, 0xbd, 0x30, 0xa4, 0xc1, 0xa9, 0x63, 0xae, 0xed,
	0xad, 0xed, 0xaf, 0xbb, 0xa5, 0x80, 0x7c, 0x08, 0x03, 0x3f, 0x89, 0x05, 0x8f, 0xcd, 0x0e, 0xaa,
	0xb2, 0x1d, 0xd9, 0x81, 0x7e, 0xc0, 0x16, 0x4c, 0x9a, 0xdd, 0xbd, 0xb5, 0xfd, 0xae, 0x9b, 0x6e,
	0xac, 0x9f, 0xe1, 0x7e, 0xcd, 0xbf, 0x88, 0xc8, 0x31, 0x80, 0x57, 0x48, 0xcc, 0xb5, 0xbd, 0xee,
	0xfe, 0x70, 0x64, 0xd9, 0xb7, 0x1d, 0xc2, 0xce, 0xac, 0xaf, 0x5d, 0xcd, 0xca, 0x7a, 0x92, 0x26,
	0x1e, 0xd0, 0x58, 0xfe, 0x10, 0xd3, 0x8b, 0xd5, 0x89, 0x5b, 0xbf, 0xa4, 0xa9, 0x68, 0x16, 0x22,
	0x22, 0x0e, 0x80, 0x57, 0x48, 0xd0, 0x66, 0x38, 0x7a, 0xb4, 0x24, 0x95, 0xd2, 0x5a, 0xb3, 0xb3,
	0x26, 0xb0, 0x3d, 0xbe, 0x53, 0x32, 0x64, 0x1b, 0xba, 0xef, 0xe8, 0x75, 0x56, 0x42, 0xb5, 0x54,
	0x92, 0x2b, 0x2f, 0xc0, 0xea, 0x19, 0xae, 0x5a, 0xaa, 0x84, 0xc7, 0xff, 0x53, 0xc2, 0x6f, 0xca,
	0xea, 0xbd, 0x4a, 0x68, 0x42, 0xff, 0xeb, 0xb6, 0x7f, 0x5f, 0xd6, 0x3a, 0xf3, 0x2f, 0x22, 0xf2,
	0x14, 0x06, 0x98, 0xc2, 0x5d, 0x5a, 0x9e, 0x59, 0x58, 0xa2, 0xac, 0xc5, 0x58, 0x7a, 0x32, 0x69,
	0x51, 0xe2, 0x87, 0x05, 0xcb, 0xae, 0x4f, 0x9d, 0x2c, 0x6b, 0x4d, 0x42, 0xf6, 0x60, 0xe8, 0x95,
	0xfe, 0x30, 0xff, 0x75, 0x57, 0x17, 0x59, 0x13, 0x20, 0xf5, 0xa0, 0x22, 0x22, 0x47, 0x60, 0xe4,
	0x5e, 0xb2, 0xfa, 0xb7, 0x39, 0x48, 0x61, 0x63, 0xfd, 0xdd, 0x01, 0x28, 0xdb, 0xb2, 0xe2, 0x10,
	0x47, 0xb0, 0x11, 0x78, 0x42, 0x9e, 0xf1, 0x19, 0xbb, 0x60, 0x74, 0x86, 0xc7, 0x18, 0x8e, 0x76,
	0xed, 0xf4, 0x5e, 0xdb, 0xf9, 0xbd, 0xb6, 0x27, 0xf9, 0xbd, 0x76, 0x2b, 0x78, 0xf2, 0x19, 0x6c,
	0x39, 0xe7, 0xce, 0x19, 0x9f, 0xd1, 0x17, 0xa1, 0x37, 0x0d, 0xe8, 0x2c, 0x23, 0x58, 0x4d, 0xaa,
	0x8a, 0x31, 0x67, 0x33, 0x7a, 0xc2, 0x83, 0x80, 0xbf, 0x17, 0x66, 0x0f, 0x41, 0xba, 0x48, 0xe5,
	0xa9, 0xb6, 0xae, 0xc7, 0x66, 0xc2, 0xec, 0xa3, 0xbe, 0x14, 0xe4, 0xda, 0xef, 0xb8, 0x90, 0xc2,
	0x1c, 0x94, 0x5a, 0x14, 0x90, 0x5d, 0x30, 0xd4, 0xe6, 0x98, 0x49, 0x61, 0xde, 0x43, 0x65, 0xb1,
	0x27, 0x07, 0x70, 0x5f, 0xad, 0xc7, 0xc9, 0x54, 0xf8, 0x31, 0x8b, 0x24, 0xe3, 0xa1, 0x30, 0x0d,
	0x04, 0xdd, 0x54, 0x90, 0x2f, 0xe1, 0x03, 0x25, 0x7c, 0xc9, 0x2e, 0x64, 0xd5, 0x62, 0x1d, 0x2d,
	0x9a, 0x95, 0xd6, 0x5f, 0x3d, 0x30, 0xf2, 0x4e, 0x90, 0x2d, 0xe8, 0x14, 0x95, 0xee, 0x9c, 0x3a,
	0xe4, 0x6b, 0x58, 0x2f, 0xa6, 0x62, 0x8b, 0xfa, 0x96, 0x60, 0x42, 0xa0, 0x27, 0xaf, 0x23, 0x9a,
	0x51, 0x07, 0xd7, 0xda, 0x3d, 0xe9, 0x55, 0xee, 0xc9, 0x57, 0xd0, 0x9b, 0xaa, 0xe3, 0xf7, 0x57,
	0x31, 0x46, 0x15, 0xc5, 0xf1, 0xa4, 0xe7, 0x22, 0x9e, 0x1c, 0xc1, 0xbd, 0x8b, 0xac, 0x29, 0x83,
	0x55, 0x97, 0x3d, 0x6d, 0x15, 0x1a, 0xe7, 0x46, 0x2a, 0xee, 0x9c, 0x0b, 0x89, 0x65, 0x5f, 0x1a,
	0x57, 0x75, 0x2a, 0x8d, 0xab, 0xf0, 0xca, 0x2e, 0xf6, 0xd8, 0x0c, 0x3b, 0xb1, 0xd4, 0x4e, 0xf5,
	0x3f, 0xb5, 0x53, 0x78, 0x72, 0x0e, 0x1b, 0x42, 0xab, 0x3d, 0xf6, 0x65, 0x38, 0x7a, 0x7c, 0xbb,
	0xbd, 0xde, 0x29, 0xf4, 0x53, 0xb1, 0x27, 0xaf, 0x61, 0x5b, 0xdf, 0xab, 0xde, 0x9a, 0x80, 0x3e,
	0xed, 0x76, 0x3e, 0x95, 0x05, 0xfa, 0xbd, 0xe1, 0xa7, 0x3e, 0x01, 0x86, 0x37, 0x27, 0xc0, 0x5b,
	0xd8, 0xd1, 0x7d, 0x9d, 0xc4, 0xde, 0xe5, 0x82, 0x86, 0x52, 0xcd, 0x00, 0xba, 0xe0, 0x92, 0xf9,
	0x3c, 0x5c, 0x3d, 0x03, 0x5e, 0x64, 0x48, 0xb7, 0xb0, 0x41, 0xe6, 0xd0, 0xdf, 0x64, 0x36, 0x95,
	0x70, 0x6d, 0x3d, 0x01, 0x23, 0x47, 0xde, 0xe0, 0xe8, 0x0e, 0xf4, 0x05, 0x95, 0xc5, 0x18, 0x4b,
	0x37, 0x56, 0x04, 0x46, 0xce, 0x16, 0x35, 0xed, 0x14, 0x5f, 0x9e, 0x2d, 0x78, 0x12, 0x4a, 0xb4,
	0xec, 0xba, 0x9a, 0x84, 0x3c, 0x82, 0x4d, 0xdc, 0x85, 0x3c, 0xbc, 0x5e, 0xf0, 0x44, 0xa0, 0x27,
	0xc3, 0xad, 0x0a, 0x73, 0x2f, 0x3f, 0x0a, 0x1a, 0x9f, 0x3a, 0x19, 0xaf, 0x35, 0x89, 0x75, 0x00,
	0x50, 0x92, 0x4c, 0xa1, 0x53, 0x9a, 0x21, 0x3a, 0xcd, 0x56, 0x93, 0x58, 0x2e, 0x18, 0x39, 0xab,
	0xd4, 0xbd, 0x50, 0xbc, 0x2a, 0x70, 0xd9, 0x8e, 0xd8, 0x40, 0xd4, 0x8a, 0x85, 0x97, 0x3f, 0x31,
	0xfa, 0x9e, 0xc6, 0xcf, 0x31, 0xff, 0x0e, 0xe6, 0xdf, 0xa0, 0xb1, 0x42, 0x30, 0x72, 0xc6, 0xa9,
	0xb1, 0xa2, 0x38, 0xa7, 0x45, 0x2f, 0xf6, 0xca, 0xaf, 0x5a, 0x37, 0xf8, 0xed, 0xbb, 0x0d, 0x1a,
	0x95, 0x9f, 0x28, 0x3f, 0x04, 0x7d, 0x37, 0xdb, 0x59, 0x7f, 0xf4, 0x60, 0xbb, 0x4e, 0x51, 0x62,
	0x15, 0x24, 0x9f, 0x6a, 0xc1, 0x2b, 0x32, 0xf2, 0xb8, 0x4a, 0xdc, 0x09, 0xa3, 0xf9, 0xa7, 0xf3,
	0x86, 0x9c, 0x9c, 0x83, 0xa5, 0xcb, 0x9e, 0x27, 0x8b, 0x24, 0xf0, 0x24, 0xbb, 0xa2, 0x13, 0x1a,
	0x26, 0x31, 0x3d, 0xe3, 0xa1, 0x9c, 0x8b, 0xec, 0x0b, 0xdb, 0x02, 0x49, 0x7e, 0xaf, 0xfb, 0x13,
	0x92, 0x2f, 0xce, 0xa8, 0x10, 0xde, 0x25, 0xcd, 0x39, 0xac, 0x86, 0x7c, 0xb7, 0xfd, 0x35, 0xca,
	0xcd, 0xdc, 0x16, 0x9e, 0x89, 0x03, 0x9f, 0xdc, 0x8a, 0x9a, 0x28, 0xde, 0xf7, 0xb1, 0x10, 0xcb,
	0x41, 0xe4, 0x04, 0x1e, 0xea, 0x80, 0xb3, 0x24, 0x90, 0x0c, 0x0f, 0xe8, 0x24, 0xb1, 0x87, 0xc3,
	0x65, 0x80, 0x15, 0x59, 0x81, 0x22, 0xc7, 0xf0, 0xa0, 0x19, 0x91, 0xd6, 0x0c, 0x47, 0x63, 0xd7,
	0x5d, 0x8a, 0xb1, 0xfe, 0xe9, 0x54, 0x27, 0x41, 0x3e, 0x55, 0xc8, 0x08, 0x76, 0xea, 0x73, 0x45,
	0xa3, 0x44, 0xa3, 0x8e, 0x7c, 0x03, 0x1f, 0xd5, 0xe5, 0xf5, 0x7b, 0x79, 0x3b, 0x80, 0x3c, 0x05,
	0xb3, 0xae, 0x7c, 0x95, 0x78, 0xa1, 0x54, 0xef, 0x91, 0x94, 0x22, 0xb7, 0xea, 0xc9, 0xb7, 0xf0,
	0x71, 0x5d, 0xe7, 0x52, 0x9f, 0x45, 0x8c, 0x86, 0xea, 0x6a, 0xa6, 0x9f, 0xac, 0x65, 0x90, 0xa6,
	0xf3, 0x22, 0xb5, 0xfb, 0xcd, 0xe7, 0x45, 0x7a, 0x37, 0x44, 0xc5, 0xda, 0x66, 0xc3, 0x2a, 0xed,
	0xe2, 0x32, 0xc8, 0xe8, 0xcf, 0x1e, 0x0c, 0xc6, 0x48, 0x4a, 0x32, 0x87, 0xcd, 0xca, 0x1f, 0x05,
	0x59, 0xf2, 0x6d, 0xa9, 0xff, 0xda, 0xec, 0x7e, 0xde, 0x1a, 0x2b, 0xa2, 0x3c, 0x52, 0xf9, 0x54,
	0x5b, 0x11, 0x49, 0x7f, 0xfe, 0xaf, 0x8a, 0x54, 0x7d, 0xd4, 0xcf, 0x61, 0x73, 0xdc, 0x36, 0xd2,
	0xf8, 0x0e, 0x91, 0xc6, 0x4d, 0x91, 0x2a, 0x0f, 0xf3, 0x36, 0x67, 0xca, 0xff, 0x10, 0xda, 0x9c,
	0xa9, 0x7c, 0xed, 0xbf, 0x83, 0xad, 0xea, 0xe3, 0x99, 0xb4, 0x48, 0xb4, 0x78, 0xdb, 0xef, 0x1e,
	0xb4, 0x07, 0x8b, 0xe8, 0x78, 0xe3, 0x35, 0x94, 0x7f, 0xc7, 0xd3, 0x01, 0x3e, 0xdb, 0xbe, 0xf8,
	0x37, 0x00, 0x00, 0xff, 0xff, 0xcd, 0x06, 0x08, 0xf1, 0x32, 0x0f, 0x00, 0x00,
}
