#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/cb/sauron-api:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-sauron-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

echo "cb-sauron-$ENVIRONMENT-api-$GIT_COMMIT"

eb deploy cb-sauron-$ENVIRONMENT-api \
  --label $ENVIRONMENT-api-$GIT_COMMIT \
  --message "$BRANCH" \
  --timeout 25 \
  --verbose

echo "cb.sauron.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u graphite-ingest.central.twitch.a2z.com 8125
