variable "alert_preferences_table_arn" {
  type = string
}

variable "allow_assume_role_arn" {
  type        = string
  description = "AWS IAM Role ARN to allow to assume the application's role.  Used to allow jenkins to assume the development role so as to run integration tests"
  default     = ""
}

variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_key_name" {
  type = string
}

variable "aws_profile" {
  type = string
}

variable "aws_region" {
  type = string
}

variable "channel_activity_table_arn" {
  type = string
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "sauron"
  description = "AWS resource name"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Owner contact email"
}

variable "private_subnets" {
  type        = string
  description = "Twitch businessviewcount private subnets"
}

variable "project" {
  type        = string
  default     = "cb/sauron"
  description = "GitHub repository name"
}

variable "security_group" {
  type        = string
  description = "Sauron security group"
}

variable "solution_stack_name" {
  type        = string
  default     = "64bit Amazon Linux 2018.03 v2.12.14 running Docker 18.06.1-ce"
  description = "Application stack specification"
}

variable "team" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "vpc_id" {
  type        = string
  description = "Saron vpc id"
}
