resource "aws_dynamodb_table" "channel_activity" {
  name           = "${var.name}-${var.environment}-channel_activity"
  billing_mode   = "PAY_PER_REQUEST"
  hash_key       = "channel_id"
  range_key      = "timestamp"

  attribute {
    name = "channel_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "S"
  }

  attribute {
    name = "id"
    type = "S"
  }

  global_secondary_index {
    name            = "ChannelEventIndex"
    hash_key        = "channel_id"
    range_key       = "id"
    projection_type = "ALL"
  }

  ttl {
    attribute_name = "expires"
    enabled        = true
  }

  point_in_time_recovery {
    enabled = true
  }

  tags = {
    DDBTableGroupKey-Sauron = "Sauron"
    Environment = var.environment
    Project = "cb/sauron"
  }
}

resource "aws_dynamodb_table" "alert_preferences" {
  name           = "${var.name}-${var.environment}-alert_preferences"
  billing_mode   = "PAY_PER_REQUEST"
  hash_key       = "channel_id"

  attribute {
      name = "channel_id"
      type = "S"
    }

  point_in_time_recovery {
    enabled = true
  }

  tags = {
    DDBTableGroupKey-Sauron = "Sauron"
    Environment = var.environment
    Project = "cb/sauron"
  }
}

resource "aws_dynamodb_table" "rate_limit" {
  name           = "${var.name}-${var.environment}-rate_limit"
  billing_mode   = "PAY_PER_REQUEST"
  hash_key       = "key"

  attribute {
      name = "key"
      type = "S"
    }
    
  ttl {
    attribute_name = "expires"
    enabled        = true
  }

  point_in_time_recovery {
    enabled = true
  }

  tags = {
    DDBTableGroupKey-Sauron = "Sauron"
    Environment = var.environment
    Project = "cb/sauron"
  }
}
