variable "api_name" {
  type        = string
  description = "Name of the API Lambda function"
}

variable "aws_profile" {
  type = string
}

variable "aws_region" {
  type = string
}

variable "dynamodb_table_name" {
  type        = string
  description = "Name of the DynamoDB table to query"
}

variable "edge_graphql_aws_account_arn" {
  type        = string
  description = "ARN of the AWS account that owns the `edge/graphql` service"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "lambda_description" {
  type        = string
  description = "Short description of what this lambda does"
}

variable "lambda_iam_role_arn" {
  type        = string
  description = "ARN of the shared IAM Role for all Lambda functions"
}

variable "lambda_reserved_concurrent_executions" {
  type        = string
  description = "Number of concurrent executions reserved for the Lambda function"
  default     = 50
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Owner contact email"
}

variable "project" {
  type        = string
  default     = "cb/sauron"
  description = "GitHub repository name"
}

variable "service_name" {
  type        = string
  default     = "sauron"
  description = "AWS resource name"
}

variable "statsd_host" {
  type        = string
  description = "Hostname for graphite stats collection"
}

variable "team_name" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "rollbar_token_secret_key" {
  type = string
}

variable "rollbar_token_secret_name" {
  type = string
}

locals {
  api_lambda_handler_name = "${var.team_code}-${var.service_name}-${var.environment}-api-${var.api_name}"
}
