data "aws_iam_policy_document" "assume_lambda_role" {
  statement {
    effect  = "Allow"
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["lambda.amazonaws.com"]
    }
  }
}

resource "aws_iam_role" "lambda" {
  name               = "cb-sauron-${var.environment}-lambda"
  assume_role_policy = data.aws_iam_policy_document.assume_lambda_role.json
}

resource "aws_iam_role_policy_attachment" "lambda_vpc_access_execution_role" {
  role       = aws_iam_role.lambda.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole"
}

resource "aws_iam_role_policy_attachment" "lambda_sqs_queue_execution_role" {
  role       = aws_iam_role.lambda.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole"
}

# Secrets Manager
resource "aws_iam_role_policy_attachment" "lambda_secrets_manager_access" {
  role       = aws_iam_role.lambda.name
  policy_arn = "arn:aws:iam::aws:policy/SecretsManagerReadWrite"
}

# DYNAMODB
data "aws_iam_policy_document" "allow_dynamodb_query" {
  statement {
    effect    = "Allow"
    actions   = ["dynamodb:*"]
    resources = [var.dynamodb_table_arn, var.alert_preferences_table_arn, var.rate_limit_table_arn]
  }

  statement {
    effect    = "Allow"
    actions   = ["dynamodb:Query"]
    resources = ["${var.dynamodb_table_arn}/index/*", "${var.alert_preferences_table_arn}/index/*", "${var.rate_limit_table_arn}/index/*"]
  }
}

resource "aws_iam_role_policy" "allow_dynamodb_query" {
  name   = "allow-dynamodb-query"
  role   = aws_iam_role.lambda.name
  policy = data.aws_iam_policy_document.allow_dynamodb_query.json
}

data "aws_cloudformation_export" "eventbus_access_policy_arn" {
  name = "eventbus-access-policy-arn"
}

resource "aws_iam_role_policy_attachment" "eventbus_access_attach" {
  role       = aws_iam_role.lambda.name
  policy_arn = data.aws_cloudformation_export.eventbus_access_policy_arn.value
}

# PDMS
resource "aws_iam_role_policy" "pdms" {
  name   = "allow-pdms-invoke"
  role = aws_iam_role.lambda.name
  policy = data.aws_iam_policy_document.pdms_role_policy.json
}

data "aws_iam_policy_document" "pdms_role_policy" {
  version = "2012-10-17"
  statement {
    effect = "Allow"
    actions = ["sts:AssumeRole"]
    resources = [var.pdms_caller_role_arn]
  }
}

resource "aws_iam_policy" "dlq_policy" {
  name = "cb-sauron-${var.environment}-dlq-send"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "sqs:SendMessage"
      ],
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
  EOF
}

resource "aws_iam_role_policy_attachment" "dlq_send" {
  role       = aws_iam_role.lambda.id
  policy_arn = aws_iam_policy.dlq_policy.arn
}