resource "aws_sqs_queue" "sns_subscriber" {
  name = local.sqs_lambda_handler_name

  visibility_timeout_seconds = 60
  message_retention_seconds  = 7200

  lifecycle {
    prevent_destroy = true
  }
}

data "aws_iam_policy_document" "sqs_queue_policy" {
  statement {
    effect    = "Allow"
    actions   = ["SQS:SendMessage"]
    resources = [aws_sqs_queue.sns_subscriber.arn]

    principals {
      type        = "AWS"
      identifiers = ["*"]
    }

    condition {
      test     = "ArnEquals"
      variable = "aws:SourceArn"
      values   = [var.sns_topic_arn]
    }
  }
}

resource "aws_sqs_queue_policy" "sns_subscriber" {
  queue_url = aws_sqs_queue.sns_subscriber.id
  policy    = data.aws_iam_policy_document.sqs_queue_policy.json
}

resource "aws_sns_topic_subscription" "sqs_queue_subscription" {
  topic_arn = var.sns_topic_arn
  protocol  = "sqs"
  endpoint  = aws_sqs_queue.sns_subscriber.arn
}
