variable "alert_preferences_table_name" {
  type        = string
  description = "Name of the DynamoDB alert preferences table"
}

variable "aws_profile" {
  type = string
}

variable "aws_region" {
  type = string
}

variable "dynamodb_table_name" {
  type        = string
  description = "Name of the DynamoDB table to query"
}

variable "rate_limit_table_name" {
  type        = string
  description = "Name of the DynamoDB rate limit table"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "lambda_iam_role_arn" {
  type        = string
  description = "ARN of the shared IAM Role for all Lambda functions"
}

variable "timeout" {
  description = "The amount of time the lambda has to run in seconds."
  type        = string
  default     = "3"
}

variable "lambda_reserved_concurrent_executions" {
  type        = string
  description = "Number of concurrent executions reserved for the Lambda function"
  default     = 50
}

variable "liveline_host" {
  type        = string
  description = "Host of liveline service (this is a vpc endpoint)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Owner contact email"
}

variable "pubsub_host" {
  type        = string
  description = "Host of the Chat team's PubSub Broker service"
}

variable "project" {
  type        = string
  default     = "cb/sauron"
  description = "GitHub repository name"
}

variable "service_name" {
  type        = string
  default     = "sauron"
  description = "AWS resource name"
}

variable "sns_topic_arn" {
  type        = string
  description = "ARN of the SNS topic to which the Lambda's SQS queue is subscribed"
}

variable "sns_topic_name" {
  type        = string
  description = "Name of the SNS topic to which the SQS queue is subscribed, e.g. 'bits-usage', 'follow', etc."
}

variable "statsd_host" {
  type        = string
  description = "Hostname for graphite stats collection"
}

variable "subscriptions_host" {
  type        = string
  description = "Host of the Subscriptions team's Subscriptions service"
}

variable "copo_host" {
  type        = string
  description = "Host of the Copo service"
}

variable "team_name" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "rollbar_token_secret_key" {
  type = string
}

variable "rollbar_token_secret_name" {
  type = string
}

variable "users_service_host" {
  type        = string
  description = "Host of the Identity team's Users Service"
}

variable "zuma_host" {
  type        = string
  description = "Host of the Chat team's Zuma service"
}

locals {
  sqs_lambda_handler_name = "${var.team_code}-${var.service_name}-${var.environment}-${var.sns_topic_name}"
}
