// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-07-01 20:06:34.231604 -0400 EDT m=+0.058760760
// Template path: handler_definitions/templates/terraform/modules/app/main.tf.tmpl

module beanstalk {
  source = "./beanstalk"

  allow_assume_role_arn = "arn:aws:iam::989470033077:user/devtools-jenkins"
  aws_key_name          = "cb-sauron-${var.environment}"
  aws_profile           = var.aws_profile
  aws_region            = var.aws_region
  environment           = var.environment

  asg_max_size = 4
  asg_min_size = 2

  private_subnets = "subnet-45e7ad0c,subnet-6f4a7808,subnet-86fe23dd"
  security_group  = "sg-57251d2c"
  vpc_id          = "vpc-7851b71e"

  channel_activity_table_arn  = module.dynamodb.channel_activity_table_arn
  alert_preferences_table_arn = module.dynamodb.alert_preferences_table_arn
}

module dynamodb {
  source      = "./dynamodb"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment
}

module shared_lambda_iam_role {
  source      = "./lambda"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment
  pdms_caller_role_arn = var.pdms_caller_role_arn

  dynamodb_table_arn          = module.dynamodb.channel_activity_table_arn
  alert_preferences_table_arn = module.dynamodb.alert_preferences_table_arn
  rate_limit_table_arn        = module.dynamodb.rate_limit_table_arn
}

module api_get_activities {
  source      = "./lambda/api"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  api_name                              = "get-activities"
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  edge_graphql_aws_account_arn          = var.edge_graphql_aws_account_arn
  lambda_description                    = "Retrieves channel activity"
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = 25
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

module eventbus_handler {
  source      = "./lambda/sqs_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["event_bus"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  handler_name                          = "event-bus"
  sqs_queue_name                        = "cb-sauron-${var.environment}-eventbus"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
  timeout                               = "20"
  pdms_caller_role_arn                  = var.pdms_caller_role_arn
  pdms_lambda_arn                       = var.pdms_lambda_arn
}


# https://git.xarth.tv/commerce/payday/blob/704849ffe78540ddc6009d4e85cbc0929c51fcb6/api/event.go#L142-L149
module payday_bits_usage {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["payday_bits_usage"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["payday_bits_usage"]
  sns_topic_name                        = "payday-bits-usage"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://git.xarth.tv/chat/tmi/blob/d705ae39b9f3ccc23e476747a5b1fb8b0158dfd3/client/sns.go#L35-L44
module clue_hosting_events {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["clue_hosting_events"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["clue_hosting_events"]
  sns_topic_name                        = "clue-hosting-events"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
  timeout                               = "10"
}

# https://git.xarth.tv/revenue/subscriptions/blob/40a042bad5e0aea302f7bf47fcb5e2083920047d/internal/app/chatnotification/chatnotification.go#L202-L211
module subscriptions_subscription_notice {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["subscriptions_subscription_notice"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["subscriptions_subscription_notice"]
  sns_topic_name                        = "subscriptions-subscription-notice"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
  timeout                               = "6"
}

# https://git.xarth.tv/revenue/lambdwich/blob/3e07958b74b6c4c97e8dbd90c3ba4def087d3a3d/app/functions/publish_gift_fulfillment_success/main.go#L46-L55
module lambdwich_fulfillment_status {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["lambdwich_fulfillment_status"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["lambdwich_fulfillment_status"]
  sns_topic_name                        = "lambdwich-fulfillment-status"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://git.xarth.tv/revenue/lambdwich/blob/afc5d096cd1bd910eb39b53da2af14fde4e15e06/app/functions/publish_multi_gift_start/main.go#L32-L40
module lambdwich_mmg_status {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["lambdwich_mmg_status"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["lambdwich_mmg_status"]
  sns_topic_name                        = "lambdwich-mmg-status"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://code.amazon.com/packages/TwitchPromotionsBoosterLambda/blobs/a80217178902eb598a9692b80ae63f799cdcbf2e/--/internal/sns/messages.go#L10-L17
module boost_activity_feed {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["boost_activity_feed"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["boost_activity_feed"]
  sns_topic_name                        = "boost-activity-feed"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
  timeout                               = "6"
}

# https://git.xarth.tv/commerce/percy/blob/master/models/sns.go#L40-L45
module celebration_purchase_activity_feed {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["celebration_purchase_activity_feed"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["celebration_purchase_activity_feed"]
  sns_topic_name                        = "celebration-purchase-activity-feed"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://git.xarth.tv/chat/copo/blob/7fc24cbe002f64456c11f7efbb3e7ca85ba10386/internal/snsapi/messages.go#L3-L9
module copo_custom_reward_redemption {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["copo_custom_reward_redemption"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["copo_custom_reward_redemption"]
  sns_topic_name                        = "copo-custom-reward-redemption"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://git.xarth.tv/chat/copo/blob/78adeb094154bfd4ef5ccba3abb5d7722da69bce/internal/snsapi/messages.go#L18-L25
module copo_goal_update {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["copo_goal_update"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["copo_goal_update"]
  sns_topic_name                        = "copo-goal-update"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://code.amazon.com/packages/TwitchDropsFulfillmentService/blobs/767c5eba29c241b55763480351a1071918ae834f/--/sns/activity_feed_topic.go#L19-L25
module drops_activity_notifications {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["drops_activity_feed"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["drops_activity_feed"]
  sns_topic_name                        = "drops-activity-feed"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}

# https://git.xarth.tv/commerce/percy/blob/67739b0a200da9f9b78b54dd4a98ba7041521e20/models/sns.go#L32-L39
module hype_train_activity_feed {
  source      = "./lambda/sns_handler"
  aws_profile = var.aws_profile
  aws_region  = var.aws_region
  environment = var.environment

  alert_preferences_table_name          = module.dynamodb.alert_preferences_table_name
  dynamodb_table_name                   = module.dynamodb.channel_activity_table_name
  rate_limit_table_name                 = module.dynamodb.rate_limit_table_name
  lambda_iam_role_arn                   = module.shared_lambda_iam_role.arn
  lambda_reserved_concurrent_executions = var.lambda_reserved_concurrent_executions["hype_train_activity_feed"]
  liveline_host                         = var.liveline_host
  pubsub_host                           = var.pubsub_host
  sns_topic_arn                         = var.sns_topic_arn["hype_train_activity_feed"]
  sns_topic_name                        = "hype-train-activity-feed"
  subscriptions_host                    = var.subscriptions_host
  copo_host                             = var.copo_host
  users_service_host                    = var.users_service_host
  zuma_host                             = var.zuma_host
  statsd_host                           = var.statsd_host
  rollbar_token_secret_key              = var.rollbar_token_secret_key
  rollbar_token_secret_name             = var.rollbar_token_secret_name
}


module "copo_vpc_endpoint" {
  source            = "./vpc_endpoint"
  aws_profile       = var.aws_profile
  aws_region        = var.aws_region
  service_dns_entry = var.copo_service_dns_entry
  create_dns_entry  = true
  service_name      = var.copo_service_name
}

module "zuma_vpc_endpoint" {
  source = "./vpc_endpoint"
  aws_profile       = var.aws_profile
  aws_region        = var.aws_region
  service_dns_entry = var.zuma_service_dns_entry
  create_dns_entry  = true
  service_name      = var.zuma_service_name
}
