

resource "aws_vpc_endpoint" "main" {
  vpc_id              = data.terraform_remote_state.account.outputs.vpc_id
  service_name        = var.service_name
  vpc_endpoint_type   = "Interface"
  private_dns_enabled = false
  subnet_ids         = split(",", data.terraform_remote_state.account.outputs.private_subnets)
  security_group_ids = [data.terraform_remote_state.account.outputs.twitch_subnets_sg]
}

resource "aws_route53_zone" "main" {
  name       = var.service_dns_entry
  comment    = "Private zone for VPC endpoints"
  depends_on = [aws_vpc_endpoint.main]
  count      = var.create_dns_entry ? 1 : 0

  vpc {
    vpc_id = data.terraform_remote_state.account.outputs.vpc_id
  }
}

resource "aws_route53_record" "main" {
  zone_id    = aws_route53_zone.main[count.index].id
  name       = var.service_dns_entry
  type       = "A"
  depends_on = [aws_vpc_endpoint.main]
  count      = var.create_dns_entry ? 1 : 0

  alias {
    name                   = aws_vpc_endpoint.main.dns_entry[0].dns_name
    zone_id                = aws_vpc_endpoint.main.dns_entry[0].hosted_zone_id
    evaluate_target_health = false
  }
}
