# Get activities
resource "aws_cloudwatch_metric_alarm" "get_activities_lambda_errors" {
  alarm_name = "${var.get_activities_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 3
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 25

  dimensions = {
    FunctionName = var.get_activities_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "get_activities_lambda_duration" {
  alarm_name = "${var.get_activities_lambda_name}-lambda-duration"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Duration"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Average"
  threshold           = 15000                           # 15 seconds

  dimensions = {
    FunctionName = var.get_activities_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "get_activities_lambda_invocations" {
  alarm_name = "${var.get_activities_lambda_name}-lambda-invocations"

  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Invocations"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Maximum"
  threshold           = 0

  dimensions = {
    FunctionName = var.get_activities_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Get alert preferences
resource "aws_cloudwatch_metric_alarm" "get_alert_preferences_lambda_errors" {
  alarm_name = "${var.get_alert_preferences_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 10

  dimensions = {
    FunctionName = var.get_alert_preferences_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "get_alert_preferences_lambda_duration" {
  alarm_name = "${var.get_alert_preferences_lambda_name}-lambda-duration"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Duration"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Average"
  threshold           = 10000                           # 10 seconds

  dimensions = {
    FunctionName = var.get_alert_preferences_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Set alert preferences
resource "aws_cloudwatch_metric_alarm" "set_alert_preferences_lambda_errors" {
  alarm_name = "${var.set_alert_preferences_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 10

  dimensions = {
    FunctionName = var.set_alert_preferences_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "set_alert_preferences_lambda_duration" {
  alarm_name = "${var.set_alert_preferences_lambda_name}-lambda-duration"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Duration"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Average"
  threshold           = 10000                           # 10 seconds

  dimensions = {
    FunctionName = var.set_alert_preferences_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
