package types

// Fragment indicates a substring in CustomMessage.Text that should be enriched with an emoticon.
type Fragment struct {
	Emoticon Emoticon `dynamodbav:"emoticon" json:"emoticon"`
	Text     string   `dynamodbav:"text" json:"text"`
}

// Emoticon contains metadata for a Twitch emote/emoticon.
type Emoticon struct {
	ID    string `dynamodbav:"id" json:"id"`
	SetID string `dynamodbav:"set_id" json:"set_id"`
}

// User is a slim version of the JSON user object returned from the Users Service.
// User is for any type of Twitch user, e.g. follower, Bits spender, subscription recipient, etc.
type User struct {
	ID          string `json:"id"`
	Login       string `json:"login"`
	DisplayName string `json:"display_name"`
}

func (u *User) IfNotAnonymous(anonymous bool) *User {
	if !anonymous {
		return u
	}
	return nil
}
