// Code generated by protoc-gen-twirp v5.5.2, DO NOT EDIT.
// source: copo.proto

/*
Package copo is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.2.

It is generated from these files:
	copo.proto
*/
package copo

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==============
// Copo Interface
// ==============

// Copo provides APIs for managing a user or channel's Community Points
type Copo interface {
	// GetBalance gets a user's community points balance in a channel.
	// SLO@750ms
	GetBalance(context.Context, *GetBalanceRequest) (*GetBalanceResponse, error)

	// GetChannelSettings returns a channel's community points settings.
	// SLO@500ms
	GetChannelSettings(context.Context, *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error)

	// UpdateChannelSettings modifies a channel's community points settings (name and enabled).
	// SLO@500ms
	UpdateChannelSettings(context.Context, *UpdateChannelSettingsRequest) (*UpdateChannelSettingsResponse, error)

	// GetAvailableClaim returns a user's available claim for a channel.
	// SLO@500ms
	GetAvailableClaim(context.Context, *GetAvailableClaimRequest) (*GetAvailableClaimResponse, error)

	// ClaimPoints claims a user's available claim for a channel and returns their new balance.
	// SLO@1000ms
	ClaimPoints(context.Context, *ClaimPointsRequest) (*ClaimPointsResponse, error)

	// GetAutomaticRewards returns the automatic rewards on a channel
	// SLO@500ms
	GetAutomaticRewards(context.Context, *GetAutomaticRewardsRequest) (*GetAutomaticRewardsResponse, error)

	// UpdateAutomaticReward modifies a channel's override for the given automatic reward type.
	// SLO@500ms
	UpdateAutomaticReward(context.Context, *UpdateAutomaticRewardRequest) (*UpdateAutomaticRewardResponse, error)

	// ListCustomRewards returns the custom rewards on a channel
	// SLO@500ms
	ListCustomRewards(context.Context, *ListCustomRewardsRequest) (*ListCustomRewardsResponse, error)

	// GetCustomReward returns a single custom reward
	// SLO@400ms
	GetCustomReward(context.Context, *GetCustomRewardRequest) (*GetCustomRewardResponse, error)

	// CreateCustomReward creates a new custom reward for a channel
	// SLO@600ms
	CreateCustomReward(context.Context, *CreateCustomRewardRequest) (*CreateCustomRewardResponse, error)

	// UpdateCustomReward updates a custom reward for a channel
	// SLO@600ms
	UpdateCustomReward(context.Context, *UpdateCustomRewardRequest) (*UpdateCustomRewardResponse, error)

	// RemoveCustomReward removes a custom reward for a channel
	// SLO@500ms
	RemoveCustomReward(context.Context, *RemoveCustomRewardRequest) (*RemoveCustomRewardResponse, error)

	// RedeemAutomaticReward redeems a user's points for a specified reward
	// SLO@1000ms
	RedeemAutomaticReward(context.Context, *RedeemAutomaticRewardRequest) (*RedeemAutomaticRewardResponse, error)

	// ListRedemptions returns a paginated list of custom reward redemptions.
	// SLO@500ms
	ListRedemptions(context.Context, *ListRedemptionsRequest) (*ListRedemptionsResponse, error)

	// RedeemCustomReward redeems a user's points for a specified custom reward
	// SLO@1000ms
	RedeemCustomReward(context.Context, *RedeemCustomRewardRequest) (*RedeemCustomRewardResponse, error)

	// EditRedemptionStatus changes the status of a redemption (for example from UNFULFILLED to FULFILLED)
	// SLO@600ms
	EditRedemptionStatus(context.Context, *EditRedemptionStatusRequest) (*EditRedemptionStatusResponse, error)

	// BulkEditRedemptionStatus changes the status of a redemption for either multiple redemptions or a single reward with outstanding redemptions.
	// SLO@500ms
	BulkEditRedemptionStatus(context.Context, *BulkEditRedemptionStatusRequest) (*BulkEditRedemptionStatusResponse, error)

	// GetRedemption gets a single redemption
	// SLO@500ms
	GetRedemption(context.Context, *GetRedemptionRequest) (*GetRedemptionResponse, error)

	// GetRewardSummary returns the custom rewards on a channel, as well as the number of unfulfilled redemptions for each reward.
	// SLO@500ms
	GetRewardSummary(context.Context, *GetRewardSummaryRequest) (*GetRewardSummaryResponse, error)

	// GetActiveMultipliers returns a list of the active multipliers for a user in a channel.
	// SLO@500ms
	GetActiveMultipliers(context.Context, *GetActiveMultipliersRequest) (*GetActiveMultipliersResponse, error)

	// CreateImageUploadInfo returns an upload info for a new channel points, custom reward or automatic reward image.
	// SLO@500ms
	CreateImageUploadInfo(context.Context, *CreateImageUploadInfoRequest) (*CreateImageUploadInfoResponse, error)

	// GetEmoteVariants returns a list of the emote variants for a channel.
	// SLO@750ms
	GetEmoteVariants(context.Context, *GetEmoteVariantsRequest) (*GetEmoteVariantsResponse, error)

	// GetEarlyAccessSettings returns a user's early access settings.
	// SLO@200ms
	GetEarlyAccessSettings(context.Context, *GetEarlyAccessSettingsRequest) (*GetEarlyAccessSettingsResponse, error)

	// UpdateEarlyAccessSettings update's a user's early access settings.
	// SLO@200ms
	UpdateEarlyAccessSettings(context.Context, *UpdateEarlyAccessSettingsRequest) (*UpdateEarlyAccessSettingsResponse, error)

	// GetLimitedEarnings returns a user's available limited earns.
	// SLO@400ms
	GetLimitedEarnings(context.Context, *GetLimitedEarningsRequest) (*GetLimitedEarningsResponse, error)

	// GetSmartCostsAcknowledgements returns a user's smart costs acknowledgements.
	// SLO@500ms
	GetSmartCostsAcknowledgements(context.Context, *GetSmartCostsAcknowledgementsRequest) (*GetSmartCostsAcknowledgementsResponse, error)

	// UpdateSmartCostsAcknowledgements returns a user's smart costs acknowledgements.
	// SLO@500ms
	UpdateSmartCostsAcknowledgements(context.Context, *UpdateSmartCostsAcknowledgementsRequest) (*UpdateSmartCostsAcknowledgementsResponse, error)

	// SubtractPoints removes the specified number of points from a user in a channel.
	// SLO@500ms
	SubtractPoints(context.Context, *SubtractPointsRequest) (*SubtractPointsResponse, error)

	// HoldPoints holds the specified number of points from a user in a channel.
	// SLO@500ms
	HoldPoints(context.Context, *HoldPointsRequest) (*HoldPointsResponse, error)

	// CommitHold completes and executes a specified points hold.
	// SLO@500ms
	CommitHold(context.Context, *CommitHoldRequest) (*CommitHoldResponse, error)

	// GetBulkEditRedemptionStatusProgress returns the progress of any ongoing async BulkEditRedemptionStatus calls.
	// SLO@200ms
	GetBulkEditRedemptionStatusProgress(context.Context, *GetBulkEditRedemptionStatusProgressRequest) (*GetBulkEditRedemptionStatusProgressResponse, error)

	// GetCustomRewardTemplateCollections returns the collections of custom reward templates.
	// SLO@200ms
	GetCustomRewardTemplateCollections(context.Context, *GetCustomRewardTemplateCollectionsRequest) (*GetCustomRewardTemplateCollectionsResponse, error)

	// GetChannelLastViewedContent returns the channel last viewed content for a user on a channel.
	// SLO@500ms
	GetChannelLastViewedContent(context.Context, *GetChannelLastViewedContentRequest) (*GetChannelLastViewedContentResponse, error)

	// GetGlobalLastViewedContent returns the global last viewed content for a user.
	// SLO@500ms
	GetGlobalLastViewedContent(context.Context, *GetGlobalLastViewedContentRequest) (*GetGlobalLastViewedContentResponse, error)

	// UpdateLastViewedContent updates last viewed content for a user.
	// SLO@500ms
	UpdateLastViewedContent(context.Context, *UpdateLastViewedContentRequest) (*UpdateLastViewedContentResponse, error)

	// GetCommunityGoal returns a community goal given a channel and goal id.
	// SLO@500ms
	GetCommunityGoal(context.Context, *GetCommunityGoalRequest) (*GetCommunityGoalResponse, error)

	// ListCommunityGoals returns all non-archived Community Goals for a channel.
	// SLO@500ms
	ListCommunityGoals(context.Context, *ListCommunityGoalsRequest) (*ListCommunityGoalsResponse, error)

	// ListArchivedCommunityGoals paginates through all archived community goals for a channel.
	// SLO@500ms
	ListArchivedCommunityGoals(context.Context, *ListArchivedCommunityGoalsRequest) (*ListArchivedCommunityGoalsResponse, error)

	// CreateCommunityGoal creates a Community Goal.
	// SLO@500ms
	CreateCommunityGoal(context.Context, *CreateCommunityGoalRequest) (*CreateCommunityGoalResponse, error)

	// DeleteCommunityGoal deletes a Community Goal.
	// SLO@500ms
	DeleteCommunityGoal(context.Context, *DeleteCommunityGoalRequest) (*DeleteCommunityGoalResponse, error)

	// UpdateCommunityGoal updates a Community Goal.
	// SLO@500ms
	UpdateCommunityGoal(context.Context, *UpdateCommunityGoalRequest) (*UpdateCommunityGoalResponse, error)

	// ContributeToCommunityGoal contributes points from a user to a community goal.
	// SLO@500ms
	ContributeToCommunityGoal(context.Context, *ContributeToCommunityGoalRequest) (*ContributeToCommunityGoalResponse, error)

	// GetUserStreamCommunityGoalContributions returns the goal contribution amounts of a single user in a channel during the current stream.
	// SLO@500ms
	GetUserStreamCommunityGoalContributions(context.Context, *GetUserStreamCommunityGoalContributionsRequest) (*GetUserStreamCommunityGoalContributionsResponse, error)

	// GetUserStreamRedemptions returns the amount of user redemptions per stream on a custom reward with per user limits enabled
	// SLO@500ms
	GetUserStreamRedemptions(context.Context, *GetUserStreamRedemptionsRequest) (*GetUserStreamRedemptionsResponse, error)
}

// ====================
// Copo Protobuf Client
// ====================

type copoProtobufClient struct {
	client HTTPClient
	urls   [44]string
}

// NewCopoProtobufClient creates a Protobuf client that implements the Copo interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCopoProtobufClient(addr string, client HTTPClient) Copo {
	prefix := urlBase(addr) + CopoPathPrefix
	urls := [44]string{
		prefix + "GetBalance",
		prefix + "GetChannelSettings",
		prefix + "UpdateChannelSettings",
		prefix + "GetAvailableClaim",
		prefix + "ClaimPoints",
		prefix + "GetAutomaticRewards",
		prefix + "UpdateAutomaticReward",
		prefix + "ListCustomRewards",
		prefix + "GetCustomReward",
		prefix + "CreateCustomReward",
		prefix + "UpdateCustomReward",
		prefix + "RemoveCustomReward",
		prefix + "RedeemAutomaticReward",
		prefix + "ListRedemptions",
		prefix + "RedeemCustomReward",
		prefix + "EditRedemptionStatus",
		prefix + "BulkEditRedemptionStatus",
		prefix + "GetRedemption",
		prefix + "GetRewardSummary",
		prefix + "GetActiveMultipliers",
		prefix + "CreateImageUploadInfo",
		prefix + "GetEmoteVariants",
		prefix + "GetEarlyAccessSettings",
		prefix + "UpdateEarlyAccessSettings",
		prefix + "GetLimitedEarnings",
		prefix + "GetSmartCostsAcknowledgements",
		prefix + "UpdateSmartCostsAcknowledgements",
		prefix + "SubtractPoints",
		prefix + "HoldPoints",
		prefix + "CommitHold",
		prefix + "GetBulkEditRedemptionStatusProgress",
		prefix + "GetCustomRewardTemplateCollections",
		prefix + "GetChannelLastViewedContent",
		prefix + "GetGlobalLastViewedContent",
		prefix + "UpdateLastViewedContent",
		prefix + "GetCommunityGoal",
		prefix + "ListCommunityGoals",
		prefix + "ListArchivedCommunityGoals",
		prefix + "CreateCommunityGoal",
		prefix + "DeleteCommunityGoal",
		prefix + "UpdateCommunityGoal",
		prefix + "ContributeToCommunityGoal",
		prefix + "GetUserStreamCommunityGoalContributions",
		prefix + "GetUserStreamRedemptions",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &copoProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &copoProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *copoProtobufClient) GetBalance(ctx context.Context, in *GetBalanceRequest) (*GetBalanceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetBalance")
	out := new(GetBalanceResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetChannelSettings(ctx context.Context, in *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	out := new(GetChannelSettingsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateChannelSettings(ctx context.Context, in *UpdateChannelSettingsRequest) (*UpdateChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	out := new(UpdateChannelSettingsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetAvailableClaim(ctx context.Context, in *GetAvailableClaimRequest) (*GetAvailableClaimResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableClaim")
	out := new(GetAvailableClaimResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) ClaimPoints(ctx context.Context, in *ClaimPointsRequest) (*ClaimPointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ClaimPoints")
	out := new(ClaimPointsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetAutomaticRewards(ctx context.Context, in *GetAutomaticRewardsRequest) (*GetAutomaticRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutomaticRewards")
	out := new(GetAutomaticRewardsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateAutomaticReward(ctx context.Context, in *UpdateAutomaticRewardRequest) (*UpdateAutomaticRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutomaticReward")
	out := new(UpdateAutomaticRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) ListCustomRewards(ctx context.Context, in *ListCustomRewardsRequest) (*ListCustomRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards")
	out := new(ListCustomRewardsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetCustomReward(ctx context.Context, in *GetCustomRewardRequest) (*GetCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomReward")
	out := new(GetCustomRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) CreateCustomReward(ctx context.Context, in *CreateCustomRewardRequest) (*CreateCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward")
	out := new(CreateCustomRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateCustomReward(ctx context.Context, in *UpdateCustomRewardRequest) (*UpdateCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward")
	out := new(UpdateCustomRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) RemoveCustomReward(ctx context.Context, in *RemoveCustomRewardRequest) (*RemoveCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward")
	out := new(RemoveCustomRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) RedeemAutomaticReward(ctx context.Context, in *RedeemAutomaticRewardRequest) (*RedeemAutomaticRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "RedeemAutomaticReward")
	out := new(RedeemAutomaticRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) ListRedemptions(ctx context.Context, in *ListRedemptionsRequest) (*ListRedemptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions")
	out := new(ListRedemptionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) RedeemCustomReward(ctx context.Context, in *RedeemCustomRewardRequest) (*RedeemCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "RedeemCustomReward")
	out := new(RedeemCustomRewardResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) EditRedemptionStatus(ctx context.Context, in *EditRedemptionStatusRequest) (*EditRedemptionStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "EditRedemptionStatus")
	out := new(EditRedemptionStatusResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) BulkEditRedemptionStatus(ctx context.Context, in *BulkEditRedemptionStatusRequest) (*BulkEditRedemptionStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus")
	out := new(BulkEditRedemptionStatusResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetRedemption(ctx context.Context, in *GetRedemptionRequest) (*GetRedemptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption")
	out := new(GetRedemptionResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetRewardSummary(ctx context.Context, in *GetRewardSummaryRequest) (*GetRewardSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetRewardSummary")
	out := new(GetRewardSummaryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetActiveMultipliers(ctx context.Context, in *GetActiveMultipliersRequest) (*GetActiveMultipliersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveMultipliers")
	out := new(GetActiveMultipliersResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) CreateImageUploadInfo(ctx context.Context, in *CreateImageUploadInfoRequest) (*CreateImageUploadInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateImageUploadInfo")
	out := new(CreateImageUploadInfoResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetEmoteVariants(ctx context.Context, in *GetEmoteVariantsRequest) (*GetEmoteVariantsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteVariants")
	out := new(GetEmoteVariantsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[21], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetEarlyAccessSettings(ctx context.Context, in *GetEarlyAccessSettingsRequest) (*GetEarlyAccessSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetEarlyAccessSettings")
	out := new(GetEarlyAccessSettingsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[22], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateEarlyAccessSettings(ctx context.Context, in *UpdateEarlyAccessSettingsRequest) (*UpdateEarlyAccessSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEarlyAccessSettings")
	out := new(UpdateEarlyAccessSettingsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[23], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetLimitedEarnings(ctx context.Context, in *GetLimitedEarningsRequest) (*GetLimitedEarningsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetLimitedEarnings")
	out := new(GetLimitedEarningsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[24], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetSmartCostsAcknowledgements(ctx context.Context, in *GetSmartCostsAcknowledgementsRequest) (*GetSmartCostsAcknowledgementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSmartCostsAcknowledgements")
	out := new(GetSmartCostsAcknowledgementsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[25], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateSmartCostsAcknowledgements(ctx context.Context, in *UpdateSmartCostsAcknowledgementsRequest) (*UpdateSmartCostsAcknowledgementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSmartCostsAcknowledgements")
	out := new(UpdateSmartCostsAcknowledgementsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[26], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) SubtractPoints(ctx context.Context, in *SubtractPointsRequest) (*SubtractPointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "SubtractPoints")
	out := new(SubtractPointsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[27], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) HoldPoints(ctx context.Context, in *HoldPointsRequest) (*HoldPointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "HoldPoints")
	out := new(HoldPointsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[28], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) CommitHold(ctx context.Context, in *CommitHoldRequest) (*CommitHoldResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CommitHold")
	out := new(CommitHoldResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[29], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetBulkEditRedemptionStatusProgress(ctx context.Context, in *GetBulkEditRedemptionStatusProgressRequest) (*GetBulkEditRedemptionStatusProgressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkEditRedemptionStatusProgress")
	out := new(GetBulkEditRedemptionStatusProgressResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[30], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetCustomRewardTemplateCollections(ctx context.Context, in *GetCustomRewardTemplateCollectionsRequest) (*GetCustomRewardTemplateCollectionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomRewardTemplateCollections")
	out := new(GetCustomRewardTemplateCollectionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[31], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetChannelLastViewedContent(ctx context.Context, in *GetChannelLastViewedContentRequest) (*GetChannelLastViewedContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelLastViewedContent")
	out := new(GetChannelLastViewedContentResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[32], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetGlobalLastViewedContent(ctx context.Context, in *GetGlobalLastViewedContentRequest) (*GetGlobalLastViewedContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetGlobalLastViewedContent")
	out := new(GetGlobalLastViewedContentResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[33], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateLastViewedContent(ctx context.Context, in *UpdateLastViewedContentRequest) (*UpdateLastViewedContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLastViewedContent")
	out := new(UpdateLastViewedContentResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[34], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetCommunityGoal(ctx context.Context, in *GetCommunityGoalRequest) (*GetCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetCommunityGoal")
	out := new(GetCommunityGoalResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[35], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) ListCommunityGoals(ctx context.Context, in *ListCommunityGoalsRequest) (*ListCommunityGoalsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListCommunityGoals")
	out := new(ListCommunityGoalsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[36], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) ListArchivedCommunityGoals(ctx context.Context, in *ListArchivedCommunityGoalsRequest) (*ListArchivedCommunityGoalsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListArchivedCommunityGoals")
	out := new(ListArchivedCommunityGoalsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[37], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) CreateCommunityGoal(ctx context.Context, in *CreateCommunityGoalRequest) (*CreateCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCommunityGoal")
	out := new(CreateCommunityGoalResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[38], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) DeleteCommunityGoal(ctx context.Context, in *DeleteCommunityGoalRequest) (*DeleteCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCommunityGoal")
	out := new(DeleteCommunityGoalResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[39], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) UpdateCommunityGoal(ctx context.Context, in *UpdateCommunityGoalRequest) (*UpdateCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCommunityGoal")
	out := new(UpdateCommunityGoalResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[40], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) ContributeToCommunityGoal(ctx context.Context, in *ContributeToCommunityGoalRequest) (*ContributeToCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ContributeToCommunityGoal")
	out := new(ContributeToCommunityGoalResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[41], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetUserStreamCommunityGoalContributions(ctx context.Context, in *GetUserStreamCommunityGoalContributionsRequest) (*GetUserStreamCommunityGoalContributionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamCommunityGoalContributions")
	out := new(GetUserStreamCommunityGoalContributionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[42], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoProtobufClient) GetUserStreamRedemptions(ctx context.Context, in *GetUserStreamRedemptionsRequest) (*GetUserStreamRedemptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamRedemptions")
	out := new(GetUserStreamRedemptionsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[43], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ================
// Copo JSON Client
// ================

type copoJSONClient struct {
	client HTTPClient
	urls   [44]string
}

// NewCopoJSONClient creates a JSON client that implements the Copo interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCopoJSONClient(addr string, client HTTPClient) Copo {
	prefix := urlBase(addr) + CopoPathPrefix
	urls := [44]string{
		prefix + "GetBalance",
		prefix + "GetChannelSettings",
		prefix + "UpdateChannelSettings",
		prefix + "GetAvailableClaim",
		prefix + "ClaimPoints",
		prefix + "GetAutomaticRewards",
		prefix + "UpdateAutomaticReward",
		prefix + "ListCustomRewards",
		prefix + "GetCustomReward",
		prefix + "CreateCustomReward",
		prefix + "UpdateCustomReward",
		prefix + "RemoveCustomReward",
		prefix + "RedeemAutomaticReward",
		prefix + "ListRedemptions",
		prefix + "RedeemCustomReward",
		prefix + "EditRedemptionStatus",
		prefix + "BulkEditRedemptionStatus",
		prefix + "GetRedemption",
		prefix + "GetRewardSummary",
		prefix + "GetActiveMultipliers",
		prefix + "CreateImageUploadInfo",
		prefix + "GetEmoteVariants",
		prefix + "GetEarlyAccessSettings",
		prefix + "UpdateEarlyAccessSettings",
		prefix + "GetLimitedEarnings",
		prefix + "GetSmartCostsAcknowledgements",
		prefix + "UpdateSmartCostsAcknowledgements",
		prefix + "SubtractPoints",
		prefix + "HoldPoints",
		prefix + "CommitHold",
		prefix + "GetBulkEditRedemptionStatusProgress",
		prefix + "GetCustomRewardTemplateCollections",
		prefix + "GetChannelLastViewedContent",
		prefix + "GetGlobalLastViewedContent",
		prefix + "UpdateLastViewedContent",
		prefix + "GetCommunityGoal",
		prefix + "ListCommunityGoals",
		prefix + "ListArchivedCommunityGoals",
		prefix + "CreateCommunityGoal",
		prefix + "DeleteCommunityGoal",
		prefix + "UpdateCommunityGoal",
		prefix + "ContributeToCommunityGoal",
		prefix + "GetUserStreamCommunityGoalContributions",
		prefix + "GetUserStreamRedemptions",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &copoJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &copoJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *copoJSONClient) GetBalance(ctx context.Context, in *GetBalanceRequest) (*GetBalanceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetBalance")
	out := new(GetBalanceResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetChannelSettings(ctx context.Context, in *GetChannelSettingsRequest) (*GetChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	out := new(GetChannelSettingsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateChannelSettings(ctx context.Context, in *UpdateChannelSettingsRequest) (*UpdateChannelSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	out := new(UpdateChannelSettingsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetAvailableClaim(ctx context.Context, in *GetAvailableClaimRequest) (*GetAvailableClaimResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableClaim")
	out := new(GetAvailableClaimResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) ClaimPoints(ctx context.Context, in *ClaimPointsRequest) (*ClaimPointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ClaimPoints")
	out := new(ClaimPointsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetAutomaticRewards(ctx context.Context, in *GetAutomaticRewardsRequest) (*GetAutomaticRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetAutomaticRewards")
	out := new(GetAutomaticRewardsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateAutomaticReward(ctx context.Context, in *UpdateAutomaticRewardRequest) (*UpdateAutomaticRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutomaticReward")
	out := new(UpdateAutomaticRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) ListCustomRewards(ctx context.Context, in *ListCustomRewardsRequest) (*ListCustomRewardsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards")
	out := new(ListCustomRewardsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetCustomReward(ctx context.Context, in *GetCustomRewardRequest) (*GetCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomReward")
	out := new(GetCustomRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) CreateCustomReward(ctx context.Context, in *CreateCustomRewardRequest) (*CreateCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward")
	out := new(CreateCustomRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateCustomReward(ctx context.Context, in *UpdateCustomRewardRequest) (*UpdateCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward")
	out := new(UpdateCustomRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) RemoveCustomReward(ctx context.Context, in *RemoveCustomRewardRequest) (*RemoveCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward")
	out := new(RemoveCustomRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) RedeemAutomaticReward(ctx context.Context, in *RedeemAutomaticRewardRequest) (*RedeemAutomaticRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "RedeemAutomaticReward")
	out := new(RedeemAutomaticRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) ListRedemptions(ctx context.Context, in *ListRedemptionsRequest) (*ListRedemptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions")
	out := new(ListRedemptionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[13], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) RedeemCustomReward(ctx context.Context, in *RedeemCustomRewardRequest) (*RedeemCustomRewardResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "RedeemCustomReward")
	out := new(RedeemCustomRewardResponse)
	err := doJSONRequest(ctx, c.client, c.urls[14], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) EditRedemptionStatus(ctx context.Context, in *EditRedemptionStatusRequest) (*EditRedemptionStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "EditRedemptionStatus")
	out := new(EditRedemptionStatusResponse)
	err := doJSONRequest(ctx, c.client, c.urls[15], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) BulkEditRedemptionStatus(ctx context.Context, in *BulkEditRedemptionStatusRequest) (*BulkEditRedemptionStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus")
	out := new(BulkEditRedemptionStatusResponse)
	err := doJSONRequest(ctx, c.client, c.urls[16], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetRedemption(ctx context.Context, in *GetRedemptionRequest) (*GetRedemptionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption")
	out := new(GetRedemptionResponse)
	err := doJSONRequest(ctx, c.client, c.urls[17], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetRewardSummary(ctx context.Context, in *GetRewardSummaryRequest) (*GetRewardSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetRewardSummary")
	out := new(GetRewardSummaryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[18], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetActiveMultipliers(ctx context.Context, in *GetActiveMultipliersRequest) (*GetActiveMultipliersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveMultipliers")
	out := new(GetActiveMultipliersResponse)
	err := doJSONRequest(ctx, c.client, c.urls[19], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) CreateImageUploadInfo(ctx context.Context, in *CreateImageUploadInfoRequest) (*CreateImageUploadInfoResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateImageUploadInfo")
	out := new(CreateImageUploadInfoResponse)
	err := doJSONRequest(ctx, c.client, c.urls[20], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetEmoteVariants(ctx context.Context, in *GetEmoteVariantsRequest) (*GetEmoteVariantsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteVariants")
	out := new(GetEmoteVariantsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[21], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetEarlyAccessSettings(ctx context.Context, in *GetEarlyAccessSettingsRequest) (*GetEarlyAccessSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetEarlyAccessSettings")
	out := new(GetEarlyAccessSettingsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[22], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateEarlyAccessSettings(ctx context.Context, in *UpdateEarlyAccessSettingsRequest) (*UpdateEarlyAccessSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEarlyAccessSettings")
	out := new(UpdateEarlyAccessSettingsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[23], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetLimitedEarnings(ctx context.Context, in *GetLimitedEarningsRequest) (*GetLimitedEarningsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetLimitedEarnings")
	out := new(GetLimitedEarningsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[24], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetSmartCostsAcknowledgements(ctx context.Context, in *GetSmartCostsAcknowledgementsRequest) (*GetSmartCostsAcknowledgementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetSmartCostsAcknowledgements")
	out := new(GetSmartCostsAcknowledgementsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[25], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateSmartCostsAcknowledgements(ctx context.Context, in *UpdateSmartCostsAcknowledgementsRequest) (*UpdateSmartCostsAcknowledgementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSmartCostsAcknowledgements")
	out := new(UpdateSmartCostsAcknowledgementsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[26], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) SubtractPoints(ctx context.Context, in *SubtractPointsRequest) (*SubtractPointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "SubtractPoints")
	out := new(SubtractPointsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[27], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) HoldPoints(ctx context.Context, in *HoldPointsRequest) (*HoldPointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "HoldPoints")
	out := new(HoldPointsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[28], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) CommitHold(ctx context.Context, in *CommitHoldRequest) (*CommitHoldResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CommitHold")
	out := new(CommitHoldResponse)
	err := doJSONRequest(ctx, c.client, c.urls[29], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetBulkEditRedemptionStatusProgress(ctx context.Context, in *GetBulkEditRedemptionStatusProgressRequest) (*GetBulkEditRedemptionStatusProgressResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkEditRedemptionStatusProgress")
	out := new(GetBulkEditRedemptionStatusProgressResponse)
	err := doJSONRequest(ctx, c.client, c.urls[30], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetCustomRewardTemplateCollections(ctx context.Context, in *GetCustomRewardTemplateCollectionsRequest) (*GetCustomRewardTemplateCollectionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomRewardTemplateCollections")
	out := new(GetCustomRewardTemplateCollectionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[31], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetChannelLastViewedContent(ctx context.Context, in *GetChannelLastViewedContentRequest) (*GetChannelLastViewedContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelLastViewedContent")
	out := new(GetChannelLastViewedContentResponse)
	err := doJSONRequest(ctx, c.client, c.urls[32], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetGlobalLastViewedContent(ctx context.Context, in *GetGlobalLastViewedContentRequest) (*GetGlobalLastViewedContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetGlobalLastViewedContent")
	out := new(GetGlobalLastViewedContentResponse)
	err := doJSONRequest(ctx, c.client, c.urls[33], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateLastViewedContent(ctx context.Context, in *UpdateLastViewedContentRequest) (*UpdateLastViewedContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLastViewedContent")
	out := new(UpdateLastViewedContentResponse)
	err := doJSONRequest(ctx, c.client, c.urls[34], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetCommunityGoal(ctx context.Context, in *GetCommunityGoalRequest) (*GetCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetCommunityGoal")
	out := new(GetCommunityGoalResponse)
	err := doJSONRequest(ctx, c.client, c.urls[35], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) ListCommunityGoals(ctx context.Context, in *ListCommunityGoalsRequest) (*ListCommunityGoalsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListCommunityGoals")
	out := new(ListCommunityGoalsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[36], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) ListArchivedCommunityGoals(ctx context.Context, in *ListArchivedCommunityGoalsRequest) (*ListArchivedCommunityGoalsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ListArchivedCommunityGoals")
	out := new(ListArchivedCommunityGoalsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[37], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) CreateCommunityGoal(ctx context.Context, in *CreateCommunityGoalRequest) (*CreateCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCommunityGoal")
	out := new(CreateCommunityGoalResponse)
	err := doJSONRequest(ctx, c.client, c.urls[38], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) DeleteCommunityGoal(ctx context.Context, in *DeleteCommunityGoalRequest) (*DeleteCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCommunityGoal")
	out := new(DeleteCommunityGoalResponse)
	err := doJSONRequest(ctx, c.client, c.urls[39], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) UpdateCommunityGoal(ctx context.Context, in *UpdateCommunityGoalRequest) (*UpdateCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCommunityGoal")
	out := new(UpdateCommunityGoalResponse)
	err := doJSONRequest(ctx, c.client, c.urls[40], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) ContributeToCommunityGoal(ctx context.Context, in *ContributeToCommunityGoalRequest) (*ContributeToCommunityGoalResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "ContributeToCommunityGoal")
	out := new(ContributeToCommunityGoalResponse)
	err := doJSONRequest(ctx, c.client, c.urls[41], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetUserStreamCommunityGoalContributions(ctx context.Context, in *GetUserStreamCommunityGoalContributionsRequest) (*GetUserStreamCommunityGoalContributionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamCommunityGoalContributions")
	out := new(GetUserStreamCommunityGoalContributionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[42], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoJSONClient) GetUserStreamRedemptions(ctx context.Context, in *GetUserStreamRedemptionsRequest) (*GetUserStreamRedemptionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamRedemptions")
	out := new(GetUserStreamRedemptionsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[43], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ===================
// Copo Server Handler
// ===================

type copoServer struct {
	Copo
	hooks *twirp.ServerHooks
}

func NewCopoServer(svc Copo, hooks *twirp.ServerHooks) TwirpServer {
	return &copoServer{
		Copo:  svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *copoServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// CopoPathPrefix is used for all URL paths on a twirp Copo server.
// Requests are always: POST CopoPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const CopoPathPrefix = "/twirp/copo.Copo/"

func (s *copoServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "Copo")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/copo.Copo/GetBalance":
		s.serveGetBalance(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetChannelSettings":
		s.serveGetChannelSettings(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateChannelSettings":
		s.serveUpdateChannelSettings(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetAvailableClaim":
		s.serveGetAvailableClaim(ctx, resp, req)
		return
	case "/twirp/copo.Copo/ClaimPoints":
		s.serveClaimPoints(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetAutomaticRewards":
		s.serveGetAutomaticRewards(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateAutomaticReward":
		s.serveUpdateAutomaticReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/ListCustomRewards":
		s.serveListCustomRewards(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetCustomReward":
		s.serveGetCustomReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/CreateCustomReward":
		s.serveCreateCustomReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateCustomReward":
		s.serveUpdateCustomReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/RemoveCustomReward":
		s.serveRemoveCustomReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/RedeemAutomaticReward":
		s.serveRedeemAutomaticReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/ListRedemptions":
		s.serveListRedemptions(ctx, resp, req)
		return
	case "/twirp/copo.Copo/RedeemCustomReward":
		s.serveRedeemCustomReward(ctx, resp, req)
		return
	case "/twirp/copo.Copo/EditRedemptionStatus":
		s.serveEditRedemptionStatus(ctx, resp, req)
		return
	case "/twirp/copo.Copo/BulkEditRedemptionStatus":
		s.serveBulkEditRedemptionStatus(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetRedemption":
		s.serveGetRedemption(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetRewardSummary":
		s.serveGetRewardSummary(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetActiveMultipliers":
		s.serveGetActiveMultipliers(ctx, resp, req)
		return
	case "/twirp/copo.Copo/CreateImageUploadInfo":
		s.serveCreateImageUploadInfo(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetEmoteVariants":
		s.serveGetEmoteVariants(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetEarlyAccessSettings":
		s.serveGetEarlyAccessSettings(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateEarlyAccessSettings":
		s.serveUpdateEarlyAccessSettings(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetLimitedEarnings":
		s.serveGetLimitedEarnings(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetSmartCostsAcknowledgements":
		s.serveGetSmartCostsAcknowledgements(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateSmartCostsAcknowledgements":
		s.serveUpdateSmartCostsAcknowledgements(ctx, resp, req)
		return
	case "/twirp/copo.Copo/SubtractPoints":
		s.serveSubtractPoints(ctx, resp, req)
		return
	case "/twirp/copo.Copo/HoldPoints":
		s.serveHoldPoints(ctx, resp, req)
		return
	case "/twirp/copo.Copo/CommitHold":
		s.serveCommitHold(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetBulkEditRedemptionStatusProgress":
		s.serveGetBulkEditRedemptionStatusProgress(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetCustomRewardTemplateCollections":
		s.serveGetCustomRewardTemplateCollections(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetChannelLastViewedContent":
		s.serveGetChannelLastViewedContent(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetGlobalLastViewedContent":
		s.serveGetGlobalLastViewedContent(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateLastViewedContent":
		s.serveUpdateLastViewedContent(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetCommunityGoal":
		s.serveGetCommunityGoal(ctx, resp, req)
		return
	case "/twirp/copo.Copo/ListCommunityGoals":
		s.serveListCommunityGoals(ctx, resp, req)
		return
	case "/twirp/copo.Copo/ListArchivedCommunityGoals":
		s.serveListArchivedCommunityGoals(ctx, resp, req)
		return
	case "/twirp/copo.Copo/CreateCommunityGoal":
		s.serveCreateCommunityGoal(ctx, resp, req)
		return
	case "/twirp/copo.Copo/DeleteCommunityGoal":
		s.serveDeleteCommunityGoal(ctx, resp, req)
		return
	case "/twirp/copo.Copo/UpdateCommunityGoal":
		s.serveUpdateCommunityGoal(ctx, resp, req)
		return
	case "/twirp/copo.Copo/ContributeToCommunityGoal":
		s.serveContributeToCommunityGoal(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetUserStreamCommunityGoalContributions":
		s.serveGetUserStreamCommunityGoalContributions(ctx, resp, req)
		return
	case "/twirp/copo.Copo/GetUserStreamRedemptions":
		s.serveGetUserStreamRedemptions(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *copoServer) serveGetBalance(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBalanceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBalanceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetBalanceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBalance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBalanceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetBalanceResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetBalance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBalanceResponse and nil error while calling GetBalance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetBalanceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBalance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetBalanceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetBalanceResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetBalance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBalanceResponse and nil error while calling GetBalance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetChannelSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetChannelSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSettingsResponse and nil error while calling GetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetChannelSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSettingsResponse and nil error while calling GetChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateChannelSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateChannelSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateChannelSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateChannelSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelSettingsResponse and nil error while calling UpdateChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateChannelSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannelSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateChannelSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateChannelSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelSettingsResponse and nil error while calling UpdateChannelSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetAvailableClaim(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAvailableClaimJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAvailableClaimProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetAvailableClaimJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableClaim")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAvailableClaimRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAvailableClaimResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetAvailableClaim(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableClaimResponse and nil error while calling GetAvailableClaim. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetAvailableClaimProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableClaim")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAvailableClaimRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAvailableClaimResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetAvailableClaim(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableClaimResponse and nil error while calling GetAvailableClaim. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveClaimPoints(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveClaimPointsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClaimPointsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveClaimPointsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClaimPoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ClaimPointsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ClaimPointsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ClaimPoints(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimPointsResponse and nil error while calling ClaimPoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveClaimPointsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClaimPoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ClaimPointsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ClaimPointsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ClaimPoints(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimPointsResponse and nil error while calling ClaimPoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetAutomaticRewards(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAutomaticRewardsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAutomaticRewardsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetAutomaticRewardsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutomaticRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAutomaticRewardsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAutomaticRewardsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetAutomaticRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutomaticRewardsResponse and nil error while calling GetAutomaticRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetAutomaticRewardsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAutomaticRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAutomaticRewardsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAutomaticRewardsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetAutomaticRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAutomaticRewardsResponse and nil error while calling GetAutomaticRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateAutomaticReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateAutomaticRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateAutomaticRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateAutomaticRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutomaticReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateAutomaticRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateAutomaticRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateAutomaticReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAutomaticRewardResponse and nil error while calling UpdateAutomaticReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateAutomaticRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateAutomaticReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateAutomaticRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateAutomaticRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateAutomaticReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateAutomaticRewardResponse and nil error while calling UpdateAutomaticReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListCustomRewards(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCustomRewardsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCustomRewardsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveListCustomRewardsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCustomRewardsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCustomRewardsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListCustomRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCustomRewardsResponse and nil error while calling ListCustomRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListCustomRewardsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListCustomRewardsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCustomRewardsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListCustomRewards(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCustomRewardsResponse and nil error while calling ListCustomRewards. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetCustomReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCustomRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCustomRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetCustomRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCustomRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCustomRewardResponse and nil error while calling GetCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetCustomRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCustomRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCustomRewardResponse and nil error while calling GetCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCreateCustomReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCustomRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCustomRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveCreateCustomRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCustomRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CreateCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCustomRewardResponse and nil error while calling CreateCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCreateCustomRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateCustomRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CreateCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCustomRewardResponse and nil error while calling CreateCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateCustomReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCustomRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCustomRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateCustomRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCustomRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCustomRewardResponse and nil error while calling UpdateCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateCustomRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCustomRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCustomRewardResponse and nil error while calling UpdateCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveRemoveCustomReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveCustomRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveCustomRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveRemoveCustomRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveCustomRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.RemoveCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveCustomRewardResponse and nil error while calling RemoveCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveRemoveCustomRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveCustomRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.RemoveCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveCustomRewardResponse and nil error while calling RemoveCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveRedeemAutomaticReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRedeemAutomaticRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRedeemAutomaticRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveRedeemAutomaticRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RedeemAutomaticReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RedeemAutomaticRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RedeemAutomaticRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.RedeemAutomaticReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RedeemAutomaticRewardResponse and nil error while calling RedeemAutomaticReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveRedeemAutomaticRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RedeemAutomaticReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RedeemAutomaticRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RedeemAutomaticRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.RedeemAutomaticReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RedeemAutomaticRewardResponse and nil error while calling RedeemAutomaticReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListRedemptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListRedemptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListRedemptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveListRedemptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListRedemptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListRedemptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListRedemptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRedemptionsResponse and nil error while calling ListRedemptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListRedemptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListRedemptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListRedemptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListRedemptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRedemptionsResponse and nil error while calling ListRedemptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveRedeemCustomReward(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRedeemCustomRewardJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRedeemCustomRewardProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveRedeemCustomRewardJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RedeemCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RedeemCustomRewardRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RedeemCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.RedeemCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RedeemCustomRewardResponse and nil error while calling RedeemCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveRedeemCustomRewardProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RedeemCustomReward")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RedeemCustomRewardRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RedeemCustomRewardResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.RedeemCustomReward(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RedeemCustomRewardResponse and nil error while calling RedeemCustomReward. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveEditRedemptionStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEditRedemptionStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEditRedemptionStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveEditRedemptionStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EditRedemptionStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(EditRedemptionStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EditRedemptionStatusResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.EditRedemptionStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EditRedemptionStatusResponse and nil error while calling EditRedemptionStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveEditRedemptionStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EditRedemptionStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EditRedemptionStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EditRedemptionStatusResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.EditRedemptionStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EditRedemptionStatusResponse and nil error while calling EditRedemptionStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveBulkEditRedemptionStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEditRedemptionStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEditRedemptionStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveBulkEditRedemptionStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEditRedemptionStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEditRedemptionStatusResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.BulkEditRedemptionStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEditRedemptionStatusResponse and nil error while calling BulkEditRedemptionStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveBulkEditRedemptionStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkEditRedemptionStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEditRedemptionStatusResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.BulkEditRedemptionStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEditRedemptionStatusResponse and nil error while calling BulkEditRedemptionStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetRedemption(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRedemptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRedemptionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetRedemptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRedemptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRedemptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetRedemption(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRedemptionResponse and nil error while calling GetRedemption. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetRedemptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRedemptionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRedemptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetRedemption(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRedemptionResponse and nil error while calling GetRedemption. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetRewardSummary(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRewardSummaryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRewardSummaryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetRewardSummaryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRewardSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRewardSummaryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRewardSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetRewardSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRewardSummaryResponse and nil error while calling GetRewardSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetRewardSummaryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRewardSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRewardSummaryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRewardSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetRewardSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRewardSummaryResponse and nil error while calling GetRewardSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetActiveMultipliers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActiveMultipliersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActiveMultipliersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetActiveMultipliersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveMultipliers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActiveMultipliersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetActiveMultipliersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetActiveMultipliers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActiveMultipliersResponse and nil error while calling GetActiveMultipliers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetActiveMultipliersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActiveMultipliers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetActiveMultipliersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetActiveMultipliersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetActiveMultipliers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActiveMultipliersResponse and nil error while calling GetActiveMultipliers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCreateImageUploadInfo(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateImageUploadInfoJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateImageUploadInfoProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveCreateImageUploadInfoJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateImageUploadInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateImageUploadInfoRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateImageUploadInfoResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CreateImageUploadInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateImageUploadInfoResponse and nil error while calling CreateImageUploadInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCreateImageUploadInfoProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateImageUploadInfo")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateImageUploadInfoRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateImageUploadInfoResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CreateImageUploadInfo(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateImageUploadInfoResponse and nil error while calling CreateImageUploadInfo. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetEmoteVariants(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEmoteVariantsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoteVariantsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetEmoteVariantsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteVariants")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEmoteVariantsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoteVariantsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetEmoteVariants(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoteVariantsResponse and nil error while calling GetEmoteVariants. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetEmoteVariantsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEmoteVariants")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoteVariantsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoteVariantsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetEmoteVariants(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoteVariantsResponse and nil error while calling GetEmoteVariants. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetEarlyAccessSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEarlyAccessSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEarlyAccessSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetEarlyAccessSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEarlyAccessSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEarlyAccessSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEarlyAccessSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetEarlyAccessSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEarlyAccessSettingsResponse and nil error while calling GetEarlyAccessSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetEarlyAccessSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEarlyAccessSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEarlyAccessSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEarlyAccessSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetEarlyAccessSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEarlyAccessSettingsResponse and nil error while calling GetEarlyAccessSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateEarlyAccessSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateEarlyAccessSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateEarlyAccessSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateEarlyAccessSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEarlyAccessSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateEarlyAccessSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateEarlyAccessSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateEarlyAccessSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEarlyAccessSettingsResponse and nil error while calling UpdateEarlyAccessSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateEarlyAccessSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEarlyAccessSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateEarlyAccessSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateEarlyAccessSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateEarlyAccessSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEarlyAccessSettingsResponse and nil error while calling UpdateEarlyAccessSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetLimitedEarnings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLimitedEarningsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLimitedEarningsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetLimitedEarningsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLimitedEarnings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetLimitedEarningsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLimitedEarningsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetLimitedEarnings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLimitedEarningsResponse and nil error while calling GetLimitedEarnings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetLimitedEarningsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLimitedEarnings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetLimitedEarningsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetLimitedEarningsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetLimitedEarnings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLimitedEarningsResponse and nil error while calling GetLimitedEarnings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetSmartCostsAcknowledgements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSmartCostsAcknowledgementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSmartCostsAcknowledgementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetSmartCostsAcknowledgementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSmartCostsAcknowledgements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSmartCostsAcknowledgementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSmartCostsAcknowledgementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetSmartCostsAcknowledgements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSmartCostsAcknowledgementsResponse and nil error while calling GetSmartCostsAcknowledgements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetSmartCostsAcknowledgementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSmartCostsAcknowledgements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSmartCostsAcknowledgementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSmartCostsAcknowledgementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetSmartCostsAcknowledgements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSmartCostsAcknowledgementsResponse and nil error while calling GetSmartCostsAcknowledgements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateSmartCostsAcknowledgements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateSmartCostsAcknowledgementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSmartCostsAcknowledgementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateSmartCostsAcknowledgementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSmartCostsAcknowledgements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSmartCostsAcknowledgementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSmartCostsAcknowledgementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateSmartCostsAcknowledgements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSmartCostsAcknowledgementsResponse and nil error while calling UpdateSmartCostsAcknowledgements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateSmartCostsAcknowledgementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSmartCostsAcknowledgements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateSmartCostsAcknowledgementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSmartCostsAcknowledgementsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateSmartCostsAcknowledgements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSmartCostsAcknowledgementsResponse and nil error while calling UpdateSmartCostsAcknowledgements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveSubtractPoints(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSubtractPointsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubtractPointsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveSubtractPointsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubtractPoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SubtractPointsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubtractPointsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.SubtractPoints(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubtractPointsResponse and nil error while calling SubtractPoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveSubtractPointsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubtractPoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SubtractPointsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubtractPointsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.SubtractPoints(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubtractPointsResponse and nil error while calling SubtractPoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveHoldPoints(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHoldPointsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHoldPointsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveHoldPointsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HoldPoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HoldPointsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HoldPointsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.HoldPoints(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HoldPointsResponse and nil error while calling HoldPoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveHoldPointsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HoldPoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(HoldPointsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *HoldPointsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.HoldPoints(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HoldPointsResponse and nil error while calling HoldPoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCommitHold(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCommitHoldJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCommitHoldProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveCommitHoldJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CommitHold")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CommitHoldRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CommitHoldResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CommitHold(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CommitHoldResponse and nil error while calling CommitHold. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCommitHoldProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CommitHold")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CommitHoldRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CommitHoldResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CommitHold(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CommitHoldResponse and nil error while calling CommitHold. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetBulkEditRedemptionStatusProgress(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBulkEditRedemptionStatusProgressJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBulkEditRedemptionStatusProgressProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetBulkEditRedemptionStatusProgressJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkEditRedemptionStatusProgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBulkEditRedemptionStatusProgressRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetBulkEditRedemptionStatusProgressResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetBulkEditRedemptionStatusProgress(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBulkEditRedemptionStatusProgressResponse and nil error while calling GetBulkEditRedemptionStatusProgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetBulkEditRedemptionStatusProgressProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBulkEditRedemptionStatusProgress")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetBulkEditRedemptionStatusProgressRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetBulkEditRedemptionStatusProgressResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetBulkEditRedemptionStatusProgress(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBulkEditRedemptionStatusProgressResponse and nil error while calling GetBulkEditRedemptionStatusProgress. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetCustomRewardTemplateCollections(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCustomRewardTemplateCollectionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCustomRewardTemplateCollectionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetCustomRewardTemplateCollectionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomRewardTemplateCollections")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCustomRewardTemplateCollectionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCustomRewardTemplateCollectionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetCustomRewardTemplateCollections(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCustomRewardTemplateCollectionsResponse and nil error while calling GetCustomRewardTemplateCollections. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetCustomRewardTemplateCollectionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCustomRewardTemplateCollections")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCustomRewardTemplateCollectionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCustomRewardTemplateCollectionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetCustomRewardTemplateCollections(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCustomRewardTemplateCollectionsResponse and nil error while calling GetCustomRewardTemplateCollections. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetChannelLastViewedContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelLastViewedContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelLastViewedContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetChannelLastViewedContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelLastViewedContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelLastViewedContentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelLastViewedContentResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetChannelLastViewedContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelLastViewedContentResponse and nil error while calling GetChannelLastViewedContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetChannelLastViewedContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelLastViewedContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelLastViewedContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelLastViewedContentResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetChannelLastViewedContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelLastViewedContentResponse and nil error while calling GetChannelLastViewedContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetGlobalLastViewedContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetGlobalLastViewedContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGlobalLastViewedContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetGlobalLastViewedContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGlobalLastViewedContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetGlobalLastViewedContentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGlobalLastViewedContentResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetGlobalLastViewedContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGlobalLastViewedContentResponse and nil error while calling GetGlobalLastViewedContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetGlobalLastViewedContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetGlobalLastViewedContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGlobalLastViewedContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGlobalLastViewedContentResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetGlobalLastViewedContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGlobalLastViewedContentResponse and nil error while calling GetGlobalLastViewedContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateLastViewedContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateLastViewedContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateLastViewedContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateLastViewedContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLastViewedContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateLastViewedContentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateLastViewedContentResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateLastViewedContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLastViewedContentResponse and nil error while calling UpdateLastViewedContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateLastViewedContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateLastViewedContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateLastViewedContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateLastViewedContentResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateLastViewedContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateLastViewedContentResponse and nil error while calling UpdateLastViewedContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetCommunityGoal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCommunityGoalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCommunityGoalProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetCommunityGoalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCommunityGoalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCommunityGoalResponse and nil error while calling GetCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetCommunityGoalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCommunityGoalRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCommunityGoalResponse and nil error while calling GetCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListCommunityGoals(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCommunityGoalsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCommunityGoalsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveListCommunityGoalsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCommunityGoals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCommunityGoalsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCommunityGoalsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListCommunityGoals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCommunityGoalsResponse and nil error while calling ListCommunityGoals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListCommunityGoalsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCommunityGoals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListCommunityGoalsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCommunityGoalsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListCommunityGoals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCommunityGoalsResponse and nil error while calling ListCommunityGoals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListArchivedCommunityGoals(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListArchivedCommunityGoalsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListArchivedCommunityGoalsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveListArchivedCommunityGoalsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListArchivedCommunityGoals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListArchivedCommunityGoalsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListArchivedCommunityGoalsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListArchivedCommunityGoals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListArchivedCommunityGoalsResponse and nil error while calling ListArchivedCommunityGoals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveListArchivedCommunityGoalsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListArchivedCommunityGoals")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListArchivedCommunityGoalsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListArchivedCommunityGoalsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ListArchivedCommunityGoals(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListArchivedCommunityGoalsResponse and nil error while calling ListArchivedCommunityGoals. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCreateCommunityGoal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCommunityGoalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCommunityGoalProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveCreateCommunityGoalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCommunityGoalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CreateCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCommunityGoalResponse and nil error while calling CreateCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveCreateCommunityGoalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateCommunityGoalRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.CreateCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCommunityGoalResponse and nil error while calling CreateCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveDeleteCommunityGoal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteCommunityGoalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteCommunityGoalProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveDeleteCommunityGoalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteCommunityGoalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.DeleteCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCommunityGoalResponse and nil error while calling DeleteCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveDeleteCommunityGoalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteCommunityGoalRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.DeleteCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteCommunityGoalResponse and nil error while calling DeleteCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateCommunityGoal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCommunityGoalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCommunityGoalProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveUpdateCommunityGoalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCommunityGoalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCommunityGoalResponse and nil error while calling UpdateCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveUpdateCommunityGoalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCommunityGoalRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.UpdateCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCommunityGoalResponse and nil error while calling UpdateCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveContributeToCommunityGoal(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveContributeToCommunityGoalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveContributeToCommunityGoalProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveContributeToCommunityGoalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ContributeToCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ContributeToCommunityGoalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ContributeToCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ContributeToCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ContributeToCommunityGoalResponse and nil error while calling ContributeToCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveContributeToCommunityGoalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ContributeToCommunityGoal")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ContributeToCommunityGoalRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ContributeToCommunityGoalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.ContributeToCommunityGoal(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ContributeToCommunityGoalResponse and nil error while calling ContributeToCommunityGoal. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetUserStreamCommunityGoalContributions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserStreamCommunityGoalContributionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserStreamCommunityGoalContributionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetUserStreamCommunityGoalContributionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamCommunityGoalContributions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserStreamCommunityGoalContributionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserStreamCommunityGoalContributionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetUserStreamCommunityGoalContributions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserStreamCommunityGoalContributionsResponse and nil error while calling GetUserStreamCommunityGoalContributions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetUserStreamCommunityGoalContributionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamCommunityGoalContributions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserStreamCommunityGoalContributionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserStreamCommunityGoalContributionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetUserStreamCommunityGoalContributions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserStreamCommunityGoalContributionsResponse and nil error while calling GetUserStreamCommunityGoalContributions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetUserStreamRedemptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetUserStreamRedemptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserStreamRedemptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoServer) serveGetUserStreamRedemptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamRedemptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetUserStreamRedemptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserStreamRedemptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetUserStreamRedemptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserStreamRedemptionsResponse and nil error while calling GetUserStreamRedemptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) serveGetUserStreamRedemptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetUserStreamRedemptions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserStreamRedemptionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserStreamRedemptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Copo.GetUserStreamRedemptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserStreamRedemptionsResponse and nil error while calling GetUserStreamRedemptions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *copoServer) ProtocGenTwirpVersion() string {
	return "v5.5.2"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.2")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 9147 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x7d, 0x5b, 0x8c, 0x1c, 0x49,
	0xb6, 0x90, 0xab, 0xaa, 0x5f, 0x75, 0xfa, 0x55, 0x1d, 0xdd, 0x6e, 0xf7, 0xcb, 0xfd, 0x48, 0xdb,
	0xe3, 0x99, 0x9e, 0x19, 0xbf, 0xc6, 0x33, 0xe3, 0x99, 0xdd, 0xd9, 0xdd, 0xec, 0xaa, 0x74, 0x77,
	0x8d, 0xeb, 0xd1, 0x9b, 0x55, 0x65, 0xaf, 0x67, 0xf7, 0x6e, 0xde, 0x74, 0x55, 0xba, 0x9d, 0xeb,
	0xaa, 0xca, 0x9e, 0xca, 0x2c, 0x3f, 0x2e, 0x20, 0x5d, 0x2e, 0x48, 0x5c, 0xf6, 0x2e, 0x42, 0x20,
	0x16, 0xd0, 0x15, 0x42, 0x80, 0xe0, 0xc2, 0x0f, 0x88, 0x8b, 0x84, 0x2e, 0x42, 0x7c, 0xef, 0xcf,
	0x7e, 0xc0, 0xcf, 0x95, 0x10, 0x77, 0xc5, 0x0f, 0x1f, 0x08, 0x04, 0x9f, 0x08, 0x3e, 0x51, 0x3c,
	0x32, 0x33, 0x32, 0x33, 0x22, 0xab, 0xba, 0x6d, 0xc3, 0x4f, 0xab, 0x2b, 0xe3, 0x9c, 0x13, 0x11,
	0x27, 0xce, 0x39, 0x71, 0x4e, 0xc4, 0x89, 0x08, 0x80, 0xb6, 0x73, 0xea, 0xdc, 0x38, 0x1d, 0x38,
	0x9e, 0x83, 0x26, 0xf0, 0xff, 0x1b, 0x3b, 0x27, 0x8e, 0x73, 0xd2, 0xb5, 0x6e, 0x92, 0x6f, 0x4f,
	0x86, 0x4f, 0x6f, 0x7a, 0x76, 0xcf, 0x72, 0x3d, 0xb3, 0x77, 0x4a, 0xc1, 0x36, 0xb6, 0xe3, 0x00,
	0x2f, 0x07, 0xe6, 0xe9, 0xa9, 0x35, 0x70, 0x69, 0xb9, 0xf2, 0x00, 0x96, 0x0e, 0x2d, 0xef, 0xc0,
	0xec, 0x9a, 0xfd, 0xb6, 0xa5, 0x5b, 0xdf, 0x0e, 0x2d, 0xd7, 0x43, 0x97, 0x60, 0x7a, 0xe8, 0x5a,
	0x03, 0xc3, 0xee, 0xac, 0x65, 0x76, 0x33, 0xef, 0xe7, 0xf5, 0x29, 0xfc, 0xb3, 0xdc, 0x41, 0x97,
	0x01, 0xda, 0xcf, 0xcc, 0x7e, 0xdf, 0xea, 0xe2, 0xb2, 0x2c, 0x29, 0xcb, 0xb3, 0x2f, 0xe5, 0x8e,
	0xf2, 0x15, 0x20, 0x9e, 0x98, 0x7b, 0xea, 0xf4, 0x5d, 0x0b, 0x5d, 0x87, 0xe9, 0x27, 0xf4, 0x13,
	0xa1, 0x36, 0x7b, 0x67, 0xfe, 0x06, 0xe9, 0x87, 0x0f, 0xe7, 0x97, 0x2a, 0x5f, 0xc2, 0xfa, 0xa1,
	0xe5, 0x15, 0x29, 0xb9, 0x86, 0xe5, 0x79, 0x76, 0xff, 0xc4, 0xf5, 0xdb, 0x14, 0xad, 0x3a, 0x13,
	0xaf, 0xba, 0x0e, 0x1b, 0x22, 0x5c, 0xd6, 0x84, 0xdb, 0x30, 0xe3, 0xb2, 0x6f, 0xac, 0x0d, 0x17,
	0x69, 0x1b, 0xe2, 0x08, 0x01, 0x98, 0xf2, 0x67, 0x59, 0xd8, 0x6a, 0x9d, 0x76, 0x4c, 0xcf, 0x3a,
	0x57, 0x83, 0xd0, 0x17, 0x00, 0xb6, 0x6b, 0x58, 0x7d, 0xf3, 0x49, 0xd7, 0xa2, 0xac, 0x9a, 0xbd,
	0xb3, 0x71, 0x83, 0x8e, 0xc6, 0x0d, 0x7f, 0x34, 0x6e, 0x1c, 0x38, 0x4e, 0xf7, 0xa1, 0xd9, 0x1d,
	0x5a, 0x7a, 0xde, 0x76, 0x35, 0x0a, 0x8c, 0x51, 0x07, 0x96, 0x6b, 0x79, 0x46, 0xdf, 0xec, 0x59,
	0x6b, 0xb9, 0xd1, 0xa8, 0x04, 0xba, 0x66, 0xf6, 0x2c, 0x74, 0x0b, 0x26, 0x08, 0xd2, 0x04, 0x41,
	0xda, 0x4a, 0x20, 0x35, 0xbc, 0x81, 0xdd, 0x3f, 0xa1, 0x68, 0x04, 0x12, 0x7d, 0x0e, 0x33, 0x76,
	0xcf, 0x3c, 0xb1, 0x70, 0x27, 0x26, 0xc7, 0xc0, 0x9a, 0x26, 0xd0, 0xe5, 0x0e, 0xfa, 0x0e, 0xcc,
	0xd2, 0x56, 0x92, 0x0f, 0x6b, 0x53, 0x23, 0x9b, 0x49, 0x3b, 0x55, 0xc6, 0xd0, 0xca, 0xcf, 0x33,
	0x70, 0x59, 0xc2, 0xdd, 0x73, 0x0f, 0x19, 0xfa, 0x0c, 0x26, 0xad, 0xc1, 0xc0, 0x19, 0x30, 0x6e,
	0xef, 0x52, 0x78, 0x61, 0x35, 0x1a, 0x86, 0xd3, 0x29, 0xb8, 0xf2, 0x10, 0x36, 0xe4, 0x40, 0xe8,
	0x1e, 0x4c, 0xb4, 0x9d, 0x0e, 0x95, 0xdd, 0x85, 0x3b, 0x57, 0x47, 0x11, 0x2d, 0x3a, 0x1d, 0x4b,
	0x27, 0x18, 0x8a, 0x0e, 0x6b, 0x87, 0x96, 0xa7, 0xbe, 0x30, 0xed, 0x2e, 0x1e, 0xd8, 0x62, 0xd7,
	0xb4, 0x7b, 0x6f, 0xaa, 0x62, 0x3f, 0x24, 0x3a, 0x12, 0xa7, 0xc9, 0x78, 0x76, 0x17, 0x16, 0x4d,
	0xbf, 0xc4, 0x68, 0xe3, 0x22, 0xc6, 0xba, 0x59, 0xc6, 0x3a, 0x02, 0xbd, 0x60, 0x46, 0xb0, 0x95,
	0x13, 0x40, 0xe4, 0x9f, 0x63, 0xc7, 0xee, 0x7b, 0xee, 0x1b, 0x36, 0x10, 0xad, 0xc3, 0x0c, 0xa9,
	0x19, 0x17, 0xe6, 0x48, 0xe1, 0x34, 0xf9, 0x5d, 0xee, 0x28, 0x7f, 0x3d, 0x03, 0xcb, 0x91, 0x9a,
	0xce, 0x68, 0x20, 0xd0, 0x1e, 0x4c, 0xd2, 0x5e, 0x65, 0x93, 0xbd, 0xa2, 0x25, 0xe8, 0x23, 0x5f,
	0x06, 0xa8, 0xda, 0xac, 0x72, 0x20, 0xb4, 0xd6, 0xc8, 0xc8, 0x7f, 0x87, 0x58, 0x0d, 0x75, 0xe8,
	0x39, 0x3d, 0xd3, 0xb3, 0xdb, 0xba, 0xf5, 0xd2, 0x1c, 0x74, 0xc6, 0x35, 0x39, 0x26, 0x6c, 0x0a,
	0x91, 0x59, 0xaf, 0x0e, 0x60, 0xc9, 0xf4, 0xcb, 0x8c, 0x01, 0x2d, 0x5c, 0xcb, 0xec, 0xe6, 0x42,
	0x49, 0x8e, 0xa1, 0xea, 0x05, 0x33, 0x46, 0x4b, 0xf9, 0xe3, 0x09, 0xdf, 0x08, 0xc5, 0x61, 0xc7,
	0x33, 0x42, 0x5f, 0x62, 0x1d, 0xc5, 0xf0, 0x86, 0xf7, 0xfa, 0xd4, 0x22, 0x6c, 0x5b, 0xb8, 0xb3,
	0x2e, 0xac, 0xbd, 0xf9, 0xfa, 0x94, 0xa8, 0xa8, 0xff, 0x3f, 0xba, 0x89, 0xe5, 0xde, 0xf5, 0x18,
	0x23, 0x37, 0x13, 0x8a, 0x5d, 0xee, 0x7b, 0x9f, 0xdd, 0x65, 0x96, 0x04, 0x03, 0x46, 0x2c, 0xc9,
	0xc4, 0x59, 0x2c, 0xc9, 0x21, 0x14, 0x9e, 0x98, 0xed, 0xe7, 0x27, 0x03, 0x67, 0xd8, 0xef, 0x18,
	0x6d, 0xa7, 0xeb, 0x0c, 0xc6, 0x32, 0x45, 0x8b, 0x21, 0x56, 0x11, 0x23, 0xc5, 0x6c, 0xee, 0xd4,
	0xb9, 0x6c, 0x2e, 0xe9, 0xf3, 0xf4, 0x98, 0x36, 0xb7, 0x88, 0xfb, 0x1d, 0x33, 0x84, 0x33, 0x67,
	0x31, 0x84, 0xe8, 0x18, 0x56, 0x29, 0x72, 0x82, 0x03, 0xf9, 0x91, 0x74, 0x56, 0x08, 0xe6, 0x41,
	0x94, 0x09, 0xca, 0x2f, 0x03, 0xd3, 0x9a, 0x90, 0x19, 0x26, 0x99, 0xdf, 0x85, 0x85, 0x21, 0x01,
	0xe8, 0x30, 0xb9, 0x8c, 0x1a, 0xd8, 0x38, 0xda, 0x3c, 0x03, 0xa6, 0x3f, 0x53, 0xad, 0x6c, 0x0c,
	0x55, 0x6c, 0x65, 0x45, 0x40, 0x69, 0x56, 0x56, 0x04, 0xcf, 0x59, 0xd9, 0x2f, 0x60, 0xad, 0x62,
	0xbb, 0x5e, 0x71, 0xe8, 0x7a, 0x4e, 0xef, 0x6c, 0x1a, 0xfc, 0xf3, 0x0c, 0xac, 0x0b, 0x70, 0x19,
	0x9b, 0xbe, 0x80, 0x85, 0x36, 0x29, 0x88, 0x69, 0x2f, 0x62, 0x36, 0x85, 0x43, 0xd2, 0xe7, 0xdb,
	0x3c, 0x09, 0x74, 0x27, 0xca, 0xa3, 0x2d, 0x8a, 0x91, 0xa8, 0x2a, 0xc2, 0x9f, 0x26, 0xac, 0x62,
	0x0f, 0x86, 0xa7, 0x3a, 0x9e, 0x92, 0x6f, 0x42, 0x9e, 0x29, 0x79, 0x60, 0x8f, 0x67, 0xe8, 0x87,
	0x72, 0x47, 0xf9, 0xcb, 0x19, 0xb8, 0x94, 0x20, 0xcb, 0x3a, 0xf8, 0x39, 0xcc, 0x47, 0x3a, 0xc8,
	0xc4, 0x40, 0xd4, 0xbf, 0x39, 0xbe, 0x7f, 0xe8, 0x56, 0xb4, 0x7b, 0x1b, 0x14, 0x21, 0x56, 0x4d,
	0xa4, 0x73, 0x7f, 0x3a, 0x09, 0xeb, 0xc5, 0x81, 0x85, 0xe7, 0xcc, 0xb3, 0x77, 0x70, 0x05, 0x26,
	0x3d, 0xdb, 0xeb, 0x5a, 0xac, 0x73, 0xf4, 0x07, 0xba, 0x0b, 0x53, 0xa7, 0x03, 0xa7, 0x77, 0xea,
	0x5b, 0xa8, 0x74, 0x5b, 0xc1, 0x60, 0x11, 0x62, 0x56, 0x0d, 0x1b, 0xa8, 0x1c, 0x33, 0x5c, 0x35,
	0x58, 0xed, 0x99, 0xaf, 0x8c, 0x53, 0x6b, 0x60, 0xb8, 0xde, 0xc0, 0x32, 0x7b, 0x06, 0x73, 0x29,
	0x98, 0x15, 0x62, 0x06, 0xb3, 0x6a, 0xbe, 0x3a, 0xb6, 0x06, 0x0d, 0x02, 0xc1, 0xa6, 0x7c, 0x7d,
	0xb9, 0x97, 0xfc, 0x28, 0xb4, 0x67, 0x53, 0xe7, 0xb1, 0x67, 0x9f, 0xc0, 0xaa, 0xed, 0x1a, 0x74,
	0x1a, 0xee, 0x9f, 0x0e, 0x3d, 0x63, 0x60, 0x7d, 0x3b, 0xb4, 0x07, 0x56, 0x87, 0x18, 0xa8, 0x19,
	0x7d, 0xd9, 0x76, 0x5b, 0x78, 0x52, 0xc6, 0x65, 0x3a, 0x2b, 0x42, 0xdb, 0x30, 0x6b, 0xbb, 0x86,
	0x3b, 0x7c, 0x62, 0x38, 0xfd, 0xee, 0x6b, 0x62, 0x8e, 0x66, 0xb0, 0xa5, 0x6b, 0x0c, 0x9f, 0xd4,
	0xfb, 0xdd, 0xd7, 0xe8, 0x18, 0xae, 0xb9, 0xcf, 0x9c, 0x61, 0x17, 0x2b, 0x7f, 0xc7, 0xea, 0x9d,
	0x7a, 0xb6, 0xd3, 0x77, 0x0d, 0xf7, 0xb9, 0x7d, 0x4a, 0xc8, 0x5b, 0xae, 0x67, 0x7c, 0x3b, 0xb4,
	0x86, 0x16, 0x31, 0x40, 0x33, 0xfa, 0x1e, 0x05, 0xd6, 0x43, 0xd8, 0xc6, 0x73, 0xfb, 0x94, 0x8d,
	0xdc, 0x0f, 0x31, 0x20, 0xfa, 0x0a, 0x66, 0x3d, 0xab, 0x77, 0xda, 0x35, 0x3d, 0x62, 0xfb, 0x61,
	0x8c, 0xae, 0x82, 0x8f, 0x50, 0xee, 0x20, 0x0b, 0x76, 0x7c, 0xf6, 0x93, 0xae, 0x0a, 0xc6, 0x61,
	0x96, 0x37, 0x35, 0x74, 0x1c, 0x70, 0xc7, 0x13, 0xc3, 0xb1, 0xd1, 0x93, 0x96, 0xa1, 0x06, 0x5c,
	0x3a, 0xe9, 0x3a, 0x4f, 0xcc, 0xae, 0xd1, 0x76, 0x9c, 0x6e, 0xc7, 0x79, 0xd9, 0x0f, 0xc8, 0xcf,
	0xb1, 0x29, 0x8e, 0x8a, 0x31, 0x01, 0x2a, 0x3a, 0x4e, 0xb7, 0xe4, 0xbc, 0xec, 0xfb, 0x94, 0x2f,
	0x9e, 0x04, 0x9f, 0x3b, 0xe1, 0x67, 0xe5, 0x17, 0x19, 0xd8, 0x10, 0xc9, 0x35, 0x67, 0x42, 0x48,
	0x69, 0x67, 0xb4, 0x8a, 0xcd, 0x33, 0x48, 0xa6, 0x63, 0x9f, 0x44, 0x75, 0xec, 0x32, 0xc3, 0x48,
	0xd4, 0x15, 0x51, 0xb3, 0x63, 0xb8, 0x24, 0x81, 0x40, 0x9f, 0x46, 0x0c, 0xec, 0x5e, 0x2a, 0x39,
	0xce, 0xba, 0xfe, 0xa7, 0x19, 0x58, 0x67, 0xce, 0xee, 0xdb, 0xb5, 0x4c, 0xd8, 0x46, 0x52, 0xad,
	0x1e, 0x47, 0x7d, 0x13, 0x3a, 0x3f, 0x71, 0x06, 0x9d, 0xf7, 0x3d, 0x99, 0xc9, 0x71, 0x3d, 0x19,
	0xb9, 0x41, 0x98, 0x7a, 0x6b, 0x06, 0x61, 0xfa, 0x3c, 0x06, 0xa1, 0x2e, 0x35, 0x08, 0xa3, 0xbd,
	0x0e, 0xa1, 0xb1, 0xf8, 0x32, 0x6a, 0x2c, 0xf2, 0xe3, 0xb8, 0x4c, 0xbe, 0x21, 0x89, 0x7a, 0x5b,
	0x70, 0x16, 0x6f, 0xeb, 0x73, 0xc8, 0xdb, 0xae, 0x71, 0x6a, 0x0e, 0x5d, 0xab, 0xc3, 0x94, 0x3b,
	0x0d, 0x73, 0xc6, 0x76, 0x8f, 0x09, 0x6c, 0xc4, 0xc7, 0x9c, 0x7b, 0x83, 0x68, 0x75, 0xfe, 0x4c,
	0x4e, 0xda, 0x47, 0x80, 0x98, 0x69, 0xb4, 0xfb, 0x27, 0x86, 0x1f, 0x16, 0x2d, 0x10, 0x81, 0x2e,
	0x84, 0x25, 0x2d, 0x1a, 0x20, 0x75, 0xc7, 0x35, 0xb0, 0x8b, 0x23, 0x1b, 0x31, 0x86, 0xf1, 0x1d,
	0xc3, 0x7a, 0x16, 0xde, 0xad, 0xf5, 0x5c, 0x7a, 0x23, 0xeb, 0x29, 0x32, 0x2e, 0xa1, 0xf5, 0x14,
	0xfa, 0xa9, 0x42, 0xeb, 0x19, 0x75, 0x52, 0xc5, 0xd6, 0x33, 0x59, 0x57, 0xdc, 0x7a, 0x4a, 0x20,
	0xc4, 0xd6, 0x53, 0x02, 0xcc, 0x59, 0xcf, 0x7f, 0x97, 0x81, 0x75, 0xdd, 0xea, 0x39, 0x2f, 0xde,
	0xba, 0xf5, 0x6c, 0x83, 0x32, 0xec, 0x3f, 0x1d, 0x76, 0x9f, 0xda, 0xdd, 0xae, 0x15, 0x95, 0xb4,
	0xbe, 0xf5, 0xd2, 0x70, 0x3d, 0xd3, 0x1b, 0xba, 0xc4, 0xb4, 0x2e, 0xf8, 0x41, 0x70, 0x28, 0x45,
	0x0d, 0x52, 0xaa, 0xef, 0x70, 0x14, 0x38, 0x11, 0xab, 0x59, 0x2f, 0x29, 0x00, 0x19, 0x1f, 0x51,
	0xf3, 0xc3, 0xf1, 0x19, 0x90, 0xd2, 0x71, 0xc6, 0x87, 0x41, 0xa6, 0x8e, 0x4f, 0xb2, 0xae, 0xf8,
	0xf8, 0x48, 0x20, 0xc4, 0xe3, 0x23, 0x01, 0xe6, 0xc6, 0xe7, 0xf7, 0xb2, 0xb0, 0x85, 0x7b, 0x6e,
	0xf5, 0x24, 0xf1, 0x75, 0x2c, 0x80, 0xce, 0x9c, 0x25, 0x80, 0xe6, 0x56, 0x50, 0xb2, 0x29, 0x2b,
	0x28, 0xb9, 0xf8, 0xb8, 0x8b, 0x5c, 0xd4, 0x6b, 0xb0, 0xe0, 0x0d, 0xcc, 0xbe, 0x6b, 0xb6, 0xf1,
	0x10, 0xf9, 0x6b, 0x75, 0x79, 0x7d, 0x9e, 0xfb, 0x5a, 0xee, 0xa0, 0x35, 0x98, 0xee, 0x59, 0xae,
	0xeb, 0xaf, 0xc7, 0xe5, 0x75, 0xff, 0x27, 0x5a, 0x87, 0x19, 0xab, 0xe7, 0x50, 0x07, 0x6d, 0x9a,
	0x16, 0x91, 0xdf, 0xe5, 0x8e, 0xf2, 0x1f, 0xb2, 0x70, 0x59, 0xc2, 0x04, 0x36, 0xd0, 0x1f, 0xc3,
	0xd4, 0x38, 0x81, 0x22, 0x03, 0xe2, 0xd7, 0x73, 0xb2, 0xa9, 0xeb, 0x39, 0xdf, 0x03, 0x20, 0x23,
	0x6b, 0x90, 0xb1, 0xa3, 0xc2, 0xba, 0xe3, 0x8f, 0x1d, 0x6d, 0x81, 0x2f, 0x95, 0xe1, 0xc8, 0xe5,
	0x2d, 0xff, 0x5f, 0xf4, 0x33, 0xd8, 0x1d, 0x98, 0xfd, 0x8e, 0xd3, 0x23, 0x33, 0x18, 0xed, 0xdf,
	0xb0, 0xdf, 0x75, 0xda, 0xcf, 0x8d, 0x9e, 0xe5, 0x99, 0x1d, 0xd3, 0x33, 0x99, 0xa3, 0xa0, 0x30,
	0xaa, 0x04, 0xba, 0x31, 0x7c, 0xa2, 0x61, 0xd8, 0x16, 0x01, 0xad, 0x32, 0x48, 0x7d, 0x6b, 0x90,
	0x52, 0x8a, 0x3e, 0x04, 0x64, 0xbb, 0xc6, 0x33, 0xab, 0xdb, 0x31, 0x9e, 0xbc, 0x36, 0xc8, 0x4a,
	0x8d, 0x43, 0x47, 0x61, 0x46, 0x5f, 0xb4, 0xdd, 0x23, 0xab, 0xdb, 0x39, 0x78, 0xad, 0xd2, 0xcf,
	0xca, 0xdf, 0xce, 0xc2, 0x2a, 0x8e, 0xf6, 0x38, 0xad, 0x1a, 0x3f, 0xd6, 0xe9, 0xda, 0x3d, 0xdb,
	0x23, 0x9c, 0xcb, 0xe9, 0xf4, 0x07, 0x5a, 0x85, 0xa9, 0xf6, 0x70, 0xe0, 0xb2, 0x65, 0xad, 0xbc,
	0xce, 0x7e, 0xa1, 0xbb, 0x30, 0xe9, 0x0c, 0x3a, 0xd6, 0x80, 0xf4, 0x72, 0xe1, 0xce, 0x76, 0x18,
	0x67, 0xf2, 0x53, 0x86, 0x33, 0xf0, 0xea, 0x18, 0x4a, 0xa7, 0xc0, 0xe8, 0x06, 0x4c, 0x31, 0xfb,
	0x30, 0x99, 0x6a, 0x1f, 0x18, 0x54, 0xd4, 0x10, 0x4d, 0xc5, 0x0c, 0x91, 0x78, 0x6e, 0x9c, 0x16,
	0xcf, 0x8d, 0xca, 0x3f, 0xcd, 0xc0, 0xa5, 0x04, 0x63, 0x98, 0x94, 0x7d, 0x86, 0x75, 0x2d, 0xf8,
	0xcc, 0x82, 0xed, 0x95, 0x78, 0xdb, 0xb4, 0xce, 0x89, 0xa5, 0xf3, 0x80, 0x48, 0x81, 0xf9, 0x67,
	0x26, 0x36, 0x7b, 0xaf, 0x3c, 0xe3, 0x14, 0x8b, 0x7e, 0x96, 0x0c, 0xca, 0xec, 0x33, 0xd3, 0xad,
	0x59, 0xaf, 0xbc, 0x63, 0x2c, 0xfe, 0xb7, 0xa2, 0xcb, 0x82, 0x1b, 0x42, 0x46, 0x45, 0x8c, 0xcd,
	0xff, 0x21, 0xa6, 0x1b, 0x6b, 0x85, 0xc8, 0x74, 0x47, 0x58, 0x92, 0x89, 0xb1, 0xe4, 0x6d, 0x2a,
	0x7e, 0x10, 0xfb, 0x4e, 0xf2, 0xb1, 0xef, 0x6a, 0xe0, 0x07, 0xd3, 0xe1, 0xf0, 0x3d, 0xdd, 0xa4,
	0x99, 0x98, 0x16, 0x99, 0x89, 0xcb, 0x00, 0xa1, 0x0f, 0x49, 0x5c, 0xc7, 0xbc, 0x9e, 0x1f, 0xfa,
	0xce, 0xa1, 0xf2, 0x2f, 0x89, 0xd9, 0x4f, 0x76, 0xfd, 0xac, 0xcb, 0xb5, 0xb7, 0x00, 0xc2, 0x71,
	0x62, 0xa6, 0xa0, 0x10, 0x1f, 0x4f, 0x9d, 0x83, 0x41, 0x9f, 0x47, 0x87, 0x69, 0x4f, 0x30, 0x91,
	0x44, 0x2d, 0x82, 0x3f, 0x5a, 0x7f, 0x98, 0x85, 0x4d, 0xad, 0x63, 0x7b, 0x09, 0x19, 0x1e, 0x4f,
	0xeb, 0xae, 0xc0, 0x7c, 0xd8, 0x8a, 0x70, 0xdc, 0xe6, 0xc2, 0x8f, 0xe5, 0x0e, 0xfa, 0x14, 0x60,
	0xec, 0xa9, 0x35, 0xdf, 0xf7, 0x27, 0xd1, 0xa8, 0xa8, 0x4c, 0xc4, 0x44, 0xe5, 0x53, 0x00, 0xa7,
	0xdb, 0x31, 0xc6, 0x52, 0xc7, 0xbc, 0xd3, 0xed, 0x30, 0x9a, 0x62, 0xa5, 0x9b, 0x92, 0x28, 0xdd,
	0x5f, 0xc9, 0xc0, 0x96, 0x98, 0x39, 0x6c, 0x44, 0xa3, 0x03, 0x95, 0x19, 0x63, 0xa0, 0x3e, 0x8d,
	0xce, 0xdf, 0xcc, 0x68, 0x8b, 0x2a, 0x89, 0x0c, 0xd3, 0x3f, 0xc8, 0xc2, 0xce, 0xc1, 0xb0, 0xfb,
	0xfc, 0x0d, 0x86, 0xea, 0x1a, 0x76, 0x3a, 0xb8, 0xa1, 0x72, 0xd7, 0xb2, 0xbb, 0x39, 0x2c, 0xe2,
	0xfc, 0x58, 0xc5, 0xb8, 0x9e, 0x4b, 0x72, 0x9d, 0x1b, 0xc9, 0x89, 0x71, 0x47, 0xf2, 0xff, 0xc9,
	0x60, 0xfd, 0xbd, 0x0c, 0xec, 0xca, 0x59, 0xc4, 0x06, 0x2c, 0x60, 0x7f, 0xe6, 0x2c, 0xec, 0x47,
	0x2a, 0x2c, 0x87, 0x0e, 0x75, 0x68, 0x69, 0xb3, 0xc4, 0xd2, 0x26, 0x07, 0x1c, 0x05, 0x3e, 0x75,
	0x00, 0xab, 0x7c, 0x03, 0x2b, 0x87, 0x16, 0x57, 0xcb, 0x5b, 0x54, 0x30, 0xe5, 0x35, 0x5c, 0x8c,
	0xd1, 0x3e, 0xb7, 0x7c, 0xde, 0x88, 0xca, 0xe7, 0x5a, 0xb0, 0x42, 0x29, 0xb1, 0x1f, 0x8f, 0x61,
	0xe7, 0xd0, 0xf2, 0xf0, 0x10, 0xd0, 0xb0, 0xe7, 0xec, 0x13, 0xb7, 0xcc, 0xe8, 0x2b, 0xbf, 0x0d,
	0xbb, 0x72, 0xd2, 0xc1, 0x8a, 0xbc, 0x60, 0xea, 0x63, 0x93, 0x94, 0x08, 0x33, 0x32, 0x01, 0x2a,
	0x4f, 0xc9, 0x12, 0x2f, 0xb5, 0x8f, 0x8d, 0x61, 0xaf, 0x67, 0x0e, 0x5e, 0x8f, 0xd9, 0x68, 0xb1,
	0x68, 0x66, 0x25, 0xa2, 0x79, 0x4c, 0xf6, 0x33, 0x63, 0xf5, 0x04, 0x5b, 0x8f, 0x79, 0x97, 0x7c,
	0xb2, 0x2d, 0xbf, 0xfd, 0x4c, 0x35, 0x28, 0xa4, 0xfd, 0x3b, 0xbe, 0xef, 0xaf, 0x87, 0x80, 0x4a,
	0x8b, 0x6e, 0xa1, 0xb5, 0x3d, 0xfb, 0x85, 0x55, 0x1d, 0x76, 0x3d, 0xfb, 0xb4, 0x6b, 0x5b, 0x83,
	0x37, 0xdd, 0x83, 0x54, 0x7e, 0x0c, 0x5b, 0x62, 0xb2, 0xac, 0xb1, 0xdf, 0x81, 0xd9, 0x5e, 0xf8,
	0x99, 0x35, 0x97, 0x79, 0xf5, 0x64, 0x97, 0xf0, 0xd0, 0xb4, 0xfb, 0x21, 0xa2, 0xce, 0x43, 0x2b,
	0x7f, 0x92, 0x85, 0x2d, 0xba, 0x6e, 0x46, 0x16, 0x07, 0x5a, 0xa7, 0x5d, 0xc7, 0xec, 0x94, 0xfb,
	0x4f, 0x9d, 0x31, 0x79, 0x7e, 0x1f, 0x0a, 0x91, 0x55, 0x77, 0xbf, 0x07, 0xa3, 0x96, 0x32, 0x16,
	0xf8, 0x25, 0xf8, 0x72, 0x07, 0x55, 0xe1, 0x62, 0x7c, 0x7f, 0x91, 0x06, 0x29, 0xb9, 0x51, 0x41,
	0xca, 0xb2, 0x99, 0xfc, 0x88, 0x79, 0x6d, 0xbb, 0x86, 0xdd, 0x76, 0xfa, 0xc4, 0x20, 0xce, 0xe8,
	0x53, 0xb6, 0x5b, 0x6e, 0x3b, 0x7d, 0x74, 0x04, 0x4b, 0x6d, 0xa7, 0xd7, 0x1b, 0xf6, 0x6d, 0xef,
	0xb5, 0x71, 0xe2, 0x98, 0xdd, 0x71, 0x33, 0x05, 0x16, 0x03, 0xb4, 0x43, 0xc7, 0xc4, 0xc3, 0xf2,
	0x8f, 0xb2, 0x70, 0x59, 0xc2, 0x39, 0x36, 0x30, 0x2a, 0x2c, 0x0d, 0xc9, 0x57, 0xc3, 0xee, 0x3f,
	0x75, 0x0c, 0xb7, 0x67, 0x76, 0xbb, 0xd1, 0x98, 0x23, 0x8e, 0xb9, 0x38, 0x0c, 0xfe, 0x6f, 0x60,
	0x68, 0x54, 0x04, 0xc4, 0x93, 0xe8, 0x59, 0x1d, 0x7b, 0xe8, 0x6f, 0x18, 0x4b, 0x68, 0x14, 0x42,
	0x1a, 0x55, 0x02, 0x1e, 0x6f, 0x47, 0xd7, 0x1c, 0x9c, 0xf8, 0xeb, 0x94, 0xa3, 0xdb, 0x51, 0xc1,
	0xd0, 0xe1, 0x36, 0xd9, 0x04, 0xbf, 0xfa, 0x22, 0xec, 0x7e, 0x7c, 0x9b, 0x4c, 0x0e, 0x24, 0xde,
	0x26, 0x93, 0xc3, 0x73, 0xa1, 0xee, 0x3d, 0x62, 0x24, 0x48, 0x64, 0xf3, 0xd0, 0x1c, 0xd8, 0x26,
	0xb7, 0xd5, 0x3f, 0x62, 0x97, 0xac, 0x45, 0xd4, 0x3e, 0x86, 0x19, 0x2e, 0x01, 0xd0, 0xb0, 0xeb,
	0x05, 0x2b, 0x89, 0xee, 0x91, 0xf1, 0x48, 0xfa, 0xbc, 0xc5, 0x93, 0x50, 0xee, 0xc1, 0x65, 0x4c,
	0xd6, 0x1c, 0x74, 0x5f, 0xab, 0xed, 0xb6, 0xe5, 0xba, 0xf1, 0x04, 0x1b, 0x99, 0xf6, 0x2b, 0x7f,
	0x0e, 0xb6, 0x65, 0x98, 0xac, 0x59, 0x52, 0xc3, 0xb1, 0x0d, 0xb3, 0x6d, 0xb3, 0x6f, 0xb8, 0xf6,
	0x49, 0xdf, 0x18, 0x9e, 0xb2, 0x48, 0x21, 0xdf, 0x36, 0xfb, 0x0d, 0xfb, 0xa4, 0xdf, 0x3a, 0x45,
	0xbb, 0x30, 0x67, 0xbb, 0xa4, 0xd8, 0xea, 0x60, 0x80, 0x1c, 0x01, 0x00, 0xdb, 0x6d, 0x90, 0x4f,
	0xad, 0x53, 0xe5, 0xb7, 0x60, 0x97, 0xae, 0xfb, 0x9c, 0xa3, 0xe5, 0x09, 0xf2, 0xd9, 0x04, 0x79,
	0x03, 0xf6, 0x52, 0xc8, 0xb3, 0xee, 0x7d, 0x19, 0x9d, 0xfe, 0x23, 0xbb, 0xa5, 0x02, 0xbc, 0x88,
	0x7c, 0x35, 0x48, 0x02, 0x49, 0x05, 0x87, 0x95, 0x56, 0x47, 0x33, 0x07, 0xfd, 0xb1, 0x1a, 0x3e,
	0xc2, 0xe0, 0xfe, 0x59, 0x96, 0x24, 0x52, 0x24, 0xa8, 0xb2, 0xf6, 0x7e, 0x00, 0x85, 0xa7, 0x4e,
	0xb7, 0xeb, 0xbc, 0x34, 0x82, 0xd4, 0x13, 0x42, 0x7f, 0x46, 0x5f, 0xa4, 0xdf, 0x83, 0x7c, 0x16,
	0x74, 0x1d, 0x16, 0xdb, 0xcf, 0x2c, 0x6b, 0xc0, 0x41, 0x52, 0x26, 0x2d, 0x90, 0xcf, 0x21, 0xe0,
	0x11, 0xa0, 0x18, 0xa0, 0x61, 0x7a, 0xd2, 0x64, 0xa9, 0xa6, 0x9f, 0x16, 0xa7, 0x17, 0xa2, 0x74,
	0x54, 0x0f, 0x7d, 0x0f, 0x36, 0xdd, 0xe1, 0x13, 0xb7, 0x3d, 0xb0, 0xa9, 0x77, 0x72, 0x62, 0x3f,
	0xf5, 0xb8, 0xea, 0xa9, 0x35, 0x5c, 0xe7, 0x41, 0x0e, 0xed, 0xa7, 0x61, 0x0a, 0x0e, 0x32, 0x60,
	0x3b, 0x05, 0x1f, 0xb7, 0x6a, 0x72, 0x64, 0xab, 0x36, 0xa5, 0xe4, 0x55, 0x4f, 0xd1, 0xe0, 0xea,
	0xa1, 0xe5, 0x35, 0x7a, 0xe6, 0x80, 0x24, 0x1c, 0xb8, 0x6a, 0xfb, 0x79, 0xdf, 0x79, 0xd9, 0xb5,
	0x3a, 0x27, 0x56, 0xcf, 0x1a, 0x5f, 0x8f, 0x3d, 0xb8, 0x36, 0x82, 0x0c, 0x1b, 0xae, 0x07, 0x50,
	0x30, 0x63, 0x65, 0x4c, 0xad, 0x99, 0xa3, 0x29, 0xa5, 0xa1, 0x27, 0x10, 0x95, 0x5f, 0x66, 0xe0,
	0x3a, 0x95, 0xcc, 0x37, 0xed, 0x80, 0xb0, 0x5d, 0xd9, 0xf3, 0xb6, 0xeb, 0xdf, 0x66, 0xe0, 0xfd,
	0xd1, 0xed, 0x7a, 0x07, 0x1c, 0x41, 0x6a, 0xd4, 0x37, 0xfd, 0x90, 0xd7, 0x5e, 0x79, 0x5b, 0x22,
	0x4a, 0xfc, 0x9b, 0x0c, 0x5c, 0x6c, 0x0c, 0x9f, 0x78, 0x03, 0xb3, 0xed, 0xbd, 0x9d, 0xb4, 0xad,
	0x55, 0x98, 0x3a, 0x25, 0x84, 0x88, 0x0a, 0xe5, 0x74, 0xf6, 0x0b, 0xdd, 0x81, 0xa9, 0x81, 0x65,
	0xba, 0xcc, 0x2b, 0x58, 0xf0, 0x9d, 0xd2, 0x78, 0xe5, 0x18, 0x42, 0x67, 0x90, 0xe8, 0xfb, 0xd8,
	0x9b, 0xc5, 0xff, 0x19, 0xe6, 0xe0, 0xc4, 0x65, 0xd2, 0xbf, 0x2d, 0x47, 0x54, 0x07, 0x27, 0x2e,
	0xf6, 0xde, 0xfd, 0xff, 0x95, 0x01, 0xac, 0xc6, 0xe1, 0xce, 0xba, 0xf6, 0x70, 0x33, 0xca, 0xe4,
	0x75, 0x51, 0xed, 0x11, 0x96, 0xfe, 0x2a, 0x03, 0x4b, 0x47, 0x4e, 0xb7, 0xf3, 0x76, 0xd8, 0x79,
	0x05, 0xe6, 0x29, 0x03, 0x0d, 0xb3, 0xe7, 0x0c, 0xfb, 0x1e, 0xe3, 0xea, 0x1c, 0xfd, 0xa8, 0x92,
	0x6f, 0x82, 0xd5, 0x9a, 0x09, 0xd1, 0x6a, 0xcd, 0xc7, 0x80, 0xac, 0x57, 0xa7, 0xf6, 0xc0, 0x24,
	0x50, 0xae, 0xd5, 0x76, 0xfa, 0x1d, 0xca, 0xd5, 0x9c, 0xbe, 0x14, 0x96, 0x34, 0x68, 0x81, 0xf2,
	0x0d, 0x20, 0xbe, 0x1f, 0xe1, 0x8c, 0xf8, 0x0c, 0x07, 0xaf, 0x61, 0x47, 0xf0, 0xcf, 0x72, 0x07,
	0x7d, 0x18, 0x65, 0x14, 0x73, 0x6f, 0x42, 0x0a, 0x11, 0x26, 0xfd, 0x93, 0x2c, 0x2c, 0x15, 0x9d,
	0x5e, 0xcf, 0xf6, 0x30, 0x00, 0xc7, 0x24, 0x31, 0xed, 0x64, 0x07, 0xb3, 0xa2, 0x0e, 0x72, 0x4c,
	0xce, 0xa5, 0x30, 0x79, 0x62, 0x24, 0x93, 0x27, 0x05, 0x4c, 0x0e, 0x05, 0x78, 0xea, 0xbc, 0x02,
	0x3c, 0x7d, 0x66, 0x01, 0x56, 0x01, 0xf1, 0x6c, 0x62, 0x63, 0xf0, 0x61, 0x74, 0xda, 0xf6, 0xf3,
	0x59, 0x03, 0xc0, 0x08, 0xab, 0x5f, 0xc3, 0xfe, 0xa1, 0xe5, 0xc9, 0x56, 0x02, 0x8e, 0x07, 0xce,
	0xc9, 0xc0, 0x72, 0xdd, 0x77, 0x12, 0xe7, 0xfd, 0x3c, 0x03, 0x1f, 0x8e, 0x55, 0x37, 0xeb, 0xd7,
	0x8f, 0x61, 0xf5, 0xc9, 0xb0, 0xfb, 0xdc, 0xb0, 0x3a, 0xb6, 0xe7, 0x1a, 0x76, 0xdf, 0x38, 0x65,
	0x10, 0xcc, 0x46, 0xbe, 0xc7, 0x74, 0x74, 0x14, 0xbd, 0xe5, 0x27, 0x0c, 0xc2, 0x2d, 0xf7, 0xfd,
	0x8f, 0xca, 0xd7, 0xf0, 0x41, 0x2c, 0xb1, 0xa8, 0xc9, 0x52, 0x47, 0x8a, 0x4e, 0xb7, 0x6b, 0xb5,
	0xcf, 0x10, 0xa3, 0x2b, 0x1e, 0xe1, 0xe9, 0x48, 0x5a, 0xac, 0x5b, 0xf7, 0x61, 0xb6, 0x1d, 0x7e,
	0x66, 0x7d, 0xb9, 0x9a, 0x5c, 0x92, 0x4c, 0xd2, 0xd0, 0x79, 0x44, 0xe5, 0x27, 0xa0, 0x84, 0xa9,
	0xe9, 0x15, 0xd3, 0xf5, 0x1e, 0xda, 0xd6, 0x4b, 0xab, 0x53, 0x74, 0xfa, 0x1e, 0x9e, 0x20, 0xde,
	0xd0, 0xf5, 0xf2, 0xe0, 0x4a, 0x2a, 0x75, 0xd6, 0x99, 0x2a, 0x2c, 0x77, 0x4d, 0xd7, 0x33, 0x5e,
	0x90, 0x52, 0xa3, 0x4d, 0x8b, 0x59, 0xa7, 0xd8, 0xf6, 0x5b, 0x02, 0xfb, 0xe0, 0x35, 0x89, 0x17,
	0x97, 0xba, 0xf1, 0x02, 0xe5, 0xbb, 0xb0, 0x77, 0x68, 0x79, 0x74, 0xb3, 0xf7, 0xcc, 0x5d, 0x52,
	0x5e, 0x11, 0x8e, 0x48, 0xb1, 0x59, 0x93, 0xf5, 0xb4, 0x26, 0x2b, 0xa9, 0x4d, 0x56, 0xfb, 0x9d,
	0x72, 0x49, 0xd4, 0xee, 0x5f, 0x67, 0x60, 0x9b, 0xce, 0xb4, 0x6f, 0x7b, 0x20, 0xd0, 0x3d, 0x58,
	0x88, 0xb5, 0x34, 0xb7, 0x9b, 0x7b, 0x7f, 0xe1, 0xce, 0x92, 0xaf, 0xe6, 0xe4, 0x23, 0x61, 0xe8,
	0xfc, 0x0b, 0xbe, 0x62, 0xf4, 0x39, 0xe4, 0x19, 0xa6, 0xe9, 0x27, 0xb6, 0xa4, 0xf9, 0x8a, 0x33,
	0x14, 0x58, 0xf5, 0x94, 0x3f, 0xcc, 0xc2, 0x8e, 0xb4, 0x37, 0x8c, 0x8b, 0x06, 0x6c, 0xb0, 0x8d,
	0xfb, 0x37, 0x63, 0x26, 0xdb, 0xfe, 0x4f, 0xc0, 0xa0, 0x9f, 0xc0, 0xa6, 0xcf, 0x16, 0x51, 0x0d,
	0xd9, 0x71, 0x24, 0x6c, 0xad, 0x2d, 0x91, 0x5f, 0x74, 0x2f, 0xba, 0x23, 0xa0, 0xf0, 0xce, 0x52,
	0x02, 0x3a, 0x62, 0x40, 0xbf, 0xf1, 0x53, 0xa7, 0xc5, 0x60, 0xe8, 0xcb, 0x48, 0x28, 0xfd, 0xde,
	0x68, 0xc2, 0x5c, 0x30, 0xfd, 0x43, 0x9a, 0x54, 0xc9, 0xaf, 0x6f, 0x8c, 0xbf, 0x4c, 0xe8, 0xaf,
	0xa1, 0xb0, 0x65, 0xc2, 0x13, 0xba, 0x38, 0x52, 0x24, 0x51, 0x76, 0x8c, 0x64, 0xe0, 0xf5, 0x4c,
	0x60, 0x28, 0x36, 0x6f, 0x2c, 0x87, 0xf3, 0x46, 0x08, 0x4a, 0x00, 0x94, 0x2f, 0x59, 0x3e, 0x2b,
	0x5f, 0x34, 0xae, 0x71, 0x3c, 0x84, 0x0d, 0x11, 0x6e, 0x10, 0xc2, 0x4d, 0xe2, 0x1a, 0x7c, 0x33,
	0x28, 0x6c, 0x03, 0x85, 0x50, 0x4e, 0x61, 0x0f, 0x13, 0x52, 0x07, 0xed, 0x67, 0xf6, 0x0b, 0xcc,
	0xc2, 0xb3, 0x37, 0xe6, 0x6c, 0xdb, 0xa0, 0xca, 0x4b, 0x50, 0xd2, 0x6a, 0x0c, 0x76, 0xb1, 0x23,
	0x5d, 0xb8, 0x24, 0xe8, 0x02, 0xd9, 0x5c, 0xa4, 0x50, 0xe3, 0x6c, 0x2b, 0x2a, 0xff, 0x2b, 0x17,
	0xa4, 0xff, 0x9d, 0x43, 0x16, 0xc4, 0x79, 0xad, 0xdf, 0x83, 0xd9, 0x8e, 0x15, 0xc4, 0x82, 0x63,
	0x65, 0xc7, 0xf1, 0x08, 0x68, 0x07, 0x66, 0x89, 0x84, 0x31, 0x9f, 0x88, 0x6e, 0x26, 0x02, 0xfe,
	0xc4, 0x3c, 0xa2, 0xaf, 0x01, 0x91, 0x85, 0x35, 0xa2, 0xa2, 0x03, 0xfb, 0xc9, 0x90, 0xd4, 0x33,
	0x46, 0x72, 0xdc, 0x12, 0x41, 0x2b, 0x72, 0x58, 0xe8, 0x1b, 0xd8, 0xec, 0x99, 0xaf, 0x22, 0x94,
	0xb8, 0x0c, 0x24, 0x96, 0x2e, 0x97, 0x4a, 0x74, 0xad, 0x67, 0xbe, 0xe2, 0x49, 0x06, 0x99, 0x47,
	0xd8, 0xbd, 0xeb, 0x0c, 0x99, 0xd7, 0xdb, 0x31, 0x5f, 0x53, 0x3f, 0x2c, 0xa7, 0xcf, 0xf9, 0x1f,
	0x4b, 0xe6, 0x6b, 0x57, 0x98, 0x5a, 0x37, 0x73, 0x9e, 0xd4, 0xba, 0x0f, 0x21, 0x4f, 0xd8, 0x46,
	0x96, 0x50, 0xf3, 0xc4, 0x26, 0x2c, 0xb0, 0x5d, 0x03, 0xc7, 0xec, 0x12, 0x2b, 0x35, 0x73, 0xc2,
	0xfe, 0x53, 0xfe, 0x20, 0x03, 0x9b, 0xc2, 0x71, 0x0f, 0xb6, 0xb2, 0xe7, 0xfc, 0xbc, 0xcf, 0x51,
	0x8a, 0x3b, 0xcb, 0x00, 0xf1, 0x0f, 0x74, 0x37, 0xea, 0x8c, 0x6f, 0x47, 0xb2, 0x34, 0x23, 0x82,
	0x1a, 0xcd, 0x1c, 0xdf, 0x28, 0x59, 0x5d, 0xeb, 0x7c, 0x42, 0x28, 0x35, 0x48, 0xb8, 0x8f, 0x42,
	0xb2, 0x61, 0x1f, 0x3b, 0xa4, 0x78, 0x8c, 0x3e, 0x32, 0xc0, 0x94, 0x3e, 0x0a, 0x6a, 0x8a, 0xf4,
	0xf1, 0xdf, 0x4f, 0x07, 0xa9, 0x62, 0x6f, 0xb1, 0x93, 0xe7, 0x4a, 0x42, 0x8d, 0x29, 0xe8, 0xc4,
	0x59, 0x15, 0xf4, 0xbb, 0x51, 0x05, 0x1d, 0x43, 0xf1, 0x46, 0x6b, 0xef, 0xd4, 0xbb, 0xd0, 0xde,
	0xe9, 0x37, 0xd1, 0xde, 0x1f, 0xc4, 0xb5, 0x77, 0x66, 0x34, 0xb5, 0xa8, 0x6a, 0xdf, 0x0e, 0xd2,
	0x54, 0xf2, 0xfc, 0x8e, 0x46, 0x64, 0xfc, 0x63, 0x99, 0x2a, 0x22, 0x6b, 0x00, 0xe7, 0xb1, 0x06,
	0x7c, 0x9e, 0xe9, 0xec, 0x1b, 0xe4, 0x99, 0xce, 0xbd, 0xa5, 0xc3, 0x40, 0xf3, 0xe7, 0x3b, 0x0c,
	0x84, 0x3a, 0xb0, 0x47, 0x29, 0xa6, 0x8d, 0xf3, 0xc2, 0x48, 0xe2, 0x97, 0x09, 0x91, 0xaa, 0x6c,
	0xac, 0x3f, 0x81, 0x69, 0xab, 0xdf, 0x71, 0xb1, 0xfb, 0xba, 0x38, 0xd2, 0x7d, 0x9d, 0xc2, 0xa0,
	0xaa, 0x47, 0xec, 0x8b, 0x50, 0xa3, 0x43, 0xfb, 0xe2, 0x6f, 0x56, 0x8f, 0xb4, 0x2f, 0x0c, 0x30,
	0xc5, 0xbe, 0x08, 0x6a, 0x8a, 0xd8, 0x97, 0x5f, 0x67, 0x60, 0x37, 0xe8, 0x9c, 0xd5, 0x74, 0xde,
	0xaa, 0x95, 0x91, 0x2e, 0x70, 0xdc, 0x84, 0xe5, 0xc8, 0xa0, 0x44, 0xe6, 0x6c, 0xc4, 0x17, 0x49,
	0x97, 0x8c, 0x44, 0x79, 0x80, 0xca, 0xbf, 0xc8, 0xc0, 0x5e, 0x4a, 0x6f, 0x82, 0x98, 0x70, 0x2e,
	0x62, 0x44, 0x28, 0x87, 0x3f, 0x88, 0x6f, 0x3b, 0x47, 0x90, 0x79, 0x01, 0xd0, 0x23, 0xe8, 0xe1,
	0xae, 0x44, 0x96, 0xdf, 0x95, 0x90, 0x36, 0x23, 0xc2, 0xfe, 0x67, 0x70, 0x23, 0xb2, 0x49, 0x2e,
	0xad, 0xf3, 0x8d, 0xb7, 0xe3, 0x7f, 0x2f, 0x03, 0x37, 0xc7, 0xae, 0x8a, 0x31, 0xaa, 0x0e, 0xf3,
	0x7c, 0x4f, 0x7d, 0x0f, 0xf2, 0x0c, 0x9c, 0x8a, 0xe2, 0x2b, 0x3f, 0x86, 0x69, 0xb6, 0x62, 0x79,
	0xee, 0x70, 0x73, 0x2d, 0x5c, 0x09, 0xa5, 0x6b, 0x8b, 0xc1, 0x31, 0xfa, 0x7f, 0x36, 0x09, 0x8b,
	0xb1, 0x93, 0xc9, 0xa3, 0xb8, 0xb5, 0x86, 0x15, 0x38, 0x3c, 0xa9, 0x3e, 0xa3, 0xfb, 0x3f, 0x71,
	0x89, 0xd9, 0xed, 0x3a, 0x2f, 0xad, 0x0e, 0xdb, 0x0b, 0xf3, 0x7f, 0x22, 0xc4, 0x1d, 0x35, 0xcf,
	0xb3, 0xc3, 0xe4, 0x37, 0x00, 0xa8, 0xd9, 0x1c, 0x0e, 0xba, 0xfe, 0xc2, 0xef, 0x22, 0xbf, 0x61,
	0xaa, 0x57, 0x5c, 0x3d, 0x4f, 0x40, 0x5a, 0x83, 0xae, 0x8b, 0xbe, 0x02, 0xd4, 0xb1, 0x9e, 0x9a,
	0xc3, 0x2e, 0xb3, 0x97, 0x14, 0x6f, 0x4a, 0x8c, 0x57, 0x60, 0xa0, 0xe5, 0x00, 0x7d, 0x1f, 0x96,
	0x06, 0xa6, 0xdd, 0x31, 0xc8, 0x82, 0x9f, 0xaf, 0x3c, 0xd4, 0x4b, 0x5c, 0xc4, 0x05, 0x64, 0x8d,
	0x8e, 0x69, 0xce, 0x21, 0x14, 0x2c, 0xba, 0x2f, 0x65, 0x04, 0xe7, 0xca, 0x67, 0xf8, 0xd3, 0x79,
	0x8c, 0x65, 0x6c, 0xf3, 0x2a, 0xd8, 0x73, 0x5b, 0xb4, 0xa2, 0x1f, 0x70, 0xa5, 0x8c, 0x39, 0x86,
	0xe9, 0x19, 0x5d, 0x73, 0xd8, 0x6f, 0x3f, 0x63, 0x67, 0xa5, 0x16, 0x59, 0x81, 0xea, 0x55, 0xc8,
	0x67, 0x0c, 0xcb, 0xd8, 0xc5, 0xc1, 0x02, 0x85, 0x65, 0x05, 0x01, 0xec, 0x0d, 0x58, 0xa6, 0x46,
	0x9a, 0xdf, 0x6b, 0x77, 0xc9, 0xec, 0x93, 0xd3, 0x97, 0xc8, 0x3c, 0xcb, 0x87, 0x35, 0xe8, 0x47,
	0xf0, 0x81, 0xcf, 0xbb, 0xd8, 0xfe, 0xbc, 0xc0, 0x3f, 0x98, 0x23, 0x54, 0xae, 0x31, 0x84, 0xe8,
	0x14, 0x9a, 0x70, 0x0b, 0x9e, 0xc1, 0x1d, 0x09, 0xe5, 0xb4, 0x59, 0x64, 0x9e, 0x54, 0xf1, 0x91,
	0xa8, 0x0a, 0xd9, 0xc4, 0xa1, 0xfc, 0x66, 0x0a, 0x56, 0xc5, 0x7c, 0x47, 0x9f, 0xc2, 0x25, 0xf3,
	0x85, 0x35, 0xc0, 0x42, 0xc1, 0x16, 0x79, 0x71, 0x5d, 0xcf, 0x9c, 0x21, 0x5d, 0x3e, 0xcd, 0xe9,
	0x2b, 0xac, 0x98, 0x2e, 0xc4, 0x1e, 0x5b, 0x83, 0x23, 0x67, 0x38, 0x40, 0x15, 0xb8, 0x22, 0x41,
	0x33, 0xd8, 0x16, 0xdb, 0x13, 0x6b, 0xe0, 0xb2, 0xb0, 0x72, 0x47, 0x44, 0xa2, 0x11, 0x82, 0xa1,
	0x5b, 0xb0, 0x42, 0x0f, 0xb3, 0x9f, 0x5a, 0x03, 0xdb, 0xe9, 0x18, 0x3d, 0xbb, 0x3f, 0xf4, 0x2c,
	0x7f, 0x8f, 0x04, 0x91, 0xb2, 0x63, 0x52, 0x54, 0xa5, 0x25, 0x68, 0x0f, 0xe6, 0x18, 0x06, 0xdd,
	0x4d, 0xa1, 0xa6, 0x7c, 0xb6, 0x1d, 0x1e, 0x40, 0xc7, 0x71, 0x0d, 0xdb, 0x0d, 0x65, 0x30, 0x6c,
	0xd9, 0x9a, 0x7e, 0x64, 0x40, 0xdf, 0x87, 0xad, 0x53, 0xd3, 0x75, 0xed, 0x17, 0x96, 0xf1, 0xd2,
	0xf4, 0xda, 0xcf, 0xe2, 0x2d, 0x98, 0x22, 0x38, 0xeb, 0x0c, 0xe6, 0x11, 0x06, 0x89, 0x36, 0xe4,
	0x16, 0xac, 0xc4, 0x08, 0xd0, 0xca, 0xa8, 0x7a, 0xa0, 0x08, 0x22, 0xad, 0x72, 0x07, 0x66, 0x43,
	0x6d, 0xa2, 0xca, 0x91, 0xd3, 0x21, 0xd0, 0x23, 0x17, 0x7d, 0x02, 0x17, 0x43, 0x1e, 0x1a, 0x61,
	0x4e, 0x0c, 0x91, 0xfe, 0x8c, 0xbe, 0x12, 0x16, 0x86, 0xb9, 0x33, 0x78, 0x1c, 0x69, 0xfd, 0x44,
	0x4c, 0x9e, 0x13, 0x11, 0xa2, 0xff, 0x12, 0x45, 0xc8, 0xe9, 0x2b, 0xa4, 0x98, 0x08, 0xc4, 0xf3,
	0xaa, 0xf9, 0x8a, 0xfe, 0x83, 0xda, 0xb0, 0x1c, 0x41, 0x63, 0x8d, 0x9a, 0x25, 0x86, 0xf7, 0x93,
	0x34, 0x8d, 0xbd, 0xf1, 0x28, 0xa4, 0xc7, 0xb6, 0x30, 0xfa, 0xde, 0xe0, 0xb5, 0xbe, 0xf4, 0x32,
	0xfe, 0x9d, 0x0c, 0x16, 0xd9, 0x43, 0x66, 0xd4, 0xe7, 0xd8, 0x60, 0xe1, 0x6f, 0x0c, 0xe4, 0x1e,
	0xac, 0x25, 0x37, 0x77, 0x19, 0x38, 0x95, 0xf8, 0xd5, 0xf8, 0xd6, 0x2d, 0xc3, 0x8c, 0x25, 0x19,
	0x2d, 0x9c, 0x25, 0xc9, 0x68, 0xa3, 0x04, 0xab, 0xe2, 0x6e, 0xa0, 0x02, 0xe4, 0x9e, 0x5b, 0xaf,
	0x99, 0x0e, 0xe0, 0x7f, 0xd1, 0x0a, 0x4c, 0xbe, 0xc0, 0x5e, 0x9a, 0xbf, 0x56, 0x42, 0x7e, 0x7c,
	0x99, 0xbd, 0x97, 0x51, 0xfe, 0x79, 0x16, 0x26, 0xc9, 0xd5, 0x07, 0x68, 0x01, 0xb2, 0x81, 0xdd,
	0xcf, 0xda, 0xe7, 0x4f, 0x51, 0xde, 0x83, 0x39, 0xcf, 0xf1, 0xcc, 0x6e, 0x4c, 0xbc, 0xc9, 0x37,
	0xd6, 0xef, 0xeb, 0xb0, 0xf8, 0xc4, 0x74, 0xad, 0xae, 0xdd, 0xb7, 0xa2, 0x02, 0xbe, 0xe0, 0x7f,
	0x16, 0x33, 0x68, 0xea, 0x2c, 0x0c, 0x42, 0x5f, 0x00, 0x9c, 0x0c, 0xcc, 0xbe, 0x47, 0x17, 0x4d,
	0xa7, 0x47, 0x7a, 0x9d, 0x79, 0x06, 0xad, 0x7a, 0x78, 0x4a, 0x23, 0xea, 0xc8, 0x4e, 0xcd, 0xcd,
	0xe8, 0xfe, 0x4f, 0xe5, 0x00, 0x0a, 0xf1, 0x9b, 0x22, 0xd0, 0x8d, 0xc8, 0x32, 0xe1, 0x86, 0xf8,
	0x3e, 0x09, 0x6e, 0x69, 0xd0, 0x81, 0x65, 0x41, 0xe3, 0xd1, 0x2a, 0x4c, 0x3d, 0x35, 0xdb, 0x1e,
	0xdb, 0xfc, 0xc9, 0xe8, 0xec, 0x17, 0xfa, 0x41, 0xb0, 0xd5, 0x44, 0x6a, 0xc9, 0xf2, 0x67, 0x20,
	0x44, 0x4c, 0xa0, 0x1b, 0x55, 0x6c, 0xaf, 0x09, 0x57, 0xab, 0xfc, 0xad, 0x49, 0x58, 0x8c, 0x65,
	0x79, 0xbd, 0xcb, 0x6b, 0x21, 0xa2, 0x53, 0x7c, 0x6e, 0xe4, 0x14, 0xff, 0x81, 0x20, 0x24, 0xa3,
	0x2e, 0x43, 0x22, 0xe8, 0xe2, 0xbc, 0x90, 0xc9, 0xa8, 0x17, 0xc2, 0x0e, 0x5f, 0xd8, 0x9d, 0x8e,
	0xd5, 0x37, 0x9e, 0x3a, 0xd4, 0x96, 0x13, 0x1b, 0x48, 0x0f, 0x5f, 0x90, 0x82, 0xfb, 0x0e, 0xb1,
	0xdd, 0x41, 0x1a, 0xfd, 0x34, 0x97, 0x46, 0xbf, 0x0e, 0x33, 0x3d, 0xbb, 0x4f, 0x2f, 0x77, 0xa0,
	0x86, 0x6d, 0xba, 0x67, 0xf7, 0xc9, 0xf5, 0x0d, 0xf7, 0x60, 0xcd, 0x9f, 0xed, 0x84, 0x77, 0x30,
	0xe4, 0xf5, 0x55, 0x56, 0x1e, 0x0f, 0xae, 0xf6, 0x60, 0x2e, 0x9c, 0x27, 0x5d, 0x8f, 0xd9, 0xb3,
	0xd9, 0x60, 0x06, 0x74, 0x3d, 0x89, 0x83, 0x33, 0x3b, 0xae, 0x83, 0xd3, 0x80, 0x35, 0x3f, 0x06,
	0xc2, 0xbd, 0xb6, 0xfb, 0x1d, 0xbb, 0x6d, 0x7a, 0xce, 0x00, 0xcb, 0xfc, 0xdc, 0x48, 0x99, 0xbf,
	0xc8, 0x70, 0xef, 0x3b, 0x83, 0xb2, 0x8f, 0xa9, 0x7a, 0x38, 0x26, 0xa4, 0x6b, 0xf9, 0xdd, 0xd7,
	0x86, 0x94, 0xfa, 0xfc, 0x48, 0xea, 0x97, 0x7d, 0x22, 0x2d, 0x51, 0x2d, 0xca, 0xb7, 0x90, 0x0f,
	0x7a, 0x46, 0xf2, 0x9e, 0xfc, 0xee, 0x1b, 0xb7, 0x5f, 0x31, 0x89, 0x04, 0x5f, 0x4a, 0x6e, 0xbf,
	0x8a, 0x42, 0xdc, 0x79, 0xc5, 0xac, 0x52, 0x00, 0x71, 0x27, 0x06, 0x71, 0xf7, 0x15, 0xb3, 0x4d,
	0x01, 0xc4, 0xdd, 0x57, 0xca, 0x7f, 0x9e, 0x81, 0x39, 0x7e, 0x63, 0xee, 0x8d, 0x0e, 0xd8, 0xfd,
	0x7f, 0x91, 0xf3, 0xd8, 0xd9, 0xfd, 0xa9, 0xf8, 0xd9, 0x7d, 0x91, 0x68, 0x07, 0xab, 0xc8, 0x33,
	0xe2, 0x13, 0x22, 0xf9, 0xc8, 0x09, 0x11, 0xf9, 0x95, 0x02, 0x20, 0xbf, 0x52, 0x40, 0x7e, 0x1e,
	0x7a, 0xf6, 0x5c, 0xe7, 0xa1, 0x37, 0xf9, 0xe3, 0xbf, 0x73, 0xa4, 0xde, 0xf0, 0x88, 0x2f, 0xe5,
	0x81, 0xdd, 0x37, 0x5c, 0xcf, 0x69, 0x3f, 0x27, 0x82, 0x48, 0x78, 0x50, 0xee, 0x37, 0xf0, 0x07,
	0x89, 0x4a, 0x2d, 0x8c, 0xab, 0x52, 0xc7, 0x67, 0x39, 0x9d, 0x3b, 0xd6, 0xf5, 0x07, 0x3b, 0xd1,
	0xeb, 0x0f, 0x0a, 0x54, 0x2e, 0xb9, 0x0b, 0x0e, 0xd2, 0xb4, 0x78, 0xe9, 0xbc, 0x5a, 0x3c, 0xc6,
	0xb9, 0x5f, 0xf4, 0x6e, 0xcf, 0xfd, 0x2e, 0x9f, 0xf7, 0xdc, 0x2f, 0xfa, 0x1a, 0x96, 0x03, 0x6a,
	0x24, 0x81, 0xc5, 0x22, 0x6b, 0x47, 0x2b, 0x23, 0x79, 0xb1, 0xe4, 0xa3, 0x69, 0x14, 0x4b, 0xf5,
	0xd0, 0xcf, 0xe0, 0x0a, 0x3f, 0x90, 0x03, 0x72, 0x6e, 0xc9, 0xea, 0x18, 0xed, 0xe1, 0x60, 0x60,
	0xf5, 0x3d, 0x3f, 0x3a, 0xb9, 0x38, 0x7a, 0xf5, 0x71, 0x77, 0xc0, 0x67, 0xe6, 0x53, 0x32, 0x45,
	0x4a, 0x85, 0x85, 0x2b, 0xdf, 0xc0, 0xb2, 0x40, 0xc6, 0xb1, 0x99, 0xe1, 0x0e, 0xc2, 0x67, 0x7c,
	0x81, 0xf5, 0x0f, 0xbb, 0x5f, 0x85, 0x85, 0xa8, 0xf6, 0x30, 0x47, 0x6d, 0x8e, 0x57, 0x0d, 0xe5,
	0x5b, 0xd8, 0x90, 0x0f, 0xd1, 0xa8, 0x2a, 0xee, 0xc2, 0x25, 0x89, 0x30, 0xb0, 0xba, 0x96, 0x05,
	0x43, 0xac, 0xf4, 0xe1, 0xa2, 0x70, 0xd8, 0x46, 0xd5, 0xf6, 0x99, 0x48, 0x26, 0x68, 0x56, 0x12,
	0xad, 0x2d, 0x31, 0xec, 0x7e, 0x66, 0xd2, 0x42, 0xf4, 0x1c, 0xdf, 0x39, 0x0e, 0x76, 0x84, 0x5b,
	0x80, 0xd9, 0xc8, 0x16, 0xe0, 0x3f, 0xcc, 0x02, 0x84, 0x28, 0xc9, 0xf3, 0x26, 0x19, 0xc1, 0x81,
	0xae, 0xf3, 0x3a, 0xc1, 0xfb, 0xc1, 0x71, 0xd8, 0x09, 0xe9, 0x79, 0x67, 0xff, 0x2c, 0x6c, 0xf4,
	0xa8, 0xdd, 0x64, 0xec, 0xa8, 0x1d, 0x77, 0x14, 0x73, 0x6a, 0xac, 0xa3, 0x98, 0xdf, 0xa1, 0x07,
	0x45, 0x88, 0x84, 0x8f, 0xe5, 0xf7, 0x82, 0x0f, 0xae, 0x7a, 0xca, 0x8f, 0x60, 0x33, 0xe5, 0x28,
	0x1d, 0xfa, 0x22, 0xe2, 0xe9, 0x5e, 0x1b, 0x79, 0xf6, 0x8e, 0x73, 0x7a, 0x9b, 0xb0, 0x2e, 0x3d,
	0x7c, 0x84, 0x3e, 0x8f, 0xd0, 0xbd, 0x32, 0xe2, 0xac, 0x12, 0x47, 0xf5, 0x6f, 0x66, 0xa0, 0x10,
	0x3f, 0x3d, 0xc2, 0x31, 0x3f, 0x33, 0x92, 0xf9, 0x1f, 0xc2, 0x12, 0x7f, 0x48, 0xbe, 0x4d, 0xd6,
	0x87, 0xa8, 0x88, 0x16, 0xb8, 0x82, 0x22, 0x5b, 0x5a, 0x5d, 0xb4, 0x5d, 0x0a, 0x63, 0x98, 0x64,
	0xc1, 0x9c, 0xad, 0x78, 0xcd, 0xd9, 0x2e, 0x81, 0x50, 0xbd, 0xaa, 0xf9, 0x4a, 0xa9, 0xc2, 0x62,
	0x2c, 0xd3, 0x1e, 0x4f, 0x67, 0xfe, 0x69, 0x81, 0xe0, 0x30, 0x28, 0x3b, 0x0e, 0x40, 0x05, 0x80,
	0x16, 0x0e, 0x07, 0x5d, 0x7f, 0x19, 0x8f, 0x7e, 0x69, 0x0d, 0xba, 0xca, 0x2f, 0x33, 0x30, 0xc7,
	0x67, 0xc9, 0xa3, 0x3d, 0x98, 0x24, 0x79, 0xf2, 0xd1, 0x9b, 0xfb, 0x08, 0x88, 0x4e, 0x4b, 0xb0,
	0x70, 0xe3, 0x39, 0x9c, 0x9c, 0x4f, 0xe6, 0x32, 0xa4, 0xe7, 0x6c, 0xb7, 0x15, 0x7c, 0x43, 0x5f,
	0xc1, 0x7c, 0xcf, 0xe9, 0xd8, 0x4f, 0xf1, 0x84, 0x41, 0xd6, 0x2c, 0x73, 0xfc, 0xae, 0x37, 0xa1,
	0x57, 0xe5, 0xca, 0xf5, 0x28, 0xb4, 0xf2, 0x31, 0x4c, 0x12, 0x98, 0x44, 0xe4, 0x88, 0xdd, 0x0d,
	0xe7, 0xb9, 0xd5, 0x0f, 0x36, 0xad, 0xf1, 0x0f, 0xe5, 0x5f, 0x65, 0x61, 0x29, 0x41, 0x73, 0x9c,
	0xbe, 0x7c, 0x05, 0x88, 0x56, 0x8c, 0x75, 0xa4, 0x4d, 0xf6, 0x8a, 0x06, 0xcf, 0xd9, 0x0a, 0x72,
	0x72, 0x36, 0xf7, 0x41, 0xcb, 0x6d, 0xa7, 0x5f, 0x32, 0x07, 0xcf, 0xd1, 0xf7, 0x61, 0x39, 0x8a,
	0xde, 0xb5, 0x4f, 0x9e, 0x79, 0x32, 0x77, 0x6d, 0x89, 0xc7, 0xaf, 0x60, 0xc8, 0xd0, 0x7b, 0x9a,
	0xe0, 0xbd, 0xa7, 0xb1, 0x5c, 0xe4, 0xc9, 0x37, 0x75, 0x91, 0x55, 0xd8, 0x4a, 0x3b, 0x90, 0x3e,
	0x06, 0xfb, 0x94, 0x9f, 0xfa, 0xe9, 0x4c, 0xb2, 0xb4, 0x7f, 0xf4, 0xdd, 0x88, 0xf6, 0xbd, 0x3f,
	0xce, 0x51, 0x81, 0xc8, 0xa9, 0x91, 0x30, 0x9a, 0x0d, 0x73, 0x1d, 0x71, 0xe4, 0xc3, 0xaf, 0xce,
	0xb0, 0xd5, 0x88, 0x59, 0x6e, 0x85, 0x45, 0xf9, 0x6b, 0x19, 0x58, 0x97, 0x66, 0x33, 0xbf, 0xd1,
	0xbd, 0x0a, 0x77, 0x61, 0x95, 0x24, 0x1a, 0x71, 0x89, 0xd5, 0x1d, 0x1a, 0x80, 0x51, 0xd5, 0x5e,
	0xc1, 0xa5, 0x5c, 0x85, 0x1d, 0xdc, 0x02, 0xa5, 0x0b, 0xd7, 0xc6, 0x4a, 0xb1, 0x46, 0xc5, 0x08,
	0xc3, 0x6e, 0x9e, 0x21, 0x3b, 0x9b, 0xe3, 0x5b, 0x0d, 0xd6, 0x64, 0x89, 0xa2, 0x78, 0xda, 0x39,
	0x75, 0xba, 0x5c, 0x48, 0x32, 0x85, 0x7f, 0xd2, 0xab, 0x33, 0xad, 0x17, 0xd8, 0x67, 0x09, 0x26,
	0xa4, 0x69, 0xf2, 0xbb, 0xdc, 0x51, 0x8e, 0x60, 0x59, 0x90, 0xbb, 0x8c, 0x6e, 0x47, 0xda, 0x7a,
	0x59, 0x9a, 0xe4, 0xcc, 0xb5, 0xec, 0x07, 0xb0, 0x18, 0x4b, 0xee, 0x45, 0x1f, 0x47, 0xa8, 0xac,
	0x0b, 0x33, 0x80, 0xa3, 0x14, 0x62, 0x39, 0xab, 0x62, 0x0a, 0x31, 0x20, 0x8e, 0xc2, 0xdf, 0xc9,
	0xca, 0xcf, 0xb8, 0xfa, 0x89, 0x9f, 0x09, 0xc3, 0x33, 0x62, 0x3f, 0xe4, 0x5d, 0x1c, 0xf8, 0xdd,
	0x82, 0xfc, 0xe9, 0xc0, 0xc1, 0xfa, 0xc1, 0x42, 0xb5, 0x9c, 0x1e, 0x7e, 0xa0, 0x96, 0xd0, 0x33,
	0xbb, 0x6c, 0x2d, 0x96, 0xfe, 0x40, 0xdf, 0x85, 0xa9, 0x9e, 0xe5, 0x3d, 0x73, 0xe8, 0xd1, 0xfb,
	0xe0, 0x8c, 0x96, 0xac, 0xbb, 0x55, 0x02, 0xab, 0x33, 0x1c, 0xe5, 0x1f, 0x67, 0x60, 0x3b, 0x3d,
	0xb7, 0x14, 0x1d, 0xc1, 0x4c, 0xdb, 0xf4, 0xac, 0x13, 0x67, 0xf0, 0x9a, 0xf1, 0xfb, 0xa3, 0x71,
	0x72, 0x52, 0x8b, 0x0c, 0x47, 0x0f, 0xb0, 0xd1, 0x3d, 0xc8, 0xfb, 0x51, 0x8a, 0x7f, 0x90, 0x62,
	0x43, 0x4e, 0x4a, 0x0f, 0x81, 0x95, 0x3f, 0x9a, 0x84, 0x15, 0x11, 0xcc, 0xa8, 0x88, 0x3b, 0x16,
	0x2a, 0x65, 0x13, 0xa1, 0xd2, 0x3b, 0x8c, 0xba, 0x63, 0xb1, 0xf5, 0xa4, 0x2c, 0xb6, 0x9e, 0x12,
	0xc5, 0xd6, 0xd3, 0xe2, 0xd8, 0x7a, 0x66, 0xcc, 0xd8, 0x3a, 0x7f, 0x9e, 0xd8, 0x1a, 0xce, 0x15,
	0x5b, 0x8f, 0x1d, 0xdf, 0xce, 0x8e, 0x1b, 0xdf, 0x8e, 0x11, 0x69, 0xce, 0xbd, 0xdb, 0x48, 0x73,
	0xfe, 0xdc, 0x37, 0x4c, 0xfd, 0x8d, 0x0c, 0x5c, 0x92, 0x24, 0x9d, 0xa2, 0xbb, 0x74, 0xfb, 0x1b,
	0x1b, 0x5c, 0x6e, 0x12, 0x12, 0xa4, 0xeb, 0xce, 0xb6, 0xc3, 0x1f, 0xe8, 0x07, 0xb0, 0xc0, 0xa7,
	0xb9, 0x9a, 0x9e, 0xf4, 0x6e, 0xef, 0xd0, 0x0f, 0x98, 0x0b, 0x13, 0x91, 0x55, 0x4f, 0xf9, 0xd7,
	0x19, 0xd8, 0x4a, 0x4b, 0xb5, 0x3d, 0x67, 0xc3, 0xb0, 0xea, 0x31, 0x2c, 0xce, 0x3e, 0xd2, 0x2f,
	0xe5, 0x8e, 0xa0, 0xdd, 0xb9, 0x33, 0xb6, 0xfb, 0x7f, 0x4e, 0xc1, 0x7c, 0x64, 0x5b, 0xef, 0xdc,
	0xf9, 0x10, 0xef, 0x50, 0xcb, 0x6f, 0xc7, 0xee, 0xb6, 0x19, 0x23, 0x69, 0x28, 0x50, 0xf2, 0x29,
	0x5e, 0xc9, 0x77, 0xa3, 0x59, 0x5e, 0xd4, 0x00, 0xa4, 0x25, 0x5a, 0xce, 0x24, 0x12, 0x2d, 0x3f,
	0x06, 0xc4, 0xf6, 0x20, 0x83, 0x3d, 0x53, 0x66, 0x0b, 0x72, 0xfa, 0x12, 0x2d, 0x09, 0xb3, 0x23,
	0xc8, 0x39, 0x1f, 0xc1, 0xce, 0x2d, 0x5d, 0x54, 0x16, 0x24, 0x6f, 0xdd, 0x87, 0x5d, 0xac, 0x96,
	0x44, 0x25, 0x65, 0x7b, 0xb2, 0x74, 0xf3, 0x78, 0xab, 0x67, 0xbe, 0xc2, 0x2a, 0x37, 0x66, 0x9a,
	0xe5, 0x9c, 0x20, 0xcd, 0xf2, 0x0b, 0x00, 0xd7, 0x33, 0x07, 0x6c, 0xbb, 0x65, 0xf4, 0xe2, 0x70,
	0x9e, 0x41, 0xab, 0x1e, 0xfa, 0x14, 0x66, 0xac, 0x7e, 0x87, 0x22, 0x2e, 0x8c, 0x44, 0x9c, 0x26,
	0xb0, 0xaa, 0x87, 0x6b, 0xf4, 0x53, 0x28, 0xc7, 0x4a, 0x2b, 0xca, 0x33, 0x68, 0x8a, 0xea, 0x3b,
	0xed, 0xa6, 0xc7, 0x6e, 0xbf, 0x4b, 0x45, 0x65, 0xd0, 0xaa, 0x6c, 0xbd, 0x7e, 0x69, 0xdc, 0xc5,
	0xc5, 0xd8, 0xda, 0x25, 0x8a, 0xaf, 0x5d, 0x46, 0x92, 0x4c, 0x97, 0x47, 0x24, 0x99, 0x36, 0xe9,
	0x59, 0xab, 0x48, 0x72, 0xf2, 0xd8, 0xa9, 0xe0, 0xd2, 0x85, 0x92, 0x5f, 0x65, 0xe0, 0xca, 0x18,
	0x19, 0x2b, 0xe7, 0xce, 0x4b, 0xe1, 0x94, 0x3e, 0x17, 0x51, 0xfa, 0x4d, 0xc8, 0xb3, 0x59, 0x23,
	0xbc, 0x07, 0x87, 0x7e, 0x28, 0x77, 0xd0, 0x6d, 0x58, 0x61, 0x85, 0xd1, 0x44, 0x1b, 0xea, 0x74,
	0x2d, 0xbb, 0xac, 0xb1, 0x7c, 0x0e, 0x8d, 0x0e, 0x6b, 0xb2, 0xc4, 0x58, 0xf4, 0x59, 0xc4, 0x1f,
	0x55, 0xd2, 0xd3, 0x68, 0xa3, 0x37, 0xf6, 0xcb, 0x12, 0xc5, 0xc4, 0x34, 0x65, 0xd0, 0x51, 0x9a,
	0xb2, 0xe4, 0x56, 0x31, 0x4d, 0x19, 0x34, 0x47, 0xf3, 0xa7, 0xb0, 0x9d, 0x9e, 0x57, 0x25, 0x0e,
	0xfb, 0xd2, 0x71, 0x38, 0xfa, 0x7f, 0x92, 0x81, 0x15, 0xd1, 0xbd, 0x23, 0xe7, 0x96, 0x8a, 0x54,
	0xef, 0x3c, 0x55, 0x32, 0xb0, 0x55, 0xa4, 0x85, 0xfc, 0x0d, 0x29, 0xec, 0xf4, 0xa3, 0x1b, 0xbf,
	0x51, 0x45, 0xf9, 0x9a, 0xdc, 0x4f, 0x93, 0xbc, 0x20, 0xf0, 0x4e, 0x84, 0x1f, 0xdb, 0xf2, 0x1b,
	0xab, 0x23, 0x41, 0xdc, 0xaa, 0xf8, 0xca, 0x6e, 0x74, 0x37, 0x42, 0x6d, 0x37, 0xed, 0x7a, 0x6f,
	0x8e, 0xde, 0x7d, 0xf2, 0x3c, 0x4a, 0x7c, 0xd9, 0xed, 0x56, 0x84, 0xd6, 0x96, 0xec, 0xa6, 0x1a,
	0x8e, 0xce, 0xd7, 0xb0, 0x22, 0xba, 0xb9, 0x4c, 0xdc, 0x47, 0x11, 0x64, 0x48, 0x6b, 0xff, 0x8f,
	0x32, 0xb0, 0x18, 0x8b, 0xf0, 0x11, 0x82, 0x85, 0x56, 0xed, 0x41, 0xad, 0xfe, 0xa8, 0x66, 0xe8,
	0x9a, 0xda, 0xa8, 0xd7, 0x0a, 0x17, 0x50, 0x1e, 0x26, 0x1f, 0xa9, 0xcd, 0xe2, 0x51, 0x21, 0x83,
	0x0a, 0x30, 0x47, 0xfe, 0x35, 0x1a, 0x4d, 0x5d, 0x53, 0x1f, 0x14, 0xb2, 0x08, 0x60, 0xea, 0x7e,
	0xbd, 0x52, 0xa9, 0x3f, 0x2a, 0xe4, 0xd0, 0x3c, 0xe4, 0x1b, 0xad, 0x83, 0x46, 0x51, 0x2f, 0x1f,
	0x68, 0x85, 0x09, 0xfc, 0xf3, 0x58, 0x2f, 0x57, 0x35, 0xa3, 0xd1, 0x3a, 0x28, 0x4c, 0x62, 0x32,
	0xc5, 0x8a, 0x5a, 0xae, 0x16, 0xa6, 0x30, 0x92, 0xae, 0xdd, 0x6f, 0xd5, 0x4a, 0x85, 0x69, 0xf2,
	0xf9, 0x48, 0xd3, 0xf4, 0xc2, 0x0c, 0x9a, 0x81, 0x09, 0x5d, 0x2d, 0x97, 0x0a, 0x79, 0x34, 0x07,
	0x33, 0x8d, 0xd6, 0x81, 0x71, 0x58, 0xbe, 0xdf, 0x2c, 0xc0, 0xfe, 0x4f, 0x61, 0x5d, 0xba, 0x1f,
	0x8e, 0x2e, 0xc3, 0xba, 0xdf, 0xe2, 0x6a, 0xab, 0xd2, 0x2c, 0x1f, 0x57, 0xca, 0x9a, 0x1e, 0x36,
	0x1e, 0x60, 0x0a, 0x53, 0x6a, 0xde, 0x2e, 0x64, 0x82, 0xff, 0xef, 0xd0, 0x76, 0x93, 0xff, 0x3f,
	0x29, 0xe4, 0xf6, 0xff, 0x34, 0x03, 0xcb, 0x82, 0x95, 0x07, 0xb4, 0x05, 0x6b, 0x3e, 0x69, 0xb5,
	0xd5, 0xac, 0x57, 0xd5, 0x66, 0xb9, 0x68, 0xe8, 0xda, 0x23, 0x55, 0x2f, 0x15, 0x2e, 0x20, 0x05,
	0xb6, 0x1b, 0xe5, 0xda, 0x61, 0x45, 0x33, 0xaa, 0x5a, 0xa3, 0xa1, 0x1e, 0x6a, 0xc6, 0xc1, 0xe3,
	0x63, 0xb5, 0xd1, 0xc0, 0xdd, 0x35, 0xaa, 0xf5, 0x92, 0x56, 0xc8, 0x60, 0x0a, 0x0d, 0xad, 0x56,
	0x32, 0x8e, 0xca, 0x87, 0x47, 0x95, 0xf2, 0xe1, 0x51, 0x53, 0x2b, 0xf9, 0xd0, 0x85, 0x2c, 0xda,
	0x84, 0x4b, 0xba, 0x5a, 0x2b, 0xd5, 0xab, 0x04, 0x45, 0xab, 0xd6, 0x9b, 0x9a, 0xd1, 0xaa, 0x55,
	0xea, 0xc5, 0x07, 0x85, 0x1c, 0x2e, 0x2c, 0x1e, 0xd5, 0x1b, 0x5a, 0x2d, 0x59, 0x38, 0x81, 0xae,
	0xc2, 0x2e, 0x2b, 0xac, 0xd6, 0x4b, 0xe5, 0xfb, 0x65, 0xad, 0x94, 0x84, 0x9a, 0xdc, 0xb7, 0x61,
	0x45, 0x94, 0xad, 0x80, 0xd6, 0xe1, 0x22, 0x19, 0x09, 0xe3, 0xb8, 0x5e, 0xae, 0x35, 0x1b, 0x46,
	0xad, 0x6e, 0x68, 0xba, 0x5e, 0xd7, 0x0b, 0x17, 0xd0, 0x06, 0xac, 0xc6, 0x8a, 0x9a, 0xc6, 0xfd,
	0x3a, 0x1e, 0xa9, 0x4c, 0xa2, 0xec, 0x7e, 0x5d, 0x3f, 0x28, 0x97, 0x4a, 0x5a, 0xad, 0x90, 0xdd,
	0xff, 0x83, 0x49, 0x58, 0x97, 0xae, 0x14, 0xe3, 0xe1, 0xe4, 0xea, 0x58, 0x82, 0xf9, 0x6a, 0xe3,
	0xd0, 0x28, 0xb5, 0x8e, 0x2b, 0xe5, 0xa2, 0xda, 0xc4, 0x7c, 0xc2, 0x62, 0xd7, 0xd0, 0x74, 0xa3,
	0xd1, 0x6a, 0x1c, 0x6b, 0xb5, 0x92, 0x56, 0x2a, 0x64, 0xd1, 0x22, 0xcc, 0x92, 0x6f, 0x07, 0x6a,
	0xad, 0xa6, 0x95, 0x0a, 0xb9, 0x00, 0xa8, 0x59, 0xae, 0x6a, 0x25, 0xa3, 0xde, 0x6a, 0x16, 0x26,
	0xd0, 0x02, 0x00, 0xed, 0x74, 0xbd, 0x56, 0x79, 0x5c, 0x98, 0x24, 0x22, 0x58, 0xa9, 0x3f, 0xa2,
	0xfc, 0x9f, 0xc2, 0x28, 0x54, 0x3a, 0x35, 0xbd, 0x41, 0x41, 0xa6, 0xd1, 0x25, 0x58, 0x8e, 0x7e,
	0x33, 0xbe, 0xd1, 0xf4, 0x7a, 0x61, 0xc6, 0x17, 0x5f, 0x0a, 0x47, 0x64, 0x50, 0xff, 0xe2, 0x01,
	0xa5, 0x04, 0x98, 0x67, 0x07, 0x95, 0xf2, 0x37, 0xdf, 0xa8, 0x7a, 0xc9, 0x28, 0xd6, 0x6b, 0x35,
	0xad, 0xd8, 0xa4, 0x45, 0xb3, 0x68, 0x05, 0x0a, 0x0f, 0x35, 0x9d, 0x8e, 0x82, 0x5a, 0x2c, 0xd6,
	0x5b, 0xb5, 0x66, 0x61, 0x0e, 0x7f, 0x2d, 0x1e, 0xe1, 0xa6, 0x57, 0x8c, 0x86, 0xd6, 0x6c, 0x96,
	0x6b, 0x87, 0x8d, 0xc2, 0x3c, 0x56, 0x20, 0x22, 0x4a, 0xf5, 0x92, 0x71, 0xa4, 0x55, 0x4a, 0x85,
	0x05, 0x0c, 0xe7, 0xcb, 0x8f, 0xae, 0x7d, 0xad, 0x15, 0x9b, 0x5a, 0xa9, 0xb0, 0x88, 0x56, 0x01,
	0xf9, 0xa2, 0x57, 0xac, 0xb4, 0x34, 0xc6, 0xbb, 0x02, 0xda, 0x85, 0xad, 0x63, 0xb5, 0x78, 0x54,
	0xae, 0x3d, 0xa8, 0x1b, 0xe5, 0x5a, 0xa3, 0x75, 0xff, 0x7e, 0xb9, 0x58, 0xd6, 0x6a, 0x4d, 0x36,
	0x26, 0x85, 0x25, 0xf4, 0x31, 0x7c, 0x10, 0x40, 0x34, 0x75, 0xb5, 0xd6, 0x50, 0x8b, 0xcd, 0x72,
	0xbd, 0x66, 0x94, 0x4b, 0x86, 0x5a, 0xd1, 0x35, 0xb5, 0xf4, 0xd8, 0x28, 0xd6, 0xab, 0xd5, 0x72,
	0x13, 0x57, 0x84, 0xd0, 0x75, 0xb8, 0x22, 0x03, 0x2f, 0xd7, 0x8c, 0x63, 0xbd, 0x7e, 0xa8, 0x6b,
	0x8d, 0x46, 0x61, 0x13, 0xad, 0xc1, 0x0a, 0x15, 0x7d, 0xa3, 0x58, 0x6f, 0x34, 0x8d, 0x6a, 0xb9,
	0x51, 0x25, 0x46, 0xe1, 0x22, 0x5a, 0x86, 0x45, 0x56, 0x52, 0x2a, 0x37, 0xd4, 0x83, 0x8a, 0x56,
	0x2a, 0xac, 0xe3, 0x6e, 0xb1, 0x8f, 0xa1, 0x98, 0x6c, 0x60, 0x65, 0x65, 0x5f, 0xfd, 0x3e, 0x97,
	0x1b, 0xa4, 0x39, 0x6a, 0xad, 0x54, 0xd8, 0xc2, 0x92, 0x51, 0xae, 0x3d, 0x54, 0x2b, 0xe5, 0x12,
	0x15, 0xe5, 0xc2, 0x2a, 0x16, 0x3a, 0x3a, 0xc0, 0x7e, 0xe3, 0xb5, 0x5a, 0xb3, 0xdc, 0xc4, 0x75,
	0x5c, 0xc2, 0x23, 0x89, 0xc5, 0x0a, 0x17, 0x37, 0x0c, 0xf5, 0xa1, 0x5a, 0xae, 0xe0, 0xda, 0x0b,
	0x6b, 0xfb, 0xbf, 0x9e, 0x80, 0x9d, 0x11, 0xbb, 0x17, 0x44, 0x9a, 0x5b, 0x8d, 0x66, 0xbd, 0xca,
	0x34, 0x9a, 0xd7, 0x02, 0xac, 0x7b, 0xb1, 0xb2, 0x50, 0x0d, 0x12, 0x85, 0x9c, 0x1e, 0xa0, 0x6b,
	0xb0, 0x17, 0x2d, 0x14, 0x0d, 0x52, 0x2e, 0x09, 0x76, 0xac, 0xd7, 0x8f, 0x35, 0xbd, 0x59, 0xd6,
	0x1a, 0x21, 0x67, 0x27, 0xf0, 0xe0, 0x44, 0xc1, 0x02, 0x9d, 0xe1, 0xc7, 0xaa, 0x30, 0x99, 0xec,
	0x4c, 0x30, 0x12, 0x53, 0x68, 0x0f, 0x2e, 0x47, 0xcb, 0x88, 0xed, 0xae, 0x92, 0x3e, 0x55, 0xca,
	0x0f, 0xb5, 0xc2, 0x34, 0x96, 0xaa, 0x28, 0x48, 0x55, 0xfd, 0x91, 0x71, 0x8c, 0xf5, 0x91, 0x80,
	0x16, 0x66, 0xf0, 0xc0, 0x45, 0x21, 0x78, 0xd5, 0xcc, 0x63, 0x5b, 0x18, 0x2d, 0x4e, 0x88, 0x3e,
	0xa0, 0x0f, 0xe0, 0x5a, 0x14, 0x26, 0x22, 0x6e, 0x9c, 0xac, 0xcd, 0x62, 0x59, 0x8b, 0xb1, 0x47,
	0x6d, 0x35, 0xb4, 0x52, 0x61, 0x8e, 0x18, 0xbe, 0x68, 0x4b, 0x93, 0x72, 0x34, 0x9f, 0xac, 0xca,
	0xef, 0x0f, 0x69, 0x35, 0xd7, 0xb1, 0x85, 0x24, 0x77, 0x0e, 0x2b, 0xf5, 0x03, 0xb5, 0x62, 0x14,
	0xeb, 0xf5, 0x4a, 0xa9, 0xfe, 0xa8, 0x56, 0x58, 0xdc, 0xff, 0x37, 0x19, 0xb8, 0x9c, 0xba, 0x67,
	0x85, 0xae, 0xc0, 0x8e, 0x56, 0x2a, 0x37, 0x0d, 0x5d, 0x2b, 0x69, 0xd5, 0x63, 0xd2, 0xa1, 0x46,
	0x53, 0x6d, 0xb6, 0x22, 0xa6, 0xf5, 0x2a, 0xec, 0x4a, 0x81, 0x42, 0xe9, 0x92, 0x43, 0xf1, 0x62,
	0xf6, 0x1e, 0x28, 0x12, 0x28, 0x9e, 0x91, 0xb9, 0xfd, 0xbf, 0x1f, 0x9c, 0x79, 0x96, 0xbd, 0x57,
	0x85, 0x2b, 0x6c, 0x1d, 0x97, 0xb0, 0x48, 0xc5, 0xc7, 0x8c, 0x6f, 0xfc, 0x4d, 0xf8, 0x50, 0x0a,
	0xa5, 0x56, 0x35, 0xc3, 0x37, 0x6a, 0xf7, 0xd5, 0x32, 0x96, 0xba, 0x0c, 0x96, 0x70, 0x19, 0x02,
	0x3f, 0x6f, 0xfc, 0x97, 0x89, 0xe0, 0x34, 0x9d, 0xc8, 0x1b, 0x23, 0xc3, 0xa3, 0x6b, 0x84, 0x8c,
	0x4c, 0x59, 0xb1, 0xec, 0x89, 0x40, 0xc2, 0x6a, 0x32, 0xd8, 0x28, 0x0a, 0x61, 0x88, 0x29, 0x89,
	0x37, 0x3e, 0x8b, 0x6e, 0xc0, 0xbe, 0x10, 0xfc, 0x58, 0xaf, 0x57, 0x8f, 0x9b, 0x71, 0x78, 0xaa,
	0xce, 0x22, 0x78, 0x62, 0x29, 0x99, 0x45, 0x2b, 0x4c, 0x60, 0x26, 0x0a, 0xc1, 0xa2, 0xda, 0x16,
	0x20, 0x4c, 0x12, 0x39, 0x16, 0x36, 0xbb, 0x5e, 0x37, 0xaa, 0x6a, 0xed, 0x31, 0xfb, 0xdd, 0x28,
	0x4c, 0x61, 0x89, 0x48, 0xe9, 0xa1, 0x4f, 0x72, 0x5a, 0x4a, 0x32, 0xb4, 0x2c, 0xcc, 0xc1, 0x99,
	0x41, 0xb7, 0xe1, 0x63, 0x21, 0xe8, 0x81, 0x5a, 0x7c, 0x70, 0xa8, 0x63, 0x79, 0x35, 0x8a, 0xf5,
	0x4a, 0x5d, 0x0f, 0xa8, 0xe7, 0xe5, 0x0d, 0xd6, 0xaa, 0xc7, 0x15, 0xfc, 0xd9, 0x07, 0x05, 0x74,
	0x0f, 0xee, 0xa6, 0x32, 0x23, 0xa6, 0xaa, 0x01, 0xe6, 0x2c, 0xba, 0x05, 0x1f, 0x09, 0x31, 0x63,
	0x9a, 0x1b, 0x60, 0xcc, 0xed, 0xff, 0xf1, 0x44, 0x70, 0xde, 0x48, 0x26, 0x65, 0xbe, 0xb0, 0xa6,
	0x48, 0x99, 0x10, 0x84, 0x97, 0x32, 0x19, 0x4c, 0xa8, 0xdf, 0x59, 0x2c, 0x89, 0x42, 0x18, 0xa1,
	0x24, 0xe6, 0xb0, 0x24, 0x0a, 0xc1, 0xc5, 0x92, 0x38, 0xc1, 0xab, 0x9d, 0x5c, 0x12, 0x27, 0x79,
	0x75, 0x1e, 0x47, 0x12, 0x89, 0x78, 0xa5, 0x34, 0x3b, 0x14, 0xaf, 0xdb, 0xf0, 0xb1, 0x10, 0x4e,
	0x2a, 0x33, 0x33, 0x58, 0x66, 0x84, 0x28, 0x09, 0x89, 0xcc, 0x63, 0x99, 0x49, 0x6d, 0x76, 0xaa,
	0xcc, 0x08, 0x31, 0xe5, 0x32, 0xf3, 0xfb, 0x19, 0xd8, 0x4c, 0xb9, 0x45, 0x1e, 0xcb, 0x8c, 0xae,
	0x55, 0xeb, 0x0f, 0xd3, 0x65, 0x46, 0x08, 0x12, 0x93, 0x19, 0x09, 0x99, 0x40, 0x66, 0xf6, 0xff,
	0x77, 0x60, 0xc5, 0x65, 0xef, 0x61, 0x71, 0x56, 0x3c, 0x1e, 0xa9, 0xf0, 0x0d, 0x0a, 0xa5, 0x23,
	0x01, 0xc5, 0xb7, 0xe9, 0x7d, 0xb8, 0x2a, 0x03, 0x23, 0x72, 0x84, 0xcd, 0x0f, 0x8e, 0xf8, 0xb2,
	0x23, 0x21, 0x7d, 0x76, 0xe6, 0xd0, 0x5d, 0xb8, 0x25, 0x83, 0x94, 0xca, 0xc6, 0xc4, 0xfe, 0xaf,
	0xb2, 0xb0, 0x9d, 0x7e, 0xc5, 0x21, 0x67, 0x7b, 0xcb, 0x55, 0xec, 0x08, 0xb4, 0x8e, 0x2b, 0x75,
	0x15, 0xfb, 0x5d, 0xf7, 0xeb, 0x7c, 0xd7, 0x43, 0xfb, 0x98, 0x04, 0xe3, 0xfb, 0x1e, 0xda, 0xe8,
	0x24, 0x5c, 0xb5, 0xae, 0x6b, 0x46, 0xf3, 0x48, 0xad, 0x19, 0xf5, 0x9a, 0x66, 0x34, 0x1f, 0x1f,
	0xe3, 0x20, 0xee, 0x2e, 0xdc, 0x92, 0x22, 0xc8, 0x86, 0x34, 0x87, 0x3e, 0x87, 0x4f, 0xa4, 0x58,
	0x82, 0x11, 0xf4, 0x11, 0x27, 0xd0, 0xa7, 0x70, 0x5b, 0x5e, 0x5d, 0xbd, 0x5a, 0x6d, 0xd5, 0xca,
	0xcd, 0xc7, 0xc6, 0x61, 0x5d, 0xad, 0x70, 0x68, 0x93, 0xfb, 0x77, 0xe8, 0x4b, 0x69, 0xa2, 0xab,
	0xe1, 0x71, 0x28, 0x5c, 0xaf, 0x94, 0xb4, 0x46, 0x93, 0x86, 0xcb, 0x35, 0xed, 0x11, 0xfe, 0x3f,
	0xb3, 0xff, 0x5b, 0x50, 0x88, 0xbb, 0x3c, 0x38, 0x46, 0xaa, 0xd5, 0x99, 0xaf, 0x51, 0xb8, 0x40,
	0x62, 0xb4, 0xda, 0xfd, 0x56, 0xe5, 0x7e, 0xb9, 0x42, 0xa7, 0xfd, 0x79, 0xc8, 0x87, 0x3f, 0xb3,
	0x38, 0x86, 0x2a, 0xaa, 0xb5, 0xa2, 0x46, 0x8d, 0x19, 0x8e, 0xa8, 0xb4, 0xe3, 0xba, 0x8e, 0x23,
	0x8f, 0x89, 0xfd, 0x43, 0x50, 0x46, 0xe7, 0x22, 0x70, 0xa6, 0x59, 0x53, 0xf5, 0xca, 0x63, 0x1c,
	0x60, 0x69, 0x0d, 0xde, 0x87, 0xb8, 0xb0, 0xff, 0x1f, 0x33, 0xf0, 0xc1, 0xd8, 0x9b, 0xf4, 0x9c,
	0x25, 0x68, 0x54, 0x55, 0xbd, 0x49, 0xe4, 0xb4, 0x61, 0xa8, 0x45, 0x1c, 0x6c, 0x55, 0xb4, 0xd2,
	0xa1, 0x56, 0xd5, 0x62, 0x31, 0x71, 0x68, 0xd3, 0x52, 0x31, 0x78, 0x29, 0xba, 0x0f, 0x07, 0xe3,
	0xa0, 0x54, 0xd4, 0x46, 0x93, 0xff, 0x1a, 0xd3, 0x9a, 0xec, 0xfe, 0x5f, 0xcc, 0xc0, 0x8a, 0x28,
	0x99, 0x80, 0x2c, 0x3e, 0xb4, 0x0e, 0x9a, 0xba, 0x5a, 0xf4, 0xa3, 0x0a, 0x23, 0xb1, 0x6e, 0xb3,
	0x0b, 0x5b, 0x71, 0x98, 0x87, 0x75, 0x32, 0x07, 0x1b, 0xc7, 0xf5, 0x4a, 0xa5, 0x90, 0xc1, 0x7e,
	0x6b, 0x1c, 0xa2, 0xaa, 0x3e, 0xd0, 0x8c, 0x63, 0x5d, 0x2b, 0x95, 0x69, 0x6c, 0x91, 0xdd, 0xff,
	0x6d, 0xb8, 0x24, 0x49, 0x2b, 0x20, 0xcb, 0x1b, 0x31, 0x7c, 0x8e, 0x6f, 0xd7, 0xe1, 0x4a, 0xbc,
	0x54, 0x14, 0x0d, 0x65, 0xf6, 0xff, 0x02, 0x2c, 0x0b, 0x52, 0x0e, 0x70, 0x14, 0x70, 0x54, 0xaf,
	0x94, 0x04, 0x94, 0xaf, 0xc0, 0x0e, 0x5f, 0x22, 0xa4, 0x8a, 0xab, 0xe7, 0x81, 0x64, 0xd1, 0x46,
	0x76, 0xdf, 0x81, 0x65, 0x41, 0xbe, 0x02, 0x09, 0x42, 0x48, 0xa0, 0x6c, 0x10, 0x32, 0x5c, 0xf5,
	0xeb, 0x70, 0x31, 0x5a, 0x12, 0xba, 0xef, 0x57, 0x60, 0x87, 0x2f, 0x3a, 0x56, 0x75, 0xb5, 0xda,
	0x30, 0x4a, 0x75, 0x02, 0x44, 0xc3, 0xba, 0xec, 0xfe, 0xff, 0xc8, 0xc0, 0x76, 0x7a, 0x52, 0x00,
	0x9e, 0xf7, 0x0f, 0x5a, 0x95, 0x07, 0x86, 0xc4, 0xcb, 0xaf, 0x6a, 0xcd, 0xa3, 0x7a, 0xc9, 0x1f,
	0x72, 0x2a, 0xa3, 0x63, 0xc0, 0x1f, 0x3c, 0xf6, 0xbd, 0xf1, 0x42, 0x06, 0x2b, 0xc2, 0x78, 0x28,
	0x6c, 0xfa, 0xcd, 0x62, 0xdb, 0x33, 0x2e, 0x86, 0x5f, 0x86, 0x83, 0x90, 0xdf, 0xcd, 0xc2, 0x7b,
	0xe3, 0x25, 0x28, 0xa0, 0xcf, 0xe0, 0x8e, 0xc4, 0x71, 0x2c, 0xd6, 0x2b, 0x15, 0x8d, 0x8e, 0x1e,
	0xf6, 0x09, 0x0e, 0xeb, 0xfa, 0x63, 0xae, 0xfb, 0x9f, 0xc0, 0xcd, 0x33, 0xe0, 0x1d, 0xaa, 0x55,
	0xad, 0x90, 0x41, 0x77, 0xe0, 0xc6, 0x19, 0x90, 0xca, 0x7a, 0x85, 0xb2, 0xe0, 0x0c, 0x38, 0xcd,
	0x47, 0x65, 0x3c, 0xe2, 0xb9, 0xfd, 0x9f, 0xc1, 0x2c, 0xb7, 0x79, 0x4b, 0x45, 0xab, 0xd6, 0xc4,
	0xe2, 0x8a, 0x67, 0x11, 0xae, 0x23, 0x38, 0xde, 0xe1, 0x4b, 0x12, 0xeb, 0x8e, 0x19, 0xb4, 0x0d,
	0x1b, 0x11, 0x90, 0x48, 0x7b, 0x0a, 0xd9, 0xfd, 0xa1, 0x7f, 0x4b, 0xad, 0xfc, 0x2a, 0x23, 0xac,
	0x1b, 0xcc, 0x3e, 0x11, 0x13, 0xf4, 0xb0, 0xac, 0x3d, 0x22, 0xc6, 0x87, 0x92, 0xe5, 0x44, 0x3d,
	0x9c, 0xe0, 0x45, 0x80, 0x9c, 0xc9, 0xdb, 0xff, 0xef, 0x19, 0xaa, 0x46, 0xb1, 0xad, 0x56, 0xda,
	0xa3, 0xc8, 0xbc, 0xc4, 0xc4, 0x25, 0xec, 0x34, 0x53, 0x1a, 0x11, 0x48, 0xa3, 0xa9, 0x92, 0xe9,
	0x22, 0x23, 0xa7, 0xe3, 0x83, 0x64, 0xd1, 0x0e, 0x6c, 0x8a, 0x41, 0xe8, 0x92, 0x62, 0x4e, 0x5e,
	0x51, 0x38, 0x67, 0x4d, 0x90, 0x78, 0x52, 0x08, 0xa4, 0xea, 0xc5, 0xa3, 0xf2, 0x43, 0x0d, 0x4f,
	0xa7, 0xbf, 0x3f, 0xe1, 0x5f, 0x04, 0x2e, 0xde, 0x4b, 0xe1, 0x83, 0xd2, 0xf8, 0xa4, 0xcc, 0x5b,
	0x31, 0x31, 0x0c, 0x3f, 0x93, 0x70, 0xa1, 0x68, 0x14, 0x48, 0x12, 0xba, 0x5e, 0x87, 0x2b, 0x69,
	0xf0, 0x11, 0x87, 0x4c, 0x0c, 0x58, 0xd2, 0x1a, 0x45, 0xbd, 0x4c, 0x35, 0x3b, 0x11, 0x5f, 0x70,
	0x81, 0xb4, 0x1c, 0x2b, 0x8c, 0x33, 0xa4, 0xe0, 0xe4, 0x8f, 0x5a, 0xad, 0xb7, 0x6a, 0x4d, 0x2e,
	0xca, 0xd8, 0x87, 0xf7, 0x24, 0xd4, 0x5b, 0xba, 0x1a, 0x21, 0x3d, 0x4d, 0xb4, 0x57, 0x08, 0x9b,
	0x12, 0x6a, 0xbc, 0x0f, 0x57, 0x25, 0xcc, 0xf1, 0x03, 0x6a, 0xfc, 0xab, 0x51, 0xc8, 0xcb, 0x21,
	0xc3, 0xa8, 0x04, 0xff, 0x2c, 0xc0, 0xfe, 0x6f, 0x82, 0x77, 0x9a, 0xe5, 0xa2, 0xe0, 0x87, 0x1e,
	0x69, 0xa2, 0x20, 0x86, 0x89, 0x89, 0x82, 0x18, 0x48, 0x2e, 0x0a, 0x69, 0xf0, 0x22, 0xdf, 0xfc,
	0x8c, 0xa2, 0x30, 0x1a, 0x2b, 0x22, 0x0a, 0x62, 0x70, 0xa9, 0x28, 0x48, 0xa8, 0x0b, 0x45, 0x41,
	0x0c, 0x9b, 0x22, 0x0a, 0x5c, 0x40, 0x2b, 0x68, 0x8e, 0x6f, 0x53, 0xf2, 0x7c, 0xa4, 0x1c, 0x85,
	0xf3, 0x17, 0xaa, 0x99, 0x71, 0xc0, 0xf3, 0xea, 0xa1, 0x56, 0x00, 0xf9, 0x50, 0x86, 0x6e, 0xc2,
	0x2c, 0x67, 0x56, 0xd3, 0xc5, 0x6b, 0x6e, 0xff, 0x17, 0x19, 0xd8, 0x4a, 0xdb, 0x15, 0xc6, 0xe2,
	0x55, 0xd2, 0x2a, 0xda, 0x28, 0xf1, 0x12, 0xc3, 0xf0, 0xe2, 0x25, 0x05, 0xe2, 0x43, 0xd1, 0xff,
	0x9a, 0x03, 0x65, 0xf4, 0x56, 0x32, 0x59, 0x07, 0xaa, 0xd7, 0x9a, 0x7a, 0xf9, 0xa0, 0xd5, 0xd4,
	0x8c, 0x66, 0x3d, 0xa5, 0x6d, 0x5f, 0xc0, 0xa7, 0x23, 0x40, 0x9b, 0x46, 0xb1, 0xa5, 0xeb, 0x5a,
	0xad, 0x59, 0xa1, 0x9e, 0x85, 0x56, 0x25, 0xcb, 0xfc, 0x74, 0x02, 0x1f, 0x85, 0xaa, 0xd5, 0xea,
	0xad, 0xc3, 0x23, 0xdf, 0x2b, 0xcc, 0x12, 0x13, 0x33, 0x0a, 0xc7, 0x0f, 0xd2, 0x46, 0xc1, 0x86,
	0xdc, 0xa3, 0x6b, 0x7b, 0x69, 0xb0, 0xb1, 0x15, 0xf5, 0x49, 0xb2, 0xfe, 0x95, 0x86, 0x20, 0xf3,
	0x57, 0xa7, 0x88, 0x93, 0x94, 0x86, 0x29, 0xde, 0x24, 0x98, 0x46, 0x1f, 0xc1, 0xfb, 0xa9, 0x78,
	0xfc, 0x92, 0xfe, 0xcc, 0xfe, 0x9f, 0xa7, 0x97, 0x12, 0x0a, 0xd7, 0x3e, 0xb6, 0x61, 0xe3, 0x50,
	0x6b, 0xca, 0x17, 0x3e, 0x76, 0x60, 0x33, 0x59, 0xce, 0xcb, 0x9a, 0x10, 0x80, 0x97, 0x33, 0x93,
	0xdd, 0x48, 0x28, 0xdc, 0x53, 0xc7, 0x91, 0x4d, 0xa5, 0xdc, 0x88, 0xe1, 0x47, 0x22, 0x84, 0x3d,
	0xb8, 0x2c, 0x82, 0xe0, 0x1d, 0x96, 0x6f, 0xc9, 0xa3, 0xdb, 0xa2, 0xad, 0xa1, 0x4d, 0xb8, 0x84,
	0x5b, 0xc7, 0x79, 0xb8, 0x1c, 0xe5, 0x2d, 0x58, 0x8b, 0x15, 0xf2, 0x1d, 0x4b, 0x96, 0xf2, 0xbd,
	0xfa, 0xdd, 0x4c, 0x22, 0x0c, 0x0f, 0x6b, 0xbd, 0x0c, 0xeb, 0xa4, 0xc9, 0x9c, 0xf3, 0xcc, 0xd7,
	0xbb, 0x0d, 0x1b, 0x89, 0x62, 0xbe, 0xe6, 0x6b, 0xb0, 0x97, 0x28, 0x17, 0x30, 0xb6, 0x0a, 0x33,
	0x7e, 0xbe, 0x11, 0xba, 0x08, 0x4b, 0x54, 0xd4, 0xa2, 0x3e, 0x68, 0xe4, 0x33, 0x99, 0x05, 0xeb,
	0x7a, 0x21, 0x83, 0x96, 0x61, 0x31, 0xfc, 0x7c, 0x50, 0xaf, 0x37, 0x9a, 0x85, 0xec, 0x9d, 0xff,
	0xb6, 0x07, 0x13, 0x45, 0xe7, 0xd4, 0x41, 0x2a, 0xc0, 0xa1, 0xe5, 0x05, 0x37, 0xdb, 0x04, 0xa9,
	0x0c, 0xfe, 0xed, 0xdc, 0x34, 0xab, 0x74, 0x63, 0x2d, 0x59, 0x40, 0x2f, 0xda, 0x51, 0x2e, 0xa0,
	0xc7, 0x24, 0x47, 0x22, 0x7e, 0x7d, 0xcd, 0x4e, 0x98, 0xaf, 0x11, 0x2d, 0xf1, 0x49, 0xee, 0xca,
	0x01, 0x02, 0xd2, 0x4f, 0xe0, 0xa2, 0x70, 0x1b, 0x04, 0x45, 0x73, 0x79, 0xc4, 0x15, 0x5c, 0x49,
	0x85, 0x09, 0xea, 0x78, 0x08, 0x4b, 0x87, 0x56, 0x78, 0x79, 0x3f, 0xbd, 0x7c, 0x21, 0xcc, 0x36,
	0x89, 0x16, 0xf8, 0xb4, 0x77, 0xa4, 0xe5, 0x01, 0xdd, 0x12, 0xcc, 0x72, 0xbb, 0xf8, 0x68, 0x2d,
	0x71, 0x0d, 0x81, 0x4f, 0x6b, 0x5d, 0x50, 0x12, 0x50, 0xf9, 0x09, 0x2c, 0xe3, 0x4a, 0xa2, 0xeb,
	0x87, 0x2e, 0x0a, 0x99, 0x17, 0x2f, 0xf2, 0xa9, 0xee, 0xa5, 0x40, 0x24, 0xf9, 0x1b, 0xbf, 0x8d,
	0x40, 0x49, 0x79, 0xcd, 0x5f, 0xc8, 0x5f, 0xc9, 0x3b, 0x94, 0x94, 0xbf, 0x09, 0x93, 0x80, 0xb6,
	0x25, 0xf9, 0x37, 0x31, 0xfe, 0x4a, 0x5f, 0xfa, 0x57, 0x2e, 0xa0, 0x63, 0x58, 0x8c, 0x19, 0x3a,
	0xb4, 0x25, 0xcc, 0x11, 0xf2, 0x69, 0x5e, 0x96, 0x94, 0xf2, 0x82, 0x9c, 0xdc, 0xd3, 0xf2, 0x05,
	0x59, 0xfa, 0x14, 0xfe, 0xc6, 0xae, 0x1c, 0x80, 0x27, 0x9d, 0xdc, 0xc8, 0xf0, 0x49, 0x4b, 0x1f,
	0xeb, 0xf6, 0x49, 0xcb, 0x1f, 0xdc, 0xa5, 0xa4, 0x93, 0xeb, 0xdd, 0x68, 0x47, 0xf6, 0x9e, 0x6a,
	0x8c, 0xb4, 0xfc, 0xad, 0x58, 0x2a, 0x1e, 0xc2, 0x57, 0x46, 0x7d, 0xf1, 0x48, 0x7b, 0x87, 0xd5,
	0x17, 0x8f, 0xd4, 0x67, 0x4a, 0xe9, 0x30, 0xc6, 0x4c, 0xab, 0x3f, 0x8c, 0xe2, 0xd7, 0x38, 0xfd,
	0x61, 0x94, 0x3c, 0x49, 0xe9, 0x33, 0x24, 0xfe, 0x14, 0x62, 0xc8, 0x10, 0xc9, 0xfb, 0x90, 0x21,
	0x43, 0x64, 0xaf, 0x28, 0x2a, 0x17, 0x90, 0x01, 0x2b, 0xa2, 0xc5, 0x1f, 0xb4, 0x27, 0x3f, 0x21,
	0xe9, 0x93, 0x57, 0xd2, 0x40, 0x82, 0x0a, 0x9e, 0xc3, 0x9a, 0x6c, 0x85, 0x09, 0x5d, 0x4b, 0x3f,
	0x96, 0xe2, 0x57, 0xf4, 0xde, 0x28, 0xb0, 0xa0, 0xb2, 0xaf, 0x61, 0x3e, 0x32, 0x93, 0xa2, 0x0d,
	0x41, 0x26, 0x9b, 0x4f, 0x76, 0x53, 0x58, 0x16, 0xd0, 0x6a, 0x40, 0x21, 0xfe, 0xd0, 0x18, 0xba,
	0xcc, 0xa1, 0x24, 0x1f, 0x3a, 0xdb, 0xd8, 0x96, 0x15, 0xf3, 0xec, 0x16, 0x3d, 0x0a, 0x86, 0x38,
	0xdb, 0x26, 0x79, 0x87, 0xcc, 0x67, 0x77, 0xda, 0x9b, 0x62, 0x54, 0xc0, 0x85, 0xdb, 0x14, 0x48,
	0x49, 0x79, 0xa6, 0x29, 0x26, 0xe0, 0xa9, 0xcf, 0x63, 0x05, 0x9c, 0x89, 0xbc, 0xc5, 0xc4, 0x71,
	0x46, 0xf4, 0xba, 0x13, 0xc7, 0x19, 0xe1, 0x13, 0x4e, 0xca, 0x05, 0x64, 0x11, 0x27, 0x48, 0xb0,
	0x02, 0x8f, 0xae, 0x84, 0xb8, 0xd2, 0xd7, 0x8e, 0x36, 0xae, 0xa6, 0x03, 0x05, 0xd5, 0xf4, 0x61,
	0x5d, 0xba, 0xd6, 0x8f, 0xde, 0x1b, 0x71, 0x30, 0xd1, 0xaf, 0xec, 0xfa, 0x48, 0xb8, 0x98, 0x2b,
	0x11, 0x7b, 0x93, 0x88, 0x73, 0x25, 0xc4, 0x6f, 0x20, 0x71, 0xae, 0x84, 0xe4, 0x39, 0x23, 0xe5,
	0x02, 0xfa, 0x1d, 0xf2, 0x76, 0x95, 0x7c, 0xa7, 0x01, 0xed, 0x07, 0x44, 0x46, 0xbe, 0x7a, 0xb3,
	0xf1, 0xe1, 0x58, 0xb0, 0x41, 0xdd, 0x7f, 0x29, 0xe3, 0xaf, 0xed, 0xa5, 0xd4, 0xff, 0xf1, 0x78,
	0xc7, 0x16, 0xfd, 0x26, 0xdc, 0x18, 0x17, 0x3c, 0x68, 0x45, 0x15, 0x16, 0xa2, 0x1b, 0x02, 0x68,
	0x53, 0xfc, 0x3e, 0x06, 0xad, 0x60, 0x4b, 0x5c, 0x18, 0x90, 0x53, 0x01, 0xc2, 0xd5, 0x7f, 0xdf,
	0x73, 0x4c, 0x3c, 0xc7, 0xe2, 0x7b, 0x8e, 0xc9, 0xf7, 0x4d, 0x28, 0x89, 0x70, 0x05, 0x1f, 0x5d,
	0x8a, 0x9f, 0x41, 0x8c, 0x91, 0x48, 0x3e, 0xcf, 0xa1, 0x5c, 0x40, 0xbf, 0xc8, 0x90, 0xc7, 0x14,
	0x46, 0x1e, 0x4d, 0xbc, 0x15, 0x3a, 0xb0, 0xe3, 0xbd, 0xcf, 0xb1, 0x71, 0xfb, 0x0c, 0x18, 0x41,
	0x73, 0xfe, 0x6a, 0x86, 0xbe, 0x1c, 0x91, 0xfe, 0x5e, 0x05, 0xba, 0x29, 0x74, 0x45, 0xe4, 0xaf,
	0x64, 0x6c, 0xdc, 0x1a, 0x1f, 0x21, 0x68, 0x8b, 0x47, 0x5e, 0x6a, 0x94, 0x3d, 0x33, 0x81, 0xde,
	0x8f, 0xfb, 0xdf, 0xb2, 0xe7, 0x15, 0x36, 0x3e, 0x18, 0x03, 0x32, 0xa8, 0xf5, 0x5b, 0xf2, 0xac,
	0x98, 0xe4, 0xa1, 0x08, 0x74, 0x3d, 0x20, 0x95, 0xfe, 0x10, 0xc5, 0xc6, 0xfb, 0xa3, 0x01, 0x83,
	0x2a, 0x9f, 0xc1, 0x25, 0xc9, 0xca, 0x39, 0xba, 0x9a, 0xfa, 0x46, 0x80, 0x5f, 0xd9, 0xb5, 0x11,
	0x50, 0x31, 0x5b, 0x1e, 0x3b, 0x51, 0x15, 0x72, 0x47, 0x70, 0x01, 0x2d, 0x67, 0xcb, 0x85, 0x37,
	0xba, 0x52, 0xa3, 0x97, 0xbc, 0xc5, 0x1f, 0xf1, 0x1e, 0xb0, 0xe8, 0x3a, 0xfe, 0x8d, 0x5d, 0x39,
	0x00, 0x3f, 0x18, 0xf2, 0x5b, 0xf6, 0xfd, 0xc1, 0x18, 0x79, 0xf3, 0xbf, 0x3f, 0x18, 0xa3, 0x2f,
	0xec, 0xa7, 0x01, 0x8b, 0x60, 0x85, 0x1d, 0xed, 0x4a, 0x0f, 0x74, 0xc4, 0x02, 0x96, 0x94, 0x3b,
	0xda, 0x29, 0x75, 0xc1, 0xaa, 0x9a, 0x4f, 0x5d, 0x7e, 0xa5, 0xba, 0x4f, 0x3d, 0xe5, 0x76, 0x74,
	0x4a, 0x5d, 0xb0, 0x24, 0x8c, 0x76, 0xa5, 0x07, 0x47, 0x62, 0xd4, 0x53, 0xee, 0x46, 0xa6, 0x93,
	0xa9, 0x74, 0x09, 0xce, 0x9f, 0x4c, 0x47, 0xdd, 0x67, 0xec, 0x4f, 0xa6, 0x23, 0x6f, 0x0a, 0x56,
	0x2e, 0xa0, 0xbf, 0x9b, 0x81, 0xeb, 0x63, 0x5e, 0x9b, 0x8b, 0xee, 0x06, 0x52, 0x7a, 0x86, 0x0b,
	0x7d, 0x37, 0x3e, 0x3d, 0x23, 0x16, 0xef, 0xe6, 0xca, 0x1e, 0xd8, 0xf5, 0xdd, 0xdc, 0x11, 0x6f,
	0xfb, 0xfa, 0x6e, 0xee, 0xa8, 0x77, 0x7a, 0x95, 0x0b, 0x07, 0xd7, 0xbe, 0xb9, 0xd2, 0x76, 0x3a,
	0xd6, 0x8d, 0x9f, 0x0d, 0x5d, 0xcf, 0xee, 0xdf, 0xf0, 0x5e, 0xdc, 0x6c, 0x3f, 0x33, 0xbd, 0x9b,
	0x18, 0xfd, 0x26, 0x39, 0x5a, 0x46, 0xfe, 0x7d, 0x32, 0x45, 0xfe, 0xff, 0xe4, 0xff, 0x06, 0x00,
	0x00, 0xff, 0xff, 0xe7, 0x69, 0x26, 0xdb, 0xb2, 0x97, 0x00, 0x00,
}
