// Code generated by protoc-gen-twirp v5.5.2, DO NOT EDIT.
// source: copothirdparty.proto

/*
Package copothirdparty is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.2.

It is generated from these files:
	copothirdparty.proto
*/
package copothirdparty

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ========================
// CopoThirdParty Interface
// ========================

// CopoThirdParty provides APIs for managing a user or channel's Community Points on behalf of a third party developer.
type CopoThirdParty interface {
	// CreateCustomReward3p creates a new custom reward for a channel
	// SLO@600ms
	CreateCustomReward3P(context.Context, *CreateCustomReward3PRequest) (*CreateCustomReward3PResponse, error)

	// ListCustomRewards3p returns the custom rewards on a channel
	// SLO@500ms
	ListCustomRewards3P(context.Context, *ListCustomRewards3PRequest) (*ListCustomRewards3PResponse, error)

	// UpdateCustomReward3p updates a custom reward for a channel
	// SLO@600ms
	UpdateCustomReward3P(context.Context, *UpdateCustomReward3PRequest) (*UpdateCustomReward3PResponse, error)

	// RemoveCustomReward3p removes a custom reward for a channel
	// SLO@500ms
	RemoveCustomReward3P(context.Context, *RemoveCustomReward3PRequest) (*RemoveCustomReward3PResponse, error)

	// ListRedemptions3p returns a paginated list of custom reward redemptions.
	// SLO@500ms
	ListRedemptions3P(context.Context, *ListRedemptions3PRequest) (*ListRedemptions3PResponse, error)

	// GetRedemption3p gets a single redemption
	// SLO@500ms
	GetRedemption3P(context.Context, *GetRedemption3PRequest) (*GetRedemption3PResponse, error)

	// BulkEditRedemptionStatus3p changes the status multiple redemptions for a single reward.
	// SLO@500ms
	BulkEditRedemptionStatus3P(context.Context, *BulkEditRedemptionStatus3PRequest) (*BulkEditRedemptionStatus3PResponse, error)

	// BulkGetCustomRewards3p returns the custom rewards on a channel specified in the request
	// SLO@500ms
	BulkGetCustomRewards3P(context.Context, *BulkGetCustomRewards3PRequest) (*BulkGetCustomRewards3PResponse, error)
}

// ==============================
// CopoThirdParty Protobuf Client
// ==============================

type copoThirdPartyProtobufClient struct {
	client HTTPClient
	urls   [8]string
}

// NewCopoThirdPartyProtobufClient creates a Protobuf client that implements the CopoThirdParty interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCopoThirdPartyProtobufClient(addr string, client HTTPClient) CopoThirdParty {
	prefix := urlBase(addr) + CopoThirdPartyPathPrefix
	urls := [8]string{
		prefix + "CreateCustomReward3P",
		prefix + "ListCustomRewards3P",
		prefix + "UpdateCustomReward3P",
		prefix + "RemoveCustomReward3P",
		prefix + "ListRedemptions3P",
		prefix + "GetRedemption3P",
		prefix + "BulkEditRedemptionStatus3P",
		prefix + "BulkGetCustomRewards3P",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &copoThirdPartyProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &copoThirdPartyProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *copoThirdPartyProtobufClient) CreateCustomReward3P(ctx context.Context, in *CreateCustomReward3PRequest) (*CreateCustomReward3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward3P")
	out := new(CreateCustomReward3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) ListCustomRewards3P(ctx context.Context, in *ListCustomRewards3PRequest) (*ListCustomRewards3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards3P")
	out := new(ListCustomRewards3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) UpdateCustomReward3P(ctx context.Context, in *UpdateCustomReward3PRequest) (*UpdateCustomReward3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward3P")
	out := new(UpdateCustomReward3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) RemoveCustomReward3P(ctx context.Context, in *RemoveCustomReward3PRequest) (*RemoveCustomReward3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward3P")
	out := new(RemoveCustomReward3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) ListRedemptions3P(ctx context.Context, in *ListRedemptions3PRequest) (*ListRedemptions3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions3P")
	out := new(ListRedemptions3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) GetRedemption3P(ctx context.Context, in *GetRedemption3PRequest) (*GetRedemption3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption3P")
	out := new(GetRedemption3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) BulkEditRedemptionStatus3P(ctx context.Context, in *BulkEditRedemptionStatus3PRequest) (*BulkEditRedemptionStatus3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus3P")
	out := new(BulkEditRedemptionStatus3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyProtobufClient) BulkGetCustomRewards3P(ctx context.Context, in *BulkGetCustomRewards3PRequest) (*BulkGetCustomRewards3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetCustomRewards3P")
	out := new(BulkGetCustomRewards3PResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ==========================
// CopoThirdParty JSON Client
// ==========================

type copoThirdPartyJSONClient struct {
	client HTTPClient
	urls   [8]string
}

// NewCopoThirdPartyJSONClient creates a JSON client that implements the CopoThirdParty interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCopoThirdPartyJSONClient(addr string, client HTTPClient) CopoThirdParty {
	prefix := urlBase(addr) + CopoThirdPartyPathPrefix
	urls := [8]string{
		prefix + "CreateCustomReward3P",
		prefix + "ListCustomRewards3P",
		prefix + "UpdateCustomReward3P",
		prefix + "RemoveCustomReward3P",
		prefix + "ListRedemptions3P",
		prefix + "GetRedemption3P",
		prefix + "BulkEditRedemptionStatus3P",
		prefix + "BulkGetCustomRewards3P",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &copoThirdPartyJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &copoThirdPartyJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *copoThirdPartyJSONClient) CreateCustomReward3P(ctx context.Context, in *CreateCustomReward3PRequest) (*CreateCustomReward3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward3P")
	out := new(CreateCustomReward3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) ListCustomRewards3P(ctx context.Context, in *ListCustomRewards3PRequest) (*ListCustomRewards3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards3P")
	out := new(ListCustomRewards3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) UpdateCustomReward3P(ctx context.Context, in *UpdateCustomReward3PRequest) (*UpdateCustomReward3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward3P")
	out := new(UpdateCustomReward3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) RemoveCustomReward3P(ctx context.Context, in *RemoveCustomReward3PRequest) (*RemoveCustomReward3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward3P")
	out := new(RemoveCustomReward3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) ListRedemptions3P(ctx context.Context, in *ListRedemptions3PRequest) (*ListRedemptions3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions3P")
	out := new(ListRedemptions3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) GetRedemption3P(ctx context.Context, in *GetRedemption3PRequest) (*GetRedemption3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption3P")
	out := new(GetRedemption3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) BulkEditRedemptionStatus3P(ctx context.Context, in *BulkEditRedemptionStatus3PRequest) (*BulkEditRedemptionStatus3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus3P")
	out := new(BulkEditRedemptionStatus3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *copoThirdPartyJSONClient) BulkGetCustomRewards3P(ctx context.Context, in *BulkGetCustomRewards3PRequest) (*BulkGetCustomRewards3PResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetCustomRewards3P")
	out := new(BulkGetCustomRewards3PResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =============================
// CopoThirdParty Server Handler
// =============================

type copoThirdPartyServer struct {
	CopoThirdParty
	hooks *twirp.ServerHooks
}

func NewCopoThirdPartyServer(svc CopoThirdParty, hooks *twirp.ServerHooks) TwirpServer {
	return &copoThirdPartyServer{
		CopoThirdParty: svc,
		hooks:          hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *copoThirdPartyServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// CopoThirdPartyPathPrefix is used for all URL paths on a twirp CopoThirdParty server.
// Requests are always: POST CopoThirdPartyPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const CopoThirdPartyPathPrefix = "/twirp/copo.CopoThirdParty/"

func (s *copoThirdPartyServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "copo")
	ctx = ctxsetters.WithServiceName(ctx, "CopoThirdParty")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/copo.CopoThirdParty/CreateCustomReward3P":
		s.serveCreateCustomReward3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/ListCustomRewards3P":
		s.serveListCustomRewards3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/UpdateCustomReward3P":
		s.serveUpdateCustomReward3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/RemoveCustomReward3P":
		s.serveRemoveCustomReward3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/ListRedemptions3P":
		s.serveListRedemptions3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/GetRedemption3P":
		s.serveGetRedemption3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/BulkEditRedemptionStatus3P":
		s.serveBulkEditRedemptionStatus3P(ctx, resp, req)
		return
	case "/twirp/copo.CopoThirdParty/BulkGetCustomRewards3P":
		s.serveBulkGetCustomRewards3P(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *copoThirdPartyServer) serveCreateCustomReward3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCustomReward3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCustomReward3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveCreateCustomReward3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCustomReward3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCustomReward3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.CreateCustomReward3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCustomReward3PResponse and nil error while calling CreateCustomReward3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveCreateCustomReward3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCustomReward3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateCustomReward3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateCustomReward3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.CreateCustomReward3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCustomReward3PResponse and nil error while calling CreateCustomReward3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveListCustomRewards3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCustomRewards3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCustomRewards3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveListCustomRewards3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListCustomRewards3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCustomRewards3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.ListCustomRewards3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCustomRewards3PResponse and nil error while calling ListCustomRewards3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveListCustomRewards3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCustomRewards3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListCustomRewards3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListCustomRewards3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.ListCustomRewards3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCustomRewards3PResponse and nil error while calling ListCustomRewards3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveUpdateCustomReward3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCustomReward3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCustomReward3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveUpdateCustomReward3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCustomReward3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCustomReward3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.UpdateCustomReward3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCustomReward3PResponse and nil error while calling UpdateCustomReward3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveUpdateCustomReward3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCustomReward3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateCustomReward3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateCustomReward3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.UpdateCustomReward3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCustomReward3PResponse and nil error while calling UpdateCustomReward3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveRemoveCustomReward3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveCustomReward3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveCustomReward3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveRemoveCustomReward3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveCustomReward3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveCustomReward3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.RemoveCustomReward3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveCustomReward3PResponse and nil error while calling RemoveCustomReward3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveRemoveCustomReward3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveCustomReward3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RemoveCustomReward3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RemoveCustomReward3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.RemoveCustomReward3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveCustomReward3PResponse and nil error while calling RemoveCustomReward3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveListRedemptions3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListRedemptions3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListRedemptions3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveListRedemptions3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListRedemptions3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListRedemptions3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.ListRedemptions3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRedemptions3PResponse and nil error while calling ListRedemptions3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveListRedemptions3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRedemptions3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListRedemptions3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListRedemptions3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.ListRedemptions3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRedemptions3PResponse and nil error while calling ListRedemptions3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveGetRedemption3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRedemption3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRedemption3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveGetRedemption3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRedemption3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRedemption3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.GetRedemption3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRedemption3PResponse and nil error while calling GetRedemption3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveGetRedemption3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRedemption3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRedemption3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRedemption3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.GetRedemption3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRedemption3PResponse and nil error while calling GetRedemption3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveBulkEditRedemptionStatus3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkEditRedemptionStatus3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkEditRedemptionStatus3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveBulkEditRedemptionStatus3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkEditRedemptionStatus3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEditRedemptionStatus3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.BulkEditRedemptionStatus3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEditRedemptionStatus3PResponse and nil error while calling BulkEditRedemptionStatus3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveBulkEditRedemptionStatus3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkEditRedemptionStatus3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkEditRedemptionStatus3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkEditRedemptionStatus3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.BulkEditRedemptionStatus3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkEditRedemptionStatus3PResponse and nil error while calling BulkEditRedemptionStatus3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveBulkGetCustomRewards3P(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBulkGetCustomRewards3PJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBulkGetCustomRewards3PProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *copoThirdPartyServer) serveBulkGetCustomRewards3PJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetCustomRewards3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BulkGetCustomRewards3PRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkGetCustomRewards3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.BulkGetCustomRewards3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetCustomRewards3PResponse and nil error while calling BulkGetCustomRewards3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) serveBulkGetCustomRewards3PProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BulkGetCustomRewards3P")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BulkGetCustomRewards3PRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BulkGetCustomRewards3PResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CopoThirdParty.BulkGetCustomRewards3P(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BulkGetCustomRewards3PResponse and nil error while calling BulkGetCustomRewards3P. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *copoThirdPartyServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *copoThirdPartyServer) ProtocGenTwirpVersion() string {
	return "v5.5.2"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.2")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1322 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcf, 0x6e, 0xdb, 0xc6,
	0x13, 0x0e, 0xa3, 0x48, 0x11, 0x47, 0xb1, 0x93, 0xdf, 0xda, 0x3f, 0x87, 0x91, 0xfc, 0x47, 0x66,
	0x1a, 0xd4, 0x97, 0x4a, 0x81, 0x9c, 0xa4, 0x48, 0x6f, 0x8d, 0x6b, 0x18, 0x06, 0xda, 0xc4, 0xa5,
	0x9a, 0xa0, 0x28, 0x0a, 0x10, 0x94, 0xb8, 0x91, 0xb7, 0xa6, 0xb8, 0xf4, 0xee, 0x32, 0x76, 0xda,
	0x07, 0xe8, 0xa5, 0x2d, 0xd0, 0x43, 0x0b, 0xf4, 0xd2, 0x7b, 0x1f, 0xa0, 0x4f, 0xd3, 0x97, 0x29,
	0x76, 0x97, 0x12, 0x49, 0x8b, 0xa2, 0xdc, 0x36, 0xc9, 0xc5, 0x30, 0x77, 0xbe, 0x99, 0xd9, 0xfd,
	0x66, 0xe6, 0xe3, 0x52, 0xb0, 0x3a, 0xa4, 0x11, 0x15, 0xc7, 0x84, 0xf9, 0x91, 0xc7, 0xc4, 0xeb,
	0x4e, 0xc4, 0xa8, 0xa0, 0xe8, 0x9a, 0x5c, 0x6d, 0x82, 0xfc, 0xab, 0x57, 0x9a, 0x9b, 0x23, 0x4a,
	0x47, 0x01, 0xee, 0xaa, 0xa7, 0x41, 0xfc, 0xb2, 0x7b, 0xc6, 0xbc, 0x28, 0xc2, 0x8c, 0x6b, 0xbb,
	0xfd, 0x67, 0x15, 0x5a, 0x7b, 0x0c, 0x7b, 0x02, 0xef, 0xc5, 0x5c, 0xd0, 0xb1, 0x83, 0xcf, 0x3c,
	0xe6, 0xef, 0x46, 0x0e, 0x3e, 0x8d, 0x31, 0x17, 0xa8, 0x05, 0xe6, 0x30, 0x20, 0x38, 0x14, 0x2e,
	0xf1, 0x2d, 0xa3, 0x6d, 0xec, 0x98, 0x4e, 0x5d, 0x2f, 0x1c, 0xfa, 0x68, 0x03, 0x60, 0x78, 0xec,
	0x85, 0x21, 0x0e, 0xa4, 0xf5, 0xaa, 0xb2, 0x9a, 0xc9, 0xca, 0xa1, 0x8f, 0x56, 0xa1, 0x2a, 0x88,
	0x08, 0xb0, 0x55, 0x51, 0x16, 0xfd, 0x80, 0x1e, 0x40, 0x2d, 0x62, 0x74, 0x1c, 0x09, 0xeb, 0x5a,
	0xdb, 0xd8, 0x69, 0xf4, 0xd6, 0x3b, 0x7a, 0x8b, 0x9d, 0xc9, 0x16, 0x3b, 0x7d, 0xc1, 0x48, 0x38,
	0x7a, 0xe1, 0x05, 0x31, 0x76, 0x12, 0x2c, 0x42, 0x70, 0x6d, 0x48, 0xb9, 0xb0, 0xaa, 0x6d, 0x63,
	0xa7, 0xe2, 0xa8, 0xff, 0xd1, 0x53, 0x58, 0x1b, 0x7b, 0xe7, 0x6e, 0x84, 0x99, 0xcb, 0x05, 0xc3,
	0xde, 0xd8, 0xe5, 0x58, 0x08, 0x12, 0x8e, 0xac, 0x9a, 0x8a, 0x7c, 0xa7, 0xa3, 0x88, 0xf8, 0xcc,
	0x3b, 0x3f, 0xc2, 0xac, 0xaf, 0x10, 0x7d, 0x0d, 0x70, 0x56, 0xc6, 0xb3, 0x8b, 0xe8, 0x00, 0x6e,
	0x0d, 0xbc, 0xe1, 0xc9, 0x88, 0xd1, 0x38, 0xf4, 0xdd, 0x21, 0x0d, 0x28, 0xb3, 0xae, 0x5f, 0x62,
	0x8f, 0x37, 0x53, 0xaf, 0x3d, 0xe9, 0x84, 0x76, 0x61, 0x8d, 0x70, 0x37, 0xe6, 0x98, 0xb9, 0x24,
	0x8c, 0x62, 0xe1, 0x32, 0x7c, 0x1a, 0x13, 0x86, 0x7d, 0xab, 0xde, 0x36, 0x76, 0xea, 0xce, 0x0a,
	0xe1, 0xcf, 0x39, 0x66, 0x87, 0xd2, 0xe6, 0x24, 0x26, 0xb4, 0x09, 0x0d, 0xc2, 0x5d, 0x1e, 0x0f,
	0x5c, 0x1a, 0x06, 0xaf, 0x2d, 0x53, 0x21, 0x4d, 0xc2, 0xfb, 0xf1, 0xe0, 0x59, 0x18, 0xbc, 0x46,
	0x47, 0x70, 0x8f, 0x1f, 0xd3, 0x38, 0xf0, 0x5d, 0x86, 0x7d, 0x3c, 0x8e, 0x04, 0xa1, 0x21, 0x77,
	0xf9, 0x09, 0x89, 0x54, 0x78, 0xcc, 0x85, 0x7b, 0x1a, 0xe3, 0x18, 0x5b, 0xa0, 0x3c, 0xb7, 0x35,
	0xd8, 0x49, 0xb1, 0xfd, 0x13, 0x32, 0x29, 0xeb, 0xe7, 0x12, 0x88, 0x30, 0x6c, 0x4d, 0xf8, 0x53,
	0x7b, 0x2d, 0x20, 0xb2, 0xa1, 0x8e, 0xdf, 0xce, 0x12, 0x29, 0x77, 0x3e, 0xc3, 0x67, 0x73, 0x3c,
	0xd7, 0x86, 0xfa, 0x70, 0x7b, 0x14, 0xd0, 0x81, 0x17, 0xb8, 0x43, 0x4a, 0x03, 0x9f, 0x9e, 0x85,
	0xd3, 0xf0, 0x37, 0x54, 0xf8, 0x96, 0x0e, 0x7f, 0xa0, 0x40, 0x7b, 0x94, 0x06, 0x9f, 0xd0, 0xb3,
	0x70, 0x12, 0xf9, 0xff, 0xa3, 0xe9, 0xb2, 0x9f, 0x2e, 0xdb, 0x3f, 0x19, 0xb0, 0x5e, 0xdc, 0xb7,
	0x3c, 0xa2, 0x21, 0xc7, 0xe8, 0x31, 0x2c, 0x0f, 0x95, 0x5d, 0xf2, 0x25, 0x6d, 0xaa, 0x7b, 0x1b,
	0x3d, 0xa4, 0x93, 0x65, 0xbd, 0x9c, 0xa5, 0x04, 0xa9, 0x1f, 0xd1, 0x2e, 0x54, 0x31, 0x63, 0x94,
	0xa9, 0x8e, 0x6e, 0xf4, 0x36, 0x12, 0x8f, 0x99, 0x6c, 0xfb, 0x12, 0xe4, 0x68, 0xac, 0xfd, 0x25,
	0x34, 0x3f, 0x25, 0x5c, 0x64, 0xed, 0xfc, 0x8d, 0x8c, 0x91, 0xfd, 0x83, 0x01, 0xad, 0xc2, 0xd0,
	0x99, 0x93, 0x2a, 0x53, 0x72, 0x50, 0x6e, 0x19, 0xed, 0xca, 0xdc, 0x93, 0x66, 0x83, 0xa0, 0x5e,
	0xfe, 0xa4, 0xeb, 0xda, 0x63, 0x26, 0x59, 0xee, 0xa0, 0xbf, 0xd5, 0xa0, 0xf5, 0x3c, 0xf2, 0xdf,
	0x8a, 0x62, 0xb4, 0xc0, 0xd4, 0x67, 0x90, 0x56, 0xad, 0x1a, 0x75, 0xbd, 0x70, 0xe8, 0xcb, 0xcd,
	0x6a, 0x39, 0xb9, 0x8c, 0x6e, 0xcc, 0x88, 0x4d, 0xf5, 0x1f, 0x88, 0x4d, 0x37, 0x11, 0x9b, 0x5a,
	0xd2, 0x9e, 0x17, 0x7d, 0x0e, 0x43, 0xf1, 0xe8, 0x81, 0x76, 0x59, 0xa4, 0x44, 0xd7, 0xdf, 0x98,
	0x12, 0xd5, 0xff, 0x8d, 0x12, 0x3d, 0x9b, 0xab, 0x44, 0xa6, 0x0a, 0xd7, 0x9c, 0x09, 0xf7, 0x84,
	0xd2, 0x40, 0x07, 0x2b, 0x54, 0xa9, 0x8f, 0xf2, 0x2a, 0x05, 0x0b, 0xa3, 0x64, 0x14, 0xec, 0x31,
	0x00, 0xe1, 0x2e, 0x0e, 0xbd, 0x41, 0x80, 0xfd, 0x44, 0x5a, 0x16, 0xb8, 0xee, 0x6b, 0x30, 0xfa,
	0x10, 0x4c, 0xc2, 0xdd, 0xc8, 0x8b, 0x39, 0xf6, 0x13, 0xd5, 0x28, 0xf3, 0xac, 0x13, 0x7e, 0xa4,
	0xb0, 0x28, 0xb8, 0xac, 0x6a, 0x2e, 0x2d, 0x0c, 0xba, 0x58, 0x51, 0x95, 0x2a, 0x15, 0xcf, 0x46,
	0x3a, 0xab, 0xb1, 0xb2, 0x5f, 0x46, 0x95, 0x12, 0x64, 0xa9, 0x2a, 0xcd, 0x66, 0xcb, 0x0d, 0xeb,
	0x5f, 0x06, 0xb4, 0x1c, 0x3c, 0xa6, 0xaf, 0xde, 0xf5, 0xb0, 0x0e, 0xc1, 0x8e, 0xc3, 0x97, 0x71,
	0xf0, 0x92, 0x04, 0x01, 0xce, 0x93, 0x1f, 0xe2, 0x33, 0x97, 0x0b, 0x4f, 0xc4, 0x5c, 0x4d, 0xf2,
	0x72, 0x6f, 0x4d, 0x1f, 0x25, 0x25, 0xb6, 0xaf, 0xac, 0xce, 0x56, 0x26, 0x42, 0x86, 0xf5, 0xa7,
	0xf8, 0x4c, 0x03, 0x14, 0xdd, 0xc5, 0xa7, 0x4b, 0xe9, 0x66, 0xca, 0x7e, 0x19, 0xba, 0x13, 0x64,
	0x29, 0xdd, 0xb3, 0xd9, 0x72, 0x74, 0x7f, 0x7f, 0x15, 0x2c, 0xa9, 0x9e, 0x99, 0xdd, 0xbe, 0xb1,
	0xab, 0x54, 0x40, 0xc6, 0x44, 0x28, 0x9e, 0x2b, 0x8e, 0x7e, 0x40, 0x6b, 0x50, 0x1b, 0xc6, 0x8c,
	0x53, 0xa6, 0x88, 0x34, 0x9d, 0xe4, 0x09, 0x3d, 0x80, 0x2a, 0x65, 0x3e, 0x66, 0x4a, 0xf4, 0x96,
	0x7b, 0x9b, 0xa9, 0xac, 0x67, 0x9b, 0x97, 0x32, 0xf1, 0x4c, 0xa2, 0x1c, 0x0d, 0x46, 0x1d, 0xa8,
	0x25, 0x65, 0xa9, 0x95, 0x96, 0x25, 0x41, 0xe5, 0xeb, 0x7f, 0x3d, 0x5f, 0x7f, 0xfb, 0x0f, 0x03,
	0xee, 0x14, 0x30, 0x91, 0xd4, 0xe5, 0x11, 0x34, 0x32, 0x1d, 0x91, 0xbc, 0xaf, 0x56, 0x2f, 0xe6,
	0xdb, 0xf7, 0x47, 0xd8, 0xc9, 0x02, 0x91, 0x0d, 0x4b, 0xc7, 0x9e, 0xec, 0xa0, 0x73, 0xe1, 0x46,
	0xde, 0x08, 0x2b, 0xa2, 0xea, 0x4e, 0xe3, 0xd8, 0xe3, 0x4f, 0xf1, 0xb9, 0x38, 0xf2, 0x46, 0x18,
	0xdd, 0x9f, 0x14, 0xae, 0x92, 0x4c, 0x74, 0xd1, 0xe1, 0x73, 0x55, 0xfb, 0xd5, 0x80, 0xb5, 0x03,
	0x9c, 0x31, 0xbf, 0x83, 0xf9, 0xb8, 0x0b, 0x4b, 0xe9, 0xc1, 0x24, 0x40, 0x57, 0xf0, 0x46, 0xba,
	0x78, 0xe8, 0xdb, 0xdf, 0xc1, 0xed, 0x99, 0x7d, 0x25, 0x0c, 0xde, 0x07, 0x48, 0xa1, 0x49, 0x57,
	0xdf, 0xba, 0x48, 0xa0, 0x93, 0xc1, 0xa0, 0x4e, 0xbe, 0xa1, 0xad, 0xe4, 0xd2, 0x95, 0x8d, 0x9f,
	0x63, 0xe5, 0xe7, 0xab, 0xb0, 0xfd, 0x24, 0x0e, 0x4e, 0xf6, 0x7d, 0x22, 0x2e, 0xf6, 0xc0, 0x3b,
	0x20, 0xe8, 0x9e, 0x1c, 0xdd, 0x0c, 0x41, 0x52, 0x2c, 0x2a, 0x3b, 0xa6, 0xb3, 0x94, 0x65, 0x88,
	0xa3, 0x87, 0x00, 0x19, 0x3d, 0xa9, 0x96, 0x36, 0xae, 0x19, 0x4e, 0x94, 0x43, 0xba, 0xd1, 0xc0,
	0x77, 0x2f, 0xd5, 0xef, 0x26, 0x0d, 0xfc, 0x44, 0x70, 0x7e, 0x37, 0xc0, 0x2e, 0xe3, 0x24, 0x29,
	0xce, 0xc7, 0xb0, 0x92, 0xaa, 0xfc, 0xc5, 0x36, 0x9f, 0xad, 0x12, 0x9a, 0x0a, 0x7d, 0xda, 0xe9,
	0x0f, 0xf3, 0xd5, 0xda, 0xd2, 0x4e, 0x45, 0x79, 0x73, 0x45, 0xfb, 0x16, 0x36, 0xe4, 0xfe, 0x0e,
	0xf0, 0x5b, 0xb8, 0x88, 0x4a, 0xf3, 0xb4, 0x5e, 0xdc, 0xaa, 0xa8, 0x72, 0x98, 0x93, 0x82, 0x71,
	0xfb, 0x47, 0x03, 0x36, 0xe7, 0x25, 0xff, 0xef, 0x57, 0xd5, 0xfb, 0x79, 0x42, 0x9a, 0xd3, 0xf6,
	0x9d, 0x27, 0xc6, 0xbd, 0x5f, 0x6a, 0xb0, 0xbc, 0x47, 0x23, 0xfa, 0x85, 0xfc, 0x4a, 0x3e, 0x92,
	0x5f, 0xc9, 0xc8, 0x85, 0xd5, 0xa2, 0x8f, 0x06, 0xb4, 0x3d, 0xef, 0x8a, 0x3f, 0x25, 0xae, 0x69,
	0x97, 0x41, 0xf4, 0xf1, 0xec, 0x2b, 0xe8, 0x6b, 0x58, 0x29, 0xb8, 0xaa, 0xa3, 0xf6, 0x9c, 0x8b,
	0x75, 0x1a, 0x7e, 0xbb, 0x04, 0x31, 0x8d, 0xee, 0xc2, 0x6a, 0xd1, 0xed, 0x62, 0xb2, 0xfd, 0x92,
	0x5b, 0xf9, 0x64, 0xfb, 0x65, 0x97, 0x13, 0x9d, 0xa0, 0xe8, 0x7d, 0x3a, 0x49, 0x50, 0x72, 0x93,
	0x98, 0x24, 0x28, 0x7b, 0x1d, 0xdb, 0x57, 0xd0, 0x0b, 0xf8, 0xdf, 0xcc, 0x5b, 0x01, 0x15, 0xbf,
	0x9f, 0xd2, 0xd0, 0x5b, 0x73, 0xed, 0xd3, 0xb8, 0x47, 0x70, 0xf3, 0x82, 0x52, 0xa2, 0xf5, 0x02,
	0x81, 0x4b, 0x63, 0x6e, 0xcc, 0xb1, 0x4e, 0x23, 0x9e, 0x42, 0x73, 0xfe, 0xa4, 0xa3, 0xf7, 0xb5,
	0xfb, 0x42, 0x7d, 0x6c, 0xee, 0x2c, 0x06, 0x4e, 0x53, 0x62, 0x58, 0x2b, 0x9e, 0x1f, 0x74, 0x37,
	0x8d, 0x32, 0x77, 0xb4, 0x9b, 0xef, 0x95, 0x83, 0x26, 0x69, 0x9e, 0x74, 0xbf, 0xfa, 0x60, 0x48,
	0x7d, 0xdc, 0xf9, 0x26, 0xe6, 0x82, 0x84, 0x1d, 0xf1, 0xaa, 0x3b, 0x3c, 0xf6, 0x44, 0x57, 0x3a,
	0xeb, 0x9f, 0x89, 0xba, 0xf9, 0xdf, 0x96, 0x06, 0x35, 0xb5, 0xba, 0xfb, 0x77, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x82, 0xef, 0xbd, 0x37, 0x74, 0x12, 0x00, 0x00,
}
