// Code generated by protoc-gen-go. DO NOT EDIT.
// source: raid/update.proto

package raid

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Status describes a raid's place in its lifecycle.
type Status int32

const (
	Status_STATUS_INVALID Status = 0
	// When a raid is started, viewers that have not opted out will be redirected to
	// the target's channel page. A raid can be started explicitly by its broadcaster,
	// or automatically when enough time passes.
	Status_STATUS_STARTED Status = 1
)

var Status_name = map[int32]string{
	0: "STATUS_INVALID",
	1: "STATUS_STARTED",
}
var Status_value = map[string]int32{
	"STATUS_INVALID": 0,
	"STATUS_STARTED": 1,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_d3e45fb138e752dc, []int{0}
}

// RaidUpdate triggers when a raid has been started.
type RaidUpdate struct {
	// The Raid's ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The user ID of the channel that the raid is originating on.
	FromBroadcasterUserId string `protobuf:"bytes,2,opt,name=from_broadcaster_user_id,json=fromBroadcasterUserId,proto3" json:"from_broadcaster_user_id,omitempty"`
	// The user ID of the channel that the raid is targeting.
	ToBroadcasterUserId string `protobuf:"bytes,3,opt,name=to_broadcaster_user_id,json=toBroadcasterUserId,proto3" json:"to_broadcaster_user_id,omitempty"`
	// The current status for the raid.
	Status Status `protobuf:"varint,4,opt,name=status,proto3,enum=raid.Status" json:"status,omitempty"`
	// The number of users that are part of the raid.
	Viewers int32 `protobuf:"varint,5,opt,name=viewers,proto3" json:"viewers,omitempty"`
	// The date/time the raid was updated.
	UpdatedAt            *timestamp.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *RaidUpdate) Reset()         { *m = RaidUpdate{} }
func (m *RaidUpdate) String() string { return proto.CompactTextString(m) }
func (*RaidUpdate) ProtoMessage()    {}
func (*RaidUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_d3e45fb138e752dc, []int{0}
}
func (m *RaidUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RaidUpdate.Unmarshal(m, b)
}
func (m *RaidUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RaidUpdate.Marshal(b, m, deterministic)
}
func (dst *RaidUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaidUpdate.Merge(dst, src)
}
func (m *RaidUpdate) XXX_Size() int {
	return xxx_messageInfo_RaidUpdate.Size(m)
}
func (m *RaidUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_RaidUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_RaidUpdate proto.InternalMessageInfo

func (m *RaidUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RaidUpdate) GetFromBroadcasterUserId() string {
	if m != nil {
		return m.FromBroadcasterUserId
	}
	return ""
}

func (m *RaidUpdate) GetToBroadcasterUserId() string {
	if m != nil {
		return m.ToBroadcasterUserId
	}
	return ""
}

func (m *RaidUpdate) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_STATUS_INVALID
}

func (m *RaidUpdate) GetViewers() int32 {
	if m != nil {
		return m.Viewers
	}
	return 0
}

func (m *RaidUpdate) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func init() {
	proto.RegisterType((*RaidUpdate)(nil), "raid.RaidUpdate")
	proto.RegisterEnum("raid.Status", Status_name, Status_value)
}

func init() { proto.RegisterFile("raid/update.proto", fileDescriptor_update_d3e45fb138e752dc) }

var fileDescriptor_update_d3e45fb138e752dc = []byte{
	// 318 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x91, 0xcf, 0x4a, 0xfb, 0x40,
	0x10, 0xc7, 0x7f, 0xc9, 0xaf, 0x8d, 0x74, 0x95, 0x52, 0xd7, 0x2a, 0x4b, 0x2f, 0x06, 0xf1, 0x10,
	0x84, 0x26, 0xd2, 0x1e, 0x44, 0x6f, 0x29, 0xf5, 0x50, 0x10, 0x0f, 0x49, 0xea, 0xc1, 0x4b, 0xd8,
	0xb8, 0xd3, 0xb2, 0x60, 0xba, 0x61, 0x77, 0xd2, 0xfa, 0x2c, 0xfa, 0x1c, 0xbe, 0x9f, 0x74, 0xd3,
	0xa2, 0xa0, 0xc7, 0xf9, 0xfe, 0xd9, 0x61, 0x3f, 0x43, 0x8e, 0x35, 0x97, 0x22, 0xaa, 0x2b, 0xc1,
	0x11, 0xc2, 0x4a, 0x2b, 0x54, 0xb4, 0xb5, 0x95, 0x06, 0x7d, 0x58, 0xc3, 0x0a, 0x8b, 0xda, 0x44,
	0x6a, 0xb3, 0x02, 0xdd, 0x78, 0x83, 0xf3, 0xa5, 0x52, 0xcb, 0x57, 0x88, 0xec, 0x54, 0xd4, 0x8b,
	0x08, 0x65, 0x09, 0x06, 0x79, 0x59, 0x35, 0x81, 0x8b, 0x0f, 0x97, 0x90, 0x84, 0x4b, 0x31, 0xb7,
	0x2f, 0xd2, 0x2e, 0x71, 0xa5, 0x60, 0x8e, 0xef, 0x04, 0x9d, 0xc4, 0x95, 0x82, 0xde, 0x10, 0xb6,
	0xd0, 0xaa, 0xcc, 0x0b, 0xad, 0xb8, 0x78, 0xe1, 0x06, 0x41, 0xe7, 0xb5, 0x01, 0x9d, 0x4b, 0xc1,
	0x5c, 0x9b, 0x3a, 0xdd, 0xfa, 0x93, 0x6f, 0x7b, 0x6e, 0x40, 0xcf, 0x04, 0x1d, 0x93, 0x33, 0x54,
	0x7f, 0xd6, 0xfe, 0xdb, 0xda, 0x09, 0xaa, 0xdf, 0xa5, 0x4b, 0xe2, 0x19, 0xe4, 0x58, 0x1b, 0xd6,
	0xf2, 0x9d, 0xa0, 0x3b, 0x3a, 0x0a, 0xb7, 0x5f, 0x0b, 0x53, 0xab, 0x25, 0x3b, 0x8f, 0x32, 0x72,
	0xb0, 0x96, 0xb0, 0x01, 0x6d, 0x58, 0xdb, 0x77, 0x82, 0x76, 0xb2, 0x1f, 0xe9, 0x2d, 0x21, 0x0d,
	0x19, 0x91, 0x73, 0x64, 0x9e, 0xef, 0x04, 0x87, 0xa3, 0x41, 0xd8, 0x20, 0x08, 0xf7, 0x08, 0xc2,
	0x6c, 0x8f, 0x20, 0xe9, 0xec, 0xd2, 0x31, 0xde, 0xf5, 0xdf, 0x3f, 0x59, 0x0f, 0x81, 0x97, 0xc3,
	0xf5, 0xdb, 0xb0, 0xd2, 0x4a, 0x0c, 0x61, 0xb5, 0xbc, 0xba, 0x26, 0x5e, 0xb3, 0x9c, 0x52, 0xd2,
	0x4d, 0xb3, 0x38, 0x9b, 0xa7, 0xf9, 0xec, 0xf1, 0x29, 0x7e, 0x98, 0x4d, 0x7b, 0xff, 0x7e, 0x68,
	0x69, 0x16, 0x27, 0xd9, 0xfd, 0xb4, 0xe7, 0x4c, 0xbc, 0x67, 0x7b, 0x8e, 0xc2, 0xb3, 0xeb, 0xc6,
	0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf5, 0x86, 0xd4, 0x46, 0xb0, 0x01, 0x00, 0x00,
}
