// Code generated by protoc-gen-go. DO NOT EDIT.
// source: user/update.proto

package user

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import change "code.justin.tv/eventbus/schema/pkg/eventbus/change"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// LoginChangeType contains the different types of a login change.
type LoginChangeType int32

const (
	// Indicates no login change or an unknown type.
	LoginChangeType_LOGIN_CHANGE_TYPE_INVALID LoginChangeType = 0
	// Indicates a standard login change.
	LoginChangeType_LOGIN_CHANGE_TYPE_NORMAL LoginChangeType = 1
	// Indicates that user's login has been changed because of a username reset.
	LoginChangeType_LOGIN_CHANGE_TYPE_RESET LoginChangeType = 2
)

var LoginChangeType_name = map[int32]string{
	0: "LOGIN_CHANGE_TYPE_INVALID",
	1: "LOGIN_CHANGE_TYPE_NORMAL",
	2: "LOGIN_CHANGE_TYPE_RESET",
}
var LoginChangeType_value = map[string]int32{
	"LOGIN_CHANGE_TYPE_INVALID": 0,
	"LOGIN_CHANGE_TYPE_NORMAL":  1,
	"LOGIN_CHANGE_TYPE_RESET":   2,
}

func (x LoginChangeType) String() string {
	return proto.EnumName(LoginChangeType_name, int32(x))
}
func (LoginChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_b1027dc0c2724707, []int{0}
}

// UserUpdate is triggered on various user/profile change actions.
//
// Other than the 'user_id' field which is always included, all the
// other fields are optional and not necessarily included in all events.
// Clients should anticipate this depending on user actions and not rely
// on getting the entire range of values.
//
// Various PII fields are currently omitted, though that they have changed
// is signaled using the 'Change' type. It is designed in such a way that
// we may be able to upgrade them to encrypted fields in the future.
type UserUpdate struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The alphanumeric login name of the user.
	Login *change.StringChange `protobuf:"bytes,2,opt,name=login,proto3" json:"login,omitempty"`
	// Supplemental field for login describing the type of login change.
	LoginChangeType LoginChangeType `protobuf:"varint,12,opt,name=login_change_type,json=loginChangeType,proto3,enum=user.LoginChangeType" json:"login_change_type,omitempty"`
	// Display Name is the stylized version of the login name (may contain localized characters).
	DisplayName *change.StringChange `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Birthday change can be signaled, data currently omitted for PII.
	Birthday *change.Change `protobuf:"bytes,4,opt,name=birthday,proto3" json:"birthday,omitempty"`
	// Email address change can be signaled, data currently omitted for PII.
	Email *change.Change `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// Phone number change can be signaled, data currently omitted for PII.
	PhoneNumber *change.Change `protobuf:"bytes,11,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// Language is an ISO-639-1 two-letter language code e.g. 'en'
	Language *change.StringChange `protobuf:"bytes,6,opt,name=language,proto3" json:"language,omitempty"`
	// The user's own set description. May be multi-line.
	Description *change.StringChange `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Each image change key is a size code e.g 320x400.
	ProfileImage         map[string]*ImageChange `protobuf:"bytes,8,rep,name=profile_image,json=profileImage,proto3" json:"profile_image,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ProfileBanner        map[string]*ImageChange `protobuf:"bytes,9,rep,name=profile_banner,json=profileBanner,proto3" json:"profile_banner,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ChannelOfflineImage  map[string]*ImageChange `protobuf:"bytes,10,rep,name=channel_offline_image,json=channelOfflineImage,proto3" json:"channel_offline_image,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *UserUpdate) Reset()         { *m = UserUpdate{} }
func (m *UserUpdate) String() string { return proto.CompactTextString(m) }
func (*UserUpdate) ProtoMessage()    {}
func (*UserUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_b1027dc0c2724707, []int{0}
}
func (m *UserUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserUpdate.Unmarshal(m, b)
}
func (m *UserUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserUpdate.Marshal(b, m, deterministic)
}
func (dst *UserUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserUpdate.Merge(dst, src)
}
func (m *UserUpdate) XXX_Size() int {
	return xxx_messageInfo_UserUpdate.Size(m)
}
func (m *UserUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_UserUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_UserUpdate proto.InternalMessageInfo

func (m *UserUpdate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UserUpdate) GetLogin() *change.StringChange {
	if m != nil {
		return m.Login
	}
	return nil
}

func (m *UserUpdate) GetLoginChangeType() LoginChangeType {
	if m != nil {
		return m.LoginChangeType
	}
	return LoginChangeType_LOGIN_CHANGE_TYPE_INVALID
}

func (m *UserUpdate) GetDisplayName() *change.StringChange {
	if m != nil {
		return m.DisplayName
	}
	return nil
}

func (m *UserUpdate) GetBirthday() *change.Change {
	if m != nil {
		return m.Birthday
	}
	return nil
}

func (m *UserUpdate) GetEmail() *change.Change {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *UserUpdate) GetPhoneNumber() *change.Change {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *UserUpdate) GetLanguage() *change.StringChange {
	if m != nil {
		return m.Language
	}
	return nil
}

func (m *UserUpdate) GetDescription() *change.StringChange {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *UserUpdate) GetProfileImage() map[string]*ImageChange {
	if m != nil {
		return m.ProfileImage
	}
	return nil
}

func (m *UserUpdate) GetProfileBanner() map[string]*ImageChange {
	if m != nil {
		return m.ProfileBanner
	}
	return nil
}

func (m *UserUpdate) GetChannelOfflineImage() map[string]*ImageChange {
	if m != nil {
		return m.ChannelOfflineImage
	}
	return nil
}

// Image denotes one of the user's image choices.
type Image struct {
	Height               uint32   `protobuf:"varint,1,opt,name=height,proto3" json:"height,omitempty"`
	Width                uint32   `protobuf:"varint,2,opt,name=width,proto3" json:"width,omitempty"`
	Url                  string   `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Image) Reset()         { *m = Image{} }
func (m *Image) String() string { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()    {}
func (*Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_b1027dc0c2724707, []int{1}
}
func (m *Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Image.Unmarshal(m, b)
}
func (m *Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Image.Marshal(b, m, deterministic)
}
func (dst *Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Image.Merge(dst, src)
}
func (m *Image) XXX_Size() int {
	return xxx_messageInfo_Image.Size(m)
}
func (m *Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Image proto.InternalMessageInfo

func (m *Image) GetHeight() uint32 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Image) GetWidth() uint32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Image) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// ImageChange represents a changed image and follows the 'change.proto' scheme.
type ImageChange struct {
	Updated              bool     `protobuf:"varint,1,opt,name=updated,proto3" json:"updated,omitempty"`
	Value                *Image   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	HasOldValue          bool     `protobuf:"varint,3,opt,name=has_old_value,json=hasOldValue,proto3" json:"has_old_value,omitempty"`
	OldValue             *Image   `protobuf:"bytes,4,opt,name=old_value,json=oldValue,proto3" json:"old_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImageChange) Reset()         { *m = ImageChange{} }
func (m *ImageChange) String() string { return proto.CompactTextString(m) }
func (*ImageChange) ProtoMessage()    {}
func (*ImageChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_b1027dc0c2724707, []int{2}
}
func (m *ImageChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageChange.Unmarshal(m, b)
}
func (m *ImageChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageChange.Marshal(b, m, deterministic)
}
func (dst *ImageChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageChange.Merge(dst, src)
}
func (m *ImageChange) XXX_Size() int {
	return xxx_messageInfo_ImageChange.Size(m)
}
func (m *ImageChange) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageChange.DiscardUnknown(m)
}

var xxx_messageInfo_ImageChange proto.InternalMessageInfo

func (m *ImageChange) GetUpdated() bool {
	if m != nil {
		return m.Updated
	}
	return false
}

func (m *ImageChange) GetValue() *Image {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ImageChange) GetHasOldValue() bool {
	if m != nil {
		return m.HasOldValue
	}
	return false
}

func (m *ImageChange) GetOldValue() *Image {
	if m != nil {
		return m.OldValue
	}
	return nil
}

func init() {
	proto.RegisterType((*UserUpdate)(nil), "user.UserUpdate")
	proto.RegisterMapType((map[string]*ImageChange)(nil), "user.UserUpdate.ChannelOfflineImageEntry")
	proto.RegisterMapType((map[string]*ImageChange)(nil), "user.UserUpdate.ProfileBannerEntry")
	proto.RegisterMapType((map[string]*ImageChange)(nil), "user.UserUpdate.ProfileImageEntry")
	proto.RegisterType((*Image)(nil), "user.Image")
	proto.RegisterType((*ImageChange)(nil), "user.ImageChange")
	proto.RegisterEnum("user.LoginChangeType", LoginChangeType_name, LoginChangeType_value)
}

func init() { proto.RegisterFile("user/update.proto", fileDescriptor_update_b1027dc0c2724707) }

var fileDescriptor_update_b1027dc0c2724707 = []byte{
	// 644 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0xdd, 0x4e, 0xdb, 0x4c,
	0x10, 0xfd, 0x4c, 0x48, 0x48, 0xc6, 0x09, 0x24, 0xfb, 0x41, 0xd9, 0xa6, 0x45, 0x4a, 0xd3, 0x8b,
	0xa6, 0x95, 0x08, 0x12, 0xdc, 0xb4, 0xdc, 0xb4, 0x81, 0x46, 0x69, 0xaa, 0x34, 0x41, 0xe6, 0x47,
	0xa2, 0x52, 0x65, 0x6d, 0xf0, 0x12, 0xaf, 0x70, 0xd6, 0xd6, 0x7a, 0x0d, 0xf2, 0x0b, 0xf4, 0x19,
	0xaa, 0xbe, 0x47, 0xdf, 0xaf, 0xf2, 0xae, 0x03, 0xa1, 0x16, 0x28, 0x12, 0x77, 0x3b, 0x33, 0xe7,
	0x9c, 0x39, 0xe3, 0x5d, 0x0f, 0xd4, 0xa2, 0x90, 0x8a, 0x9d, 0x28, 0x70, 0x88, 0xa4, 0xed, 0x40,
	0xf8, 0xd2, 0x47, 0xcb, 0x49, 0xaa, 0xbe, 0x41, 0xaf, 0x29, 0x97, 0xe3, 0x28, 0xdc, 0xb9, 0x70,
	0x09, 0x9f, 0xa4, 0xc5, 0xfa, 0xfa, 0x6d, 0xda, 0xbf, 0xe1, 0x54, 0xe8, 0x6c, 0xf3, 0x67, 0x11,
	0xe0, 0x34, 0xa4, 0xe2, 0x54, 0xe9, 0xa0, 0x4d, 0x58, 0x49, 0x34, 0x6c, 0xe6, 0x60, 0xa3, 0x61,
	0xb4, 0x4a, 0x56, 0x21, 0x09, 0xfb, 0x0e, 0xda, 0x83, 0xbc, 0xe7, 0x4f, 0x18, 0xc7, 0x4b, 0x0d,
	0xa3, 0x65, 0xee, 0x6e, 0xb5, 0x67, 0x6a, 0xed, 0xb4, 0xc9, 0xb1, 0x14, 0x8c, 0x4f, 0x0e, 0x55,
	0x60, 0x69, 0x2c, 0xea, 0x40, 0x4d, 0x1d, 0x6c, 0x8d, 0xb1, 0x65, 0x1c, 0x50, 0x5c, 0x6e, 0x18,
	0xad, 0xd5, 0xdd, 0x8d, 0x76, 0x22, 0xdc, 0x1e, 0x24, 0x65, 0x4d, 0x3a, 0x89, 0x03, 0x6a, 0xad,
	0x79, 0xf7, 0x13, 0xe8, 0x13, 0x94, 0x1d, 0x16, 0x06, 0x1e, 0x89, 0x6d, 0x4e, 0xa6, 0x14, 0xe7,
	0x16, 0x69, 0x6f, 0xa6, 0x94, 0x21, 0x99, 0x52, 0xb4, 0x07, 0xc5, 0x31, 0x13, 0xd2, 0x75, 0x48,
	0x8c, 0x97, 0x15, 0x7b, 0x33, 0xc3, 0x4e, 0x79, 0xb7, 0x40, 0xb4, 0x0d, 0x79, 0x3a, 0x25, 0xcc,
	0xc3, 0xf9, 0xc7, 0x19, 0x1a, 0x85, 0xf6, 0xa1, 0x1c, 0xb8, 0x3e, 0xa7, 0x36, 0x8f, 0xa6, 0x63,
	0x2a, 0xb0, 0xf9, 0x38, 0xcb, 0x54, 0xe0, 0xa1, 0xc2, 0xa2, 0x0f, 0x50, 0xf4, 0x08, 0x9f, 0x44,
	0x64, 0x42, 0x71, 0x61, 0x91, 0xe9, 0x6e, 0xe1, 0xe8, 0x23, 0x98, 0x0e, 0x0d, 0x2f, 0x04, 0x0b,
	0x24, 0xf3, 0x39, 0x5e, 0x59, 0xec, 0xdb, 0xdc, 0x31, 0x50, 0x0f, 0x2a, 0x81, 0xf0, 0x2f, 0x99,
	0x47, 0x6d, 0x36, 0x4d, 0x0c, 0x14, 0x1b, 0xb9, 0x96, 0xb9, 0xdb, 0xd4, 0x97, 0x73, 0xf7, 0x2e,
	0xda, 0x47, 0x1a, 0xd5, 0x4f, 0x40, 0x5d, 0x2e, 0x45, 0x6c, 0x95, 0x83, 0xb9, 0x14, 0xfa, 0x0a,
	0xab, 0x33, 0xa1, 0x31, 0xe1, 0x9c, 0x0a, 0x5c, 0x52, 0x4a, 0xaf, 0x1f, 0x52, 0x3a, 0x50, 0x28,
	0x2d, 0x35, 0xf3, 0xa0, 0x73, 0xe8, 0x07, 0x6c, 0x24, 0xc6, 0x39, 0xf5, 0x6c, 0xff, 0xf2, 0xd2,
	0x63, 0x7c, 0x66, 0x0e, 0x94, 0xe4, 0xdb, 0x8c, 0xe4, 0xa1, 0x46, 0x8f, 0x34, 0x78, 0xce, 0xe3,
	0xff, 0x17, 0xd9, 0x4a, 0xdd, 0x82, 0x5a, 0x66, 0x1a, 0x54, 0x85, 0xdc, 0x15, 0x8d, 0xd3, 0x37,
	0x9f, 0x1c, 0xd1, 0x1b, 0xc8, 0x5f, 0x13, 0x2f, 0xa2, 0xe9, 0x83, 0xaf, 0xe9, 0xae, 0x8a, 0x32,
	0xbb, 0x7b, 0x55, 0xdf, 0x5f, 0x7a, 0x6f, 0xd4, 0x8f, 0x01, 0x65, 0xe7, 0x7a, 0xaa, 0xe8, 0x39,
	0xe0, 0x87, 0x26, 0x7b, 0xa2, 0xf4, 0x7e, 0xed, 0xf7, 0x1f, 0x5c, 0x91, 0x94, 0x4c, 0xb7, 0x99,
	0x43, 0xb9, 0x64, 0x32, 0x6e, 0xf6, 0x20, 0xaf, 0xaf, 0xf2, 0x19, 0x14, 0x5c, 0xca, 0x26, 0xae,
	0x54, 0xea, 0x15, 0x2b, 0x8d, 0xd0, 0x3a, 0xe4, 0x6f, 0x98, 0x23, 0x5d, 0xd5, 0xa0, 0x62, 0xe9,
	0x20, 0x31, 0x12, 0x09, 0x4f, 0xfd, 0x96, 0x25, 0x2b, 0x39, 0x36, 0x7f, 0x19, 0x60, 0xce, 0xb5,
	0x45, 0x18, 0x56, 0xf4, 0x92, 0xd2, 0x2b, 0xa5, 0x68, 0xcd, 0x42, 0xf4, 0xea, 0xbe, 0x65, 0x73,
	0xce, 0x72, 0x6a, 0x16, 0x35, 0xa1, 0xe2, 0x92, 0xd0, 0xf6, 0x3d, 0xc7, 0xd6, 0xd0, 0x9c, 0x92,
	0x30, 0x5d, 0x12, 0x8e, 0x3c, 0xe7, 0x4c, 0x61, 0x5a, 0x50, 0xba, 0xab, 0x2f, 0x67, 0xa5, 0x8a,
	0x7e, 0x8a, 0x7c, 0x77, 0x05, 0x6b, 0xff, 0x2c, 0x1c, 0xb4, 0x05, 0xcf, 0x07, 0xa3, 0x5e, 0x7f,
	0x68, 0x1f, 0x7e, 0xe9, 0x0c, 0x7b, 0x5d, 0xfb, 0xe4, 0xfc, 0xa8, 0x6b, 0xf7, 0x87, 0x67, 0x9d,
	0x41, 0xff, 0x73, 0xf5, 0x3f, 0xf4, 0x12, 0x70, 0xb6, 0x3c, 0x1c, 0x59, 0xdf, 0x3a, 0x83, 0xaa,
	0x81, 0x5e, 0xc0, 0x66, 0xb6, 0x6a, 0x75, 0x8f, 0xbb, 0x27, 0xd5, 0xa5, 0x83, 0xc2, 0x77, 0xb5,
	0x8e, 0xc7, 0x05, 0xb5, 0x68, 0xf7, 0xfe, 0x06, 0x00, 0x00, 0xff, 0xff, 0x33, 0x82, 0x2b, 0xe9,
	0xb0, 0x05, 0x00, 0x00,
}
