# twirpserviceslohook
[![GoDoc](https://img.shields.io/badge/godoc-reference-5272B4.svg?style=flat-square)](https://godoc.internal.justin.tv/code.justin.tv/hygienic/twirpserviceslohook)
[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=hygienic/twirpserviceslohook/master)](https://jenkins.internal.justin.tv/job/hygienic/job/twirpserviceslohook/job/master/)

twirpserviceslohook helps track twirp SLO metrics

# Example

```go
	stat := &statsd.NoopClient{}
	t := twirpserviceslohook.TwirpSLOTracker {
		SLO: map[twirpserviceslohook.ServiceName]map[twirpserviceslohook.MethodName]time.Duration{
			"Haberdasher": {
				"MakeHat": time.Millisecond * 50,
			},
		},
		DefaultSLO: time.Millisecond * 100,
		StatTracker: &statsdslo.StatTracker {
			Statter: stat,
		},
	}
	rpc.NewHaberdasherServer(nil, t.ServerHook())
```