package usernotice

import (
	"context"

	"code.justin.tv/commerce/pantheon/rpc/pantheonrpc"
	rediser "code.justin.tv/identity/rediser/client"
	"code.justin.tv/revenue/subscriptions/internal/app/gifts"
	"code.justin.tv/revenue/subscriptions/internal/app/products"
	"code.justin.tv/revenue/subscriptions/internal/clients/tmi"
	substwirp "code.justin.tv/revenue/subscriptions/twirp"
	userservice "code.justin.tv/web/users-service/client/usersclient_internal"
)

// UserNotifier contains methods to send user notices to Twitch IRC for events such as channel
// subscriptions and gift->paid upgrade conversions.
type UserNotifier interface {
	// PaidUpgrade will determine whether to send a user notice for a paid upgrade, what kind
	// of user notice to send, and will send the user notice.
	PaidUpgrade(ctx context.Context, baseSubKey *substwirp.SubKey) error
}

// TMIUserNotifier implements the UserNotifier interface using the TMI service.
type TMIUserNotifier struct {
	rediser     rediser.Handler
	gifts       gifts.Gifts
	pantheon    pantheonrpc.Pantheon
	tmi         tmi.Client
	products    products.Products
	userService userservice.InternalClient
}

type NewTMIUserNotifierParams struct {
	Rediser     rediser.Handler
	Gifts       gifts.Gifts
	Pantheon    pantheonrpc.Pantheon
	TMI         tmi.Client
	Products    products.Products
	UserService userservice.InternalClient
}

func NewTMIUserNotifier(params NewTMIUserNotifierParams) *TMIUserNotifier {
	return &TMIUserNotifier{
		rediser:     params.Rediser,
		gifts:       params.Gifts,
		pantheon:    params.Pantheon,
		tmi:         params.TMI,
		products:    params.Products,
		userService: params.UserService,
	}
}
