// Code generated by protoc-gen-twirp v4.7.0, DO NOT EDIT.
// source: twirp/subscriptions.proto

/*
Package substwirp is a generated twirp stub package.
This code was generated with code.justin.tv/common/twirp/protoc-gen-twirp v4.7.0.

It is generated from these files:
	twirp/subscriptions.proto
*/
package substwirp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/timestamp"

import bytes "bytes"
import context "golang.org/x/net/context"
import http "net/http"
import ioutil "io/ioutil"
import jsonpb "github.com/golang/protobuf/jsonpb"
import log "log"
import proto1 "github.com/golang/protobuf/proto"
import twirp "code.justin.tv/common/twirp"
import fmt1 "fmt"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import strings "strings"
import json "encoding/json"
import url "net/url"
import ctxhttp "golang.org/x/net/context/ctxhttp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// =======================
// Subscriptions Interface
// =======================

type Subscriptions interface {
	// Subscriptions
	// =============
	// FulfillSubscription creates/upgrades subscription for user to product.
	FulfillSubscription(context.Context, *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error)

	// CreateSubscription creates a new subscription without the extra steps that FulfillSubscription
	// does, such as creating chat notification tokens. CreateSubscription is called by
	// FulfillSubscription as one of its steps.
	// The following steps will be executed during CreateSubscription:
	//   Lock using redis
	//   CanSubscribe?
	//   Create subscription entitlement
	//   Send entitlementSNS
	//   Unlock
	CreateSubscription(context.Context, *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error)

	// CancelSubscription cancels user's subscription to product.
	CancelSubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error)

	// UpdateSubscription updates user's subscription to product.
	// The following steps will be executed during UpdateSubscription:
	//   Update subscription entitlement
	//   Send entitlementSNS
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error)

	// CanSubscribe returns whether user can subscribe to product for a given platform.
	CanSubscribe(context.Context, *CanSubscribeRequest) (*CanSubscribeResponse, error)

	// ListUserSubscriptions returns a paginated list of user's active subscriptions.
	ListUserSubscriptions(context.Context, *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error)

	// ListUserExpiredSubscriptions returns a list of user's expired subscriptions sorted by most recently expired. An expired sub refers to the most recent ticket - that is not active.
	ListUserExpiredSubscriptions(context.Context, *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error)

	// GetUserChannelSubscriptionWithPaymentsData returns the highest max tier active subscription with payments data for an owner channel pair.
	GetUserChannelSubscriptionWithPaymentsData(context.Context, *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error)

	// GetUserSubscriptions returns the list of all a user's active subscriptions without payment data. Will return highest tier sub per channel.
	GetUserSubscriptions(context.Context, *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error)

	// GetUserChannelSubscription returns the highest max tier active subscription without payments data for a user channel pair.
	// This should be used when you need to know if a user channel pair is subscribed.
	GetUserChannelSubscription(context.Context, *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error)

	// GetUserSubscriptions returns the list of a user's active subscriptions without payments data given a list of product_ids.
	GetUserProductSubscriptions(context.Context, *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error)

	// GetUserProductSubscriptionWithPaymentsData returns the list of a user's active subscriptions with payments data given a list of product_ids
	GetUserProductSubscriptionsWithPaymentsData(context.Context, *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error)

	// GetChannelSubscriptions returns a paginated list of active subscribers to a channel.
	GetChannelSubscriptions(context.Context, *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error)

	// GetFormerSubscribers returns a paginated list of former subscribers to a channel.
	// This API is not sorted, going through paginated results might result in duplicates/missing entries.
	// Limit is capped at 1000
	GetFormerSubscribers(context.Context, *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error)

	// GetSubscriptionByID returns a Subscription given a Owner, Product, and Origin or a TicketID.
	// Prefer to use Owner, Product, Origin if possible as TicketID will not be supported in the future.
	GetSubscriptionByID(context.Context, *GetSubscriptionByIDRequest) (*GetSubscriptionByIDResponse, error)

	// Subscriber Badges
	// =====
	// TakedownBadges takes down one or more custom subscriber badges belonging to a broadcaster
	TakedownBadges(context.Context, *TakedownBadgesRequest) (*TakedownBadgesResponse, error)

	// TakedownAllBadges takes down all badges belonging to a broadcaster
	TakedownAllBadges(context.Context, *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error)

	// GetSubscriberBadge returns the correctly subscription tenure based badge for a channel and user pair
	GetSubscriberBadge(context.Context, *GetSubscriberBadgeRequest) (*GetSubscriberBadgeResponse, error)

	// Score
	// =====
	// SetScore sets the subscription high score given a channel and current score.
	SetScore(context.Context, *SetScoreRequest) (*SetScoreResponse, error)

	// CalculateSubscriberScore returns the subscriber score given their channel id.
	CalculateSubscriberCount(context.Context, *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error)

	// ChatNotification
	// =====
	// CreateChatNotificationToken creates a chat notification token
	CreateChatNotificationToken(context.Context, *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error)

	// UseChatNotificationToken posts a chat notification token, marks it as used given a token_id.
	UseChatNotificationToken(context.Context, *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error)

	// CancelChatNotificationToken invalidates a chat notification token, given a subscription_id.
	CancelChatNotificationToken(context.Context, *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error)

	// GetAvailableTokens gets all the tokens that are available that belong to a user and channel.
	GetUserChannelChatNotificationToken(context.Context, *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error)

	// GetAllUsedChatNotificationTokens returns a historical list of a user's used chat notification tokens sorted by createdAt date to a channel.
	GetAllUsedChatNotificationTokens(context.Context, *GetAllUsedChatNotificationTokensRequest) (*GetAllUsedChatNotificationTokensResponse, error)

	AllowReplayForLastUsedChatNotificationToken(context.Context, *AllowReplayForLastUsedChatNotificationTokenRequest) (*AllowReplayForLastUsedChatNotificationTokenResponse, error)

	// UserSettings
	// ============
	// GetUserSettings gets the user subscription settings.
	GetUserSettings(context.Context, *GetUserSettingsRequest) (*GetUserSettingsResponse, error)

	// SetUserSettings sets the user subscription settings.
	SetUserSettings(context.Context, *SetUserSettingsRequest) (*SetUserSettingsResponse, error)

	// External Product
	// ================
	// GetExternalProductTemplateSKU returns a template SKU which can be used to fetch external product's attributes
	// from third party subscription providers like Apple, Google.
	GetExternalProductTemplateSKU(context.Context, *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error)

	// GetExternalProductPurchasableSKU does subscription eligibility checks and returns SKU for purchase from
	// external subscriptions providers (e.g, Apple, Google)
	GetExternalProductPurchasableSKU(context.Context, *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error)

	// Paid Upgrades
	// =======
	// GetPaidUpgrades returns a list of paid upgrades from a list of subKeys.
	GetPaidUpgrades(context.Context, *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error)

	// FulfillPaidUpgrade creates a Subscription and a Paid Upgrade.
	FulfillPaidUpgrade(context.Context, *FulfillPaidUpgradeRequest) (*FulfillPaidUpgradeResponse, error)

	// CreatePaidUpgrades creates a paid upgrade from a subKey.
	CreatePaidUpgrade(context.Context, *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error)

	// CancelPaidUpgrade cancels the paid upgrade from a subKey.
	CancelPaidUpgrade(context.Context, *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error)

	// Gifts
	// ======
	// CreateGift creates a new gift record in the gifts table if product is valid and sender/recipient are eligibile. Also sends notifications about the new gift.
	CreateGift(context.Context, *CreateGiftRequest) (*CreateGiftResponse, error)

	// InsertGift creates a new gift record in the gifts table without checking product, eligibilty or sending notifications.
	InsertGift(context.Context, *InsertGiftRequest) (*InsertGiftResponse, error)

	// CancelGift cancels a subscription gift.
	CancelGift(context.Context, *CancelGiftRequest) (*CancelGiftResponse, error)

	// GetGifts determines if there are gifts associated with supplied POODs.
	GetGifts(context.Context, *GetGiftsRequest) (*GetGiftsResponse, error)

	// CanGift determines if a sender can gift a subscription to a recipient.
	CanGift(context.Context, *CanGiftRequest) (*CanGiftResponse, error)

	// GetGiftPromotion returns the active gift promotion for subscription products.
	GetGiftPromotion(context.Context, *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error)

	// GetPaidUpgradePromotion returns the active gift promotion for a user's subscription products
	GetPaidUpgradePromotion(context.Context, *GetPaidUpgradePromotionRequest) (*GetPaidUpgradePromotionResponse, error)

	// CanSenderGift determines if a sender is allowed to gift to recipients
	CanSenderGift(context.Context, *CanSenderGiftRequest) (*CanSenderGiftResponse, error)

	// CanGiftRecipient determines if a recipient is allowed to receive a gift from a particular sender depending on the type of gift.
	CanGiftRecipient(context.Context, *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error)

	// FulfillGifts asynchronously entitles gift subscription for a given request.
	FulfillGifts(context.Context, *FulfillGiftsRequest) (*FulfillGiftsResponse, error)

	// SendGiftChatNotification sends a chat notification indicating the recipient has been gifted a sub.
	SendGiftChatNotification(context.Context, *SendGiftChatNotificationRequest) (*SendGiftChatNotificationResponse, error)

	// SendMMGChatNotification sends a chat notification indicating the sender has gifted a sub to a recipient.
	SendMMGChatNotification(context.Context, *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error)

	// SendMMGStartChatNotification sends a chat notification that indicates the start of a mass mystery gift.
	SendMMGStartChatNotification(context.Context, *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error)

	// GetRelatedChannels gets related channels to a product.
	GetRelatedChannels(context.Context, *GetRelatedChannelsRequest) (*GetRelatedChannelsResponse, error)

	// Emoticons
	// ======
	// GetEmotePrefix gets the emote prefix for a given channel ID.
	GetEmotePrefix(context.Context, *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error)

	// CreateEmoticon creates a subscription emoticon.
	CreateEmoticon(context.Context, *CreateEmoticonRequest) (*CreateEmoticonReponse, error)

	GetAllEmoticonsByProductIDs(context.Context, *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error)

	// Get standing status of a user. Can be "in good standing" or "not in good standing".
	// Partners are considered to be in “good standing” if they have not had a conduct infraction within the last 90 days.
	GetPartnerStanding(context.Context, *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error)

	// GetEmoticonPrefix returns the emote prefix and prefix state for a given channel ID.
	GetEmoticonPrefix(context.Context, *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error)

	// SubmitEmoticonPrefix is used when a new partner has a blank emoticon prefix and wants to submit
	// a prefix for approval. Will return precondition failed if the user does not have a blank prefix.
	SubmitEmoticonPrefix(context.Context, *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error)

	// Pending Emoticons
	// ======
	// GetPendingEmoticonByID returns a particular pending emoticon for use in the aegis GQL loader
	GetPendingEmoticonsByIDs(context.Context, *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error)

	// GetPendingEmoticons returns an array of pending emoticons for the moderation team's approval flow.
	GetPendingEmoticons(context.Context, *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error)

	// ReviewPendingEmoticons accepts an array of approve or reject actions and either approves or rejects each emoticon
	ReviewPendingEmoticons(context.Context, *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error)

	// Products
	// =========
	// GetProductsByIDs returns a list of products given a list of product ids.
	// Max size of 100 ids.
	GetProductsByIDs(context.Context, *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error)

	// GetProductsByNames returns a list of products given a list of product short names with length x, 0 < x <=100.
	GetProductsByNames(context.Context, *GetProductsByNamesRequest) (*GetProductsByNamesResponse, error)

	// GetChannelProducts accepts a channelID and returns a list of active products owned by the channel.
	// If the channel belongs to a teamsub, it will return the teamsub product.
	GetChannelProducts(context.Context, *GetChannelProductsRequest) (*GetChannelProductsResponse, error)

	// UpdateProduct updates the fields of the given product.
	UpdateProduct(context.Context, *UpdateProductRequest) (*UpdateProductResponse, error)

	// Updates all products for a given channel.
	UpdateChannelProducts(context.Context, *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error)

	// EmailSubscribers publishes to a queue to initiate the email process.
	EmailSubscribers(context.Context, *EmailSubscribersRequest) (*EmailSubscribersResponse, error)

	EmailGlobalEmote(context.Context, *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error)

	EmailPendingPrefixApproval(context.Context, *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error)

	// Tickets
	// ========
	// GetTicketsForUserChannel returns the tickets for a particular user/channel.
	// This is not paginated but will return a failure if there are more than 150.
	// (only 6 user/channel pairs have more than 150 as of 12/13/2018 and all are test accounts or banned)
	GetTicketsForUserChannel(context.Context, *GetTicketsForUserChannelRequest) (*GetTicketsForUserChannelResponse, error)
}

// =============================
// Subscriptions Protobuf Client
// =============================

type subscriptionsProtobufClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsProtobufClient creates a Protobuf client that implements the Subscriptions interface.
// It communicates using protobuf messages and can be configured with a custom http.Client.
func NewSubscriptionsProtobufClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsProtobufClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsProtobufClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateSubscription"
	out := new(CreateSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateSubscription"
	out := new(UpdateSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserExpiredSubscriptions"
	out := new(ListUserExpiredSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptionsWithPaymentsData"
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelSubscriptions"
	out := new(GetChannelSubscriptionsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetFormerSubscribers(ctx context.Context, in *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetFormerSubscribers"
	out := new(GetFormerSubscribersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetSubscriptionByID(ctx context.Context, in *GetSubscriptionByIDRequest) (*GetSubscriptionByIDResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriptionByID"
	out := new(GetSubscriptionByIDResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) TakedownBadges(ctx context.Context, in *TakedownBadgesRequest) (*TakedownBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownBadges"
	out := new(TakedownBadgesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) TakedownAllBadges(ctx context.Context, in *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownAllBadges"
	out := new(TakedownAllBadgesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetSubscriberBadge(ctx context.Context, in *GetSubscriberBadgeRequest) (*GetSubscriberBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriberBadge"
	out := new(GetSubscriberBadgeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetAllUsedChatNotificationTokens(ctx context.Context, in *GetAllUsedChatNotificationTokensRequest) (*GetAllUsedChatNotificationTokensResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllUsedChatNotificationTokens"
	out := new(GetAllUsedChatNotificationTokensResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) AllowReplayForLastUsedChatNotificationToken(ctx context.Context, in *AllowReplayForLastUsedChatNotificationTokenRequest) (*AllowReplayForLastUsedChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "AllowReplayForLastUsedChatNotificationToken"
	out := new(AllowReplayForLastUsedChatNotificationTokenResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) FulfillPaidUpgrade(ctx context.Context, in *FulfillPaidUpgradeRequest) (*FulfillPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillPaidUpgrade"
	out := new(FulfillPaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateGift(ctx context.Context, in *CreateGiftRequest) (*CreateGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateGift"
	out := new(CreateGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) InsertGift(ctx context.Context, in *InsertGiftRequest) (*InsertGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "InsertGift"
	out := new(InsertGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPaidUpgradePromotion(ctx context.Context, in *GetPaidUpgradePromotionRequest) (*GetPaidUpgradePromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgradePromotion"
	out := new(GetPaidUpgradePromotionResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanSenderGift(ctx context.Context, in *CanSenderGiftRequest) (*CanSenderGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSenderGift"
	out := new(CanSenderGiftResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CanGiftRecipient(ctx context.Context, in *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGiftRecipient"
	out := new(CanGiftRecipientResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) FulfillGifts(ctx context.Context, in *FulfillGiftsRequest) (*FulfillGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillGifts"
	out := new(FulfillGiftsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendGiftChatNotification(ctx context.Context, in *SendGiftChatNotificationRequest) (*SendGiftChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendGiftChatNotification"
	out := new(SendGiftChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendMMGChatNotification(ctx context.Context, in *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGChatNotification"
	out := new(SendMMGChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SendMMGStartChatNotification(ctx context.Context, in *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGStartChatNotification"
	out := new(SendMMGStartChatNotificationResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetRelatedChannels(ctx context.Context, in *GetRelatedChannelsRequest) (*GetRelatedChannelsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetRelatedChannels"
	out := new(GetRelatedChannelsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticonsByIDs(ctx context.Context, in *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs"
	out := new(GetPendingEmoticonsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) ReviewPendingEmoticons(ctx context.Context, in *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ReviewPendingEmoticons"
	out := new(ReviewPendingEmoticonsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetProductsByNames(ctx context.Context, in *GetProductsByNamesRequest) (*GetProductsByNamesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByNames"
	out := new(GetProductsByNamesResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailSubscribers(ctx context.Context, in *EmailSubscribersRequest) (*EmailSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailSubscribers"
	out := new(EmailSubscribersResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailGlobalEmote(ctx context.Context, in *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailGlobalEmote"
	out := new(EmailGlobalEmoteResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) EmailPendingPrefixApproval(ctx context.Context, in *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailPendingPrefixApproval"
	out := new(EmailPendingPrefixApprovalResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsProtobufClient) GetTicketsForUserChannel(ctx context.Context, in *GetTicketsForUserChannelRequest) (*GetTicketsForUserChannelResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTicketsForUserChannel"
	out := new(GetTicketsForUserChannelResponse)
	err := doProtoRequest(ctx, c.client, url, in, out)
	return out, err
}

// =========================
// Subscriptions JSON Client
// =========================

type subscriptionsJSONClient struct {
	urlBase string
	client  *http.Client
}

// NewSubscriptionsJSONClient creates a JSON client that implements the Subscriptions interface.
// It communicates using JSON requests and responses instead of protobuf messages.
func NewSubscriptionsJSONClient(addr string, client *http.Client) Subscriptions {
	return &subscriptionsJSONClient{
		urlBase: urlBase(addr),
		client:  withoutRedirects(client),
	}
}

func (c *subscriptionsJSONClient) FulfillSubscription(ctx context.Context, in *FulfillSubscriptionRequest) (*FulfillSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillSubscription"
	out := new(FulfillSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest) (*CreateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateSubscription"
	out := new(CreateSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelSubscription(ctx context.Context, in *CancelSubscriptionRequest) (*CancelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelSubscription"
	out := new(CancelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest) (*UpdateSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateSubscription"
	out := new(UpdateSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSubscribe(ctx context.Context, in *CanSubscribeRequest) (*CanSubscribeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSubscribe"
	out := new(CanSubscribeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ListUserSubscriptions(ctx context.Context, in *ListUserSubscriptionsRequest) (*ListUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserSubscriptions"
	out := new(ListUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ListUserExpiredSubscriptions(ctx context.Context, in *ListUserExpiredSubscriptionsRequest) (*ListUserExpiredSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ListUserExpiredSubscriptions"
	out := new(ListUserExpiredSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, in *GetUserChannelSubscriptionWithPaymentsDataRequest) (*GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData"
	out := new(GetUserChannelSubscriptionWithPaymentsDataResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSubscriptions(ctx context.Context, in *GetUserSubscriptionsRequest) (*GetUserSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSubscriptions"
	out := new(GetUserSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelSubscription(ctx context.Context, in *GetUserChannelSubscriptionRequest) (*GetUserChannelSubscriptionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelSubscription"
	out := new(GetUserChannelSubscriptionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserProductSubscriptions(ctx context.Context, in *GetUserProductSubscriptionsRequest) (*GetUserProductSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptions"
	out := new(GetUserProductSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserProductSubscriptionsWithPaymentsData(ctx context.Context, in *GetUserProductSubscriptionsWithPaymentsDataRequest) (*GetUserProductSubscriptionsWithPaymentsDataResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserProductSubscriptionsWithPaymentsData"
	out := new(GetUserProductSubscriptionsWithPaymentsDataResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelSubscriptions(ctx context.Context, in *GetChannelSubscriptionsRequest) (*GetChannelSubscriptionsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelSubscriptions"
	out := new(GetChannelSubscriptionsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetFormerSubscribers(ctx context.Context, in *GetFormerSubscribersRequest) (*GetFormerSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetFormerSubscribers"
	out := new(GetFormerSubscribersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetSubscriptionByID(ctx context.Context, in *GetSubscriptionByIDRequest) (*GetSubscriptionByIDResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriptionByID"
	out := new(GetSubscriptionByIDResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) TakedownBadges(ctx context.Context, in *TakedownBadgesRequest) (*TakedownBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownBadges"
	out := new(TakedownBadgesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) TakedownAllBadges(ctx context.Context, in *TakedownAllBadgesRequest) (*TakedownAllBadgesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "TakedownAllBadges"
	out := new(TakedownAllBadgesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetSubscriberBadge(ctx context.Context, in *GetSubscriberBadgeRequest) (*GetSubscriberBadgeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetSubscriberBadge"
	out := new(GetSubscriberBadgeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetScore(ctx context.Context, in *SetScoreRequest) (*SetScoreResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetScore"
	out := new(SetScoreResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CalculateSubscriberCount(ctx context.Context, in *CalculateSubscriberCountRequest) (*CalculateSubscriberCountResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CalculateSubscriberCount"
	out := new(CalculateSubscriberCountResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateChatNotificationToken(ctx context.Context, in *CreateChatNotificationTokenRequest) (*CreateChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateChatNotificationToken"
	out := new(CreateChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UseChatNotificationToken(ctx context.Context, in *UseChatNotificationTokenRequest) (*UseChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UseChatNotificationToken"
	out := new(UseChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelChatNotificationToken(ctx context.Context, in *CancelChatNotificationTokenRequest) (*CancelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelChatNotificationToken"
	out := new(CancelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserChannelChatNotificationToken(ctx context.Context, in *GetUserChannelChatNotificationTokenRequest) (*GetUserChannelChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken"
	out := new(GetUserChannelChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetAllUsedChatNotificationTokens(ctx context.Context, in *GetAllUsedChatNotificationTokensRequest) (*GetAllUsedChatNotificationTokensResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllUsedChatNotificationTokens"
	out := new(GetAllUsedChatNotificationTokensResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) AllowReplayForLastUsedChatNotificationToken(ctx context.Context, in *AllowReplayForLastUsedChatNotificationTokenRequest) (*AllowReplayForLastUsedChatNotificationTokenResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "AllowReplayForLastUsedChatNotificationToken"
	out := new(AllowReplayForLastUsedChatNotificationTokenResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetUserSettings(ctx context.Context, in *GetUserSettingsRequest) (*GetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetUserSettings"
	out := new(GetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SetUserSettings(ctx context.Context, in *SetUserSettingsRequest) (*SetUserSettingsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SetUserSettings"
	out := new(SetUserSettingsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductTemplateSKU(ctx context.Context, in *GetExternalProductTemplateSKURequest) (*GetExternalProductTemplateSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductTemplateSKU"
	out := new(GetExternalProductTemplateSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetExternalProductPurchasableSKU(ctx context.Context, in *GetExternalProductPurchasableSKURequest) (*GetExternalProductPurchasableSKUResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU"
	out := new(GetExternalProductPurchasableSKUResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPaidUpgrades(ctx context.Context, in *GetPaidUpgradesRequest) (*GetPaidUpgradesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgrades"
	out := new(GetPaidUpgradesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) FulfillPaidUpgrade(ctx context.Context, in *FulfillPaidUpgradeRequest) (*FulfillPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillPaidUpgrade"
	out := new(FulfillPaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreatePaidUpgrade(ctx context.Context, in *CreatePaidUpgradeRequest) (*CreatePaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreatePaidUpgrade"
	out := new(CreatePaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelPaidUpgrade(ctx context.Context, in *CancelPaidUpgradeRequest) (*CancelPaidUpgradeResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelPaidUpgrade"
	out := new(CancelPaidUpgradeResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateGift(ctx context.Context, in *CreateGiftRequest) (*CreateGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateGift"
	out := new(CreateGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) InsertGift(ctx context.Context, in *InsertGiftRequest) (*InsertGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "InsertGift"
	out := new(InsertGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CancelGift(ctx context.Context, in *CancelGiftRequest) (*CancelGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CancelGift"
	out := new(CancelGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGifts(ctx context.Context, in *GetGiftsRequest) (*GetGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGifts"
	out := new(GetGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGift(ctx context.Context, in *CanGiftRequest) (*CanGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGift"
	out := new(CanGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetGiftPromotion(ctx context.Context, in *GetGiftPromotionRequest) (*GetGiftPromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetGiftPromotion"
	out := new(GetGiftPromotionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPaidUpgradePromotion(ctx context.Context, in *GetPaidUpgradePromotionRequest) (*GetPaidUpgradePromotionResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPaidUpgradePromotion"
	out := new(GetPaidUpgradePromotionResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanSenderGift(ctx context.Context, in *CanSenderGiftRequest) (*CanSenderGiftResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanSenderGift"
	out := new(CanSenderGiftResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CanGiftRecipient(ctx context.Context, in *CanGiftRecipientRequest) (*CanGiftRecipientResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CanGiftRecipient"
	out := new(CanGiftRecipientResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) FulfillGifts(ctx context.Context, in *FulfillGiftsRequest) (*FulfillGiftsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "FulfillGifts"
	out := new(FulfillGiftsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendGiftChatNotification(ctx context.Context, in *SendGiftChatNotificationRequest) (*SendGiftChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendGiftChatNotification"
	out := new(SendGiftChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendMMGChatNotification(ctx context.Context, in *SendMMGChatNotificationRequest) (*SendMMGChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGChatNotification"
	out := new(SendMMGChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SendMMGStartChatNotification(ctx context.Context, in *SendMMGStartChatNotificationRequest) (*SendMMGStartChatNotificationResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SendMMGStartChatNotification"
	out := new(SendMMGStartChatNotificationResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetRelatedChannels(ctx context.Context, in *GetRelatedChannelsRequest) (*GetRelatedChannelsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetRelatedChannels"
	out := new(GetRelatedChannelsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmotePrefix(ctx context.Context, in *GetEmotePrefixRequest) (*GetEmotePrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmotePrefix"
	out := new(GetEmotePrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) CreateEmoticon(ctx context.Context, in *CreateEmoticonRequest) (*CreateEmoticonReponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "CreateEmoticon"
	out := new(CreateEmoticonReponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetAllEmoticonsByProductIDs(ctx context.Context, in *GetAllEmoticonsByProductIDsRequest) (*GetAllEmoticonsByProductIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs"
	out := new(GetAllEmoticonsByProductIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPartnerStanding(ctx context.Context, in *GetPartnerStandingRequest) (*GetPartnerStandingResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPartnerStanding"
	out := new(GetPartnerStandingResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetEmoticonPrefix(ctx context.Context, in *GetEmoticonPrefixRequest) (*GetEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetEmoticonPrefix"
	out := new(GetEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) SubmitEmoticonPrefix(ctx context.Context, in *SubmitEmoticonPrefixRequest) (*SubmitEmoticonPrefixResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "SubmitEmoticonPrefix"
	out := new(SubmitEmoticonPrefixResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticonsByIDs(ctx context.Context, in *GetPendingEmoticonsByIDsRequest) (*GetPendingEmoticonsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs"
	out := new(GetPendingEmoticonsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetPendingEmoticons(ctx context.Context, in *GetPendingEmoticonsRequest) (*GetPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetPendingEmoticons"
	out := new(GetPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) ReviewPendingEmoticons(ctx context.Context, in *ReviewPendingEmoticonsRequest) (*ReviewPendingEmoticonsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "ReviewPendingEmoticons"
	out := new(ReviewPendingEmoticonsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetProductsByIDs(ctx context.Context, in *GetProductsByIDsRequest) (*GetProductsByIDsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByIDs"
	out := new(GetProductsByIDsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetProductsByNames(ctx context.Context, in *GetProductsByNamesRequest) (*GetProductsByNamesResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetProductsByNames"
	out := new(GetProductsByNamesResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetChannelProducts(ctx context.Context, in *GetChannelProductsRequest) (*GetChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetChannelProducts"
	out := new(GetChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest) (*UpdateProductResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateProduct"
	out := new(UpdateProductResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) UpdateChannelProducts(ctx context.Context, in *UpdateChannelProductsRequest) (*UpdateChannelProductsResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "UpdateChannelProducts"
	out := new(UpdateChannelProductsResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailSubscribers(ctx context.Context, in *EmailSubscribersRequest) (*EmailSubscribersResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailSubscribers"
	out := new(EmailSubscribersResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailGlobalEmote(ctx context.Context, in *EmailGlobalEmoteRequest) (*EmailGlobalEmoteResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailGlobalEmote"
	out := new(EmailGlobalEmoteResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) EmailPendingPrefixApproval(ctx context.Context, in *EmailPendingPrefixApprovalRequest) (*EmailPendingPrefixApprovalResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "EmailPendingPrefixApproval"
	out := new(EmailPendingPrefixApprovalResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

func (c *subscriptionsJSONClient) GetTicketsForUserChannel(ctx context.Context, in *GetTicketsForUserChannelRequest) (*GetTicketsForUserChannelResponse, error) {
	url := c.urlBase + SubscriptionsPathPrefix + "GetTicketsForUserChannel"
	out := new(GetTicketsForUserChannelResponse)
	err := doJSONRequest(ctx, c.client, url, in, out)
	return out, err
}

// ============================
// Subscriptions Server Handler
// ============================

type subscriptionsServer struct {
	Subscriptions
	hooks     *twirp.ServerHooks
	ctxSource ContextSource
}

func NewSubscriptionsServer(svc Subscriptions, hooks *twirp.ServerHooks, ctxSrc ContextSource) TwirpServer {
	defaultHooks := twirp.NewServerHooks()
	if hooks == nil {
		hooks = defaultHooks
	} else {
		if hooks.RequestReceived == nil {
			hooks.RequestReceived = defaultHooks.RequestReceived
		}
		if hooks.RequestRouted == nil {
			hooks.RequestRouted = defaultHooks.RequestRouted
		}
		if hooks.ResponsePrepared == nil {
			hooks.ResponsePrepared = defaultHooks.ResponsePrepared
		}
		if hooks.ResponseSent == nil {
			hooks.ResponseSent = defaultHooks.ResponseSent
		}
		if hooks.Error == nil {
			hooks.Error = defaultHooks.Error
		}
	}
	if ctxSrc == nil {
		ctxSrc = RequestContextSource
	}

	return &subscriptionsServer{
		Subscriptions: svc,
		hooks:         hooks,
		ctxSource:     ctxSrc,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *subscriptionsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	// When handling v2 client requests, serve backwards-compatible error responses
	if version := getVersion(ctx); version == "v1" || version == "v2" {
		writeErrorPreV3(ctx, resp, err, s.hooks)
	} else {
		writeErrorPostV3(ctx, resp, err, s.hooks)
	}
}

// SubscriptionsPathPrefix is used for all URL paths on a twirp Subscriptions server.
// Requests are always: POST SubscriptionsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SubscriptionsPathPrefix = "/twirp/code.justin.tv.revenue.subscriptions.Subscriptions/"

// SubscriptionsPathPrefixOld is used to handle requests from v2 Clients.
// If you are using an HTTP mux, please handle this routes as well to upgrade from v2 to v3.
const SubscriptionsPathPrefixOld = "/v2/code.justin.tv.revenue.subscriptions.Subscriptions/"

func (s *subscriptionsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := s.ctxSource(resp, req)
	ctx = setServerName(ctx, "Subscriptions")
	ctx = setVersionFromPath(ctx, req.URL.Path)
	ctx = context.WithValue(ctx, "__tw_response_writer", resp) // for SetHTTPResponseHeader
	ctx = s.hooks.RequestReceived(ctx)

	if req.Method != "POST" {
		msg := fmt1.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}

	switch req.URL.Path {
	case SubscriptionsPathPrefix + "FulfillSubscription", SubscriptionsPathPrefixOld + "FulfillSubscription", "/v1/Subscriptions/FulfillSubscription":
		s.serveFulfillSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateSubscription", SubscriptionsPathPrefixOld + "CreateSubscription", "/v1/Subscriptions/CreateSubscription":
		s.serveCreateSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelSubscription", SubscriptionsPathPrefixOld + "CancelSubscription", "/v1/Subscriptions/CancelSubscription":
		s.serveCancelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateSubscription", SubscriptionsPathPrefixOld + "UpdateSubscription", "/v1/Subscriptions/UpdateSubscription":
		s.serveUpdateSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSubscribe", SubscriptionsPathPrefixOld + "CanSubscribe", "/v1/Subscriptions/CanSubscribe":
		s.serveCanSubscribe(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ListUserSubscriptions", SubscriptionsPathPrefixOld + "ListUserSubscriptions", "/v1/Subscriptions/ListUserSubscriptions":
		s.serveListUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ListUserExpiredSubscriptions", SubscriptionsPathPrefixOld + "ListUserExpiredSubscriptions", "/v1/Subscriptions/ListUserExpiredSubscriptions":
		s.serveListUserExpiredSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscriptionWithPaymentsData", SubscriptionsPathPrefixOld + "GetUserChannelSubscriptionWithPaymentsData", "/v1/Subscriptions/GetUserChannelSubscriptionWithPaymentsData":
		s.serveGetUserChannelSubscriptionWithPaymentsData(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSubscriptions", SubscriptionsPathPrefixOld + "GetUserSubscriptions", "/v1/Subscriptions/GetUserSubscriptions":
		s.serveGetUserSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelSubscription", SubscriptionsPathPrefixOld + "GetUserChannelSubscription", "/v1/Subscriptions/GetUserChannelSubscription":
		s.serveGetUserChannelSubscription(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserProductSubscriptions", SubscriptionsPathPrefixOld + "GetUserProductSubscriptions", "/v1/Subscriptions/GetUserProductSubscriptions":
		s.serveGetUserProductSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserProductSubscriptionsWithPaymentsData", SubscriptionsPathPrefixOld + "GetUserProductSubscriptionsWithPaymentsData", "/v1/Subscriptions/GetUserProductSubscriptionsWithPaymentsData":
		s.serveGetUserProductSubscriptionsWithPaymentsData(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelSubscriptions", SubscriptionsPathPrefixOld + "GetChannelSubscriptions", "/v1/Subscriptions/GetChannelSubscriptions":
		s.serveGetChannelSubscriptions(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetFormerSubscribers", SubscriptionsPathPrefixOld + "GetFormerSubscribers", "/v1/Subscriptions/GetFormerSubscribers":
		s.serveGetFormerSubscribers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetSubscriptionByID", SubscriptionsPathPrefixOld + "GetSubscriptionByID", "/v1/Subscriptions/GetSubscriptionByID":
		s.serveGetSubscriptionByID(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "TakedownBadges", SubscriptionsPathPrefixOld + "TakedownBadges", "/v1/Subscriptions/TakedownBadges":
		s.serveTakedownBadges(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "TakedownAllBadges", SubscriptionsPathPrefixOld + "TakedownAllBadges", "/v1/Subscriptions/TakedownAllBadges":
		s.serveTakedownAllBadges(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetSubscriberBadge", SubscriptionsPathPrefixOld + "GetSubscriberBadge", "/v1/Subscriptions/GetSubscriberBadge":
		s.serveGetSubscriberBadge(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetScore", SubscriptionsPathPrefixOld + "SetScore", "/v1/Subscriptions/SetScore":
		s.serveSetScore(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CalculateSubscriberCount", SubscriptionsPathPrefixOld + "CalculateSubscriberCount", "/v1/Subscriptions/CalculateSubscriberCount":
		s.serveCalculateSubscriberCount(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateChatNotificationToken", SubscriptionsPathPrefixOld + "CreateChatNotificationToken", "/v1/Subscriptions/CreateChatNotificationToken":
		s.serveCreateChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UseChatNotificationToken", SubscriptionsPathPrefixOld + "UseChatNotificationToken", "/v1/Subscriptions/UseChatNotificationToken":
		s.serveUseChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelChatNotificationToken", SubscriptionsPathPrefixOld + "CancelChatNotificationToken", "/v1/Subscriptions/CancelChatNotificationToken":
		s.serveCancelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserChannelChatNotificationToken", SubscriptionsPathPrefixOld + "GetUserChannelChatNotificationToken", "/v1/Subscriptions/GetUserChannelChatNotificationToken":
		s.serveGetUserChannelChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetAllUsedChatNotificationTokens", SubscriptionsPathPrefixOld + "GetAllUsedChatNotificationTokens", "/v1/Subscriptions/GetAllUsedChatNotificationTokens":
		s.serveGetAllUsedChatNotificationTokens(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "AllowReplayForLastUsedChatNotificationToken", SubscriptionsPathPrefixOld + "AllowReplayForLastUsedChatNotificationToken", "/v1/Subscriptions/AllowReplayForLastUsedChatNotificationToken":
		s.serveAllowReplayForLastUsedChatNotificationToken(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetUserSettings", SubscriptionsPathPrefixOld + "GetUserSettings", "/v1/Subscriptions/GetUserSettings":
		s.serveGetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SetUserSettings", SubscriptionsPathPrefixOld + "SetUserSettings", "/v1/Subscriptions/SetUserSettings":
		s.serveSetUserSettings(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductTemplateSKU", SubscriptionsPathPrefixOld + "GetExternalProductTemplateSKU", "/v1/Subscriptions/GetExternalProductTemplateSKU":
		s.serveGetExternalProductTemplateSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetExternalProductPurchasableSKU", SubscriptionsPathPrefixOld + "GetExternalProductPurchasableSKU", "/v1/Subscriptions/GetExternalProductPurchasableSKU":
		s.serveGetExternalProductPurchasableSKU(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPaidUpgrades", SubscriptionsPathPrefixOld + "GetPaidUpgrades", "/v1/Subscriptions/GetPaidUpgrades":
		s.serveGetPaidUpgrades(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "FulfillPaidUpgrade", SubscriptionsPathPrefixOld + "FulfillPaidUpgrade", "/v1/Subscriptions/FulfillPaidUpgrade":
		s.serveFulfillPaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreatePaidUpgrade", SubscriptionsPathPrefixOld + "CreatePaidUpgrade", "/v1/Subscriptions/CreatePaidUpgrade":
		s.serveCreatePaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelPaidUpgrade", SubscriptionsPathPrefixOld + "CancelPaidUpgrade", "/v1/Subscriptions/CancelPaidUpgrade":
		s.serveCancelPaidUpgrade(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateGift", SubscriptionsPathPrefixOld + "CreateGift", "/v1/Subscriptions/CreateGift":
		s.serveCreateGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "InsertGift", SubscriptionsPathPrefixOld + "InsertGift", "/v1/Subscriptions/InsertGift":
		s.serveInsertGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CancelGift", SubscriptionsPathPrefixOld + "CancelGift", "/v1/Subscriptions/CancelGift":
		s.serveCancelGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGifts", SubscriptionsPathPrefixOld + "GetGifts", "/v1/Subscriptions/GetGifts":
		s.serveGetGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGift", SubscriptionsPathPrefixOld + "CanGift", "/v1/Subscriptions/CanGift":
		s.serveCanGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetGiftPromotion", SubscriptionsPathPrefixOld + "GetGiftPromotion", "/v1/Subscriptions/GetGiftPromotion":
		s.serveGetGiftPromotion(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPaidUpgradePromotion", SubscriptionsPathPrefixOld + "GetPaidUpgradePromotion", "/v1/Subscriptions/GetPaidUpgradePromotion":
		s.serveGetPaidUpgradePromotion(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanSenderGift", SubscriptionsPathPrefixOld + "CanSenderGift", "/v1/Subscriptions/CanSenderGift":
		s.serveCanSenderGift(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CanGiftRecipient", SubscriptionsPathPrefixOld + "CanGiftRecipient", "/v1/Subscriptions/CanGiftRecipient":
		s.serveCanGiftRecipient(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "FulfillGifts", SubscriptionsPathPrefixOld + "FulfillGifts", "/v1/Subscriptions/FulfillGifts":
		s.serveFulfillGifts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendGiftChatNotification", SubscriptionsPathPrefixOld + "SendGiftChatNotification", "/v1/Subscriptions/SendGiftChatNotification":
		s.serveSendGiftChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendMMGChatNotification", SubscriptionsPathPrefixOld + "SendMMGChatNotification", "/v1/Subscriptions/SendMMGChatNotification":
		s.serveSendMMGChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SendMMGStartChatNotification", SubscriptionsPathPrefixOld + "SendMMGStartChatNotification", "/v1/Subscriptions/SendMMGStartChatNotification":
		s.serveSendMMGStartChatNotification(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetRelatedChannels", SubscriptionsPathPrefixOld + "GetRelatedChannels", "/v1/Subscriptions/GetRelatedChannels":
		s.serveGetRelatedChannels(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmotePrefix", SubscriptionsPathPrefixOld + "GetEmotePrefix", "/v1/Subscriptions/GetEmotePrefix":
		s.serveGetEmotePrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "CreateEmoticon", SubscriptionsPathPrefixOld + "CreateEmoticon", "/v1/Subscriptions/CreateEmoticon":
		s.serveCreateEmoticon(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetAllEmoticonsByProductIDs", SubscriptionsPathPrefixOld + "GetAllEmoticonsByProductIDs", "/v1/Subscriptions/GetAllEmoticonsByProductIDs":
		s.serveGetAllEmoticonsByProductIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPartnerStanding", SubscriptionsPathPrefixOld + "GetPartnerStanding", "/v1/Subscriptions/GetPartnerStanding":
		s.serveGetPartnerStanding(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetEmoticonPrefix", SubscriptionsPathPrefixOld + "GetEmoticonPrefix", "/v1/Subscriptions/GetEmoticonPrefix":
		s.serveGetEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "SubmitEmoticonPrefix", SubscriptionsPathPrefixOld + "SubmitEmoticonPrefix", "/v1/Subscriptions/SubmitEmoticonPrefix":
		s.serveSubmitEmoticonPrefix(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticonsByIDs", SubscriptionsPathPrefixOld + "GetPendingEmoticonsByIDs", "/v1/Subscriptions/GetPendingEmoticonsByIDs":
		s.serveGetPendingEmoticonsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetPendingEmoticons", SubscriptionsPathPrefixOld + "GetPendingEmoticons", "/v1/Subscriptions/GetPendingEmoticons":
		s.serveGetPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "ReviewPendingEmoticons", SubscriptionsPathPrefixOld + "ReviewPendingEmoticons", "/v1/Subscriptions/ReviewPendingEmoticons":
		s.serveReviewPendingEmoticons(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetProductsByIDs", SubscriptionsPathPrefixOld + "GetProductsByIDs", "/v1/Subscriptions/GetProductsByIDs":
		s.serveGetProductsByIDs(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetProductsByNames", SubscriptionsPathPrefixOld + "GetProductsByNames", "/v1/Subscriptions/GetProductsByNames":
		s.serveGetProductsByNames(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetChannelProducts", SubscriptionsPathPrefixOld + "GetChannelProducts", "/v1/Subscriptions/GetChannelProducts":
		s.serveGetChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateProduct", SubscriptionsPathPrefixOld + "UpdateProduct", "/v1/Subscriptions/UpdateProduct":
		s.serveUpdateProduct(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "UpdateChannelProducts", SubscriptionsPathPrefixOld + "UpdateChannelProducts", "/v1/Subscriptions/UpdateChannelProducts":
		s.serveUpdateChannelProducts(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailSubscribers", SubscriptionsPathPrefixOld + "EmailSubscribers", "/v1/Subscriptions/EmailSubscribers":
		s.serveEmailSubscribers(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailGlobalEmote", SubscriptionsPathPrefixOld + "EmailGlobalEmote", "/v1/Subscriptions/EmailGlobalEmote":
		s.serveEmailGlobalEmote(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "EmailPendingPrefixApproval", SubscriptionsPathPrefixOld + "EmailPendingPrefixApproval", "/v1/Subscriptions/EmailPendingPrefixApproval":
		s.serveEmailPendingPrefixApproval(ctx, resp, req)
		return
	case SubscriptionsPathPrefix + "GetTicketsForUserChannel", SubscriptionsPathPrefixOld + "GetTicketsForUserChannel", "/v1/Subscriptions/GetTicketsForUserChannel":
		s.serveGetTicketsForUserChannel(ctx, resp, req)
		return
	default:
		msg := fmt1.Sprintf("no handler for path %q", req.URL.Path)
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
		return
	}
}

func (s *subscriptionsServer) serveFulfillSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillSubscriptionResponse and nil error while calling FulfillSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResponse and nil error while calling CreateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateSubscriptionResponse and nil error while calling CreateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelSubscriptionResponse and nil error while calling CancelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriptionResponse and nil error while calling UpdateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateSubscriptionResponse and nil error while calling UpdateSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribe(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSubscribeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSubscribeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSubscribeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSubscribeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSubscribeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSubscribe")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSubscribeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSubscribeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSubscribe(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSubscribeResponse and nil error while calling CanSubscribe. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveListUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserSubscriptionsResponse and nil error while calling ListUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserExpiredSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveListUserExpiredSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListUserExpiredSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveListUserExpiredSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ListUserExpiredSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveListUserExpiredSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ListUserExpiredSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListUserExpiredSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListUserExpiredSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListUserExpiredSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListUserExpiredSubscriptionsResponse and nil error while calling ListUserExpiredSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscriptionWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionWithPaymentsDataRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscriptionWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionWithPaymentsDataResponse and nil error while calling GetUserChannelSubscriptionWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSubscriptionsResponse and nil error while calling GetUserSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscription(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelSubscriptionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelSubscriptionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelSubscriptionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelSubscriptionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelSubscription")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelSubscriptionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelSubscriptionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelSubscription(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelSubscriptionResponse and nil error while calling GetUserChannelSubscription. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserProductSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserProductSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserProductSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsResponse and nil error while calling GetUserProductSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsWithPaymentsData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsWithPaymentsDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserProductSubscriptionsWithPaymentsDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserProductSubscriptionsWithPaymentsData")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserProductSubscriptionsWithPaymentsDataRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserProductSubscriptionsWithPaymentsDataResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserProductSubscriptionsWithPaymentsData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserProductSubscriptionsWithPaymentsDataResponse and nil error while calling GetUserProductSubscriptionsWithPaymentsData. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelSubscriptions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelSubscriptionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSubscriptionsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelSubscriptionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelSubscriptionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelSubscriptionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelSubscriptions")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelSubscriptionsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelSubscriptionsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelSubscriptions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSubscriptionsResponse and nil error while calling GetChannelSubscriptions. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetFormerSubscribers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetFormerSubscribersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFormerSubscribersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetFormerSubscribersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetFormerSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetFormerSubscribersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFormerSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFormerSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFormerSubscribersResponse and nil error while calling GetFormerSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetFormerSubscribersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetFormerSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetFormerSubscribersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetFormerSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetFormerSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetFormerSubscribersResponse and nil error while calling GetFormerSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriptionByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetSubscriptionByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriptionByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetSubscriptionByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriptionByID")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetSubscriptionByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriptionByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriptionByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriptionByIDResponse and nil error while calling GetSubscriptionByID. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriptionByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriptionByID")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSubscriptionByIDRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriptionByIDResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriptionByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriptionByIDResponse and nil error while calling GetSubscriptionByID. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownBadges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveTakedownBadgesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownBadgesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveTakedownBadgesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(TakedownBadgesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownBadgesResponse and nil error while calling TakedownBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownBadgesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TakedownBadgesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownBadgesResponse and nil error while calling TakedownBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownAllBadges(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveTakedownAllBadgesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTakedownAllBadgesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveTakedownAllBadgesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownAllBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(TakedownAllBadgesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownAllBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownAllBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownAllBadgesResponse and nil error while calling TakedownAllBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveTakedownAllBadgesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "TakedownAllBadges")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TakedownAllBadgesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TakedownAllBadgesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.TakedownAllBadges(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TakedownAllBadgesResponse and nil error while calling TakedownAllBadges. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriberBadge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetSubscriberBadgeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSubscriberBadgeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetSubscriberBadgeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriberBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetSubscriberBadgeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriberBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriberBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberBadgeResponse and nil error while calling GetSubscriberBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetSubscriberBadgeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetSubscriberBadge")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetSubscriberBadgeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetSubscriberBadgeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetSubscriberBadge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSubscriberBadgeResponse and nil error while calling GetSubscriberBadge. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScore(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetScoreJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetScoreProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetScoreJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetScoreRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetScoreProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetScore")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetScoreRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetScoreResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetScore(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetScoreResponse and nil error while calling SetScore. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCalculateSubscriberCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCalculateSubscriberCountProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCalculateSubscriberCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CalculateSubscriberCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCalculateSubscriberCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CalculateSubscriberCount")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CalculateSubscriberCountRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CalculateSubscriberCountResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CalculateSubscriberCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CalculateSubscriberCountResponse and nil error while calling CalculateSubscriberCount. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateChatNotificationTokenResponse and nil error while calling CreateChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUseChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUseChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUseChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UseChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUseChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UseChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UseChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UseChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UseChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UseChatNotificationTokenResponse and nil error while calling UseChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelChatNotificationTokenResponse and nil error while calling CancelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserChannelChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserChannelChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserChannelChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserChannelChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserChannelChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserChannelChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserChannelChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserChannelChatNotificationTokenResponse and nil error while calling GetUserChannelChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllUsedChatNotificationTokens(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllUsedChatNotificationTokensJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllUsedChatNotificationTokensProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetAllUsedChatNotificationTokensJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllUsedChatNotificationTokens")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllUsedChatNotificationTokensRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllUsedChatNotificationTokensResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllUsedChatNotificationTokens(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllUsedChatNotificationTokensResponse and nil error while calling GetAllUsedChatNotificationTokens. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllUsedChatNotificationTokensProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllUsedChatNotificationTokens")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllUsedChatNotificationTokensRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllUsedChatNotificationTokensResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllUsedChatNotificationTokens(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllUsedChatNotificationTokensResponse and nil error while calling GetAllUsedChatNotificationTokens. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveAllowReplayForLastUsedChatNotificationToken(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveAllowReplayForLastUsedChatNotificationTokenJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllowReplayForLastUsedChatNotificationTokenProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveAllowReplayForLastUsedChatNotificationTokenJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "AllowReplayForLastUsedChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(AllowReplayForLastUsedChatNotificationTokenRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowReplayForLastUsedChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowReplayForLastUsedChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowReplayForLastUsedChatNotificationTokenResponse and nil error while calling AllowReplayForLastUsedChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveAllowReplayForLastUsedChatNotificationTokenProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "AllowReplayForLastUsedChatNotificationToken")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(AllowReplayForLastUsedChatNotificationTokenRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *AllowReplayForLastUsedChatNotificationTokenResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.AllowReplayForLastUsedChatNotificationToken(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllowReplayForLastUsedChatNotificationTokenResponse and nil error while calling AllowReplayForLastUsedChatNotificationToken. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetUserSettingsResponse and nil error while calling GetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSetUserSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetUserSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSetUserSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SetUserSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSetUserSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SetUserSettings")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SetUserSettingsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SetUserSettingsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SetUserSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetUserSettingsResponse and nil error while calling SetUserSettings. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductTemplateSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductTemplateSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductTemplateSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductTemplateSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductTemplateSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductTemplateSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductTemplateSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductTemplateSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductTemplateSKUResponse and nil error while calling GetExternalProductTemplateSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKU(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetExternalProductPurchasableSKUJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetExternalProductPurchasableSKUProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetExternalProductPurchasableSKURequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetExternalProductPurchasableSKUProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetExternalProductPurchasableSKU")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetExternalProductPurchasableSKURequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetExternalProductPurchasableSKUResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetExternalProductPurchasableSKU(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetExternalProductPurchasableSKUResponse and nil error while calling GetExternalProductPurchasableSKU. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgrades(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPaidUpgradesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPaidUpgradesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPaidUpgradesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPaidUpgradesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgrades")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPaidUpgradesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgrades(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradesResponse and nil error while calling GetPaidUpgrades. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillPaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillPaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillPaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillPaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillPaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillPaidUpgradeResponse and nil error while calling FulfillPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillPaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillPaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillPaidUpgradeResponse and nil error while calling FulfillPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreatePaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreatePaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreatePaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreatePaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreatePaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreatePaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreatePaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreatePaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePaidUpgradeResponse and nil error while calling CreatePaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgrade(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelPaidUpgradeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelPaidUpgradeProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelPaidUpgradeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelPaidUpgradeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelPaidUpgradeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelPaidUpgrade")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelPaidUpgradeRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelPaidUpgradeResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelPaidUpgrade(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelPaidUpgradeResponse and nil error while calling CancelPaidUpgrade. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateGiftResponse and nil error while calling CreateGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateGiftResponse and nil error while calling CreateGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveInsertGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveInsertGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInsertGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveInsertGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "InsertGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(InsertGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InsertGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InsertGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InsertGiftResponse and nil error while calling InsertGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveInsertGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "InsertGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(InsertGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *InsertGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.InsertGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InsertGiftResponse and nil error while calling InsertGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCancelGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCancelGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CancelGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCancelGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CancelGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CancelGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CancelGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CancelGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelGiftResponse and nil error while calling CancelGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftsResponse and nil error while calling GetGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftResponse and nil error while calling CanGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetGiftPromotionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetGiftPromotionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetGiftPromotionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetGiftPromotionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetGiftPromotionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetGiftPromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetGiftPromotionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetGiftPromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetGiftPromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetGiftPromotionResponse and nil error while calling GetGiftPromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradePromotion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPaidUpgradePromotionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPaidUpgradePromotionProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPaidUpgradePromotionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgradePromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPaidUpgradePromotionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradePromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgradePromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradePromotionResponse and nil error while calling GetPaidUpgradePromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPaidUpgradePromotionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPaidUpgradePromotion")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPaidUpgradePromotionRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPaidUpgradePromotionResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPaidUpgradePromotion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPaidUpgradePromotionResponse and nil error while calling GetPaidUpgradePromotion. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSenderGift(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanSenderGiftJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanSenderGiftProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanSenderGiftJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSenderGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanSenderGiftRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSenderGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSenderGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSenderGiftResponse and nil error while calling CanSenderGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanSenderGiftProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanSenderGift")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanSenderGiftRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanSenderGiftResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanSenderGift(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanSenderGiftResponse and nil error while calling CanSenderGift. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftRecipient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCanGiftRecipientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCanGiftRecipientProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCanGiftRecipientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGiftRecipient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CanGiftRecipientRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftRecipientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGiftRecipient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftRecipientResponse and nil error while calling CanGiftRecipient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCanGiftRecipientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CanGiftRecipient")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CanGiftRecipientRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CanGiftRecipientResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CanGiftRecipient(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CanGiftRecipientResponse and nil error while calling CanGiftRecipient. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillGifts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveFulfillGiftsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFulfillGiftsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveFulfillGiftsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(FulfillGiftsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillGiftsResponse and nil error while calling FulfillGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveFulfillGiftsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "FulfillGifts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FulfillGiftsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *FulfillGiftsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.FulfillGifts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FulfillGiftsResponse and nil error while calling FulfillGifts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendGiftChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendGiftChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendGiftChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendGiftChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendGiftChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendGiftChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendGiftChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendGiftChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendGiftChatNotificationResponse and nil error while calling SendGiftChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendGiftChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendGiftChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendGiftChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendGiftChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendGiftChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendGiftChatNotificationResponse and nil error while calling SendGiftChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendMMGChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMMGChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendMMGChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendMMGChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGChatNotificationResponse and nil error while calling SendMMGChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMMGChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGChatNotificationResponse and nil error while calling SendMMGChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGStartChatNotification(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSendMMGStartChatNotificationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSendMMGStartChatNotificationProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSendMMGStartChatNotificationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGStartChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SendMMGStartChatNotificationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGStartChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGStartChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGStartChatNotificationResponse and nil error while calling SendMMGStartChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSendMMGStartChatNotificationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SendMMGStartChatNotification")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SendMMGStartChatNotificationRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SendMMGStartChatNotificationResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SendMMGStartChatNotification(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SendMMGStartChatNotificationResponse and nil error while calling SendMMGStartChatNotification. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetRelatedChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetRelatedChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRelatedChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetRelatedChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetRelatedChannels")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetRelatedChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRelatedChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRelatedChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRelatedChannelsResponse and nil error while calling GetRelatedChannels. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetRelatedChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetRelatedChannels")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetRelatedChannelsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetRelatedChannelsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetRelatedChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRelatedChannelsResponse and nil error while calling GetRelatedChannels. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmotePrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmotePrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmotePrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmotePrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmotePrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmotePrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmotePrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmotePrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmotePrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmotePrefixResponse and nil error while calling GetEmotePrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticon(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveCreateEmoticonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEmoticonProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveCreateEmoticonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(CreateEmoticonRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveCreateEmoticonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "CreateEmoticon")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateEmoticonRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateEmoticonReponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateEmoticon(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEmoticonReponse and nil error while calling CreateEmoticon. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetAllEmoticonsByProductIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAllEmoticonsByProductIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetAllEmoticonsByProductIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetAllEmoticonsByProductIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAllEmoticonsByProductIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAllEmoticonsByProductIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAllEmoticonsByProductIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAllEmoticonsByProductIDsResponse and nil error while calling GetAllEmoticonsByProductIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStanding(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPartnerStandingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPartnerStandingProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPartnerStandingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPartnerStandingRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPartnerStandingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPartnerStanding")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPartnerStandingRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPartnerStandingResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPartnerStanding(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPartnerStandingResponse and nil error while calling GetPartnerStanding. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEmoticonPrefixResponse and nil error while calling GetEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefix(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveSubmitEmoticonPrefixJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitEmoticonPrefixProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(SubmitEmoticonPrefixRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveSubmitEmoticonPrefixProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "SubmitEmoticonPrefix")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(SubmitEmoticonPrefixRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *SubmitEmoticonPrefixResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.SubmitEmoticonPrefix(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitEmoticonPrefixResponse and nil error while calling SubmitEmoticonPrefix. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticonsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticonsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsByIDsResponse and nil error while calling GetPendingEmoticonsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticonsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticonsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsByIDsResponse and nil error while calling GetPendingEmoticonsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPendingEmoticonsResponse and nil error while calling GetPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveReviewPendingEmoticons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveReviewPendingEmoticonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveReviewPendingEmoticonsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveReviewPendingEmoticonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ReviewPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(ReviewPendingEmoticonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReviewPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ReviewPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReviewPendingEmoticonsResponse and nil error while calling ReviewPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveReviewPendingEmoticonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "ReviewPendingEmoticons")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ReviewPendingEmoticonsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReviewPendingEmoticonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ReviewPendingEmoticons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReviewPendingEmoticonsResponse and nil error while calling ReviewPendingEmoticons. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetProductsByIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetProductsByIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetProductsByIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByIDs")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProductsByIDsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByIDsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByIDsResponse and nil error while calling GetProductsByIDs. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByNames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetProductsByNamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProductsByNamesProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetProductsByNamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByNames")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetProductsByNamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByNamesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByNamesResponse and nil error while calling GetProductsByNames. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetProductsByNamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetProductsByNames")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetProductsByNamesRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetProductsByNamesResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetProductsByNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetProductsByNamesResponse and nil error while calling GetProductsByNames. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelProductsResponse and nil error while calling GetChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProduct(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateProductJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProductProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateProductJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateProductRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateProductProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateProduct")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateProductRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateProductResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateProduct(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateProductResponse and nil error while calling UpdateProduct. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProducts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveUpdateChannelProductsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelProductsProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveUpdateChannelProductsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(UpdateChannelProductsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveUpdateChannelProductsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "UpdateChannelProducts")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateChannelProductsRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateChannelProductsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateChannelProducts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateChannelProductsResponse and nil error while calling UpdateChannelProducts. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailSubscribers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailSubscribersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailSubscribersProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailSubscribersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailSubscribersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailSubscribersResponse and nil error while calling EmailSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailSubscribersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailSubscribers")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailSubscribersRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailSubscribersResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailSubscribers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailSubscribersResponse and nil error while calling EmailSubscribers. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailGlobalEmote(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailGlobalEmoteJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailGlobalEmoteProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailGlobalEmoteJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailGlobalEmote")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailGlobalEmoteRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailGlobalEmoteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailGlobalEmote(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailGlobalEmoteResponse and nil error while calling EmailGlobalEmote. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailGlobalEmoteProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailGlobalEmote")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailGlobalEmoteRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailGlobalEmoteResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailGlobalEmote(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailGlobalEmoteResponse and nil error while calling EmailGlobalEmote. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailPendingPrefixApproval(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveEmailPendingPrefixApprovalJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEmailPendingPrefixApprovalProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveEmailPendingPrefixApprovalJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailPendingPrefixApproval")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(EmailPendingPrefixApprovalRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailPendingPrefixApprovalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailPendingPrefixApproval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailPendingPrefixApprovalResponse and nil error while calling EmailPendingPrefixApproval. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveEmailPendingPrefixApprovalProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "EmailPendingPrefixApproval")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(EmailPendingPrefixApprovalRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *EmailPendingPrefixApprovalResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.EmailPendingPrefixApproval(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EmailPendingPrefixApprovalResponse and nil error while calling EmailPendingPrefixApproval. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTicketsForUserChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	switch req.Header.Get("Content-Type") {
	case "application/json":
		s.serveGetTicketsForUserChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTicketsForUserChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt1.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *subscriptionsServer) serveGetTicketsForUserChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTicketsForUserChannel")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	reqContent := new(GetTicketsForUserChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTicketsForUserChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTicketsForUserChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTicketsForUserChannelResponse and nil error while calling GetTicketsForUserChannel. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(buf.Bytes()); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) serveGetTicketsForUserChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = setMethodName(ctx, "GetTicketsForUserChannel")
	ctx = s.hooks.RequestRouted(ctx)

	defer closebody(req.Body)
	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetTicketsForUserChannelRequest)
	if err = proto1.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetTicketsForUserChannelResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetTicketsForUserChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTicketsForUserChannelResponse and nil error while calling GetTicketsForUserChannel. nil responses are not supported"))
		return
	}

	ctx = s.hooks.ResponsePrepared(ctx)

	respBytes, err := proto1.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = setStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if _, err = resp.Write(respBytes); err != nil {
		log.Printf("errored while writing response to client, but already sent response status code to 200: %s", err)
	}
	_ = s.hooks.ResponseSent(ctx)
}

func (s *subscriptionsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *subscriptionsServer) ProtocGenTwirpVersion() string {
	return "v4.7.0"
}

// =====
// Utils
// =====

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshaled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// A ContextSource establishes the base context for a Server.
type ContextSource func(http.ResponseWriter, *http.Request) context.Context

var RequestContextSource ContextSource = func(w http.ResponseWriter, req *http.Request) context.Context {
	return req.Context()
}

var BackgroundContextSource ContextSource = func(http.ResponseWriter, *http.Request) context.Context {
	return context.Background()
}

// done returns ctx.Err() if ctx.Done() indicates that the context done
func done(ctx context.Context) error {
	select {
	case <-ctx.Done():
		return ctx.Err()
	default:
		return nil
	}
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
// NOTE: not compatible with old v1/v2 clients (only returns v3+ errors)
func WriteError(resp http.ResponseWriter, err error) {
	writeErrorPostV3(nil, resp, err, nil) // does not trigger server hooks
}

// writeErrorPostV3 writes Twirp v3+ errors in the response.
func writeErrorPostV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, err2 := resp.Write(respBody)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// writeErrorPreV3 writes Twirp v1/v2 backwards-compatible errors in the response.
// This is to make it easy to upgrade to v3, a v3 server keeps serving v2-style errors to v2 clients.
func writeErrorPreV3(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Unknown 500 (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.NewError(twirp.Unknown, err.Error())
	}

	resp.Header().Set("Content-Type", "text/plain")

	// v2err.Retryable <= v3err.Meta("retryable")
	if twerr.Meta("retryable") != "" {
		resp.Header().Set("Twirp-Error-Retryable", "true")
	}

	// v2err.ErrorID <= v3err.Meta("v2_error_id") if present, otherwise v3err.Code()
	// or "unroutable" if generated from twirp router (BadRoute)
	var v2ErrorID string
	if twerr.Code() == twirp.BadRoute {
		v2ErrorID = "unroutable" // as was generated by previous router
	} else if twerr.Meta("v2_error_id") != "" {
		v2ErrorID = twerr.Meta("v2_error_id")
	} else {
		v2ErrorID = string(twerr.Code()) // the string-format of v3 codes match v2 error ids for the most part: i.e. "not_found", "internal", "unknown", "canceled", etc.
	}
	resp.Header().Set("Twirp-ErrorID", v2ErrorID)

	// v2err.StatusCode <= v3err.Meta("v2_status_code") if present, otherwise same as in v3
	statusCode, err := strconv.Atoi(twerr.Meta("v2_status_code"))
	if err != nil {
		statusCode = twirp.ServerHTTPStatusFromErrorCode(twerr.Code()) // v3 it's the same as v2 for the most part: i.e. "not_found" is 404
	}
	if hooks != nil {
		ctx = setStatusCode(ctx, statusCode)
		ctx = hooks.Error(ctx, twerr)
	}
	resp.WriteHeader(statusCode)

	msg := []byte(twerr.Msg())
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}
	_, err2 := resp.Write(msg)
	if err2 != nil {
		log.Printf("unable to send error message %q: %s", twerr, err2)
	}

	if hooks != nil {
		_ = hooks.ResponseSent(ctx)
	}
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// setMethodName, setServerName, and setStatusCode are functions to
// expose internal state through contexts. The context keys hardcoded
// in here are not to be used on their own. Twirp provides accessor
// functions which will retrieve these values out and give them the
// correct type for you.
func setMethodName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_method_name", name)
}
func setServerName(ctx context.Context, name string) context.Context {
	return context.WithValue(ctx, "__tw_service_name", name)
}
func setStatusCode(ctx context.Context, code int) context.Context {
	return context.WithValue(ctx, "__tw_status_code", strconv.Itoa(code))
}

type privateContextKey int

var versionKey = new(privateContextKey)

// setVersionFromPath adds "v1", "v2" or "v3" to the context depending on the path.
func setVersionFromPath(ctx context.Context, path string) context.Context {
	var version string
	if strings.HasPrefix(path, "/v1/") {
		version = "v1"
	} else if strings.HasPrefix(path, "/v2/") {
		version = "v2"
	} else {
		version = "v3"
	}
	return context.WithValue(ctx, versionKey, version)
}

// getVersion returns the version number ("v1", "v2", "v3") or empty string if unset.
func getVersion(ctx context.Context) string {
	v, _ := ctx.Value(versionKey).(string)
	return v
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := ctx.Value("__tw_request_header").(http.Header)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// closebody closes a response or request body and just logs
// any error encountered while closing, since errors are
// considered very unusual.
func closebody(body io.Closer) {
	if err := body.Close(); err != nil {
		log.Printf("error closing body: %q", err)
	}
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v4.7.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients dont't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt1.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt1.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtoRequest is common code to make a request to the remote twirp service.
func doProtoRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBodyBytes, err := proto1.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto1.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client *http.Client, url string, in, out proto1.Message) error {
	var err error
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := ctxhttp.Do(ctx, client, req)
	if err != nil {
		return clientError("failed to do request", err)
	}
	defer closebody(resp.Body)
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = done(ctx); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

var twirpFileDescriptor0 = []byte{
	// 6983 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x3d, 0x5d, 0x6f, 0x23, 0xc9,
	0x71, 0x37, 0x24, 0x25, 0x91, 0x25, 0x4a, 0xa2, 0x66, 0x77, 0xb5, 0x5c, 0xee, 0xde, 0xed, 0xed,
	0xec, 0x9e, 0x7d, 0x51, 0x6c, 0x1d, 0x4e, 0xf7, 0xfd, 0xb9, 0x4b, 0x49, 0x94, 0x8e, 0xb7, 0x2b,
	0x4a, 0x37, 0xa4, 0xee, 0x76, 0xcf, 0xe7, 0x8c, 0x47, 0x9c, 0x96, 0x34, 0xd6, 0x70, 0x86, 0x37,
	0x33, 0x94, 0x56, 0x89, 0x01, 0x07, 0x70, 0x02, 0x07, 0x76, 0x1c, 0xc4, 0xb0, 0x11, 0x27, 0x01,
	0x62, 0x18, 0x0e, 0x6c, 0x24, 0x4f, 0x06, 0x8c, 0x24, 0x70, 0x90, 0xe4, 0xc1, 0x0f, 0x41, 0xbe,
	0x1e, 0x0c, 0x24, 0xb0, 0x91, 0x37, 0x03, 0x01, 0xf2, 0x10, 0x20, 0xc8, 0x0f, 0x48, 0x80, 0x24,
	0xe8, 0x8f, 0xf9, 0xe4, 0x90, 0xec, 0x21, 0xb5, 0x8e, 0xed, 0xbc, 0xec, 0xb2, 0x6b, 0xba, 0xab,
	0xab, 0xab, 0xab, 0xbb, 0xab, 0xab, 0xab, 0x4a, 0x70, 0xc5, 0x3d, 0xd5, 0xed, 0xee, 0x33, 0x4e,
	0x6f, 0xdf, 0x69, 0xdb, 0x7a, 0xd7, 0xd5, 0x2d, 0xd3, 0x59, 0xe9, 0xda, 0x96, 0x6b, 0x89, 0xb7,
	0xda, 0x96, 0x86, 0x56, 0x3e, 0xdd, 0x73, 0x5c, 0xdd, 0x5c, 0x71, 0x4f, 0x56, 0x6c, 0x74, 0x82,
	0xcc, 0x1e, 0x5a, 0x89, 0xd4, 0xad, 0x5c, 0x3f, 0xb4, 0xac, 0x43, 0x03, 0x3d, 0x43, 0xda, 0xec,
	0xf7, 0x0e, 0x9e, 0x71, 0xf5, 0x0e, 0x72, 0x5c, 0xb5, 0xd3, 0xa5, 0x68, 0xa4, 0xdf, 0x11, 0xe0,
	0x46, 0xad, 0xa3, 0xea, 0xc6, 0x2e, 0x32, 0x35, 0xdd, 0x3c, 0xdc, 0xb5, 0xd1, 0x81, 0xfe, 0xb0,
	0xda, 0xed, 0xda, 0xd6, 0x89, 0x6a, 0xc8, 0xe8, 0xc3, 0x1e, 0x72, 0x5c, 0xf1, 0x32, 0xcc, 0xf4,
	0x1c, 0x64, 0x2b, 0xba, 0x56, 0x16, 0x9e, 0x14, 0x9e, 0x2e, 0xc8, 0xd3, 0xb8, 0x58, 0xd7, 0xc4,
	0x25, 0x98, 0xee, 0x92, 0x16, 0xe5, 0x0c, 0x85, 0xd3, 0x92, 0x78, 0x11, 0xa6, 0x1c, 0x57, 0x75,
	0x51, 0x39, 0x4b, 0xc0, 0xb4, 0x20, 0x2e, 0xc3, 0x02, 0xea, 0x58, 0xae, 0xde, 0xb6, 0x4c, 0xc5,
	0x41, 0x2e, 0x46, 0x97, 0xc3, 0xdf, 0xd7, 0x32, 0x65, 0x41, 0x9e, 0xf3, 0x3e, 0x35, 0x91, 0x5b,
	0xd7, 0xa4, 0x5b, 0x20, 0x0d, 0xa3, 0xcb, 0xe9, 0x5a, 0xa6, 0x83, 0x24, 0x17, 0x2e, 0x93, 0x5a,
	0x5b, 0x86, 0xb5, 0xaf, 0x1a, 0xb5, 0x8e, 0xe5, 0x22, 0x8f, 0xe6, 0xc7, 0x01, 0xac, 0x53, 0x13,
	0xd9, 0x8a, 0xa9, 0x76, 0x10, 0x23, 0xbb, 0x40, 0x20, 0x0d, 0xb5, 0x83, 0xc4, 0xeb, 0x30, 0x4b,
	0x3f, 0x23, 0xdc, 0x9e, 0x91, 0x4f, 0x5b, 0x10, 0x8c, 0xe2, 0x15, 0xc8, 0x63, 0x8a, 0x10, 0xa6,
	0x92, 0x8e, 0x62, 0x86, 0x94, 0xeb, 0x9a, 0x54, 0x81, 0x72, 0x7f, 0xaf, 0x8c, 0xa2, 0x7d, 0x46,
	0x51, 0x93, 0xce, 0xc3, 0x3e, 0xb2, 0x9d, 0x10, 0x45, 0xed, 0x23, 0xd5, 0x34, 0x91, 0x11, 0x30,
	0xb2, 0xc0, 0x20, 0x75, 0x0d, 0xf3, 0xcc, 0xd5, 0x5d, 0x03, 0x31, 0x5a, 0x68, 0x41, 0x14, 0x21,
	0xe7, 0xa2, 0x87, 0x2e, 0x23, 0x81, 0xfc, 0xf6, 0xfb, 0x8f, 0xf4, 0xc1, 0xfa, 0xff, 0x04, 0xcc,
	0xd5, 0x18, 0x23, 0xef, 0xa1, 0x13, 0x64, 0x88, 0x37, 0x61, 0xae, 0xa3, 0x9b, 0x7a, 0xa7, 0xd7,
	0x51, 0x9c, 0xb6, 0x65, 0x53, 0x56, 0x64, 0xe5, 0x22, 0x03, 0x36, 0x31, 0x4c, 0x7c, 0x0a, 0xe6,
	0xfd, 0x99, 0x31, 0xf4, 0x8e, 0xee, 0x12, 0x22, 0xb2, 0xc1, 0xa4, 0xdc, 0xc3, 0x40, 0xe9, 0x13,
	0xb0, 0xd0, 0x44, 0x2e, 0x69, 0xc2, 0x39, 0xa8, 0x5f, 0x80, 0x92, 0xe3, 0x53, 0xc9, 0x08, 0xa0,
	0xa8, 0x17, 0x02, 0x38, 0x41, 0x28, 0x7d, 0x4f, 0x80, 0x52, 0x80, 0x9d, 0x0e, 0x27, 0xb1, 0xbd,
	0x90, 0xd8, 0x9e, 0x73, 0x0c, 0xa2, 0x0c, 0x60, 0xa2, 0x87, 0xae, 0x62, 0x60, 0xee, 0x10, 0xb6,
	0xce, 0xae, 0x3e, 0xb7, 0xc2, 0xb3, 0x9a, 0x56, 0x22, 0x8c, 0x95, 0x0b, 0x18, 0x0d, 0xf9, 0x29,
	0xfd, 0x79, 0x0e, 0x16, 0x9b, 0xa1, 0xaa, 0xeb, 0x56, 0xcf, 0x74, 0xc9, 0x22, 0x08, 0x11, 0x4c,
	0x0b, 0xb1, 0xfe, 0x33, 0xe7, 0xd1, 0xbf, 0xe8, 0xc2, 0x42, 0x1b, 0x77, 0xa9, 0xec, 0xdb, 0x48,
	0x3d, 0xd6, 0xac, 0x53, 0xb3, 0x9c, 0x7d, 0x32, 0xfb, 0xf4, 0xec, 0xea, 0x5d, 0x3e, 0xc4, 0x7d,
	0xb4, 0xaf, 0x90, 0x7f, 0xd7, 0x3c, 0x6c, 0x35, 0xd3, 0xb5, 0xcf, 0xe4, 0xf9, 0x76, 0x04, 0x88,
	0x7b, 0x25, 0x43, 0x0a, 0xf5, 0x9a, 0x9b, 0xac, 0x57, 0x32, 0x91, 0xf1, 0x5e, 0x9d, 0x08, 0x50,
	0xbc, 0x01, 0x45, 0x57, 0x6f, 0x1f, 0x23, 0x57, 0x21, 0xe4, 0x94, 0xa7, 0x08, 0x73, 0x67, 0x29,
	0x8c, 0x32, 0xbe, 0x5f, 0x12, 0xa6, 0x13, 0x24, 0xa1, 0x52, 0x85, 0x0b, 0x09, 0xc3, 0x14, 0x4b,
	0x90, 0x3d, 0x46, 0x67, 0x4c, 0x94, 0xf1, 0x4f, 0x3c, 0x91, 0x27, 0xaa, 0xd1, 0xf3, 0x24, 0x97,
	0x16, 0x5e, 0xcd, 0xbc, 0x2c, 0x60, 0x14, 0x09, 0x34, 0xa7, 0x41, 0x21, 0xdd, 0x81, 0xeb, 0xeb,
	0xaa, 0xd1, 0xee, 0x19, 0xaa, 0x8b, 0x82, 0x05, 0x4d, 0x08, 0xe3, 0x5b, 0x63, 0xd2, 0x2f, 0xc3,
	0x93, 0x83, 0x31, 0xb0, 0x75, 0xf4, 0x2e, 0x00, 0x66, 0x3e, 0xe3, 0x99, 0x40, 0xa4, 0xee, 0xa5,
	0x31, 0xa7, 0x49, 0x2e, 0xe0, 0x0a, 0xe4, 0xa7, 0xf4, 0x2c, 0x2c, 0x6d, 0x21, 0x77, 0xcf, 0x41,
	0x76, 0x13, 0xb9, 0xae, 0x6e, 0x1e, 0x3a, 0xa3, 0xce, 0x0c, 0xe9, 0xfb, 0x02, 0x5c, 0xee, 0x6b,
	0xc3, 0xc8, 0xdc, 0x80, 0xeb, 0x87, 0xfa, 0x81, 0xeb, 0x28, 0xba, 0xa9, 0x1c, 0x58, 0x86, 0x61,
	0x9d, 0x22, 0x4d, 0x61, 0x23, 0x75, 0x14, 0xcb, 0x34, 0x28, 0x53, 0xf3, 0xf2, 0x55, 0x52, 0xad,
	0x6e, 0x6e, 0xb2, 0x4a, 0xeb, 0xac, 0xce, 0x8e, 0x69, 0x9c, 0x89, 0x1f, 0x81, 0x85, 0x23, 0x5d,
	0x43, 0x0a, 0xae, 0xc3, 0x46, 0x9c, 0x21, 0xad, 0xe6, 0x30, 0x78, 0x4b, 0x3f, 0x60, 0x72, 0xf2,
	0x32, 0x94, 0x49, 0xbd, 0xf0, 0x78, 0x15, 0x7c, 0x54, 0xf5, 0x1c, 0xb2, 0x31, 0xe4, 0xe5, 0x25,
	0xfc, 0x3d, 0xcc, 0x80, 0x26, 0xf9, 0x2a, 0xfd, 0x43, 0x16, 0x96, 0x9a, 0xe9, 0xc6, 0xcd, 0x33,
	0xb6, 0xcc, 0xe8, 0xb1, 0x7d, 0x5e, 0x80, 0x8f, 0xda, 0xa8, 0x8d, 0xf4, 0x13, 0x3a, 0xbe, 0x61,
	0xe8, 0xe8, 0xe6, 0xb6, 0xca, 0x37, 0xcd, 0x3b, 0xe4, 0x7f, 0xd5, 0x58, 0xb3, 0x2c, 0x43, 0x96,
	0x58, 0x17, 0x5b, 0x43, 0x28, 0x79, 0xbf, 0x9f, 0xcb, 0xb9, 0xb1, 0x3b, 0x8c, 0xcd, 0x8c, 0x31,
	0x64, 0x66, 0xa6, 0xc6, 0xee, 0x64, 0xd0, 0x6c, 0x62, 0x89, 0x6c, 0xfe, 0x8c, 0x4b, 0xe4, 0x2d,
	0x28, 0x86, 0xc7, 0x1a, 0x6c, 0x38, 0x94, 0x3a, 0x5a, 0x90, 0xfe, 0x23, 0x03, 0xc5, 0x70, 0x63,
	0x71, 0x1e, 0x32, 0xbe, 0xa0, 0x66, 0x74, 0x2d, 0xb6, 0xd5, 0x64, 0xe2, 0xc7, 0xf9, 0x15, 0xc8,
	0x53, 0xad, 0x29, 0x50, 0x8a, 0x48, 0xb9, 0x4e, 0x5a, 0x76, 0x6d, 0x4b, 0xeb, 0xb5, 0x03, 0xbd,
	0x4e, 0x2e, 0x30, 0x48, 0x5d, 0x13, 0xaf, 0x42, 0xc1, 0xb2, 0xf5, 0x43, 0xdd, 0xc4, 0x5f, 0xa7,
	0xc8, 0xd7, 0x3c, 0x05, 0xd4, 0x35, 0xf1, 0x36, 0xcc, 0xed, 0x23, 0x13, 0x1d, 0xe8, 0x2e, 0x1e,
	0xac, 0x4d, 0xf7, 0xeb, 0xd9, 0xd5, 0xca, 0x0a, 0x55, 0x5f, 0x57, 0x3c, 0xf5, 0x75, 0xa5, 0xe5,
	0xa9, 0xaf, 0x72, 0x91, 0x35, 0x68, 0xe2, 0xfa, 0xe2, 0x6b, 0x30, 0xeb, 0x21, 0x40, 0xa6, 0x56,
	0x9e, 0x19, 0xd9, 0x1c, 0x58, 0xf5, 0x9a, 0xa9, 0x61, 0x55, 0x50, 0x6d, 0xb7, 0x91, 0xe3, 0x28,
	0x87, 0x3d, 0x5d, 0x2b, 0xe7, 0xa9, 0x2a, 0x48, 0x41, 0x5b, 0x3d, 0x5d, 0x13, 0x5f, 0x01, 0xe8,
	0x75, 0x35, 0xd5, 0x45, 0x9a, 0x62, 0x99, 0xe5, 0xc2, 0x48, 0xe4, 0x05, 0x56, 0x7b, 0xc7, 0x94,
	0xaa, 0x50, 0xda, 0xb4, 0xec, 0x0e, 0xb2, 0x83, 0x8d, 0x39, 0x25, 0xcf, 0xa5, 0xbf, 0xca, 0x40,
	0x65, 0xb3, 0x67, 0x1c, 0xe8, 0x86, 0x11, 0x9e, 0x3a, 0x6f, 0xbf, 0x09, 0x4f, 0x89, 0x30, 0x6c,
	0x4a, 0x32, 0x43, 0xa7, 0x24, 0x3b, 0x6a, 0x4a, 0x72, 0x93, 0x4d, 0xc9, 0x54, 0xaa, 0x29, 0x79,
	0x1b, 0xf2, 0x5d, 0x43, 0x75, 0x0f, 0x2c, 0xbb, 0x43, 0x64, 0x61, 0x7e, 0x75, 0x85, 0x6f, 0xbd,
	0xef, 0xb2, 0x56, 0xb2, 0xdf, 0x5e, 0xea, 0xc1, 0xd5, 0x44, 0xf6, 0xf9, 0x27, 0x63, 0x31, 0x8c,
	0x82, 0x9d, 0x8d, 0xab, 0xe9, 0xcf, 0x46, 0x39, 0x82, 0x47, 0xfa, 0x61, 0x06, 0xae, 0xac, 0xdb,
	0x28, 0x38, 0x93, 0x7f, 0xfe, 0x67, 0xad, 0x0d, 0x8b, 0x91, 0x8d, 0xcb, 0x3d, 0xeb, 0x22, 0x36,
	0x7d, 0x2f, 0xa6, 0xe7, 0x67, 0xeb, 0xac, 0x8b, 0xe4, 0x92, 0x13, 0x83, 0x48, 0x2e, 0x54, 0x92,
	0xd8, 0xfa, 0x88, 0x67, 0xd3, 0x86, 0x2b, 0xeb, 0xaa, 0xd9, 0x46, 0x3f, 0xc1, 0x25, 0x28, 0x5d,
	0x83, 0x4a, 0x52, 0x9f, 0xec, 0xa2, 0xf7, 0x97, 0x02, 0x5c, 0xd9, 0x23, 0xfb, 0x4c, 0x12, 0x49,
	0xa5, 0x60, 0x8f, 0x79, 0xeb, 0x31, 0xb2, 0xcb, 0xdc, 0xa1, 0x3a, 0x29, 0xbd, 0x70, 0x7c, 0x8c,
	0x9b, 0x21, 0x77, 0xd1, 0xd9, 0x5b, 0x8f, 0x51, 0x1d, 0x36, 0x26, 0x1b, 0xd9, 0x34, 0xb2, 0xb1,
	0x36, 0x1f, 0x9d, 0x18, 0x3c, 0xb8, 0x24, 0xea, 0xd9, 0xe0, 0x7e, 0x35, 0x03, 0x17, 0xd6, 0x55,
	0xd3, 0xdf, 0x34, 0x27, 0xe7, 0x74, 0x78, 0x47, 0xc9, 0x4e, 0xb6, 0xa3, 0x24, 0xcb, 0x79, 0xee,
	0x9c, 0xe5, 0xfc, 0x35, 0xb8, 0x18, 0xe5, 0x00, 0x93, 0xf0, 0x9b, 0x30, 0xd7, 0x56, 0x4d, 0xc5,
	0xbf, 0xfd, 0xb2, 0x03, 0xbe, 0xd8, 0x0e, 0x55, 0x96, 0x7e, 0x90, 0x81, 0x6b, 0xf7, 0x74, 0x87,
	0xaa, 0x34, 0xe1, 0x9e, 0x39, 0x18, 0x79, 0x11, 0xa6, 0xc2, 0xd7, 0x67, 0x5a, 0x10, 0x97, 0x60,
	0xba, 0xdd, 0xb3, 0x1d, 0xcb, 0x66, 0x62, 0xca, 0x4a, 0x11, 0xbe, 0xe6, 0x26, 0xe4, 0xab, 0x0a,
	0xd3, 0x07, 0xba, 0xe1, 0x22, 0x9b, 0xec, 0x3b, 0xf3, 0xab, 0x75, 0x3e, 0x4c, 0xc3, 0x06, 0xba,
	0xb2, 0x49, 0x10, 0xca, 0x0c, 0xb1, 0xf4, 0x12, 0x4c, 0x53, 0x88, 0x38, 0x03, 0xd9, 0xea, 0xbd,
	0x7b, 0xa5, 0xc7, 0xc4, 0x22, 0xe4, 0x77, 0xef, 0x55, 0x5b, 0x9b, 0x3b, 0xf2, 0x76, 0x49, 0x10,
	0xf3, 0x90, 0xdb, 0xaa, 0x6f, 0xb6, 0x4a, 0x19, 0x0c, 0x6f, 0xec, 0xb4, 0x76, 0xe5, 0xfa, 0x76,
	0xad, 0x94, 0x95, 0x4c, 0xb8, 0xe9, 0xf5, 0x53, 0x7b, 0xd8, 0xd5, 0x6d, 0xa4, 0x9d, 0x1b, 0x5f,
	0xad, 0x83, 0x03, 0x07, 0x51, 0x0b, 0x4f, 0x56, 0x66, 0x25, 0xa9, 0x03, 0xcf, 0xb2, 0x4b, 0x12,
	0x53, 0x24, 0xc3, 0xdd, 0xbd, 0xa7, 0xbb, 0x47, 0xbb, 0xea, 0x59, 0x07, 0x99, 0xae, 0xb3, 0xa1,
	0xba, 0x2a, 0xdf, 0xf2, 0x18, 0xa6, 0x64, 0x7c, 0x12, 0x6e, 0x0c, 0xee, 0x6e, 0x72, 0xf4, 0xff,
	0x9e, 0x83, 0x52, 0x7c, 0x8a, 0xc4, 0x8f, 0xc2, 0x42, 0x64, 0x19, 0xf9, 0x58, 0xe7, 0xc3, 0xe0,
	0x98, 0xd6, 0x99, 0x19, 0xb6, 0xea, 0xb3, 0x43, 0xf7, 0xd7, 0xdc, 0xa8, 0xc3, 0x72, 0x6a, 0xb2,
	0xc3, 0x72, 0x7a, 0x6c, 0x15, 0x67, 0x66, 0xc2, 0x85, 0xf3, 0x12, 0x14, 0x6c, 0x64, 0xa2, 0x53,
	0x47, 0x51, 0x5d, 0xa2, 0xbf, 0x0e, 0x27, 0x23, 0x4f, 0x2b, 0x57, 0x5d, 0xf1, 0x69, 0x28, 0xa1,
	0x87, 0xae, 0xd2, 0xed, 0xd9, 0xed, 0x23, 0xd5, 0x41, 0x8a, 0x73, 0xdc, 0x23, 0xfa, 0x6d, 0x41,
	0x9e, 0x47, 0x0f, 0xdd, 0x5d, 0x06, 0x6e, 0x1e, 0xf7, 0xf0, 0x1c, 0xe8, 0x8e, 0xd2, 0xb5, 0xf5,
	0x0e, 0x2a, 0x03, 0xd9, 0x71, 0x66, 0x74, 0x67, 0x17, 0x17, 0xf1, 0x8d, 0x57, 0x77, 0xc8, 0xd5,
	0xa6, 0x3c, 0x4b, 0xbe, 0x4c, 0xeb, 0x0e, 0xbe, 0xd2, 0xe0, 0xad, 0x4a, 0x77, 0x14, 0x1b, 0x1d,
	0xf4, 0x4c, 0x4d, 0xdd, 0x37, 0x50, 0xb9, 0x48, 0xb7, 0x2a, 0xdd, 0x91, 0x7d, 0x18, 0x6b, 0xad,
	0x99, 0xb6, 0x56, 0x9e, 0xf3, 0x5a, 0x6f, 0x98, 0x76, 0x5c, 0xeb, 0x9e, 0x4f, 0xa3, 0x75, 0xff,
	0xa6, 0x00, 0x4b, 0x71, 0x71, 0x93, 0x91, 0xd3, 0x33, 0x5c, 0xf1, 0xfd, 0x44, 0x05, 0x81, 0x73,
	0xdb, 0xee, 0xc3, 0x19, 0xc1, 0x15, 0xda, 0x23, 0x33, 0xe1, 0x3d, 0x52, 0xfa, 0x35, 0x01, 0xc4,
	0x04, 0x52, 0x1e, 0x91, 0xae, 0x32, 0x90, 0x8c, 0x1f, 0x09, 0x70, 0x6b, 0xf8, 0x1e, 0xc6, 0x8e,
	0x98, 0x5f, 0x82, 0xb9, 0x48, 0x67, 0x65, 0x81, 0x98, 0xf5, 0x5e, 0x1e, 0x83, 0x32, 0x32, 0x52,
	0x39, 0x8a, 0x4e, 0x5c, 0x86, 0xc5, 0x23, 0x15, 0x0b, 0x13, 0x3a, 0xd1, 0xad, 0x9e, 0xa3, 0x74,
	0xd5, 0x43, 0xc4, 0xee, 0xc3, 0x0b, 0x47, 0xaa, 0xb3, 0xcb, 0xe0, 0xbb, 0xea, 0x21, 0x12, 0x25,
	0x98, 0xc3, 0x75, 0x89, 0xc9, 0x94, 0xd4, 0xa3, 0xd7, 0xe0, 0xd9, 0x23, 0xd5, 0x69, 0x60, 0x11,
	0x55, 0x0f, 0x91, 0xf4, 0x37, 0x02, 0x3c, 0x3e, 0xe0, 0x10, 0xf0, 0xd5, 0xc2, 0x19, 0x9b, 0x90,
	0xe2, 0x8d, 0xe5, 0xf5, 0x31, 0x27, 0x9c, 0x8e, 0xc7, 0x43, 0x76, 0xee, 0x23, 0xf9, 0x6d, 0x01,
	0x56, 0xd3, 0x6c, 0xfb, 0x6c, 0x78, 0x8f, 0x50, 0xa8, 0xa5, 0xcf, 0x80, 0x34, 0xec, 0x64, 0x78,
	0xc4, 0x7a, 0xf7, 0xa7, 0xfc, 0xde, 0x77, 0xe9, 0xa6, 0x9e, 0xf6, 0xd4, 0xbd, 0x0e, 0xb3, 0xc1,
	0x01, 0xe1, 0x94, 0x33, 0x4f, 0x66, 0xf1, 0xe5, 0xde, 0x3f, 0x21, 0x1c, 0xe9, 0xb3, 0x70, 0x73,
	0x68, 0x0f, 0x6c, 0x80, 0xf7, 0x93, 0xd7, 0xc4, 0x38, 0x23, 0x8c, 0x22, 0x92, 0xba, 0xfe, 0x94,
	0x27, 0x11, 0x30, 0xc6, 0x51, 0x3f, 0x72, 0xc8, 0x5f, 0x11, 0xe0, 0xb9, 0x54, 0x5d, 0x32, 0x1e,
	0x7c, 0x90, 0xcc, 0x83, 0x71, 0xe5, 0x2c, 0xc6, 0x87, 0x97, 0xe1, 0xaa, 0x67, 0x16, 0x4e, 0x37,
	0xc7, 0xd2, 0x43, 0xb8, 0x96, 0xdc, 0xf2, 0x91, 0xcf, 0xdd, 0x7f, 0x09, 0xf0, 0xc4, 0x16, 0x72,
	0x13, 0x56, 0x46, 0x8a, 0x57, 0xbf, 0x40, 0x2b, 0x9c, 0x4a, 0xd6, 0x0a, 0xa7, 0x3c, 0xad, 0x50,
	0x3c, 0x84, 0xbc, 0x65, 0x6b, 0xc8, 0x56, 0xf6, 0xcf, 0x98, 0xb6, 0x7d, 0x8f, 0x6f, 0x10, 0xc3,
	0x89, 0x5c, 0xd9, 0xc1, 0x48, 0xd7, 0xce, 0xe4, 0x19, 0x8b, 0xfe, 0x90, 0x6e, 0xc2, 0x0c, 0x83,
	0x61, 0x8d, 0xb8, 0xb1, 0xd3, 0xa8, 0x95, 0x1e, 0x13, 0xe7, 0x01, 0xf6, 0x76, 0x37, 0xaa, 0xad,
	0xda, 0x86, 0x52, 0x6d, 0x95, 0x04, 0xe9, 0x57, 0xe0, 0xfa, 0x40, 0xbc, 0x8f, 0x9c, 0xf5, 0x9f,
	0x26, 0xe2, 0x12, 0x37, 0xae, 0x3d, 0x12, 0xb6, 0x4b, 0xff, 0x26, 0x10, 0x09, 0x4b, 0xe8, 0x8c,
	0x0d, 0xf3, 0x3a, 0xcc, 0xba, 0x96, 0xab, 0x1a, 0xa1, 0xf7, 0x95, 0x29, 0x19, 0x08, 0x88, 0x1a,
	0x76, 0xef, 0xc3, 0x6c, 0xf0, 0x5e, 0x49, 0xd7, 0x24, 0xf7, 0xc2, 0x89, 0x77, 0x2b, 0x87, 0x51,
	0x25, 0x1f, 0x41, 0x59, 0xce, 0x23, 0x28, 0xd7, 0x7f, 0x04, 0x7d, 0x5e, 0x80, 0xca, 0x16, 0x8a,
	0xec, 0x08, 0x6b, 0x67, 0xf5, 0x0d, 0x8f, 0xaf, 0x5b, 0x30, 0xe3, 0xf4, 0xf6, 0x15, 0xef, 0x79,
	0x2b, 0xbd, 0x29, 0x61, 0xda, 0x21, 0xbf, 0x98, 0x85, 0x22, 0x13, 0x58, 0x28, 0xfa, 0x4c, 0x04,
	0x3d, 0x32, 0xc3, 0xfd, 0x84, 0x3c, 0xe2, 0x23, 0xe7, 0x18, 0x2e, 0xb5, 0xd4, 0x63, 0xa4, 0x59,
	0xa7, 0xe6, 0x9a, 0xaa, 0x1d, 0x22, 0x5e, 0x91, 0xba, 0x0a, 0x85, 0x7d, 0x5c, 0x3f, 0xb4, 0xe9,
	0xe6, 0x09, 0xa0, 0xae, 0x39, 0x58, 0xb2, 0x6c, 0xa4, 0x3a, 0x96, 0xe9, 0x5d, 0x9f, 0x69, 0x49,
	0xba, 0x0d, 0x4b, 0xf1, 0xce, 0xd8, 0xf0, 0x9e, 0x82, 0x79, 0xd2, 0x1a, 0x2b, 0xd0, 0x1d, 0xeb,
	0x04, 0x69, 0x64, 0xe9, 0x14, 0xe4, 0xb9, 0x7d, 0x56, 0x8f, 0x00, 0xa5, 0x77, 0xa0, 0xec, 0x21,
	0xa8, 0x1a, 0x46, 0x2a, 0x82, 0x03, 0x9a, 0x32, 0x11, 0x9a, 0xd6, 0xe0, 0x4a, 0x02, 0xca, 0x74,
	0x64, 0x35, 0xe1, 0x4a, 0x30, 0x77, 0xfb, 0xc8, 0x26, 0x58, 0x38, 0xe9, 0x0a, 0xbd, 0xa0, 0x65,
	0x22, 0x2f, 0x87, 0x5f, 0x8e, 0x88, 0x66, 0x80, 0x95, 0x91, 0xd6, 0x00, 0xa0, 0x13, 0x40, 0xec,
	0x31, 0x02, 0xd9, 0x1e, 0x9f, 0xe1, 0x13, 0x07, 0x82, 0x88, 0x18, 0x62, 0xe8, 0x1c, 0xe2, 0x9f,
	0xf8, 0xfa, 0x42, 0xf1, 0x9d, 0x20, 0xdb, 0xd1, 0x7d, 0x36, 0x15, 0x09, 0xf0, 0x5d, 0x0a, 0x93,
	0xfe, 0x44, 0x80, 0x5b, 0x5b, 0xc8, 0xad, 0x3d, 0x74, 0x91, 0x6d, 0xaa, 0x06, 0x3b, 0x4f, 0x5b,
	0xa8, 0xd3, 0x25, 0xcf, 0xb1, 0x77, 0xf7, 0x42, 0x83, 0x0e, 0xdd, 0x54, 0x85, 0x61, 0xf6, 0xa9,
	0xcc, 0x84, 0xd7, 0xc1, 0x1b, 0x50, 0x24, 0xfb, 0x90, 0x7d, 0xa6, 0x60, 0x14, 0x4c, 0xe4, 0x66,
	0x19, 0x6c, 0xdd, 0xd2, 0x90, 0xf4, 0x26, 0x3c, 0x35, 0x82, 0x6a, 0xc6, 0xd4, 0x4b, 0x30, 0xed,
	0x1c, 0xf7, 0x02, 0x92, 0xa7, 0x9c, 0xe3, 0x5e, 0x5d, 0x93, 0xfe, 0x51, 0x80, 0x8f, 0xf6, 0x23,
	0x60, 0x17, 0x46, 0x7c, 0xaf, 0x0b, 0x8d, 0xfc, 0xa7, 0xc3, 0x68, 0x17, 0x67, 0x4a, 0xae, 0x9f,
	0x29, 0x55, 0x78, 0x7a, 0xf4, 0x98, 0x86, 0xf3, 0x65, 0x17, 0xa6, 0xe9, 0x4e, 0x27, 0x96, 0x61,
	0x86, 0x0d, 0xc4, 0x1b, 0x34, 0x2b, 0xe2, 0xb3, 0x87, 0x8c, 0xdf, 0x73, 0xf4, 0x21, 0x05, 0x72,
	0xf6, 0x10, 0xcb, 0x84, 0xb7, 0x43, 0xd0, 0x92, 0xf4, 0xa3, 0x2c, 0xcc, 0xee, 0xaa, 0xba, 0xb6,
	0xd7, 0x3d, 0xb4, 0x55, 0x0d, 0x89, 0x5b, 0x90, 0xdf, 0xc7, 0x57, 0xf5, 0x31, 0x77, 0x60, 0x79,
	0x06, 0xb7, 0xc6, 0x04, 0x6e, 0xc3, 0x6c, 0x8f, 0xe2, 0x54, 0xc6, 0x34, 0x0c, 0xcb, 0xc0, 0x10,
	0x60, 0x74, 0x4f, 0xc1, 0x3c, 0x32, 0x89, 0xcf, 0x12, 0x56, 0x1c, 0x03, 0x6b, 0xcc, 0x5c, 0x08,
	0x5a, 0x27, 0xb7, 0x7a, 0x62, 0x6c, 0x51, 0xf0, 0x5d, 0x9d, 0xe3, 0x79, 0xa2, 0x40, 0x6a, 0x6f,
	0xa8, 0x2e, 0x75, 0x85, 0xd2, 0x99, 0x71, 0xb0, 0x20, 0x93, 0xdf, 0x98, 0x97, 0x5d, 0x5b, 0x6f,
	0xd3, 0x67, 0x86, 0x29, 0x99, 0x16, 0xb0, 0xc4, 0x91, 0x1f, 0x98, 0x8a, 0x19, 0x8f, 0xf9, 0x7a,
	0x1b, 0xd5, 0x07, 0xbc, 0x51, 0xe4, 0xcf, 0xd7, 0x76, 0xcb, 0x0c, 0x1f, 0x6d, 0x62, 0xbc, 0x27,
	0x86, 0x8f, 0x82, 0x67, 0xf8, 0x58, 0xf7, 0x61, 0xd2, 0xfb, 0xc4, 0x75, 0x22, 0x34, 0xb5, 0xfe,
	0xbe, 0x7d, 0x07, 0x72, 0xc7, 0xe8, 0xcc, 0xd3, 0x95, 0xd2, 0x4d, 0x09, 0x69, 0x29, 0x7d, 0x48,
	0x5c, 0x2c, 0xa2, 0xb8, 0xfd, 0x63, 0x73, 0xae, 0xab, 0xea, 0x9a, 0xc2, 0xa6, 0xce, 0xeb, 0xe5,
	0x59, 0xce, 0x85, 0x15, 0xa0, 0x94, 0x8b, 0xdd, 0x10, 0x7e, 0xe9, 0x6b, 0x19, 0x28, 0xd3, 0x87,
	0x99, 0x70, 0x1d, 0x5f, 0x6b, 0xf8, 0xe9, 0x14, 0xda, 0x44, 0x69, 0xc8, 0x9e, 0xb3, 0x25, 0xff,
	0x43, 0xef, 0x21, 0x30, 0xc2, 0x18, 0x36, 0x1d, 0x2d, 0x28, 0x86, 0xa7, 0x83, 0x71, 0x67, 0x8c,
	0xd9, 0x98, 0x0d, 0xcd, 0x86, 0xf4, 0x5d, 0x01, 0xca, 0x54, 0xd4, 0x7e, 0x76, 0x26, 0x43, 0xba,
	0xea, 0xbd, 0xb1, 0x25, 0xf0, 0x49, 0xfa, 0x7a, 0x16, 0xae, 0xb0, 0x67, 0xdc, 0x84, 0x21, 0xfd,
	0x5c, 0x3e, 0xa7, 0x86, 0xe7, 0x69, 0x7a, 0x92, 0x79, 0x4a, 0x94, 0xf2, 0x99, 0x73, 0x96, 0x72,
	0xdb, 0xf7, 0x52, 0xf8, 0xc9, 0x89, 0xf9, 0x0f, 0x33, 0x20, 0xd1, 0xa5, 0xb5, 0x7e, 0xa4, 0xba,
	0x0d, 0xcb, 0xd5, 0x0f, 0xf4, 0xb6, 0x4a, 0x48, 0xb2, 0x8e, 0xd1, 0x39, 0xbc, 0xcf, 0xbe, 0x01,
	0x45, 0xf5, 0x44, 0xd5, 0xc9, 0x86, 0xad, 0xa8, 0x2e, 0xc7, 0x9b, 0xe7, 0xac, 0x5f, 0xbf, 0xea,
	0x8a, 0xdb, 0x21, 0xa3, 0xf9, 0xf8, 0xbe, 0x51, 0xbe, 0xa1, 0xfd, 0x10, 0x2e, 0x98, 0xe8, 0x54,
	0x61, 0xee, 0x8f, 0xba, 0xe9, 0x22, 0xfb, 0x44, 0x35, 0x98, 0x54, 0x71, 0x7a, 0xf3, 0x35, 0xd0,
	0x69, 0x8b, 0xb4, 0xaf, 0xb3, 0xe6, 0xf2, 0xa2, 0x19, 0x07, 0x49, 0xb7, 0xe1, 0xe6, 0x50, 0xb6,
	0xb2, 0x49, 0x2d, 0xc3, 0x4c, 0x07, 0x39, 0x0e, 0xbe, 0x48, 0x32, 0xb6, 0xb2, 0xa2, 0xf4, 0x25,
	0x01, 0x16, 0xfb, 0x7a, 0x22, 0xdc, 0xa4, 0x8e, 0x36, 0x74, 0x35, 0x09, 0x1c, 0xdc, 0x24, 0xf5,
	0xe9, 0x62, 0x7a, 0x05, 0x98, 0x53, 0x0e, 0x59, 0x4b, 0x99, 0xd1, 0xaa, 0x03, 0xad, 0x5d, 0x33,
	0x35, 0xe9, 0x7f, 0x04, 0xb8, 0xbe, 0xe7, 0x8c, 0x94, 0x12, 0x17, 0x97, 0x43, 0x52, 0x42, 0xca,
	0x75, 0x4d, 0xbc, 0x05, 0xf3, 0x6a, 0xcf, 0x3d, 0x42, 0x9a, 0x12, 0xbd, 0x98, 0x14, 0x29, 0x74,
	0x8f, 0x3a, 0xf8, 0x3d, 0x05, 0xf3, 0xed, 0x9e, 0xe3, 0x5a, 0x1d, 0xc5, 0xe3, 0x0a, 0xd3, 0x80,
	0x28, 0x74, 0x9b, 0x02, 0xc5, 0x3d, 0x28, 0x3a, 0x47, 0xaa, 0x8d, 0x14, 0xc7, 0xb5, 0x91, 0x7a,
	0x3c, 0x81, 0x60, 0xcc, 0x12, 0x3c, 0x4d, 0x82, 0x26, 0x76, 0xa9, 0x9a, 0x8a, 0xbf, 0xc0, 0xbd,
	0x0e, 0x4f, 0x0e, 0x66, 0xc0, 0xc8, 0xf9, 0xdc, 0x06, 0x89, 0x6e, 0xcd, 0x43, 0x39, 0xc8, 0xfb,
	0xa0, 0x47, 0xe4, 0x6b, 0x18, 0xba, 0x91, 0xf4, 0x68, 0xb0, 0x1c, 0x35, 0x4a, 0x0f, 0xa5, 0x6b,
	0xa0, 0x4b, 0xe6, 0x88, 0x57, 0xcb, 0x6f, 0x0a, 0xf0, 0x8b, 0x5c, 0xdd, 0x30, 0x7a, 0x1d, 0xb8,
	0xdc, 0x3e, 0x52, 0x5d, 0xc5, 0x0c, 0xd5, 0x50, 0x88, 0x0c, 0x31, 0x51, 0x7f, 0x8d, 0x6f, 0x92,
	0x93, 0x7b, 0xb9, 0xd4, 0x4e, 0x02, 0x4b, 0x2a, 0xb9, 0x88, 0x55, 0x0d, 0x63, 0xcf, 0x21, 0x4e,
	0x87, 0xfd, 0x55, 0x9c, 0x49, 0xf9, 0xf0, 0x7b, 0x02, 0xb9, 0x18, 0x8d, 0xe8, 0x83, 0x31, 0xa1,
	0x03, 0xa5, 0x9e, 0x43, 0x7d, 0x24, 0x5d, 0x3a, 0x78, 0x4f, 0xc5, 0x5c, 0xe7, 0xb6, 0x13, 0x27,
	0xf7, 0x51, 0x77, 0x51, 0x47, 0x9e, 0xef, 0xb1, 0xcf, 0xb4, 0x5b, 0xe9, 0xeb, 0x02, 0xac, 0x56,
	0x0d, 0xc3, 0x3a, 0x95, 0x51, 0xd7, 0x50, 0xcf, 0x36, 0x2d, 0xfb, 0x9e, 0x4a, 0x5e, 0x82, 0xb4,
	0x09, 0x8e, 0x84, 0x61, 0x2e, 0x90, 0x4b, 0x30, 0xed, 0x22, 0xb3, 0x67, 0x7b, 0xab, 0x9b, 0x95,
	0x30, 0xbc, 0x83, 0xdc, 0x23, 0xcb, 0x7b, 0x67, 0x66, 0x25, 0xe9, 0x05, 0x78, 0x2e, 0x15, 0x7d,
	0x4c, 0xdf, 0xf9, 0x27, 0x01, 0x2e, 0x25, 0xd6, 0xe8, 0x73, 0x1f, 0x0c, 0xad, 0x92, 0x4c, 0x64,
	0x95, 0xe0, 0xcb, 0x51, 0xc7, 0x32, 0xdd, 0x23, 0x2f, 0x0a, 0x87, 0x14, 0xf0, 0x35, 0xea, 0x58,
	0x37, 0x3d, 0x32, 0xc9, 0x6f, 0xf1, 0x45, 0xb8, 0xdc, 0xee, 0x75, 0x7a, 0x86, 0xea, 0xea, 0x27,
	0x48, 0xa1, 0x23, 0x52, 0x68, 0xdb, 0x29, 0x72, 0xb1, 0xba, 0x14, 0x7c, 0x6e, 0x91, 0xaf, 0xdb,
	0x04, 0xd7, 0x0a, 0x5c, 0xa0, 0xbb, 0x58, 0xb4, 0x0d, 0xbd, 0x8c, 0x2d, 0xd2, 0x4f, 0xa1, 0xfa,
	0xd2, 0x97, 0x72, 0xf0, 0xf8, 0xd0, 0xf9, 0x0d, 0x2e, 0xc7, 0x42, 0xf8, 0x72, 0x5c, 0x86, 0x19,
	0x36, 0x03, 0xde, 0x18, 0x59, 0x31, 0xed, 0x74, 0xe0, 0xab, 0x19, 0xa3, 0x98, 0x6c, 0x9e, 0x74,
	0xa7, 0xcc, 0xcb, 0x45, 0x0a, 0x6c, 0x12, 0x98, 0x78, 0x03, 0x58, 0x59, 0xa1, 0x3e, 0xb4, 0x74,
	0x3c, 0xb3, 0x14, 0xf6, 0x2e, 0x06, 0xe1, 0x91, 0x47, 0x37, 0x7b, 0x85, 0x84, 0xe9, 0xd0, 0xdb,
	0xe6, 0x62, 0x64, 0xc7, 0x6f, 0xa1, 0x87, 0xae, 0xb8, 0x0a, 0x97, 0x62, 0xf5, 0x59, 0xff, 0x79,
	0xd2, 0xff, 0x85, 0x48, 0x0b, 0x46, 0x46, 0xc8, 0x84, 0x50, 0x88, 0x9a, 0x10, 0xbc, 0xab, 0x30,
	0x84, 0xae, 0xc2, 0xe1, 0x17, 0xfa, 0xd9, 0xe8, 0x0b, 0xfd, 0x0d, 0x28, 0xaa, 0x58, 0x06, 0x15,
	0x9b, 0x08, 0x21, 0x7b, 0x87, 0x9f, 0x55, 0x03, 0xb9, 0xc4, 0x87, 0x6b, 0x9b, 0x1c, 0xf9, 0x1a,
	0xd6, 0x73, 0xe6, 0x46, 0x1f, 0xae, 0xac, 0x76, 0xd5, 0x0d, 0x3f, 0xd4, 0xab, 0x6e, 0x8a, 0x87,
	0xfa, 0xaa, 0x2b, 0xfd, 0x73, 0x06, 0x72, 0xc4, 0x55, 0x60, 0x09, 0xa6, 0x1d, 0x64, 0x6a, 0xfe,
	0xbc, 0xb3, 0x92, 0x78, 0x0d, 0x0a, 0x36, 0x6a, 0xeb, 0x5d, 0x1d, 0x31, 0x97, 0xe9, 0x82, 0x1c,
	0x00, 0xc2, 0x0c, 0xca, 0x46, 0x19, 0x14, 0x58, 0x53, 0x72, 0x61, 0x6b, 0x8a, 0x58, 0xf3, 0x02,
	0xd3, 0xa6, 0xd2, 0x98, 0x07, 0x31, 0x89, 0x4d, 0xdc, 0xcc, 0x8b, 0x64, 0x7b, 0x09, 0x0a, 0xc4,
	0x95, 0x9b, 0x18, 0x31, 0x46, 0xfb, 0x7d, 0xe4, 0x71, 0x65, 0x62, 0xc3, 0xb8, 0xcb, 0x1a, 0x86,
	0x54, 0xf0, 0x15, 0x7e, 0x1a, 0x88, 0xea, 0x4d, 0x90, 0x11, 0x33, 0xc3, 0x55, 0x28, 0xa8, 0xa6,
	0x65, 0x52, 0xd7, 0x0b, 0x2a, 0x47, 0x79, 0x0c, 0xc0, 0x55, 0xa5, 0x07, 0x30, 0x83, 0xff, 0x1f,
	0x6e, 0x8a, 0x0a, 0xd8, 0x94, 0x89, 0xb0, 0x29, 0xc2, 0xf6, 0x6c, 0x8c, 0xed, 0xd2, 0xdf, 0x0a,
	0xb0, 0x48, 0xf5, 0x43, 0xdc, 0x83, 0xb7, 0xa5, 0xfe, 0xa4, 0xa6, 0x30, 0xc2, 0xc2, 0xa9, 0xc9,
	0x58, 0x28, 0xb5, 0x40, 0x0c, 0x8f, 0x84, 0x9d, 0x61, 0x6f, 0x42, 0x8e, 0xf0, 0x94, 0x9e, 0xda,
	0xcb, 0xfc, 0xd8, 0x65, 0xd2, 0x4e, 0xfa, 0x57, 0x01, 0x16, 0xeb, 0xa6, 0x83, 0x6c, 0xf7, 0x67,
	0x9d, 0x41, 0x51, 0x19, 0x9b, 0x8e, 0xc9, 0x58, 0x0b, 0xc4, 0xf0, 0x30, 0xcf, 0x89, 0x7b, 0x6d,
	0x58, 0xa4, 0xda, 0x61, 0x98, 0x79, 0xe7, 0x2d, 0xc3, 0x08, 0xc4, 0x70, 0x27, 0x8c, 0xf4, 0x1d,
	0xe2, 0x5c, 0xd9, 0x46, 0x06, 0xd2, 0x94, 0x31, 0xc7, 0x50, 0xf4, 0x10, 0x30, 0x0e, 0x2d, 0x6c,
	0x21, 0xc2, 0x1e, 0x5f, 0x0b, 0xab, 0x46, 0xac, 0x7b, 0x1f, 0xe7, 0x47, 0x1d, 0x98, 0xf7, 0x5a,
	0x50, 0x0a, 0xb0, 0x32, 0xd2, 0xef, 0xc0, 0x14, 0x89, 0x40, 0x61, 0x78, 0xd3, 0x90, 0x4c, 0x1b,
	0x4a, 0x9f, 0x82, 0xf9, 0x75, 0xd5, 0x7c, 0x84, 0x12, 0x2b, 0x7d, 0x0c, 0x16, 0xfc, 0x1e, 0x18,
	0xd9, 0x57, 0x20, 0xdf, 0x56, 0xcd, 0x80, 0xd9, 0x79, 0x79, 0xa6, 0x4d, 0xab, 0x48, 0xa7, 0xd4,
	0x03, 0x96, 0x74, 0x19, 0xa6, 0xea, 0x2a, 0x14, 0x28, 0x1d, 0x81, 0xf2, 0x96, 0xa7, 0x80, 0xd1,
	0x17, 0xfa, 0x9b, 0x30, 0x47, 0xd6, 0xc6, 0x87, 0x3d, 0xd5, 0x74, 0x75, 0xf7, 0x8c, 0x3d, 0xf4,
	0x16, 0x31, 0xf0, 0x1d, 0x06, 0x93, 0x56, 0xe1, 0x52, 0xac, 0xe3, 0xd1, 0xc4, 0xfe, 0xb5, 0x00,
	0x97, 0xfd, 0xb1, 0x31, 0x4e, 0x9c, 0x07, 0xc1, 0x37, 0xa0, 0xe8, 0x73, 0x36, 0x30, 0x51, 0xcd,
	0xfa, 0xb0, 0xba, 0x16, 0x5d, 0xef, 0xb9, 0x09, 0x37, 0xc4, 0x6d, 0x62, 0x38, 0x8c, 0x0d, 0x63,
	0xe4, 0xf0, 0x07, 0xbe, 0x25, 0xfe, 0xb7, 0x00, 0x73, 0xb8, 0xc2, 0xae, 0x6d, 0x75, 0x2c, 0xe2,
	0x9d, 0x36, 0xe2, 0x1d, 0xec, 0x2a, 0x14, 0x4c, 0x74, 0xaa, 0x50, 0xa3, 0x3e, 0xf5, 0x94, 0xcd,
	0x9b, 0xe8, 0x74, 0x97, 0xd8, 0xf5, 0xaf, 0x42, 0xc1, 0x32, 0x34, 0xf6, 0x91, 0xfa, 0xcb, 0xe6,
	0x2d, 0x43, 0xa3, 0x1f, 0xdf, 0x83, 0x39, 0x4d, 0x77, 0x68, 0x1c, 0x6c, 0x88, 0x15, 0x9c, 0x17,
	0xeb, 0x0d, 0xd6, 0x94, 0xb0, 0xa3, 0xa8, 0x85, 0x4a, 0xf8, 0x5e, 0xef, 0x23, 0xa6, 0xfa, 0x20,
	0x8d, 0x39, 0xf5, 0xbb, 0xa3, 0x1a, 0xe1, 0x45, 0x98, 0x42, 0xb6, 0x6d, 0xd9, 0x64, 0x97, 0x2c,
	0xc8, 0xb4, 0x20, 0xfd, 0xa7, 0x00, 0x85, 0xff, 0xb7, 0x83, 0x7f, 0x95, 0x3c, 0x43, 0x44, 0xe6,
	0xdf, 0x5b, 0x13, 0x31, 0x27, 0x25, 0xa1, 0xcf, 0x49, 0xe9, 0x8f, 0x04, 0x28, 0xf7, 0x37, 0x66,
	0x92, 0xb8, 0x02, 0x17, 0x88, 0xae, 0xcb, 0xe0, 0x8a, 0xda, 0xc6, 0x37, 0x13, 0x26, 0x94, 0x8b,
	0x58, 0xed, 0x65, 0x5f, 0xaa, 0xe4, 0x83, 0xf8, 0x01, 0x2c, 0x90, 0x25, 0xe2, 0xb7, 0xf0, 0x5c,
	0x30, 0x9e, 0xe3, 0x5f, 0x28, 0x01, 0x15, 0xf3, 0x87, 0xe1, 0xa2, 0x23, 0xbd, 0x4f, 0x9c, 0x80,
	0x42, 0x56, 0xca, 0xbe, 0xd1, 0x0e, 0xbc, 0x79, 0x8f, 0xf4, 0xd5, 0xb2, 0x89, 0x8f, 0x4d, 0x32,
	0x6e, 0xff, 0xd0, 0x82, 0xbe, 0x71, 0x71, 0x2a, 0xb6, 0x01, 0xb2, 0x10, 0x0a, 0xe9, 0xcf, 0xb2,
	0x70, 0x81, 0xd9, 0x72, 0x23, 0x27, 0xd7, 0x24, 0xfb, 0xd8, 0x50, 0x3b, 0xfb, 0x79, 0xee, 0x60,
	0xfd, 0x5b, 0xfc, 0x54, 0xff, 0x16, 0xff, 0x7f, 0x1c, 0x71, 0x78, 0x13, 0xe6, 0xc2, 0x9b, 0xba,
	0x53, 0xce, 0x93, 0x79, 0x2f, 0x86, 0x76, 0x75, 0x27, 0xaa, 0x79, 0x15, 0xa2, 0x9a, 0x17, 0x5e,
	0x6f, 0xaa, 0x73, 0x66, 0xb6, 0x99, 0x2f, 0x36, 0x2d, 0x48, 0x4b, 0x70, 0x31, 0x3a, 0x6f, 0xcc,
	0x98, 0xf0, 0xed, 0x0c, 0x5c, 0xc7, 0xc7, 0x19, 0x09, 0x34, 0x8d, 0x5d, 0xbd, 0xb9, 0x26, 0x37,
	0x7e, 0x0a, 0x65, 0xfa, 0x4f, 0xa1, 0x11, 0x9e, 0xf8, 0x51, 0xab, 0x4a, 0x2e, 0xc1, 0x79, 0x26,
	0x18, 0xec, 0x54, 0x6c, 0xb0, 0x11, 0xf1, 0x98, 0x9e, 0x5c, 0xa1, 0x0d, 0x04, 0x71, 0x26, 0x16,
	0x72, 0x25, 0xc1, 0x93, 0x83, 0xf9, 0xc4, 0x98, 0xf9, 0x17, 0x02, 0x3c, 0x81, 0x2b, 0x6d, 0x6f,
	0x6f, 0xfd, 0xd4, 0xf2, 0x72, 0x60, 0xa8, 0xad, 0x74, 0x83, 0x4a, 0x42, 0x22, 0xf1, 0x6c, 0x80,
	0x3f, 0x16, 0xe0, 0x26, 0xab, 0x43, 0x64, 0x7d, 0xac, 0x51, 0x8e, 0xd8, 0x0e, 0xa2, 0x43, 0xc8,
	0xc6, 0x87, 0xd0, 0xb7, 0x86, 0x73, 0x09, 0x6b, 0x78, 0xa8, 0xcc, 0x44, 0x98, 0x30, 0x1d, 0x63,
	0xc2, 0x47, 0xe0, 0xd6, 0xf0, 0x01, 0x32, 0x4e, 0xbc, 0x4a, 0xbc, 0x98, 0x64, 0x64, 0xa8, 0x6e,
	0x10, 0xd0, 0xcd, 0xe7, 0xd0, 0x23, 0xbd, 0x41, 0x7c, 0x95, 0xfa, 0xda, 0x06, 0x0e, 0x83, 0xc1,
	0xf8, 0xfd, 0xe3, 0xcf, 0x67, 0x80, 0x83, 0x75, 0xd0, 0x2d, 0xe4, 0x92, 0xdc, 0x32, 0x34, 0xf7,
	0x0d, 0x87, 0x1f, 0xec, 0xf3, 0xc4, 0xa3, 0x20, 0xd2, 0x86, 0x75, 0x57, 0x81, 0x3c, 0xcd, 0xcc,
	0x83, 0xbc, 0xbe, 0xfc, 0xb2, 0xf4, 0x0a, 0x39, 0x67, 0xbd, 0xdc, 0x22, 0xd1, 0xce, 0x46, 0x64,
	0x9e, 0xf8, 0x96, 0x40, 0x18, 0x14, 0x6f, 0xcb, 0x3a, 0x0d, 0x92, 0x03, 0x09, 0x91, 0xe4, 0x40,
	0x3b, 0x9e, 0x0d, 0x86, 0xfa, 0x39, 0xbd, 0x92, 0x2e, 0xf9, 0x09, 0xed, 0x24, 0x62, 0x8d, 0xb9,
	0x0e, 0xb3, 0xba, 0xa3, 0x20, 0x4d, 0x77, 0x89, 0xb3, 0x05, 0x75, 0x7e, 0x04, 0xdd, 0xa9, 0x31,
	0x88, 0xf4, 0x03, 0x01, 0x2e, 0xd1, 0x6b, 0xbe, 0x87, 0x85, 0xe7, 0x60, 0xc6, 0x64, 0x29, 0x4e,
	0xef, 0x20, 0x48, 0x6f, 0x04, 0x18, 0xd4, 0x24, 0x10, 0x8e, 0x35, 0xaa, 0x77, 0xd4, 0x43, 0xb4,
	0xfa, 0x72, 0x68, 0x8d, 0x32, 0x48, 0xe8, 0xf3, 0x0b, 0x2f, 0x86, 0x5e, 0x6b, 0x18, 0x84, 0xf6,
	0x4e, 0x0a, 0xcf, 0x3e, 0xbb, 0x1a, 0xc8, 0x2f, 0x78, 0xa0, 0xba, 0x26, 0x7d, 0x31, 0x61, 0x44,
	0x94, 0xeb, 0x71, 0xf3, 0xb0, 0x08, 0x39, 0xe2, 0xef, 0x44, 0x47, 0x40, 0x7e, 0x8f, 0xa2, 0xfd,
	0x0a, 0xe4, 0x0f, 0x6d, 0xab, 0xd7, 0x0d, 0x28, 0x9f, 0x21, 0x65, 0xea, 0x37, 0x1b, 0xd8, 0xcf,
	0xbc, 0xc4, 0x4e, 0x52, 0x8d, 0x78, 0xe9, 0x57, 0x0d, 0xc3, 0x23, 0xc6, 0x59, 0x3b, 0x63, 0xee,
	0x53, 0xf5, 0x0d, 0x87, 0x5b, 0xe5, 0xfb, 0x9c, 0x40, 0x7c, 0xf1, 0x07, 0xe3, 0xf1, 0xfd, 0xd0,
	0x83, 0x3c, 0x52, 0x84, 0x30, 0xef, 0xd2, 0x9b, 0x32, 0x8f, 0xce, 0x16, 0x6e, 0x2b, 0xfb, 0xb9,
	0x62, 0x48, 0xd1, 0x91, 0x3e, 0x13, 0x64, 0x50, 0x22, 0x90, 0x51, 0x4a, 0xfb, 0x3d, 0x28, 0x78,
	0x18, 0x3c, 0xed, 0x6b, 0x25, 0x1d, 0x1d, 0x72, 0x80, 0x40, 0xfa, 0xaa, 0x00, 0x79, 0x0f, 0xce,
	0x35, 0x97, 0xe1, 0xc9, 0xca, 0x46, 0x27, 0xab, 0xee, 0x4d, 0x16, 0x55, 0xa9, 0x52, 0x72, 0x27,
	0xbc, 0xc4, 0xa4, 0xe7, 0xc9, 0x42, 0xdf, 0x55, 0x6d, 0xd7, 0x44, 0x76, 0xd3, 0x55, 0x49, 0x52,
	0xae, 0x91, 0xa9, 0x5e, 0xee, 0x92, 0x3d, 0xb0, 0xaf, 0x15, 0x9b, 0xc6, 0x8f, 0x13, 0x25, 0x5e,
	0x37, 0x95, 0x43, 0xcb, 0xd2, 0xb0, 0x1a, 0x46, 0x3e, 0x33, 0x25, 0xbe, 0xa4, 0x3b, 0x75, 0x73,
	0xcb, 0xb2, 0x34, 0xaf, 0x99, 0xd4, 0x82, 0xab, 0xcd, 0xde, 0x7e, 0x47, 0x1f, 0x6b, 0xab, 0x1a,
	0x94, 0xa9, 0x4c, 0x7a, 0x02, 0xae, 0x25, 0x63, 0x65, 0x47, 0xc0, 0x06, 0xd5, 0xbf, 0x69, 0x16,
	0xb2, 0x90, 0x58, 0x86, 0xe4, 0xfa, 0x06, 0x14, 0x7d, 0x71, 0x0c, 0x04, 0x7b, 0xd6, 0x83, 0x61,
	0xc9, 0x3e, 0x85, 0x27, 0x07, 0x63, 0x61, 0xec, 0x68, 0x86, 0xe5, 0x88, 0xca, 0xf3, 0x0b, 0x9c,
	0x5a, 0x7c, 0x14, 0x6f, 0x58, 0x9c, 0xbe, 0x92, 0xa1, 0x53, 0x10, 0xeb, 0xd9, 0x23, 0xfd, 0x9e,
	0x1f, 0x71, 0x4b, 0xdd, 0x65, 0x9f, 0x4f, 0x27, 0x22, 0xd1, 0xe0, 0x5a, 0xbc, 0x39, 0x04, 0xb9,
	0x4d, 0xa6, 0x64, 0x5a, 0xc0, 0x7d, 0xec, 0xf7, 0xda, 0xc7, 0xc8, 0xf3, 0x9e, 0x48, 0xd9, 0xc7,
	0x1a, 0x69, 0x2b, 0x33, 0x1c, 0xe2, 0x3a, 0x2c, 0xa8, 0x07, 0x2e, 0xb2, 0x15, 0x3f, 0x93, 0x1d,
	0x87, 0x53, 0xce, 0x3c, 0x69, 0xe2, 0x97, 0xa5, 0xaf, 0x08, 0xc4, 0xb5, 0xbc, 0x9f, 0x2b, 0x8f,
	0x70, 0x2a, 0xe2, 0x31, 0x02, 0x99, 0x78, 0x8c, 0x80, 0xf4, 0xbb, 0x02, 0x3c, 0x2e, 0xa3, 0x13,
	0x1d, 0x9d, 0x0e, 0x9a, 0xae, 0x0f, 0x60, 0xc6, 0x26, 0x15, 0x3c, 0xaa, 0xd6, 0xf8, 0xa8, 0x4a,
	0xc4, 0xca, 0x90, 0xca, 0x1e, 0x4a, 0xbc, 0x93, 0xa8, 0x5a, 0x87, 0x6a, 0x4c, 0xec, 0x95, 0x8d,
	0x94, 0xeb, 0x9a, 0xf4, 0x0d, 0x01, 0xae, 0x0d, 0x43, 0x92, 0xf4, 0x28, 0xa9, 0x92, 0x64, 0x7d,
	0x5e, 0x38, 0x9c, 0x57, 0x24, 0x06, 0x05, 0xd4, 0x36, 0x74, 0x13, 0x29, 0x11, 0x8f, 0xf8, 0x39,
	0x06, 0x95, 0x09, 0x50, 0x7c, 0x06, 0x2e, 0x78, 0xd5, 0xd0, 0xc3, 0xae, 0xa1, 0x9a, 0x44, 0x33,
	0x63, 0xc7, 0x91, 0xc8, 0x3e, 0xd5, 0x82, 0x2f, 0xd2, 0x67, 0xe1, 0x89, 0x41, 0xcc, 0x63, 0xb3,
	0xfa, 0xc9, 0x78, 0x10, 0xe0, 0xfa, 0x44, 0xdc, 0xa3, 0x58, 0xfd, 0x58, 0x40, 0xc9, 0x18, 0x30,
	0x7b, 0x7e, 0xff, 0x71, 0x1e, 0x5d, 0x83, 0x82, 0xd3, 0x6b, 0xb7, 0x11, 0xd2, 0x90, 0xc6, 0xb8,
	0x14, 0x00, 0xf0, 0x7e, 0x66, 0xa2, 0xd3, 0x70, 0xf2, 0x9f, 0x82, 0x5c, 0x30, 0xd1, 0x29, 0xcb,
	0xf7, 0xf3, 0x0e, 0xcc, 0x47, 0x57, 0x08, 0x35, 0xca, 0x92, 0xd9, 0x40, 0x1a, 0x8b, 0x40, 0x09,
	0x00, 0x78, 0x93, 0xa2, 0x2b, 0x28, 0x22, 0x7e, 0xb3, 0x14, 0x46, 0xe5, 0xef, 0x5b, 0x02, 0x2c,
	0xc4, 0x68, 0xef, 0xa3, 0x79, 0x50, 0xc2, 0x47, 0xef, 0x64, 0xca, 0x46, 0x4f, 0x26, 0x5f, 0x53,
	0xcd, 0x45, 0xdf, 0xd8, 0x5f, 0x83, 0xd9, 0x5e, 0xd7, 0xb0, 0x54, 0x8d, 0x2c, 0x63, 0x1e, 0xbf,
	0x38, 0x5a, 0x1d, 0x03, 0xa4, 0xbf, 0x9b, 0x82, 0x19, 0xa6, 0x15, 0x24, 0xe5, 0xd2, 0x71, 0x8e,
	0x2c, 0xdb, 0xa5, 0x59, 0x1f, 0xd9, 0xb5, 0x83, 0x40, 0x48, 0xd6, 0xc7, 0x1b, 0x50, 0xd4, 0x74,
	0xa7, 0x6b, 0xa8, 0x67, 0xb4, 0x02, 0xb3, 0xa6, 0x32, 0x18, 0xa9, 0xf2, 0x34, 0x94, 0x62, 0x49,
	0x2a, 0x1d, 0x92, 0xd6, 0xae, 0x10, 0x28, 0x0a, 0x24, 0x43, 0xa5, 0x13, 0xf8, 0x1e, 0x4f, 0xc5,
	0x7c, 0x8f, 0x49, 0x0a, 0x27, 0x55, 0x73, 0xd8, 0x7b, 0xc9, 0x0c, 0x2e, 0x57, 0x35, 0x87, 0xbc,
	0xda, 0x7a, 0xef, 0x7e, 0x05, 0x99, 0xfc, 0x8e, 0x30, 0x29, 0x1f, 0x65, 0x92, 0xf7, 0xc8, 0x5b,
	0x08, 0x3d, 0xf2, 0xbe, 0x03, 0x79, 0xdf, 0xef, 0x0b, 0x08, 0xd7, 0x5e, 0xe0, 0xb6, 0xf4, 0x10,
	0x7d, 0xc5, 0xf3, 0xfa, 0xf2, 0xd1, 0x90, 0x88, 0x0e, 0xdd, 0xb5, 0x55, 0x17, 0x29, 0xd4, 0x61,
	0xaa, 0x3c, 0xcb, 0x22, 0x3a, 0x28, 0xb4, 0x4a, 0x80, 0x2c, 0x13, 0xa3, 0x65, 0x1a, 0x67, 0x8a,
	0x6a, 0xb7, 0x8f, 0xf4, 0x13, 0xe4, 0xb0, 0x77, 0xe4, 0x05, 0x06, 0xaf, 0x32, 0xb0, 0xf8, 0x91,
	0xfe, 0x3c, 0x9f, 0x73, 0xcc, 0x17, 0x3c, 0xcc, 0xc1, 0x88, 0x9b, 0xf6, 0x7c, 0xd4, 0x4d, 0xbb,
	0xcf, 0x3e, 0xb3, 0x30, 0x99, 0x7d, 0xa6, 0x94, 0xca, 0x3e, 0xf3, 0x04, 0x40, 0x28, 0x6a, 0x7d,
	0x91, 0xde, 0x27, 0x02, 0x88, 0xf8, 0x96, 0xa7, 0x58, 0x89, 0x69, 0xac, 0xac, 0x5e, 0xac, 0x65,
	0x58, 0xaf, 0xfa, 0x0c, 0x2c, 0xc4, 0x66, 0x06, 0xdf, 0xd5, 0xb4, 0x9e, 0xad, 0xfa, 0x31, 0x4d,
	0x53, 0xb2, 0x5f, 0x16, 0xb7, 0x21, 0xd7, 0x33, 0x59, 0xd4, 0x1a, 0xf7, 0xcd, 0x29, 0xd6, 0xc1,
	0x9e, 0xa9, 0xbb, 0x32, 0x41, 0xc3, 0xec, 0xb3, 0xec, 0x7b, 0x54, 0xa9, 0x19, 0xa9, 0xac, 0x23,
	0x72, 0x6d, 0x8c, 0xb5, 0x65, 0x3b, 0x5d, 0x1d, 0x4f, 0x2c, 0xfd, 0x90, 0xee, 0x99, 0x8b, 0xa1,
	0x93, 0xfd, 0xe6, 0xd2, 0x1d, 0xaa, 0x78, 0xfa, 0xdd, 0xe0, 0x35, 0xea, 0x13, 0x79, 0x13, 0xe6,
	0x3c, 0x22, 0xf1, 0x72, 0xf6, 0xc8, 0x2c, 0x32, 0x20, 0xa9, 0x2b, 0x1d, 0x52, 0x0d, 0x28, 0x8e,
	0xe1, 0xfc, 0x49, 0x7d, 0x8f, 0x90, 0xca, 0xae, 0xfa, 0x5e, 0x7f, 0xfc, 0xc1, 0x63, 0x6d, 0x23,
	0x6a, 0x11, 0xca, 0x53, 0x40, 0x5d, 0x63, 0x23, 0xe8, 0x43, 0x7c, 0xfe, 0x23, 0xb8, 0x0f, 0x17,
	0x69, 0x52, 0x1e, 0xef, 0x13, 0x5f, 0xec, 0x52, 0x7c, 0x57, 0xcd, 0xf4, 0xed, 0xaa, 0xd2, 0x65,
	0xb8, 0x14, 0xc3, 0xcc, 0xf4, 0xeb, 0xcf, 0x09, 0x70, 0x8d, 0x7e, 0x19, 0x8f, 0x71, 0xe1, 0xed,
	0x36, 0x13, 0xdd, 0x6e, 0x93, 0x76, 0xac, 0x6c, 0xe2, 0x8e, 0x25, 0x5d, 0x87, 0xc7, 0x07, 0x10,
	0xc1, 0xc8, 0x7c, 0x40, 0xae, 0x01, 0xd4, 0x9f, 0xd5, 0xd9, 0xb4, 0xec, 0x90, 0x4f, 0xe0, 0xa4,
	0xde, 0x75, 0x0e, 0xb9, 0x1b, 0x0c, 0x40, 0xed, 0x9b, 0xf8, 0x67, 0xa8, 0xd7, 0x6f, 0x4a, 0x75,
	0x94, 0x62, 0xdd, 0xb2, 0x55, 0xd3, 0x25, 0x91, 0xdc, 0x1e, 0x16, 0xe9, 0x9b, 0x19, 0x58, 0x88,
	0x7d, 0x8c, 0x9a, 0xcc, 0x84, 0x51, 0xae, 0xf0, 0x99, 0xc9, 0x36, 0xe4, 0x54, 0xd9, 0xa3, 0x62,
	0xb9, 0x40, 0x72, 0x29, 0x72, 0x81, 0x84, 0x1d, 0x9b, 0x2c, 0x93, 0x43, 0xd3, 0xf0, 0x1c, 0x9b,
	0x76, 0xcc, 0x65, 0x03, 0xf2, 0x5e, 0x20, 0x99, 0xb8, 0x08, 0x73, 0x5e, 0x96, 0x20, 0x85, 0x85,
	0x43, 0x97, 0xa0, 0xe8, 0x83, 0xde, 0xab, 0xad, 0x95, 0x84, 0x08, 0xa4, 0xbe, 0xd3, 0x2c, 0x65,
	0xc4, 0x8b, 0x50, 0xf2, 0x21, 0xd5, 0xc6, 0x86, 0xbc, 0x53, 0xdf, 0x28, 0x65, 0xc5, 0x0b, 0xb0,
	0x10, 0x40, 0xb7, 0xab, 0xef, 0xef, 0x34, 0x4a, 0xb9, 0xe5, 0x2f, 0x64, 0xa0, 0x14, 0xf7, 0xb3,
	0x17, 0x2f, 0xc1, 0x62, 0x73, 0x6f, 0xad, 0xb9, 0x2e, 0xd7, 0x77, 0x5b, 0xf5, 0x9d, 0x86, 0xb2,
	0x5b, 0xad, 0x6f, 0x94, 0x1e, 0x13, 0x97, 0x40, 0x8c, 0x82, 0x49, 0x96, 0x22, 0xa1, 0x0f, 0x5e,
	0xdd, 0xd8, 0xae, 0x37, 0x4a, 0x19, 0x51, 0x82, 0x27, 0x22, 0xf0, 0xad, 0xfa, 0x66, 0x8b, 0xe0,
	0x52, 0xf6, 0x76, 0xb7, 0xe4, 0xea, 0x46, 0xad, 0x94, 0x15, 0x6f, 0xc2, 0xf5, 0x7e, 0x9c, 0xd1,
	0x4a, 0xb9, 0x3e, 0x7a, 0x48, 0xae, 0xa4, 0x29, 0xf1, 0x29, 0xb8, 0x11, 0x01, 0x6f, 0x34, 0xe4,
	0x0d, 0x45, 0xae, 0x35, 0xf7, 0xd6, 0x14, 0xb9, 0xb6, 0xbe, 0x27, 0xcb, 0xf5, 0xc6, 0x56, 0x69,
	0x5a, 0x7c, 0x1a, 0x6e, 0x0d, 0xaa, 0xd6, 0xd8, 0x69, 0x04, 0x35, 0x67, 0x96, 0xd7, 0xa0, 0xe0,
	0xc7, 0x64, 0xd2, 0x4c, 0x4c, 0xca, 0x5a, 0x75, 0x63, 0x0b, 0xb3, 0x7d, 0x11, 0xe6, 0x36, 0x6a,
	0x9b, 0xd5, 0xbd, 0x7b, 0x2d, 0x06, 0x12, 0x30, 0x97, 0x19, 0xde, 0xb5, 0x9a, 0xcc, 0xa0, 0x99,
	0xe5, 0x3b, 0x50, 0xf0, 0x1d, 0xb7, 0xc4, 0x39, 0x28, 0x90, 0x41, 0xb3, 0xb9, 0x5b, 0x84, 0x39,
	0x52, 0xac, 0xae, 0xaf, 0xd7, 0x76, 0x5b, 0xb5, 0x8d, 0x92, 0xe0, 0x83, 0xd6, 0xab, 0x8d, 0xf5,
	0xda, 0xbd, 0xda, 0x46, 0x29, 0xb3, 0xfc, 0x2e, 0x14, 0xc3, 0x4f, 0xa3, 0xa4, 0xeb, 0x7a, 0x73,
	0x7d, 0x67, 0xaf, 0xe1, 0x23, 0xba, 0x0c, 0x17, 0x7c, 0xd0, 0x6e, 0x4d, 0x5e, 0xaf, 0x35, 0x5a,
	0x3b, 0x9b, 0x9b, 0x25, 0x41, 0xac, 0xc0, 0x92, 0xff, 0x61, 0xb3, 0x7e, 0xbf, 0xb6, 0xf1, 0x6e,
	0xf5, 0xde, 0x5e, 0x0d, 0x7f, 0xcb, 0x2c, 0x6f, 0x43, 0xde, 0x7b, 0x99, 0x10, 0x45, 0x98, 0x27,
	0xdd, 0xb6, 0x1e, 0xec, 0xd6, 0x3c, 0xa4, 0x97, 0x60, 0x31, 0x80, 0x6d, 0x3f, 0x68, 0xb6, 0x6a,
	0xf2, 0x03, 0x3a, 0xbb, 0x01, 0xb8, 0xd9, 0xaa, 0x36, 0x36, 0xaa, 0x32, 0x26, 0xf3, 0x61, 0x60,
	0xb1, 0xa2, 0x83, 0x5d, 0x02, 0x31, 0x02, 0xf0, 0xf0, 0x96, 0xe1, 0x62, 0x14, 0x5e, 0x5d, 0x6f,
	0xd5, 0xdf, 0xc5, 0x1c, 0xbc, 0x02, 0x97, 0xa2, 0x5f, 0x76, 0x6b, 0x8d, 0x0d, 0x3c, 0x15, 0x19,
	0x3c, 0x90, 0xe8, 0xa7, 0x7a, 0x83, 0x35, 0xcb, 0x2e, 0x9f, 0xc2, 0x85, 0x04, 0xbb, 0x2c, 0x1e,
	0xd3, 0xae, 0x5c, 0xdb, 0xac, 0xdf, 0x57, 0xf6, 0x1a, 0x77, 0x1b, 0x3b, 0xef, 0x35, 0xd8, 0x6a,
	0xf1, 0x60, 0xcd, 0x5a, 0x8b, 0x32, 0x9c, 0x41, 0x18, 0xbe, 0x0c, 0x59, 0x18, 0x14, 0x24, 0xd7,
	0xde, 0xae, 0xad, 0xe3, 0x89, 0xc9, 0x86, 0xb0, 0x79, 0x44, 0xe5, 0x96, 0xf7, 0x83, 0xeb, 0x0f,
	0xcb, 0xe7, 0x15, 0x1a, 0x33, 0x85, 0x28, 0x55, 0xc3, 0x28, 0x3d, 0x16, 0x26, 0x9f, 0xc1, 0x99,
	0x3d, 0xaa, 0x24, 0x88, 0xd7, 0xa0, 0x1c, 0x6f, 0x73, 0x70, 0xa0, 0x1b, 0xba, 0xea, 0xa2, 0x52,
	0x66, 0xf9, 0x3b, 0x02, 0x5c, 0x48, 0xd0, 0x9d, 0x70, 0xab, 0x04, 0xb0, 0xc7, 0xe3, 0x01, 0x5f,
	0xdf, 0xab, 0xd5, 0xee, 0x96, 0x04, 0xf1, 0x71, 0xb8, 0x92, 0xf4, 0x75, 0x7b, 0xa7, 0xd1, 0x7a,
	0xab, 0x94, 0x19, 0xd4, 0xf8, 0x41, 0xad, 0x2a, 0x97, 0xb2, 0xe2, 0x75, 0xb8, 0x9a, 0xf4, 0x75,
	0xa7, 0x51, 0x6b, 0xe1, 0xe5, 0x9f, 0x5b, 0xfe, 0x00, 0x8a, 0x61, 0x25, 0x13, 0xcf, 0x77, 0xb8,
	0x1c, 0x9a, 0x8d, 0xcb, 0xfe, 0xd0, 0xfa, 0x05, 0x21, 0xf2, 0xc1, 0x9f, 0xec, 0xcc, 0xea, 0x17,
	0x9a, 0x30, 0x17, 0xc9, 0xf2, 0x20, 0xfe, 0xbe, 0xe0, 0x3f, 0x14, 0x47, 0x32, 0x7b, 0xdd, 0xe1,
	0x4c, 0x6c, 0x30, 0x30, 0xab, 0x69, 0xa5, 0x3a, 0x01, 0x06, 0x76, 0x66, 0x7e, 0x4d, 0xf0, 0x7c,
	0xfb, 0x22, 0xb4, 0xdd, 0xe6, 0xf4, 0xc1, 0x1f, 0x94, 0xba, 0xb3, 0x72, 0x67, 0x7c, 0x04, 0x61,
	0xca, 0xfa, 0x32, 0x3b, 0x72, 0x53, 0x36, 0x28, 0x0f, 0x25, 0x37, 0x65, 0x03, 0x93, 0x4a, 0x12,
	0xca, 0xfa, 0xd3, 0x32, 0xf2, 0x52, 0x36, 0x30, 0x1d, 0x25, 0x2f, 0x65, 0x83, 0x33, 0x42, 0x8a,
	0xbf, 0x2e, 0x40, 0x31, 0x9c, 0x0f, 0x51, 0x7c, 0x85, 0x7b, 0xb0, 0xf1, 0x2c, 0x92, 0x95, 0x57,
	0xc7, 0x69, 0xca, 0xe8, 0xf8, 0x86, 0x00, 0x97, 0x12, 0x73, 0x4d, 0x89, 0x6b, 0x93, 0x67, 0x2b,
	0xac, 0xac, 0x4f, 0x84, 0x83, 0x91, 0xf8, 0xa7, 0x42, 0x90, 0xfc, 0x31, 0x29, 0xcf, 0x97, 0x98,
	0x32, 0xaf, 0xe2, 0x90, 0x7c, 0x87, 0x95, 0xb7, 0xcf, 0x03, 0x15, 0xa3, 0xfb, 0xc7, 0x42, 0x3c,
	0xaa, 0x67, 0x58, 0xf2, 0x2b, 0xf1, 0x3d, 0xee, 0xcc, 0x37, 0xe9, 0xb2, 0x28, 0x56, 0xee, 0x9f,
	0x3f, 0x62, 0x36, 0xc2, 0x3f, 0x10, 0xe0, 0x62, 0x52, 0xa6, 0x22, 0xb1, 0x9a, 0xaa, 0xcb, 0xc4,
	0x99, 0x58, 0x9b, 0x04, 0x05, 0xa3, 0xef, 0x3b, 0x34, 0xc1, 0xc6, 0x80, 0x61, 0x89, 0x5b, 0x93,
	0x32, 0xc6, 0xa3, 0xf5, 0xad, 0xc9, 0x11, 0x31, 0x8a, 0xbf, 0x2b, 0xf8, 0x59, 0xa3, 0x92, 0x52,
	0x59, 0x89, 0xe9, 0x7a, 0x1a, 0x92, 0x63, 0xac, 0x52, 0x3f, 0x07, 0x4c, 0x8c, 0xe8, 0x7f, 0x09,
	0xe2, 0xca, 0x78, 0xf2, 0x6f, 0x89, 0xf7, 0x27, 0xee, 0x7a, 0x90, 0xa8, 0x3f, 0x78, 0x04, 0x98,
	0xd9, 0x20, 0xbf, 0x4d, 0xff, 0xcc, 0x43, 0x52, 0x76, 0x28, 0x71, 0xe3, 0x3c, 0x92, 0x56, 0x55,
	0x6a, 0x13, 0x62, 0x89, 0x2e, 0xca, 0xbe, 0xe4, 0x4e, 0x29, 0x16, 0xe5, 0xa0, 0x2c, 0x54, 0x29,
	0x16, 0xe5, 0xe0, 0xdc, 0x52, 0x58, 0xc9, 0x4a, 0xc8, 0x83, 0xc4, 0xab, 0x64, 0x0d, 0xce, 0xe5,
	0x54, 0xa9, 0x4e, 0x80, 0x81, 0x11, 0xf7, 0x45, 0x01, 0xe6, 0xa3, 0x09, 0x8c, 0x44, 0xce, 0x20,
	0xc7, 0xc4, 0x1c, 0x4b, 0x95, 0xd7, 0xc7, 0x6b, 0xcc, 0xa8, 0xf9, 0xaa, 0x00, 0x8b, 0x7d, 0xa9,
	0x8b, 0xc4, 0x37, 0xd3, 0xe1, 0x8c, 0xa7, 0x51, 0xaa, 0xdc, 0x1e, 0xbb, 0x7d, 0x48, 0xab, 0xea,
	0xcf, 0x5b, 0xc4, 0xab, 0x55, 0x0d, 0xcc, 0xa3, 0x54, 0xb9, 0x33, 0x3e, 0x02, 0x46, 0xd9, 0x19,
	0xe4, 0xbd, 0x3f, 0xb9, 0x24, 0x72, 0x9a, 0x94, 0x62, 0x7f, 0x00, 0xaa, 0xf2, 0x62, 0xda, 0x66,
	0xac, 0xeb, 0x3f, 0x26, 0x29, 0x2a, 0x92, 0xff, 0x6c, 0x8d, 0x58, 0xe3, 0xd5, 0xd0, 0x86, 0xfe,
	0xe1, 0x9c, 0xca, 0xe6, 0xa4, 0x68, 0x42, 0xa7, 0xcc, 0x90, 0x80, 0x78, 0xde, 0x53, 0x66, 0x74,
	0xaa, 0x02, 0xde, 0x53, 0x86, 0x27, 0x3a, 0x1f, 0x33, 0x78, 0x50, 0xc8, 0x37, 0x2f, 0x83, 0x47,
	0xc4, 0xcc, 0xf3, 0x32, 0x78, 0x64, 0xe4, 0x39, 0x61, 0xf0, 0xe0, 0x88, 0x70, 0x6e, 0x06, 0x8f,
	0x8c, 0x51, 0xe7, 0x66, 0x30, 0x47, 0x78, 0xfa, 0xdf, 0x0b, 0x7e, 0xea, 0xd0, 0x61, 0xe1, 0xe1,
	0xe2, 0xee, 0x38, 0xda, 0xce, 0xd0, 0x41, 0xbc, 0x73, 0x8e, 0x18, 0xd9, 0x60, 0xbe, 0x2f, 0x10,
	0x33, 0xf4, 0xd0, 0x18, 0x6f, 0x71, 0x9b, 0xbb, 0x5f, 0x9e, 0x78, 0xf4, 0x4a, 0xe3, 0xbc, 0xd0,
	0x85, 0xf4, 0xaa, 0x14, 0xb1, 0xd6, 0xbc, 0x7a, 0x55, 0xfa, 0xf0, 0x72, 0x5e, 0xbd, 0x6a, 0x8c,
	0xc0, 0x70, 0xf1, 0xb7, 0x04, 0x12, 0x52, 0x16, 0xfe, 0x63, 0x45, 0xe2, 0xeb, 0xe9, 0x74, 0xff,
	0xe8, 0x5f, 0xac, 0xaa, 0xbc, 0x31, 0x66, 0xeb, 0x10, 0x41, 0xcd, 0xf1, 0x08, 0x6a, 0x4e, 0x44,
	0xd0, 0xa0, 0x3f, 0xd9, 0xf4, 0x3d, 0x01, 0x1e, 0x1f, 0x9a, 0xdc, 0x4e, 0x7c, 0x9b, 0x7b, 0xc4,
	0x23, 0xf3, 0xfa, 0x55, 0xee, 0x9e, 0x0b, 0xae, 0xe8, 0x2a, 0x1c, 0x9a, 0x82, 0x2e, 0xc5, 0x2a,
	0xe4, 0x49, 0xcf, 0x97, 0x62, 0x15, 0xf2, 0x65, 0xc6, 0x63, 0x02, 0x1a, 0x4e, 0x3e, 0x96, 0x42,
	0x40, 0x13, 0xf2, 0xa1, 0xa5, 0x10, 0xd0, 0xc4, 0x8c, 0x67, 0x58, 0xfd, 0xea, 0x4f, 0x4d, 0xc4,
	0xab, 0x7e, 0x0d, 0x4c, 0x3a, 0x55, 0xb9, 0x33, 0x3e, 0x82, 0x90, 0xbe, 0xda, 0x97, 0x1a, 0x8c,
	0x57, 0x5f, 0x1d, 0x94, 0x6c, 0xad, 0x72, 0x7b, 0xec, 0xf6, 0x61, 0xb2, 0xe2, 0x99, 0xb8, 0xb8,
	0xc9, 0x1a, 0x90, 0x76, 0xac, 0x72, 0x7b, 0xec, 0xf6, 0x8c, 0xac, 0xcf, 0x02, 0x04, 0xb1, 0xda,
	0xe2, 0x4b, 0x69, 0x46, 0x19, 0x0a, 0x1f, 0xad, 0xbc, 0x9c, 0xbe, 0x61, 0x40, 0x40, 0x10, 0xee,
	0xcc, 0x4b, 0x40, 0x5f, 0x1c, 0x38, 0x2f, 0x01, 0x09, 0x91, 0xd5, 0x98, 0x03, 0x7e, 0xd0, 0x32,
	0x37, 0x07, 0xe2, 0xb1, 0xd4, 0xdc, 0x1c, 0xe8, 0x8f, 0x8f, 0x3e, 0x83, 0xbc, 0x17, 0x78, 0xcc,
	0x7b, 0x5f, 0x88, 0x85, 0x3f, 0xf3, 0xde, 0x17, 0xfa, 0xe2, 0x9b, 0x4f, 0x60, 0x86, 0x05, 0xa6,
	0x8a, 0xcf, 0x73, 0xd3, 0x1f, 0x1e, 0xf5, 0x0b, 0x29, 0x5b, 0xb1, 0x7e, 0xbf, 0x2c, 0xf8, 0xc1,
	0xd6, 0x41, 0x1c, 0xe7, 0x1b, 0xa9, 0x06, 0x11, 0x0f, 0x07, 0xac, 0xbc, 0x39, 0x6e, 0xf3, 0xa8,
	0x6d, 0x25, 0x29, 0x2a, 0x30, 0x85, 0x6d, 0x65, 0x48, 0xc0, 0x62, 0x0a, 0xdb, 0xca, 0xd0, 0xd0,
	0xc4, 0xdf, 0x10, 0x60, 0x2e, 0x12, 0x4a, 0x2d, 0xa6, 0xb0, 0xbd, 0xc7, 0x03, 0xbf, 0x2b, 0xaf,
	0x8d, 0xd5, 0x36, 0x34, 0x8f, 0xf1, 0xc8, 0x66, 0xde, 0x79, 0x1c, 0x10, 0xd8, 0x5d, 0x79, 0x73,
	0xdc, 0xe6, 0xa1, 0x47, 0x8d, 0x70, 0xc0, 0x1e, 0xef, 0xa3, 0x46, 0x42, 0x70, 0x26, 0xef, 0xa3,
	0x46, 0x52, 0x7c, 0x20, 0xb9, 0x2a, 0x0e, 0x8a, 0x7b, 0xe3, 0xbd, 0x2a, 0x8e, 0x88, 0x2f, 0xe4,
	0xbd, 0x2a, 0x8e, 0x0a, 0xbf, 0x23, 0xb2, 0x3f, 0x20, 0x82, 0x8d, 0x57, 0xf6, 0x87, 0x47, 0xef,
	0x55, 0x6a, 0x13, 0x62, 0x09, 0x3d, 0xc3, 0x0c, 0x8b, 0x32, 0xe3, 0x7d, 0x86, 0xe1, 0x08, 0xc5,
	0xe3, 0x7d, 0x86, 0xe1, 0x09, 0x7a, 0xf3, 0xac, 0x55, 0xb1, 0xc8, 0xb5, 0x14, 0xd6, 0xaa, 0xe4,
	0x78, 0xb9, 0x14, 0xd6, 0xaa, 0x41, 0x41, 0x73, 0x5f, 0x14, 0x60, 0x3e, 0x1a, 0xe0, 0xc6, 0x6b,
	0x6c, 0x4c, 0x0c, 0xa5, 0xab, 0xbc, 0x3e, 0x5e, 0x63, 0x46, 0xcd, 0x17, 0x04, 0x98, 0x8f, 0x86,
	0x60, 0xf1, 0x52, 0x93, 0x18, 0x8a, 0x56, 0x19, 0xb3, 0x71, 0xe4, 0x1d, 0x64, 0x50, 0xe8, 0x54,
	0x8a, 0x77, 0x90, 0x11, 0x51, 0x5c, 0x29, 0xde, 0x41, 0x46, 0xc6, 0x71, 0x31, 0x49, 0x8b, 0xc5,
	0x07, 0xa5, 0x90, 0xb4, 0xe4, 0x78, 0xa4, 0x14, 0x92, 0x36, 0x28, 0x34, 0x09, 0x6b, 0xc0, 0x7d,
	0x81, 0x8d, 0xe2, 0x9b, 0xa9, 0xe4, 0xa5, 0x2f, 0x44, 0xa9, 0x72, 0x7b, 0xec, 0xf6, 0xa1, 0xa7,
	0x8a, 0xa4, 0x68, 0x25, 0xde, 0xa7, 0x8a, 0x21, 0xf1, 0x53, 0xbc, 0x4f, 0x15, 0xc3, 0x82, 0xa5,
	0xc8, 0x39, 0x32, 0x28, 0xce, 0x49, 0x4c, 0xa1, 0x52, 0x0c, 0x89, 0xb6, 0xe2, 0x3d, 0x47, 0x46,
	0x86, 0x5b, 0xb1, 0x67, 0x95, 0x78, 0xa5, 0x14, 0xcf, 0x2a, 0x03, 0xa2, 0x74, 0x52, 0x3c, 0xab,
	0x0c, 0x0c, 0x55, 0xf9, 0x43, 0x01, 0x96, 0x92, 0xa3, 0x59, 0xc4, 0x49, 0x82, 0x56, 0x7c, 0x12,
	0x37, 0x26, 0x43, 0x12, 0x55, 0x8d, 0x23, 0x3e, 0xe0, 0x29, 0x54, 0xe3, 0x24, 0xbf, 0xf3, 0x14,
	0xaa, 0x71, 0xb2, 0xeb, 0xb9, 0xb7, 0xa7, 0x44, 0xdd, 0xbd, 0xd3, 0xec, 0x29, 0x89, 0xae, 0xe6,
	0x69, 0xf6, 0x94, 0x01, 0x9e, 0xe6, 0x8c, 0xb2, 0x98, 0x87, 0x71, 0x0a, 0xca, 0x92, 0x1d, 0xa4,
	0x53, 0x50, 0x36, 0xc8, 0x83, 0x1c, 0x6b, 0xe9, 0x11, 0xef, 0x6c, 0x5e, 0x2d, 0x3d, 0xc9, 0x59,
	0x9c, 0xf7, 0x1c, 0x4b, 0x74, 0x07, 0x27, 0xee, 0x35, 0x89, 0x9e, 0xd8, 0xbc, 0xee, 0x35, 0xc3,
	0x7c, 0xc9, 0x79, 0xdd, 0x6b, 0x86, 0xba, 0x82, 0x13, 0xa9, 0xaf, 0x75, 0x54, 0xdd, 0x08, 0xbf,
	0x15, 0xbf, 0xc1, 0x1b, 0xd4, 0x18, 0x6d, 0x97, 0x52, 0xea, 0xfb, 0x9b, 0xc7, 0x69, 0xda, 0x32,
	0xac, 0x7d, 0x95, 0x1c, 0xbb, 0x28, 0x15, 0x4d, 0xa1, 0x76, 0xe3, 0xd0, 0x14, 0x69, 0x1e, 0x72,
	0x26, 0x21, 0x1f, 0xd9, 0xfe, 0x41, 0xcf, 0x8a, 0x2a, 0x09, 0x03, 0x54, 0x0d, 0x5e, 0x67, 0x92,
	0xc1, 0x18, 0x52, 0x3a, 0x93, 0x0c, 0x43, 0x14, 0x3d, 0xbe, 0x12, 0x5d, 0xf1, 0x53, 0x1c, 0x5f,
	0xc3, 0xa2, 0x04, 0x52, 0x1c, 0x5f, 0x43, 0x23, 0x02, 0xd6, 0x66, 0xdf, 0x2f, 0xe0, 0x16, 0xee,
	0xa9, 0x6e, 0x77, 0xf7, 0xa7, 0x89, 0x1f, 0xfb, 0x73, 0xff, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x71,
	0x20, 0x48, 0xeb, 0x30, 0x8a, 0x00, 0x00,
}
