import cdk = require('@aws-cdk/core');
import capacity = require('@twitch-easymode/capacity-planning');
import security = require('@twitch-easymode/twitch-security');

/**
 * Requirements for all Twitch accounts
 */
export class AccountStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: cdk.StackProps) {
    super(scope, id, {
      description: 'Requirements for Twitch AWS Accounts: CloudTrail, SecurityRole, InventoryRole',
      ...props,
    });

    new capacity.InventoryRole(this, 'InventoryRole');
    new security.TwitchSecurityCloudTrail(this, 'CloudTrail');
    new security.TwitchSecurityRole(this, 'SecurityRole');
  }
}
