import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as cdk from '@aws-cdk/core';
import * as iam from '@aws-cdk/aws-iam';

export interface DynamoDBStackProps extends cdk.StackProps {
    awsAccountID: string;
}

export class DynamoDBStack extends cdk.Stack {
    constructor(parent: cdk.App, id: string, props: DynamoDBStackProps) {
        super(parent, id, props);

        new dynamodb.Table(this, 'QuickActionsStore', {
            tableName: 'quick-actions-store',
            partitionKey: {
                // scope refers either to 'global', an action available to all channels,
                // or a channel_id, only available to that channel
                name: 'scope',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: {
                name: 'name',
                type: dynamodb.AttributeType.STRING,
            },
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            pointInTimeRecovery: true,
        });
    }
}
