import * as ecr from '@aws-cdk/aws-ecr';
import * as cdk from '@aws-cdk/core';

export class ECRStack extends cdk.Stack {
  respositoryName = 'secretshop';
  repository: ecr.IRepository;
  constructor(parent: cdk.App, id: string, props?: cdk.StackProps) {
    super(parent, id, props);

    this.repository = new ecr.Repository(this, 'SecretShopECR', {
      repositoryName: this.respositoryName,
    });
  }
}
