import cdk = require('@aws-cdk/core');
import iam = require('@aws-cdk/aws-iam');

export class DeployRole extends cdk.Construct {
  constructor(parent: cdk.Construct, id: string) {
    super(parent, id);

    new iam.Role(this, 'Role', {
      assumedBy: new iam.CompositePrincipal(
      new iam.ArnPrincipal('arn:aws:iam::043714768218:role/jenkins-prod-slave'),
      new iam.ArnPrincipal('arn:aws:iam::043714768218:role/jenkins-prod-master'),
    ),
      roleName: 'secretshop-jenkins',
      managedPolicies: [
        'AmazonEC2ContainerRegistryPowerUser',
        'AmazonEC2ContainerServiceFullAccess',
      ].map(iam.ManagedPolicy.fromAwsManagedPolicyName),
    });
  }
}
