#!/usr/bin/env bash
# Runs the ecs-deploy app in Docker (required for Jenkins),
# passing all args to the app.
# This file powers deployments to the "integration" environments.

set -u
set -e


REGION=us-west-2

echo "Deploying with docker.internal.justin.tv/edge/ecs-deploy:latest"

# Run ecs-deploy via docker, passing in the current AWS creds as env vars in the docker runtime plus all input args
docker run -e AWS_DEFAULT_REGION=$REGION -e AWS_ACCESS_KEY_ID -e AWS_SECRET_ACCESS_KEY -e AWS_SESSION_TOKEN \
     docker.internal.justin.tv/edge/ecs-deploy:latest $*
