# secretshop Deploys and Rollbacks

Deployment is done using Jenkins.

## Deploy
1. Create a new branch for a feature in [cb/secretshop](https://git-aws.internal.justin.tv/cb/secretshop).
2. After writing your feature, you can test locally by running `make run` and making calls to `localhost:8080`. To see more details about testing locally, follow [the testing doc](./testing.md#testing-locally).
3. Create a pull request for your branch. You can ask in the slack channel #dashboard-feedback for a review.
4. Using [Jenkins Build job](https://jenkins.internal.justin.tv/job/cb/job/secretshop/), confirm that your branch has been built and its docker image has been pushed to to ECR.
5. To deploy to staging, click `Build Now` on [Jenkins Dev Deploy job](https://jenkins.internal.justin.tv/view/Creator%20Business/job/secretshop-deploy-dev/). When the `Select version` stage is reached, choose the git revision you want to deploy.
6. When the deploy has finished, verify that the staging ECS service is healthy with your latest changes by visiting the [ECS dashboard](https://us-west-2.console.aws.amazon.com/ecs/home?region=us-west-2#/clusters/SecretShop/services/SecretShop/details) in `twitch-secretshop-dev`. You can also test on staging by following [the testing doc](./testing.md#testing-in-staging).
7. After your PR is approved, merge your branch.
8. Using [Jenkins Build job](https://jenkins.internal.justin.tv/job/cb/job/secretshop/), confirm that the master branch has been built and its docker image has been pushed to to ECR. The job will automatically deploy your changes to the canary environment, which taks 10% of the production traffic.
9. When the deploy has finished, verify that the canary ECS service is healthy with your latest changes by visiting the [ECS dashboard](https://us-west-2.console.aws.amazon.com/ecs/home?region=us-west-2#/clusters/SecretShop/services/SecretShop-canary/details) in `twitch-secretshop-prod`. 
10. To deploy to production, click `Build Now` on [Jenkins Prod Deploy job](https://jenkins.internal.justin.tv/view/Creator%20Business/job/secretshop-deploy-prod/). When the `Select version` stage is reached, choose the git revision you want to deploy.
11. When the deploy has finished, verify that the staging ECS service is healthy with your latest changes by visiting the [ECS dashboard](https://us-west-2.console.aws.amazon.com/ecs/home?region=us-west-2#/clusters/SecretShop/services/SecretShop/details) in `twitch-secretshop-prod`. You can also test on production by following [the testing doc](./testing.md#testing-in-production).

In case of a deployment problem or emergency, you can use the [Jenkins Canary Deploy job](https://jenkins.internal.justin.tv/view/Creator%20Business/job/secretshop-deploy-canary/) to deploy a recent build to canary.
