# secretshop Testing

## Testing Locally
1. If you do not have access to `twitch-secretshop-dev` AWS account via Isengard, ask in #dashboard-feedback to gain access.
2. There are two ways to set up your credentials for Secret Shop. 
	- Go to [Isengard](https://isengard.amazon.com/console-access), find `twitch-secretshop-dev@amazon.com` and click on the ![temp-cred](./images/temp-cred.png) icon to get your temporary credentials. Copy and paste the commands into your shell to set up your AWS CLI environment variables. Your temporary credentials expire after 30 minutes.
	- Alternatively, you can set up using [twitch/isengard_credentials](https://git-aws.internal.justin.tv/twitch/isengard_credentials). If you use this method, set your environment variable by running `export AWS_PROFILE = twitch-secretshop-dev` for the session.
4. Run `make run` at the root of this project to start a local server. 
5. Make `curl` requests to `localhost:8080` to test your feature changes.

## Testing in Staging
1. If you are not in the LDAP group `team-creator-business`, ask in #dashboard-feedback to be added.
2. (Optional) Deploy to staging environment by clicking `Build Now` on [Jenkins Dev Deploy job](https://jenkins.internal.justin.tv/view/Creator%20Business/job/secretshop-deploy-dev/). When the `Select version` stage is reached, choose the git revision you want to deploy.
3. Make sure you have [Teleport Bastion](https://wiki.twitch.com/display/SEC/Teleport+Bastion) enabled.
4. Run `TC=twitch-secretshop-dev-us-west-2 ssh jumpbox` to be connected to the jumpbox in the staging VPC. 
5. Make `curl` requests to `dev.secretshop.twitch.a2z.com` from the jumpbox to test your feature changes.

## Testing in Production
1. If you are not in the LDAP group `team-creator-business`, ask in #dashboard-feedback to be added.
2. (Optional) Deploy to production environment by clicking `Build Now` on [Jenkins Prod Deploy job](https://jenkins.internal.justin.tv/job/cb/job/secretshop/job/master/). When the `Deploy prod docker image` stage is reached, click `Proceed` to finish deploy.
3. Make sure you have [Teleport Bastion](https://wiki.twitch.com/display/SEC/Teleport+Bastion) enabled.
4. Run `TC=twitch-secretshop-prod-us-west-2 ssh jumpbox` to be connected to the jumpbox in the staging VPC. 
5. **Caution: This will make changes to production data!** Make `curl` requests to `prod.secretshop.twitch.a2z.com` from the jumpbox to test your feature changes.
