package dynamodb

import (
	"context"

	"code.justin.tv/cb/secretshop/internal/quickactions/schema"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
)

type Datastore interface {
	GetAllStoreItems(ctx context.Context, channelID string) ([]*schema.QuickAction, error)
	PutGlobals(ctx context.Context, globals []*schema.QuickAction) error
	AddStoreItem(ctx context.Context, quickAction *schema.QuickAction) error
	RemoveItem(ctx context.Context, channelID string, itemName string) (*schema.QuickAction, error)
	GetDefaultItems(ctx context.Context, isPartner bool) ([]*schema.QuickAction, error)
}

type Client struct {
	dynamoDB       dynamodbiface.DynamoDBAPI
	storeTableName string
}

func NewClient(storeTable string, region string) (*Client, error) {
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String(region),
	})

	if err != nil {
		return nil, err
	}

	return &Client{
		storeTableName: storeTable,
		dynamoDB:       dynamodb.New(sess),
	}, nil
}
