package conv

import (
	"strings"

	"code.justin.tv/cb/secretshop/internal/quickactions/schema"
	pb "code.justin.tv/cb/secretshop/rpc/secretshop"
)

func DynamoToProtoList(quickActions []*schema.QuickAction) []*pb.QuickAction {
	if (len(quickActions) == 0) || (quickActions == nil) {
		return []*pb.QuickAction{}
	}

	items := make([]*pb.QuickAction, len(quickActions))

	for i, qa := range quickActions {
		items[i] = DynamoToProtoQuickAction(qa)
	}

	return items
}

func ProtoToDynamoQuickAction(quickAction *pb.QuickAction) *schema.QuickAction {
	return &schema.QuickAction{
		Name:     quickAction.Name,
		Scope:    quickAction.Scope,
		Category: quickAction.Category.String(),
		Enabled:  quickAction.Enabled,
		//TODO: Properties
	}
}

func DynamoToProtoQuickAction(quickAction *schema.QuickAction) *pb.QuickAction {
	return &pb.QuickAction{
		Name:     quickAction.Name,
		Scope:    quickAction.Scope,
		Category: strToCategory(quickAction.Category),
		Enabled:  quickAction.Enabled,
		//TODO: Properties
	}
}

func strToCategory(cat string) pb.CategoryType {
	converted, ok := pb.CategoryType_value[strings.ToUpper(cat)]
	if !ok {
		return pb.CategoryType_UNCATEGORIZED
	}
	return pb.CategoryType(converted)
}
