package conv_test

import (
	"testing"

	"code.justin.tv/cb/secretshop/internal/quickactions/conv"
	"code.justin.tv/cb/secretshop/internal/quickactions/schema"

	"github.com/stretchr/testify/assert"

	pb "code.justin.tv/cb/secretshop/rpc/secretshop"
)

func TestConvertDynamoQuickActions(t *testing.T) {
	t.Run("nil input", func(t *testing.T) {
		result := conv.DynamoToProtoList(nil)
		assert.NotNil(t, result)
		assert.Equal(t, 0, len(result))
	})

	t.Run("empty input", func(t *testing.T) {
		result := conv.DynamoToProtoList([]*schema.QuickAction{})
		assert.NotNil(t, result)
		assert.Equal(t, 0, len(result))
	})

	t.Run("invalid category", func(t *testing.T) {
		input := []*schema.QuickAction{
			{
				Name:     "some-QA",
				Scope:    "global",
				Category: "invalid_category",
				Enabled:  true,
			},
		}
		result := conv.DynamoToProtoList(input)

		assert.NotNil(t, result)
		assert.Equal(t, 1, len(result))
		assert.Equal(t, input[0].Name, result[0].Name)
		assert.Equal(t, input[0].Scope, result[0].Scope)
		assert.Equal(t, input[0].Enabled, result[0].Enabled)
		assert.Equal(t, pb.CategoryType_UNCATEGORIZED, result[0].Category)
	})

	t.Run("valid input", func(t *testing.T) {
		input := []*schema.QuickAction{
			{
				Name:     "some-QA",
				Scope:    "global",
				Category: "manage_stream",
				Enabled:  true,
			},
		}
		result := conv.DynamoToProtoList(input)

		assert.NotNil(t, result)
		assert.Equal(t, 1, len(result))
		assert.Equal(t, input[0].Name, result[0].Name)
		assert.Equal(t, input[0].Scope, result[0].Scope)
		assert.Equal(t, input[0].Enabled, result[0].Enabled)
		assert.Equal(t, pb.CategoryType_MANAGE_STREAM, result[0].Category)
	})
}
