package global

import (
	"encoding/json"
	"io/ioutil"

	"code.justin.tv/cb/secretshop/internal/quickactions/schema"
)

type QuickActions struct {
	Globals []*schema.QuickAction `json:"globals"`
}

func LoadGlobals(fromFile string) (*QuickActions, error) {
	actions := &QuickActions{}

	// load global config file
	globalBytes, err := ioutil.ReadFile(fromFile)
	if err != nil {
		return nil, err
	}

	err = json.Unmarshal(globalBytes, &actions)
	if err != nil {
		return nil, err
	}

	return actions, nil
}
