package global_test

import (
	"testing"

	"code.justin.tv/cb/secretshop/internal/quickactions/global"
	"github.com/stretchr/testify/assert"
)

const (
	expectedGlobalQuickActions = 36
	globalsRelativeFilePath    = "../../../config/global_quick_actions.json"
)

func TestGlobalLoad(t *testing.T) {
	t.Run("empty path", func(t *testing.T) {
		globals, err := global.LoadGlobals("")
		assert.NotNil(t, err)
		assert.Nil(t, globals)
	})

	t.Run("nonexistent file path", func(t *testing.T) {
		globals, err := global.LoadGlobals("./file-does-not-exist.json")
		assert.NotNil(t, err)
		assert.Nil(t, globals)
	})

	t.Run("valid file", func(t *testing.T) {
		// pass in relative path to config file
		globals, err := global.LoadGlobals(globalsRelativeFilePath)
		assert.Nil(t, err)
		assert.NotNil(t, globals)
		assert.Equal(t, len(globals.Globals), expectedGlobalQuickActions)
	})
}
