package server

import (
	"github.com/twitchtv/twirp"
)

const errGQLMetaKey = "gql_code"

var (
	ErrMissingChannelID   = twirp.RequiredArgumentError("channelID").WithMeta(errGQLMetaKey, "INVALID_CHANNEL_ID")
	ErrMissingQuickAction = twirp.RequiredArgumentError("QuickAction").WithMeta(errGQLMetaKey, "INVALID_QUICK_ACTION")
	ErrMissingName        = twirp.RequiredArgumentError("name").WithMeta(errGQLMetaKey, "INVALID_QUICK_ACTION_NAME")
	ErrInvalidScope       = twirp.InvalidArgumentError("scope", "Cannot change a global quick action").WithMeta(errGQLMetaKey, "INVALID_SCOPE_NAME")
)
