# [DEPRECATED] Semki

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=cb-semki-build)](https://jenkins.internal.justin.tv/job/cb-semki-build) [![Go Report Card](https://goreportcard.internal.justin.tv/badge/code.justin.tv/cb/semki)](https://goreportcard.internal.justin.tv/report/code.justin.tv/cb/semki)

Semki has been replaced by [zephyr](https://git-aws.internal.justin.tv/ce-analytics/zephyr).

Semki queries redshift for predefined stats and stores the results for future consumption by the [Dashy](https://git-aws.internal.justin.tv/cb/dashy) service

## System Organization

Semki consists of two ebs worker environments -- cron and ingest.
The cron environment runs redshift queries via a cron, it takes the results and formats them into DynamoRow struct types and pushes the results to ingest's sqs queue.
The ingest environment takes DynamoRow structs off of the sqs queue and propogates them to their appropriate dynamo db table on the twitch-cb-aws account.

## Development

You may want to run a development version of the cron service (you should never need to run a dev version of ingest).

Add redshift credentials to the development.yaml file of the form

```
redshift:
  credentials: '{username}:{password}'
```

Run

```
make dev-cron
```

Hit your dev-cron worker instance at

```
localhost:8000/calc/event
```

Use the headers _X-Aws-Sqsd-Attr-Name_, _X-Aws-Sqsd-Attr-Backfill-Start-Date_, _X-Aws-Sqsd-Attr-Backfill-End-Date_ to fine tune the query

_NOTE_ all instances of semki (production/staging/development) all share the same redshift cluster. Please behave responsibly.

### Setup

To setup your machine (macOS) for local development, run the following command:

```
make setup
```

### Testing

```
make lint
```

### Dependency Management

[Glide](https://github.com/Masterminds/glide) is used for pinning package versions and updating dependencies.

To add or update a dependency, edit [`glide.yaml`](./glide.yaml) and run the following command:

```
make update
```

Nested vendor packages will be stripped, and only the vendor packages that are imported and used will be kept in the `vendor/` directory.

## Backfilling

You may periodically get requests to backfill a certain stat for a certain time range.

Follow the instructions on the [Backfilling](./docs/backfilling.md) page.

## On Call

[Sign in](https://console.aws.amazon.com/console/home) to the `twitch-cb-aws` AWS account with your assigned IAM user.

### Alerts

> Sum NumberOfMessagesReceived LessThanThreshold 250000.0 for QueueName cb-semki-production-ingest-queue

Not enough messages were sent to the ingest queue from the cron job, which
usually indicates we stopped processing stats at some point during the batch
cycle. For example, this has previously happened due to redshift errors in
session calculation, which other stats depend on.

Because we use batch jobs, the next batch will pick everything up and there
isn't much customer facing impact (except for extra delays to stats). However,
if the alarm continues it might indicate that redshift is down or hung. Check
rollbar for any sql errors, check the queries tab in the redshift console for
long-running or aborted queries, and review the timings in grafana.

1. Check under [Recent Events](https://us-west-2.console.aws.amazon.com/redshift/home?region=us-west-2#cluster-status:cluster=dev-cb-tahoe-replica) for maintenance, this can happen once per week
   between Wednesday 20:00 UTC and Thursday 1:00 UTC. If this caused the alert
   there is nothing to worry about, the data will be picked up in the next cron
   cycle.
2. Check [Semki Rollbar](https://rollbar.com/Twitch/CB_Semki/)
3. [Check for long running queries](https://us-west-2.console.aws.amazon.com/redshift/home?region=us-west-2#queries:cluster=dev-cb-tahoe-replica)
4. Review [Grafana](https://grafana.internal.justin.tv/d/000001477/cb-semki?orgId=1)

#### Review CloudWatch Logs

1. Go to [Cron CloudWatch Logs](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logStream:group=/aws/elasticbeanstalk/cb-semki-production-cron/var/log/eb-docker/containers/eb-current-app/stdouterr.log)
2. Sort the table by "Last Event Time" to find the most recent log stream
3. Click the entry at the top of the list
4. Filter logs by choosing a date range that matches Grafana/Cloudwatch events

#### Example Outage

Below is a screenshot from Grafana showing what an outage might look like.

![Sample Outage in Grafana](docs/images/outage-example-grafana.png)

#### Known Issues

- Redshift downtime as noted in [Recent Events](https://us-west-2.console.aws.amazon.com/redshift/home?region=us-west-2#cluster-status:cluster=dev-cb-tahoe-replica).
- Failure to connect to SQS results in the cron task posting no messages to [SQS](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#metricsV2:graph=~(view~'timeSeries~stacked~false~metrics~(~(~'AWS*2fSQS~'NumberOfMessagesSent~'QueueName~'cb-semki-production-cron-queue))~region~'us-west-2);query=~'*7bAWS*2fSQS*2cQueueName*7d*20cb-semki-production) and degraded health for the [SQSD Process](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#metricsV2:graph=~(view~'timeSeries~stacked~false~metrics~(~(~'ElasticBeanstalk*2fSQSD~'Health~'EnvironmentName~'cb-semki-production-cron))~region~'us-west-2~start~'-PT3H~end~'P0D);query=~'*7bElasticBeanstalk*2fSQSD*2cEnvironmentName*7d). The [`/var/log/aws-sqsd/default.log`](https://elasticbeanstalk-us-west-2-989470033077.s3-us-west-2.amazonaws.com/resources/environments/logs/tail/e-pqbjvqapp8/i-0191a02735244f632/TailLogs-1553037606523.out?AWSAccessKeyId=AKIAJ4EUBGPT4J56L5CQ&Expires=1553124006&Signature=31opJ2smsbph%2FOrFFvslkG3c4o4%3D) file may show `No address associated with hostname`. This appears to be associated with DNS resolution failures.
