package main

import (
	"context"
	"fmt"

	"code.justin.tv/cb/semki/config"
	"code.justin.tv/cb/semki/internal/awscredentials"
	models "code.justin.tv/cb/semki/internal/stats/sessions"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"

	_ "github.com/lib/pq"
)

const (
	channel = "142427481"
	start   = "2017-02-02T00:00:00Z"
	end     = "2017-02-03T00:00:00Z"
)

func main() {
	sess, err := session.NewSession(&aws.Config{
		Credentials: awscredentials.New(config.Development, "us-west-2"),
		Region:      aws.String("us-west-2"),
	})
	if err != nil {
		fmt.Printf("session init failed: %s\n", err.Error())
	}

	d := dynamodb.New(sess)

	var exclusiveStartKey map[string]*dynamodb.AttributeValue
	keyCondition := aws.String("channel_id = :channelID AND #T BETWEEN :startTime AND :endTime")
	conditionAttrValues := map[string]*dynamodb.AttributeValue{
		":channelID": {
			N: aws.String(channel),
		},
		":startTime": {
			S: aws.String(start),
		},
		":endTime": {
			S: aws.String(end),
		},
	}
	attributePlaceholders := map[string]*string{
		"#T": aws.String("segment_start_time"),
	}

	result := []models.DynamoRow{}
	for {
		output, err := d.QueryWithContext(context.TODO(), &dynamodb.QueryInput{
			TableName:                 aws.String("cb-semki-staging-sessions"),
			ScanIndexForward:          aws.Bool(true),
			KeyConditionExpression:    keyCondition,
			ExpressionAttributeValues: conditionAttrValues,
			ExpressionAttributeNames:  attributePlaceholders,
			ExclusiveStartKey:         exclusiveStartKey,
		})

		if err != nil {
		}

		subResults := []models.DynamoRow{}
		err = dynamodbattribute.UnmarshalListOfMaps(output.Items, &subResults)
		if err != nil {
		}

		result = append(result, subResults...)

		if output.LastEvaluatedKey == nil {
			break
		}
	}

	fmt.Println(result)
}
