package awscredentials

import (
	"code.justin.tv/cb/semki/config"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/ec2rolecreds"
	"github.com/aws/aws-sdk-go/aws/session"
)

// New returns AWS Credentials object for the current env
// will be used to generate dynamo/sns clients
func New(env string, region string) *credentials.Credentials {
	if env == config.Development {
		return credentials.NewSharedCredentials("", "twitch-cb-aws")
	}

	return ec2rolecreds.NewCredentials(
		session.New(&aws.Config{
			Region: aws.String(region),
		}),
	)
}
