package clips

import (
	"context"
	"time"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/video/clips-upload/client/clipsv2"
)

// Clips gets clips data for a channel
type Clips interface {
	GetTopClipFromStream(ctx context.Context, channelID string, start, end time.Time) (*clipsv2.Clip, error)
}

// Client is a wrapper for an clipsv2.Client client
type Client struct {
	clips clipsv2.Client
}

// NewClient creates an instance of an Client
func NewClient(clipsHost string) (Clips, error) {
	clips, err := clipsv2.NewClient(twitchclient.ClientConf{
		Host: clipsHost,
	})
	if err != nil {
		return nil, err
	}

	return &Client{
		clips: clips,
	}, nil
}

// GetTopClipFromStream returns if a user is in the stream summary experiment's test group
func (c *Client) GetTopClipFromStream(ctx context.Context, channelID string, start, end time.Time) (*clipsv2.Clip, error) {
	resp, err := c.clips.GetTopClips(ctx, &clipsv2.GetTopClipsParams{
		ChannelIDs: &[]string{channelID},
		Start:      &start,
		End:        &end,
		Limit:      1,
	}, nil)
	if err != nil {
		return nil, err
	}

	if len(resp.Clips) == 0 {
		return nil, nil
	}

	return resp.Clips[0], nil
}
