package pushy

import (
	"code.justin.tv/cb/semki/internal/awscredentials"
	"code.justin.tv/chat/pushy/client/events"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/cactus/go-statsd-client/statsd"
	"github.com/pkg/errors"
)

// NewClient creates an instance of an events.Publisher
func NewClient(env string, region string, snsARN string, stats statsd.Statter) (events.Publisher, error) {
	sess, err := session.NewSession(&aws.Config{
		Credentials: awscredentials.New(env, region),
		Region:      aws.String(region),
	})
	snsClient := sns.New(sess)

	if err != nil {
		return nil, errors.Wrap(err, "pushy: failed to initialize client")
	}

	return events.NewPublisher(events.Config{
		DispatchSNSARN: snsARN,
		Stats:          stats,
		SNSClient:      snsClient,
	})
}
